package com.example.demo.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.AdunitEndpointCreateDTO;
import com.example.demo.dto.AdunitEndpointListDTO;
import com.example.demo.service.AdunitEndpointService;

@RestController
@RequestMapping("api/AdunitEndpoint")
public class AdunitEndpointController {

	@Autowired
	private AdunitEndpointService service;
	
	@PostMapping("link")
	private APIResponse createlinking(@RequestBody AdunitEndpointCreateDTO create) {
		APIResponse api = service.createlinking(create);
		return api;
	}
	
	@PostMapping("unlink")
	private APIResponse updatelinking(@RequestBody AdunitEndpointCreateDTO delete) {
		APIResponse api = service.deletelinking(delete);
		return api;
	}
	
	@PostMapping("list")
	private APIResponse list(@RequestBody AdunitEndpointListDTO list) {
		APIResponse api = service.list(list);
		return api;
	}
}
