package com.example.demo.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.AdunitDealDTO;
import com.example.demo.dto.AdunitDealListDTO;
import com.example.demo.service.AdunitDealService;

@RestController
@RequestMapping("api/adunitdeal")
public class AdunitDealController {
	
	@Autowired
	private AdunitDealService service;
	
	@PostMapping("link")
	private APIResponse createlinking(@RequestBody AdunitDealDTO link) {
		APIResponse api = service.createlink(link);
		return api;
	}
	
	@PostMapping("unlink")
	private APIResponse deletedlinking(@RequestBody AdunitDealDTO unlink) {
		APIResponse api = service.deletelink(unlink);
		return api;
	}
	
	@PostMapping("list")
	private APIResponse list(@RequestBody AdunitDealListDTO list) {
		APIResponse api = service.list(list);
		return api;
	}

}
