package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.AdunitDeleteDTO;
import com.example.demo.dto.AdunitUpdateDTO;
import com.example.demo.dto.AdunitsCreateDTO;
import com.example.demo.dto.AdunitsFilterRequest;
import com.example.demo.service.AdunitService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("/api/adunits")
public class AdunitController {

	@Autowired
	private AdunitService service;

	@PostMapping("create")
	private APIResponse createadunit(@RequestBody AdunitsCreateDTO create) throws JsonProcessingException {
		APIResponse api = service.createadunit(create);
		return api;
	}

	@PutMapping("update/{adunit_id}")
	private APIResponse updateadunit(@RequestBody AdunitUpdateDTO update, @PathVariable("adunit_id") UUID adunit_id) throws JsonProcessingException {
		APIResponse api = service.updateadunit(update, adunit_id);
		return api;
	}

	@PostMapping("block/{adunit_id}")
	private APIResponse blockadunit(@PathVariable("adunit_id") UUID adunit_id) {
		APIResponse api = service.blockadunit(adunit_id);
		return api;
	}

	@PostMapping("Unblock/{adunit_id}")
	private APIResponse unblockadunit(@PathVariable("adunit_id") UUID adunit_id) {
		APIResponse api = service.unblockadunit(adunit_id);
		return api;
	}

	@GetMapping("getbyid/{adunit_id}")
	private APIResponse getbyid(@PathVariable("adunit_id") UUID adunit_id) {
		APIResponse api = service.getbyid(adunit_id);
		return api;
	}

	@PostMapping("list")
	private FilterResponse list(@RequestBody AdunitsFilterRequest filter, @RequestHeader UUID user_id) {
		FilterResponse api = service.list(filter, user_id);
		return api;
	}

	@PostMapping("delete")
	private APIResponse deleteadunit(@RequestBody AdunitDeleteDTO delete) {
		APIResponse api = service.deleteadunit(delete);
		return api;
	}

}
