package com.example.demo.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.AdunitBidderDTO;
import com.example.demo.dto.AdunitBidderListDTO;
import com.example.demo.service.AdunitBidderService;

@RestController
@RequestMapping("api/adunitbidder")
public class AdunitBidderController {

	@Autowired
	private AdunitBidderService service;
	
	@PostMapping("link")
	private APIResponse createlinking(@RequestBody AdunitBidderDTO link) {
		APIResponse api = service.createlinking(link);
		return api;
	}
	
	@PostMapping("unlink")
	private APIResponse deletelinking(@RequestBody AdunitBidderDTO unlink) {
		APIResponse api = service.deletedlinking(unlink);
		return api;
	}
	
	@PostMapping("list")
	private APIResponse list(@RequestBody AdunitBidderListDTO list) {
		APIResponse api = service.list(list);
		return api;
	}
}
