package com.example.demo.controller;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.CommonSubAPIDto.BannerVideoDTO;
import com.example.demo.common.APIResponse;
import com.example.demo.dto.AdFormatTypeReqDTO;
import com.example.demo.entity.AdFormats;
import com.example.demo.repository.AdFormatRepo;

@RestController
@RequestMapping("/api")
public class AdformatController {
	@Autowired
	AdFormatRepo repo;

	@GetMapping("/adtype/list")
	public ResponseEntity<APIResponse> getAll() {
		APIResponse api = new APIResponse();
		List<AdFormats> ad = repo.orderByName();

		api.setData(ad);

		return ResponseEntity.status(api.getStatuscode()).body(api);
	}

	@PostMapping("/adtype/type")
	public APIResponse getFormatByType(@RequestBody AdFormatTypeReqDTO typeReq) {
		APIResponse api = new APIResponse();

		List<AdFormats> allAdtype = new ArrayList<>();
		for (String str : typeReq.getType()) {
			List<AdFormats> adtype = null;
			if (str.equalsIgnoreCase("Banner")) {
				adtype = repo.getAdformatByType("B");
			} else if (str.equalsIgnoreCase("Video")) {
				adtype = repo.getAdformatByType("V");
			}
			allAdtype.addAll(adtype);
		}
		api.setData(allAdtype);
		api.setMessage("Adformat list by type got successfully");
		api.setMsgCode("ADFORMAT_LIST_BY_TYPE_GOT_SUCCESSFULLY");
		return api;
	}

	@GetMapping("/adformat/list")
	private APIResponse getAdtype() {
		APIResponse api = new APIResponse();
		BannerVideoDTO bv1 = new BannerVideoDTO();
		BannerVideoDTO bv2 = new BannerVideoDTO();
		bv1.setFormatId(1);
		bv1.setFormatType("Banner");
		bv2.setFormatId(2);
		bv2.setFormatType("Video");
		List<BannerVideoDTO> bvList = new ArrayList<BannerVideoDTO>();
		bvList.add(bv1);
		bvList.add(bv2);
		api.setData(bvList);
		return api;

	}
}
