package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.AccessRequestCreateDTO;
import com.example.demo.dto.AccessRequestUpdateDTO;
import com.example.demo.dto.RequestApproveDTO;
import com.example.demo.service.AccessRequestService;

@RestController
@RequestMapping("/api/accessrequest")
public class AccessRequestController {

	@Autowired
	private AccessRequestService service;

	@PostMapping("create")
	private APIResponse create(@RequestBody AccessRequestCreateDTO create) {
		APIResponse api = service.create(create);
		return api;
	}

	@PutMapping("update/{request_id}")
	private APIResponse update(@RequestBody AccessRequestUpdateDTO update,
			@PathVariable("request_id") UUID request_id) {
		APIResponse api = service.update(update, request_id);
		return api;
	}

	@PostMapping("approve")
	private APIResponse approve(@RequestBody RequestApproveDTO approve, @RequestHeader UUID user_id) {
		APIResponse api = service.approve(approve, user_id);
		return api;
	}

	@PostMapping("reject")
	private APIResponse reject(@RequestBody RequestApproveDTO reject) {
		APIResponse api = service.reject(reject);
		return api;
	}

	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

}
