package com.example.demo.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;

@Configuration
public class RedisConfiguration {

	@Value("${spring.redis.host}")
	private String host;

	@Value("${spring.redis.port}")
	private int port;

//	@Value("${spring.redis.password}")
//	private String password;

	@Bean
	@Primary
	public Jedis redisConnection() {
		JedisShardInfo info = new JedisShardInfo(host, port);
		Jedis jedis = new Jedis(info);
//		if (!password.equals("")) {
//
//			jedis.auth(password);
//		}

		return jedis;
	}

}
