/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.IpVersionPriorityResolver;
import ru.yandex.clickhouse.util.ssl.NonValidatingTrustManager;

public class ClickHouseHttpClientBuilder {
    private final ClickHouseProperties properties;

    public ClickHouseHttpClientBuilder(ClickHouseProperties properties) {
        this.properties = properties;
    }

    public CloseableHttpClient buildClient() throws Exception {
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.getConnectionManager()).setKeepAliveStrategy(this.createKeepAliveStrategy()).setDefaultConnectionConfig(this.getConnectionConfig()).setDefaultRequestConfig(this.getRequestConfig()).setDefaultHeaders(this.getDefaultHeaders()).disableContentCompression().build();
    }

    private PoolingHttpClientConnectionManager getConnectionManager() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        RegistryBuilder registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (this.properties.getSsl()) {
            registry.register("https", (Object)new SSLConnectionSocketFactory(this.getSSLContext()));
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry.build(), null, null, (DnsResolver)new IpVersionPriorityResolver(), (long)this.properties.getTimeToLiveMillis(), TimeUnit.MILLISECONDS);
        connectionManager.setDefaultMaxPerRoute(this.properties.getDefaultMaxPerRoute());
        connectionManager.setMaxTotal(this.properties.getMaxTotal());
        connectionManager.setDefaultConnectionConfig(this.getConnectionConfig());
        return connectionManager;
    }

    private ConnectionConfig getConnectionConfig() {
        return ConnectionConfig.custom().setBufferSize(this.properties.getApacheBufferSize()).build();
    }

    private RequestConfig getRequestConfig() {
        return RequestConfig.custom().setSocketTimeout(this.properties.getSocketTimeout()).setConnectTimeout(this.properties.getConnectionTimeout()).build();
    }

    private Collection<Header> getDefaultHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        if (this.properties.getHttpAuthorization() != null) {
            headers.add((Header)new BasicHeader("Authorization", this.properties.getHttpAuthorization()));
        }
        return headers;
    }

    private ConnectionKeepAliveStrategy createKeepAliveStrategy() {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    return -1L;
                }
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(httpResponse.headerIterator("Connection"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    if (param == null || !param.equalsIgnoreCase("Keep-Alive")) continue;
                    return ClickHouseHttpClientBuilder.this.properties.getKeepAliveTimeout();
                }
                return -1L;
            }
        };
    }

    private SSLContext getSSLContext() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        TrustManager[] tms = null;
        KeyManager[] kms = null;
        SecureRandom sr = null;
        if (this.properties.getSslMode().equals("none")) {
            tms = new TrustManager[]{new NonValidatingTrustManager()};
            kms = new KeyManager[]{};
            sr = new SecureRandom();
        } else if (this.properties.getSslMode().equals("strict")) {
            if (!this.properties.getSslRootCertificate().isEmpty()) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(this.getKeyStore());
                tms = tmf.getTrustManagers();
                kms = new KeyManager[]{};
                sr = new SecureRandom();
            }
        } else {
            throw new IllegalArgumentException("unknown ssl mode '" + this.properties.getSslMode() + "'");
        }
        ctx.init(kms, tms, sr);
        return ctx;
    }

    private KeyStore getKeyStore() throws NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException {
        InputStream caInputStream;
        KeyStore ks;
        block5: {
            try {
                ks = KeyStore.getInstance("jks");
                ks.load(null, null);
            }
            catch (KeyStoreException e) {
                throw new NoSuchAlgorithmException("jks KeyStore not available");
            }
            try {
                caInputStream = new FileInputStream(this.properties.getSslRootCertificate());
            }
            catch (FileNotFoundException ex) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                caInputStream = cl.getResourceAsStream(this.properties.getSslRootCertificate());
                if (caInputStream != null) break block5;
                throw new IOException("Could not open SSL/TLS root certificate file '" + this.properties.getSslRootCertificate() + "'", ex);
            }
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Iterator<? extends Certificate> caIt = cf.generateCertificates(caInputStream).iterator();
        int i = 0;
        while (caIt.hasNext()) {
            ks.setCertificateEntry("cert" + i, caIt.next());
            ++i;
        }
        return ks;
    }
}

