package djvalidate

import (
	"errors"
	"fmt"
	openrtb "openrtb/openrtb2.5"
	"strings"
	// openrtb2 "github.com/mxmCherry/openrtb/openrtb2"
)

func ValidateRequest25(req *openrtb.BidRequest) []error {
	fmt.Println("validation for openrtb25 called")
	if req.ID == "" {
		return []error{errors.New("openrtb: request ID missing")}
	} else if len(req.Imp) == 0 {
		return []error{errors.New("openrtb: request has no impressions")}
	} else if req.Site != nil && req.App != nil {
		return []error{errors.New("openrtb: request has multiple inventory sources")}
	} else if req.Device == nil {
		return []error{errors.New("openrtb: device format error")}
	}
	if req.Imp != nil {
		for _, Imp := range req.Imp {
			fmt.Println("impression iterater called")
			if err := Validate(Imp); err != nil {
				return []error{errors.New("openrtb: imp format error")}
			}
		}
	}
	if req.Site != nil {
		if err := validatesite(req.Site); err != nil {
			return []error{errors.New("openrtb:Site format error")}
		}
	}
	if req.App != nil {
		if err := validateApp(req.App); err != nil {
			fmt.Println("App validation called")
			return []error{errors.New("openrtb: app format error")}
		}
	}
	if req.Device != nil {
		if err := validatedevice(req.Device); err != nil {
			return []error{errors.New("openrtb: Device format error")}
		}
	}
	// if req.User != nil {
	// 	if err := validateuser(req.User); err != nil {
	// 		return []error{errors.New("openrtb:user Format error")}
	// 	}
	// }
	return nil
}

func Validate(Imp openrtb.Impression) []error {
	if Imp.ID == "" {
		return []error{errors.New("openrtb:imp id is missing")}
	} else if Imp.Metric != nil {
		for _, Metric := range Imp.Metric {
			if Metric.Type == "" {
				return []error{errors.New("openrtb:metric type value is missing")}
			} else if Metric.Value == 0 {
				return []error{errors.New("openrtb:metric value is missing")}
			}
		}
	} else if Imp.BidFloor == 0 {
		fmt.Println("bidfloor is missing")
		return []error{errors.New("openrtb:bidfloor is missing")}
	} else if Imp.Banner != nil {
		if err := validateBanner(Imp.Banner); err != nil {
			return []error{errors.New("openrtb: Banner Format error")}
		}
	} else if Imp.Video != nil {
		if err := validateVideo(Imp.Video); err != nil {
			return []error{errors.New("openrtb:video Format error")}
		}
	} else if Imp.Audio != nil {
		if err := validateAudio(Imp.Audio); err != nil {
			return []error{errors.New("openrtb:audio Format error")}
		}
	}
	if Imp.Pmp != nil {
		if Imp.Pmp.Private >= 2 {
			fmt.Println("private is missing")
			return []error{errors.New("openrtb: private_auction is missing")}
		}
		if Imp.Pmp.Private == 1 {
			if len(Imp.Pmp.Deals) != 0 {
				for _, deal := range Imp.Pmp.Deals {
					if deal.ID == "" {
						fmt.Println("Deal id is missing")
						return []error{errors.New("openrtb:bidfloorcur is missing")}
					}
					if len(deal.WSeat) == 0 {
						fmt.Println("wseat is missing")
						return []error{errors.New("openrtb: wseat is missing")}
					}

				}
			}
		}
	}

	return nil
}

func validateBanner(banner *openrtb.Banner) []error {
	if banner.W == 0 {
		return []error{errors.New("openrtb:width is missing")}
	}
	if banner.H == 0 {
		return []error{errors.New("openrtb:height is missing")}
	}
	// if len(banner.Mimes) == 0 {
	// 	return []error{errors.New("openrtb:Mimes is missing")}
	// }
	return nil
}

func validateVideo(video *openrtb.Video) []error {
	if len(video.Mimes) == 0 {
		return []error{errors.New("openrtb:Mimes is missing")}
	}
	// if video.Linearity == 0 {
	// 	return []error{errors.New("linearity is missing")}
	// }
	return nil
}

func validateAudio(audio *openrtb.Audio) []error {
	if len(audio.Mimes) == 0 {
		return []error{errors.New("openrtb:Mimes is missing")}
	}
	return nil
}

func validatesite(site *openrtb.Site) []error {
	if site.ID == "" {
		return []error{errors.New("openrtb:site id is missing")}
	}
	if site.Name == "" {
		return []error{errors.New("openrtb:name is missing")}
	}
	if len(site.Page) == 0 {
		return []error{errors.New("openrtb: page url is missing")}
	} else if len(site.Page) != 0 {
		if strings.Contains(site.Page, "%1$") {
			strings.ReplaceAll(site.Page, "%1$", "")
		}
	}
	// else if site.Cat != nil {
	// 	if len(site.Cat) == 0 {
	// 		return []error{errors.New("openrtb:site cat is missing")}
	// 	}
	// }
	// if site.Publisher != nil {
	// 	if err := validatepublisher(site.Publisher); err != nil {
	// 		return []error{errors.New("openrtb: publisher format error")}
	// 	}
	// }
	// if site.Domain == "" {
	// 	return []error{errors.New("openrtb:domain is missing")}
	// }
	return nil
}

func validateApp(app *openrtb.App) []error {
	if app.ID == "" {
		fmt.Println("app id")
		return []error{errors.New("openrtb: app id is missing")}
	} else if app.Name == "" {
		fmt.Println("app name")
		return []error{errors.New("openrtb: app name is missing")}
	}
	// else if app.Domain == "" {
	// 	fmt.Println("app Domain")
	// 	return []error{errors.New("openrtb: app domain is missing")}
	// }
	// else if app.Cat != nil {
	// 	if len(app.Cat) == 0 {
	// 		fmt.Println("app cat")
	// 		return []error{errors.New("openrtb: app cat has no value")}
	// 	}
	// } else if app.Publisher != nil {
	// 	if err := validatepublisher(app.Publisher); err != nil {
	// 		fmt.Println("app Publisher")
	// 		return []error{errors.New("openrtb : publisher format error")}
	// 	}
	// }
	return nil
}

func validatedevice(device *openrtb.Device) []error {
	if device.Geo != nil {
		if err := validategeo(device.Geo); err != nil {
			return []error{errors.New("openrtb: Geo is missing")}
		}
	}

	return nil
	// if device.ua == "" {
	// 	return []error{errors.New("openrtb:ua is missing")}
	// } else
	// else if device.Ip != nil {
	// 	if device.Ip == "" {
	// 		fmt.Println("Ip is missing")
	// 		return []error{errors.New("openrtb:Ip is missing")}
	// 	}
	// } else if device.Type != nil {
	// 	if device.Type == 0 {
	// 		fmt.Println("device type is missing")
	// 		return []error{errors.New("openrtb: device type is missing")}
	// 	}
	// } else if device.os != nil {
	// 	if device.os == "" {
	// 		fmt.Println("os is missing")
	// 		return []error{errors.New("openrtb:os is missing")}
	// 	}
	// } else if device.osv != nil {
	// 	if device.osv == 0 {
	// 		fmt.Println("osv is missing")
	// 		return []error{errors.New("openrtb: osv is missing")}
	// 	}
	// }
	// else if device.dnt != nil {
	// 	return []error{errors.New("openrtb:dnt is missing")}
	// } else if device.lmt != nil {
	// 	return []error{errors.New("openrtb:lmt is missing")}
	// }

}

func validategeo(geo *openrtb.Geo) []error {
	if geo.Lat == 0 {
		return []error{errors.New("openrtb:lat is missing")}
	} else if geo.Lon == 0 {
		return []error{errors.New("openrtb:lon is missing")}
	} else if geo.Type == 0 {
		return []error{errors.New("openrtb:type is missing")}
	} else if geo.Country == "" {
		return []error{errors.New("openrtb:country is missing")}
	} else if geo.City == "" {
		return []error{errors.New("openrtb:city is missing")}
	}
	return nil
}

// func validateuser(user *openrtb.User) []error {
// 	if user.Data != nil {
// 		for _, data := range user.Data {
// 			if len(data.Segment) == 0 {
// 				return []error{errors.New("openrtb: segment is missing")}
// 			}
// 			if len(data.Segment) != 0 {
// 				for _, segment := range data.Segment {
// 					if segment.ID == "" {
// 						return []error{errors.New("openrtb:segment id is missing")}
// 					}
// 				}

// 			}
// 		}
// 	}
// 	return nil
// }

// func validatepublisher(publisher *openrtb.Publisher) []error {
// 	// if publisher.ID != nil {
// 	// 	if publisher.ID == "" {
// 	// 		fmt.Println("publisher id is missing")
// 	// 		return []error{errors.New("openrtb: Id is missing")}
// 	// 	}
// 	// } else if publisher.Name != nil {
// 	// 	if publisher.Name == "" {
// 	// 		fmt.Println("publisher name is missing")
// 	// 		return []error{errors.New("openrtb: name is missing")}
// 	// 	}
// 	// } else
// 	// if publisher.Cat != nil {
// 	// 	if len(publisher.Cat) == 0 {
// 	// 		return []error{errors.New("openrtb:cat is missing")}
// 	// 	}
// 	// }
// 	// if publisher.Domain != nil {
// 	if publisher.Domain == "" {
// 		return []error{errors.New("openrtb:domain is missing")}
// 	}
// 	// }
// 	return nil
// }

// func ValidateRequest26(req *openrtb2.BidRequest) []error {
// 	if req.ID == "" {
// 		return []error{errors.New("openrtb: request ID missing")}
// 	} else if len(req.Imp) == 0 {
// 		return []error{errors.New("openrtb: request has no impressions")}
// 	} else if req.Site != nil && req.App != nil {
// 		return []error{errors.New("openrtb: request has multiple inventory sources")}
// 	}
// 	for _, imp := range req.Imp {
// 		if err := (&imp).Validate(); err != nil {
// 			return []error{errors.New("openrtb: impression Format Error")}
// 		}
// 	}
// 	return nil
// }
