package djtracking

import (
	"context"
	"djclickConnect"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Bkt_m struct {
	Request_id  proto.ColUUID
	Bidderid    proto.ColUInt16
	Adid        proto.ColUInt16
	Agencyid    proto.ColUInt16
	Clientid    proto.ColUInt16
	Campaignid  proto.ColUInt16
	Imp_count   proto.ColUInt64
	Won_price   proto.ColFloat64
	Admin_share proto.ColFloat64
	Date_time   proto.ColDateTime
}

func Track_imp(Client *ch.Client, ad_imp *Bkt_m) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "request_id", Data: &ad_imp.Request_id},
		{Name: "bidderid", Data: &ad_imp.Bidderid},
		{Name: "ad_id", Data: &ad_imp.Adid},
		{Name: "agencyid", Data: &ad_imp.Agencyid},
		{Name: "clientid", Data: &ad_imp.Clientid},
		{Name: "campaignid", Data: &ad_imp.Campaignid},
		{Name: "impression_count", Data: &ad_imp.Imp_count},
		{Name: "won_price", Data: &ad_imp.Won_price},
		{Name: "admin_share", Data: &ad_imp.Admin_share},
		{Name: "datatime", Data: &ad_imp.Date_time},
	}

	Client = djclickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("dj_data_bkt_m"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
