package djtarget

import (
	"djconstants"
	"djdb"
	"djextrafunc"
	"djgetad"
	"djlogger"
	"djredis"
	"encoding/csv"
	"fmt"
	"net/url"
	"os"
	"reflect"
	"regexp"
	"strconv"
	"strings"
	"time"

	openrtb "openrtb/openrtb2.5"
)

var redisClient = djredis.Initialize()

type Command struct {
	Name   string
	Args   []string
	Dsp_id int
}

type Commander struct{}

var (
	siteobj25 *openrtb.Site
)

var (
	devobj25 *openrtb.Device
)

var (
	appobj25 *openrtb.App
)

var (
	cookie string
)

var (
	restrictobj25 openrtb.Restrictions
)

var (
	regsobj25 *openrtb.Regulations
)

var (
	userobj25 *openrtb.User
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for coverting string to function arguments
func StringCommandParserUA(cmd string) *Command {
	parts := strings.SplitN(cmd, "(", 2)
	countR := strings.Count(parts[1], ")")
	parts2 := djextrafunc.ReplaceNth(parts[1], ")", "", "", "", countR)
	count := strings.Count(parts2, ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2, ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for Replacing empty geo values with zeros
func MAX_geoReplaceEmptyWithZero(aRegion []string) []string {
	for i := 0; i < len(aRegion); i++ {
		if aRegion[i] == "" {
			aRegion[i] = "0.0000"
		}
	}
	return aRegion
}

// Function for checking region
func MAX_geoIsPlaceInRegion(lattitude string, longitude string, region []string) bool {
	lattitudeSouth := region[0]
	lattitudeNorth := region[1]
	longitudeWest := region[2]
	longitudeEast := region[3]
	return lattitude >= lattitudeSouth && lattitude <= lattitudeNorth && longitude >= longitudeWest && longitude <= longitudeEast
}

// Function to get banner ad
func Targeting(tarChannel chan []djgetad.GetAd, req25 *openrtb.BidRequest, ads []djgetad.GetAd, cookie string, dspid int) {
	cookie = cookie
	var filterads []djgetad.GetAd

	if req25.Device != nil {
		devobj25 = req25.Device
	}

	if req25.Site != nil {
		siteobj25 = req25.Site
	}

	if req25.App != nil {
		appobj25 = req25.App
	}
	if len(req25.Bcat) > 0 || len(req25.BAdv) > 0 || len(req25.BApp) > 0 {
		restrictobj25 = openrtb.Restrictions{Bcat: req25.Bcat, Badv: req25.BAdv, Bapp: req25.BApp}
	}

	if req25.Regs != nil {
		regsobj25 = req25.Regs
	}

	if req25.User != nil {
		userobj25 = req25.User
	}

	validate_campaign := make(map[int]int)

	for _, ad := range ads {

		if validate_campaign[ad.Placement_id] == 1 {

			filterads = append(filterads, ad)
			continue
		}

		if validate_campaign[ad.Placement_id] == 2 {
			continue
		}

		validate_campaign[ad.Placement_id] = 2 // by default not match

		var and bool = true
		var or bool = true
		var command *Command
		var orArray []string
		var andArray []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			compiledlimitation := ad.Compiledlimitation
			replaced1 := strings.ReplaceAll(compiledlimitation, " or ", "||or||")
			replaced2 := strings.ReplaceAll(replaced1, " and ", "||and||")

			if dspid == 46 {
				fmt.Println("replaced string : ", replaced2)
			}

			s := strings.Split(replaced2, "||")
			if dspid == 46 {
				fmt.Println("Compiledlimitation : ", s[1])
			}

			andArray = append(andArray, s[0])

			for i := 1; i < len(s); i += 2 {

				if s[i] == "or" {
					orArray = append(orArray, s[i+1])
				} else if s[i] == "and" {
					andArray = append(andArray, s[i+1])
				}

				// if element != "" {
				// 	for _, e := range strings.Split(element, " or ") {
				// 		if e != "" {
				// 			funcarr = append(funcarr, e)
				// 		}
				// 	}
				// }
			}
			if dspid == 46 {
				fmt.Println("and array :", andArray)
				fmt.Println("or array :", orArray)

			}

			//Add
			for _, funcName := range andArray {
				if funcName != "" {

					//MAX_checkClient_Useragent
					if strings.Contains(funcName, "MAX_checkClient_Useragent") {
						command = StringCommandParserUA(funcName)
					} else {
						command = StringCommandParser(funcName)
					}

					//MAX_checkClient_DSPDomain
					if command.Name == "MAX_checkClient_DSPDomain" {
						// fmt.Printf("condition called")
						command.Dsp_id = dspid
					}
					// fmt.Printf("command :%+v\n", command)

					c := &Commander{}

					f := reflect.ValueOf(c).MethodByName(fmt.Sprint(command.Name))
					if dspid == 46 {
						fmt.Println("AND command.Name", command.Name)
					}
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if dspid == 46 {
							fmt.Println("AND Result of command", fu[0].Interface().(bool))
						}
						if fu[0].Interface().(bool) == false {
							and = false
							break
						} else {
							and = true

						}
					} else {
						and = true
					}
				}
			}

			//Or
			for _, funcName := range orArray {
				if funcName != "" {

					//MAX_checkClient_Useragent
					if strings.Contains(funcName, "MAX_checkClient_Useragent") {
						command = StringCommandParserUA(funcName)
					} else {
						command = StringCommandParser(funcName)
					}

					//MAX_checkClient_DSPDomain
					if command.Name == "MAX_checkClient_DSPDomain" {
						// fmt.Printf("condition called")
						command.Dsp_id = dspid
					}
					// fmt.Printf("command :%+v\n", command)

					c := &Commander{}

					f := reflect.ValueOf(c).MethodByName(fmt.Sprint(command.Name))
					if dspid == 46 {
						fmt.Println("OR command.Name", command.Name)
					}
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if dspid == 46 {
							fmt.Println("OR Result of command", fu[0].Interface().(bool))
						}
						if fu[0].Interface().(bool) == true {
							or = true
							break
						} else {
							or = false

						}
					} else {
						or = false
					}
				}
			}
			if dspid == 46 {

				fmt.Println("and :", and)
				fmt.Println("or : ", or)
			}
			if and != false && or != false {

				filterads = append(filterads, ad)
				validate_campaign[ad.Placement_id] = 1 // match

			}
		} else {
			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match

		}
	}

	if dspid == 46 {
		fmt.Println("filterads :", filterads)
	}
	tarChannel <- filterads

	// fmt.Println("Targetting called")
	// if cookie != "" {
	// 	audiChannel := make(chan []djgetad.GetAd)
	// 	go djaudience_target.CheckAudienceCriteria(audiChannel, cookie, ads)
	// 	ads = <-audiChannel
	// }

	// // var targetads []djgetad.GetAd

	// if req25 != nil {
	// 	restrictobj25 := openrtb.Restrictions{Bcat: req25.Bcat, Badv: req25.BAdv, Bapp: req25.BApp}
	// 	if req25.Device != nil {
	// 		devChannel := make(chan []djgetad.GetAd)
	// 		devobj := req25.Device
	// 		fmt.Println("device target")
	// 		go djdevice_target.CheckDeviceCriteria(devChannel, devobj, ads)

	// 		ads = <-devChannel
	// 		fmt.Println("length", len(devChannel), len(ads))
	// 	}
	// 	if req25.Site != nil {
	// 		siteChannel := make(chan []djgetad.GetAd)
	// 		siteobj := req25.Site
	// 		go djsite_target.CheckSiteCriteria(siteChannel, siteobj, ads, dspid)
	// 		fmt.Println("sitechannel", siteChannel)
	// 		ads = <-siteChannel
	// 		fmt.Println("length", len(siteChannel), len(ads))
	// 		fmt.Println("site targeting done")
	// 	}
	// 	if req25.App != nil {
	// 		appChannel := make(chan []djgetad.GetAd)
	// 		appobj := req25.App
	// 		go djapp_target.CheckAppCriteria(appChannel, appobj, ads)
	// 		ads = <-appChannel
	// 	}
	// 	if req25.User != nil {
	// 		userChannel := make(chan []djgetad.GetAd)
	// 		userobj := req25.User
	// 		go djuser_target.CheckUserCriteria(userChannel, userobj, ads)
	// 		ads = <-userChannel
	// 		if req25.User.Data != nil {
	// 			for _, data := range req25.User.Data {
	// 				dataChannel := make(chan []djgetad.GetAd)
	// 				dataobj := data
	// 				go djdata_target.CheckDataCriteria(dataChannel, 2, dataobj, ads)
	// 				ads = <-dataChannel
	// 				if data.Segment != nil {
	// 					for _, segment := range data.Segment {
	// 						segmentChannel := make(chan []djgetad.GetAd)
	// 						segmentobj := segment
	// 						go djsegment_target.CheckSegmentCriteria(segmentChannel, 2, segmentobj, ads)
	// 						ads = <-segmentChannel
	// 					}
	// 				}
	// 			}
	// 		}
	// 	}
	// 	if req25.Regs != nil {
	// 		regsChannel := make(chan []djgetad.GetAd)
	// 		regsobj := req25.Regs
	// 		go djregs_target.CheckRegsCriteria(regsChannel, regsobj, ads)
	// 		ads = <-regsChannel
	// 	}
	// 	if len(req25.Bcat) > 0 || len(req25.BAdv) > 0 || len(req25.BApp) > 0 {
	// 		restrictChannel := make(chan []djgetad.GetAd)
	// 		go djrestrict_target.CheckRestrictCriteria(restrictChannel, 2, restrictobj25, ads)
	// 		ads = <-restrictChannel
	// 	}
	// }
	// tarChannel <- ads
}

/* ------------------------------------------------------------------------------------
			Device Targetting Start(16/12/19 -18/12/19)
---------------------------------------------------------------------------------------*/
// Ip start
func (c Commander) MAX_checkClient_Ip(cmd Command) bool {
	var reqIP string
	if devobj25 != nil {
		reqIP = devobj25.IP
	}
	argIP := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqIP != "" {
		if op == "=~" || op == "==" {
			return reqIP == argIP
		} else if op == "!=" || op == "!~" {
			return reqIP != argIP
		} else {
			return false
		}
	}
	return false
}

//Ip end

// Os start
func (c Commander) MAX_checkClient_Os(cmd Command) bool {
	var argOS []string
	var reqOS string
	if devobj25 != nil {
		reqOS = strings.ToLower(devobj25.OS)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argOS = append(argOS, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqOS != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqOS, argOS)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqOS, argOS)
		} else {
			return false
		}
	}
	return false
}

// Os end

// Display Type start
func (c Commander) MAX_checkClient_DeviceType(cmd Command) bool {
	var argDT []string
	var reqDT string
	if devobj25 != nil {
		reqDT = strconv.Itoa(devobj25.DeviceType)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argDT = append(argDT, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqDT != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqDT, argDT)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqDT, argDT)
		} else {
			return false
		}
	}
	return false
}

// Display Type end

// Connection Type start
func (c Commander) MAX_checkClient_ConnectionType(cmd Command) bool {

	var argCT []string
	var reqCT string
	if devobj25 != nil {
		reqCT = strconv.Itoa(devobj25.ConnType)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argCT = append(argCT, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqCT != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqCT, argCT)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqCT, argCT)
		} else {
			return false
		}
	}
	return false
}

// connection Type end

// mobileCarrierLimitation start
func (c Commander) MAX_checkClient_Network(cmd Command) bool {
	var argCL []string
	var reqCL string
	if devobj25 != nil {
		reqCL = strings.ToLower(devobj25.Carrier)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argCL = append(argCL, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqCL != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqCL, argCL)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqCL, argCL)
		} else {
			return false
		}
	}
	return false
}

// mobileCarrierLimitation end

// Useragent start
func (c Commander) MAX_checkClient_Useragent(cmd Command) bool {
	var reqUA string
	if devobj25 != nil {
		reqUA = strings.TrimSpace(devobj25.UA)
	}
	argUA := strings.TrimSpace(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqUA != "" {
		if op == "==" {
			return reqUA == argUA
		} else if op == "=~" {
			if strings.Contains(reqUA, argUA) {
				return true
			} else {
				return false
			}
		} else if op == "!=" {
			return reqUA != argUA
		} else if op == "!~" {
			if strings.Contains(reqUA, argUA) {
				return false
			} else {
				return true
			}
		} else if op == "=x" {
			// Create a regular expression object
			regex, err := regexp.Compile(argUA)
			if err != nil {
				fmt.Println("Error compiling regex:", err)
			}
			if regex.MatchString(reqUA) {
				return true
			} else {
				return false
			}
		} else if op == "!x" {
			regex, err := regexp.Compile(argUA)
			if err != nil {
				fmt.Println("Error compiling regex:", err)
			}
			if regex.MatchString(reqUA) {
				return false
			} else {
				return true
			}
		}
	}
	return false
}

// Useragent end

// device make start
func (c Commander) MAX_checkClient_Manufacture(cmd Command) bool {
	var argMake []string
	var reqMake string
	if devobj25 != nil {
		reqMake = strings.ToLower(devobj25.Make)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argMake = append(argMake, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqMake != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqMake, argMake)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqMake, argMake)
		} else {
			return false
		}
	}
	return false
}

// device make end

// device Model start
func (c Commander) MAX_checkClient_Mobilebrandwithmodel(cmd Command) bool {
	var argModel []string
	var reqModel string
	if devobj25 != nil {
		reqModel = strings.ToLower(devobj25.Model)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	remBrand := strings.Split(cmd.Args[0], "|")
	remBrand[0] = strings.ToLower(strings.Replace(remBrand[0], "'", "", -1))
	for _, val := range strings.Split(remBrand[1], ",") {
		argModel = append(argModel, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqModel != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqModel, argModel)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqModel, argModel)
		} else {
			return false
		}
	}
	return false
}

// device Model end

// language start
func (c Commander) MAX_checkClient_Language(cmd Command) bool {
	var argLang []string
	var reqLang string
	if devobj25 != nil {
		reqLang = strings.ToLower(devobj25.Language)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argLang = append(argLang, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqLang != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqLang, argLang)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqLang, argLang)
		} else {
			return false
		}
	}
	return false
}

// language end

// PxRatio start
func (c Commander) MAX_checkClient_PxRatio(cmd Command) bool {
	var argPxRatio []string
	var reqPxRatio string
	if devobj25 != nil {
		reqPxRatio = strconv.FormatFloat(devobj25.PxRatio, 'f', -1, 64)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argPxRatio = append(argPxRatio, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqPxRatio != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqPxRatio, argPxRatio)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqPxRatio, argPxRatio)
		} else {
			return false
		}
	}
	return false
}

// PxRatio end

// ifa start
func (c Commander) MAX_checkClient_IFA(cmd Command) bool {
	var argIFA []string
	var reqIFA string
	if devobj25 != nil {
		reqIFA = strings.ToLower(devobj25.IFA)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argIFA = append(argIFA, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqIFA != "" {
		if op == "==" || op == "=~" {
			return djextrafunc.In_array(reqIFA, argIFA)
		} else if op == "!=" || op == "!~" {
			return !djextrafunc.In_array(reqIFA, argIFA)
		} else {
			return false
		}
	}
	return false
}

// ifa end

// ipv6 start
func (c Commander) MAX_checkClient_IPv6(cmd Command) bool {
	var argIPv6 []string
	var reqIPv6 string
	if devobj25 != nil {
		reqIPv6 = strings.ToLower(devobj25.IPv6)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argIPv6 = append(argIPv6, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqIPv6 != "" {
		if op == "==" {
			return djextrafunc.In_array(reqIPv6, argIPv6)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqIPv6, argIPv6)
		} else {
			return false
		}
	}
	return false
}

// ipv6 end

// OSVer start
func (c Commander) MAX_checkClient_OsVersion(cmd Command) bool {
	var argOSVer []string
	var reqOSVer string
	if devobj25 != nil {
		reqOSVer = strings.ToLower(devobj25.OSVer)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	remOS := strings.Split(cmd.Args[0], "|")
	remOS[0] = strings.ToLower(strings.Replace(remOS[0], "'", "", -1))
	if op == "nn" {
		// if remOS[0] == devobj.OS {
		// 	return true
		// }
	} else {
		for _, val := range strings.Split(remOS[1], ",") {
			argOSVer = append(argOSVer, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
		}
		if reqOSVer != "" {
			if op == "==" {
				return reqOSVer == argOSVer[0]
			} else if op == "!=" {
				return reqOSVer != argOSVer[0]
			} else if op == "lt" {
				return djextrafunc.StringToFloat(argOSVer[0], 64) < djextrafunc.StringToFloat(reqOSVer, 64)
			} else if op == "gt" {
				return djextrafunc.StringToFloat(argOSVer[0], 64) > djextrafunc.StringToFloat(reqOSVer, 64)
			} else if op == "le" {
				return djextrafunc.StringToFloat(argOSVer[0], 64) <= djextrafunc.StringToFloat(reqOSVer, 64)
			} else if op == "ge" {
				return djextrafunc.StringToFloat(argOSVer[0], 64) >= djextrafunc.StringToFloat(reqOSVer, 64)
			} else {
				return false
			}
		}
	}
	return false
}

// OSVer end
/* ------------------------------------------------------------------------------------
			Device Targetting End(16/12/19 -18/12/19)
---------------------------------------------------------------------------------------*/

/* ------------------------------------------------------------------------------------
			Geo Targetting Start(16/12/19 -18/12/19)
---------------------------------------------------------------------------------------*/
// Country Start
func (c Commander) MAX_checkGeo_Country(cmd Command) bool {
	// fmt.Println("country called")
	type Ccode struct {
		Country_code string
	}
	vC := &Ccode{}
	redisClient := djredis.Initialize()
	var argCountry []string
	var reqCountry string
	if devobj25 != nil {
		reqCountry = strings.ToLower(devobj25.Geo.Country)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		val = strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1))
		if len(val) == 3 {
			err := redisClient.GetKey(val, vC)
			if err != nil {
				djlogger.Log.Println("Key : "+val+" expired or error in getting redis key: ", err.Error())
			}
			if vC != nil && err == nil {
				val = strings.ToLower(vC.Country_code)
			} else {
				djdb.DbQueryRow("SELECT country_code from " + djconstants.TablePrefix + "country where iso_countycode_alpha3='" + val + "'").Scan(&vC.Country_code)
				val = strings.ToLower(vC.Country_code)
				err = redisClient.SetKey(val, &Ccode{Country_code: vC.Country_code}, time.Minute*djconstants.RedisExpInMin)
				if err != nil {
					djlogger.Log.Println("Error in setting redis key: ", err.Error())
				}
			}
		}
		argCountry = append(argCountry, val)
	}
	if len(reqCountry) == 3 {
		err := redisClient.GetKey(reqCountry, vC)
		if err != nil {
			djlogger.Log.Println("Key : "+reqCountry+" expired or error in getting redis key: ", err.Error())
		}
		if vC != nil && err == nil {
			reqCountry = strings.ToLower(vC.Country_code)
		} else {
			djdb.DbQueryRow("SELECT country_code from " + djconstants.TablePrefix + "country where iso_countycode_alpha3='" + reqCountry + "'").Scan(&vC.Country_code)
			err = redisClient.SetKey(reqCountry, &Ccode{Country_code: vC.Country_code}, time.Minute*djconstants.RedisExpInMin)
			if err != nil {
				djlogger.Log.Println("Error in setting redis key: ", reqCountry, err.Error())
			}
		}
	}
	// fmt.Println("arg country", argCountry, "req country", reqCountry)
	if reqCountry != "" {
		if op == "=~" {
			// fmt.Println("=~", djextrafunc.In_array(reqCountry, argCountry))
			return djextrafunc.In_array(reqCountry, argCountry)
		} else if op == "!~" {
			// fmt.Println("!~", djextrafunc.In_array(reqCountry, argCountry))
			return !djextrafunc.In_array(reqCountry, argCountry)
		} else {
			// fmt.Println("return false called")
			return false
		}
	}
	return false
}

// Country End

// Latlong Start
func (c Commander) MAX_checkGeo_Latlong(cmd Command) bool {
	var reqLat, reqLon string
	if devobj25 != nil {
		reqLat = djextrafunc.FloatToString(devobj25.Geo.Lat)
		reqLon = djextrafunc.FloatToString(devobj25.Geo.Lon)
	}
	argLatLong := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqLat != "" && reqLon != "" {
		aRegion := MAX_geoReplaceEmptyWithZero(strings.Split(argLatLong, ","))
		result := MAX_geoIsPlaceInRegion(reqLat, reqLon, aRegion)
		if op == "==" {
			return result
		} else if op == "!=" {
			return !result
		} else {
			return false
		}
	}
	return false
}

// Latlong End

// City Start
func (c Commander) MAX_checkGeo_City(cmd Command) bool {
	var reqcountry, reqcity string
	if devobj25 != nil {
		reqcountry = strings.ToUpper(devobj25.Geo.Country)
		reqcity = strings.ToLower(devobj25.Geo.City)
	}
	countryCity := strings.Split(cmd.Args[0], "|")
	argcountry := strings.Replace(strings.ToUpper(countryCity[0]), "'", "", -1)
	argcity := strings.Replace(strings.ToLower(countryCity[1]), "'", "", -1)
	argcities := strings.Split(argcity, ",")
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))

	country_code := make(map[string]interface{})
	var req_countrycode string
	if reqcountry == "IN" {
		fmt.Println("arg country", argcountry, "req country", reqcountry, reqcity, argcities)
	}
	if reqcountry != "" {
		arr1 := redisClient.GetKey("country_code", &country_code)
		if arr1 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr1.Error())
		}

		if val1, err1 := country_code[fmt.Sprint(reqcountry)]; err1 {
			req_countrycode = fmt.Sprint(val1)
		}
		if reqcountry == "IN" {
			fmt.Println("reqcity", reqcity, djextrafunc.In_array(reqcity, argcities))
		}
		if reqcity != "" {

			// fmt.Println("req con", req_countrycode, argcountry, "reqcity", reqcity, argcities)
			if reqcountry == "IN" {
				fmt.Println("req_countrycode", req_countrycode, "argcountry", argcountry)
				fmt.Println("reqcity", argcities, "reqcity", argcities, djextrafunc.In_array(reqcity, argcities))

			}
			if req_countrycode != argcountry {
				return false
			}
			if reqcountry == "IN" {
				fmt.Println("req_countrycode", req_countrycode, "argcountry", argcountry)
				fmt.Println("reqcity", argcities, "reqcity", argcities, djextrafunc.In_array(reqcity, argcities))

			}
			if op == "==" {
				return djextrafunc.In_array(reqcity, argcities)
			} else if op == "!=" {
				return !djextrafunc.In_array(reqcity, argcities)
			} else if op == "=~" {
				return djextrafunc.CheckContains(reqcity, argcities)
			} else if op == "!~" {
				return !djextrafunc.CheckContains(reqcity, argcities)
			} else if op == "=x" {
				return djextrafunc.CheckRegexMatch(reqcity, argcities)
			} else if op == "!x" {
				return !djextrafunc.CheckRegexMatch(reqcity, argcities)
			}
		}
	}
	return false
}

// City End

// Postalcode Start
func (c Commander) MAX_checkGeo_Postalcode(cmd Command) bool {
	var argZip []string
	var reqZip string
	if devobj25 != nil {
		reqZip = devobj25.Geo.Zip
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argZip = append(argZip, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqZip != "" {
		if op == "==" || op == "=~" {
			return djextrafunc.In_array(reqZip, argZip)
		} else if op == "!=" || op == "!~" {
			return !djextrafunc.In_array(reqZip, argZip)
		} else {
			return false
		}
	}
	return false
}

// Postalcode End

// Region Start
func (c Commander) MAX_checkGeo_Region(cmd Command) bool {
	var argRegions []string
	var reqRegions []string
	var reqRegion string
	if devobj25 != nil {
		reqRegion = strings.ToLower(devobj25.Geo.Region)
	}
	argRegion := strings.Split(cmd.Args[0], "|")
	argcountry := strings.Replace(argRegion[0], "'", "", -1)
	reqdata := strings.Split(reqRegion, "|")
	reqcountry := reqdata[0]
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(reqdata[1], ",") {
		reqRegions = append(reqRegions, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	for _, val := range strings.Split(argRegion[1], ",") {
		argRegions = append(argRegions, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqRegion != "" {
		// fmt.Println("arg country", argcountry, "req country", reqcountry)
		if reqcountry != argcountry {
			return false
		}
		if op == "=~" {
			return djextrafunc.In_array(reqRegions, argRegions)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqRegions, argRegions)
		}
	}
	return false
}

// Region End
/* ------------------------------------------------------------------------------------
			Geo Targetting End(16/12/19 -18/12/19)
---------------------------------------------------------------------------------------*/

func (c Commander) MAX_checkTime_Date(cmd Command) bool {

	argtime := strings.TrimSpace(strings.Replace(cmd.Args[0], "'", "", -1))
	parts := strings.Split(argtime, "@")
	date := parts[0]     // Extract date part
	timezone := parts[1] // Extract timezone part
	parsedDate, err := time.Parse("20060102", date)
	if err != nil {
		fmt.Println("Error:", err)

	}
	// Format the parsed date into the desired format
	formattedDate := parsedDate.Format("2006-01-02")

	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))

	location, err := time.LoadLocation(timezone)
	if err != nil {
		fmt.Println("Error:", err)
	}

	currentDate := time.Now().In(location)
	curDate := currentDate.Format("2006-01-02")

	if op == "==" {
		return formattedDate == curDate
	} else if op == "!=" {
		return formattedDate != curDate
	} else if op == ">" {
		return formattedDate > curDate
	} else if op == ">=" {
		return formattedDate >= curDate
	} else if op == "<" {
		return formattedDate < curDate
	} else if op == "<=" {
		return formattedDate <= curDate
	}

	return false

}

func (c Commander) MAX_checkTime_Day(cmd Command) bool {

	var weekdays []string
	var currentDay []string
	argtime := strings.TrimSpace(strings.Replace(cmd.Args[0], "'", "", -1))
	parts := strings.Split(argtime, "@")
	daypart := parts[0] // Extract date part
	day := strings.Split(daypart, ",")
	timezone := parts[1] // Extract timezone part

	for _, v := range day {
		if v == "0" {
			weekdays = append(weekdays, "Sunday")
		} else if v == "1" {
			weekdays = append(weekdays, "Monday")
		} else if v == "2" {
			weekdays = append(weekdays, "Tuesday")
		} else if v == "3" {
			weekdays = append(weekdays, "Wednesday")
		} else if v == "4" {
			weekdays = append(weekdays, "Thursday")
		} else if v == "5" {
			weekdays = append(weekdays, "Friday")
		} else {
			weekdays = append(weekdays, "Saturday")
		}
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))

	location, err := time.LoadLocation(timezone)
	if err != nil {
		fmt.Println("Error:", err)
	}

	currentDate := time.Now().In(location)
	curDate := currentDate.Format("2006-01-02")
	parsedDate, err := time.Parse("2006-01-02", curDate)
	if err != nil {
		fmt.Println("Error:", err)
	}

	currentDay = append(currentDay, parsedDate.Weekday().String())

	if op == "=~" {
		return !djextrafunc.CheckEqualCat(weekdays, currentDay)
	} else if op == "!~" {
		return djextrafunc.CheckEqualCat(weekdays, currentDay)
	}

	return false

}

func (c Commander) MAX_checkTime_Hour(cmd Command) bool {

	var argHour []string
	var currentHour []string
	argtime := strings.TrimSpace(strings.Replace(cmd.Args[0], "'", "", -1))
	parts := strings.Split(argtime, "@")
	hourpart := parts[0] // Extract date part
	argHour = strings.Split(hourpart, ",")
	timezone := parts[1] // Extract timezone part

	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))

	location, err := time.LoadLocation(timezone)
	if err != nil {
		fmt.Println("Error:", err)
	}

	currentDate := time.Now().In(location)
	curDate := currentDate.Format("2006-01-02 15:04:05")
	parsedDate, err := time.Parse("2006-01-02 15:04:05", curDate)
	if err != nil {
		fmt.Println("Error:", err)
	}

	currentHour = append(currentHour, fmt.Sprint(parsedDate.Hour()))

	if op == "=~" {
		return !djextrafunc.CheckEqualCat(argHour, currentHour)
	} else if op == "!~" {
		return djextrafunc.CheckEqualCat(argHour, currentHour)
	}

	return false

}

/* -----------------------------------------------------------------------------------
					Site Targetting (19-12-19 to 20-12-19)
--------------------------------------------------------------------------------------*/
// Domain start
func (c Commander) MAX_checkClient_Domain(cmd Command) bool {
	var argDomain []string
	var reqDomain string
	if siteobj25 != nil {
		reqDomain = strings.ToLower(siteobj25.Domain)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argDomain = append(argDomain, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqDomain != "" {
		if op == "==" || op == "=~" {
			return djextrafunc.In_array(reqDomain, argDomain)
		} else if op == "!=" || op == "!~" {
			return !djextrafunc.In_array(reqDomain, argDomain)
		} else {
			return false
		}
	}
	return false
}

// Domain end

// publisher Domain start
func (c Commander) MAX_checkClient_PubDomain(cmd Command) bool {
	var argPub []string
	var reqPub string
	if siteobj25 != nil {
		reqPub = strings.ToLower(siteobj25.Publisher.Domain)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argPub = append(argPub, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqPub != "" {
		if op == "==" {
			return djextrafunc.In_array(reqPub, argPub)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqPub, argPub)
		} else {
			return false
		}
	}
	return false
}

func removeInvalidEscapes(urlStr string) string {
	// re := regexp.MustCompile(`%[^0-9A-Fa-f]{2}`)
	// re := regexp.MustCompile(`%[0-9A-Fa-f]{0,1}[^0-9A-Fa-f]|%$`)
	re := regexp.MustCompile(`%[^0-9A-Fa-f]{2}|%[0-9A-Fa-f]{0,1}[^0-9A-Fa-f]|%$`)

	return re.ReplaceAllStringFunc(urlStr, func(s string) string {
		return url.QueryEscape(s)
	})
}

// publisher Domain end

// DSP Domain start
func (c Commander) MAX_checkClient_DSPDomain(cmd Command) bool {
	// fmt.Printf("MAX_checkClient_PubDomain called %+v\n", siteobj25.Page, cmd.Dsp_id)
	if cmd.Dsp_id == 42 {
		fmt.Println("MAX_checkClient_DSPDomain")
	}
	var argPub []string
	var reqPub string
	if siteobj25 != nil {

		siteobj25.Page = removeInvalidEscapes(siteobj25.Page)

		parsedURL, err := url.Parse(siteobj25.Page)
		if err != nil {
			fmt.Println("Error parsing URL:", err)

		}

		// domain := parsedURL.Host
		// if strings.HasPrefix(domain, "www.") {
		// 	domain = strings.TrimPrefix(domain, "www.")
		// }

		// Decode and parse loc URL
		loc, err := url.QueryUnescape(parsedURL.Query().Get("loc"))
		if err != nil {
			fmt.Println("Error decoding loc URL:", err)

		}

		locURL, err := url.Parse(loc)
		if err != nil {
			fmt.Println("Error parsing loc URL:", err)

		}

		if loc == "" {
			domain := parsedURL.Host
			if strings.HasPrefix(domain, "www.") {
				domain = strings.TrimPrefix(domain, "www.")
			}
			reqPub = domain
		} else {
			domain := locURL.Host
			if strings.HasPrefix(domain, "www.") {
				domain = strings.TrimPrefix(domain, "www.")
			}
			reqPub = domain
			// fmt.Println("locURL.Get() :", domain)
			//reqPub = strings.ToLower(locURL.Host)
		}
		if cmd.Dsp_id == 46 {
			fmt.Println("Site Targeting Domain :", reqPub)
		}
	} else if appobj25 != nil {
		appobj25.StoreURL = removeInvalidEscapes(appobj25.StoreURL)

		parsedURL, err := url.Parse(appobj25.StoreURL)
		if err != nil {
			fmt.Println("Error parsing URL:", err)

		}

		// domain := parsedURL.Host
		// if strings.HasPrefix(domain, "www.") {
		// 	domain = strings.TrimPrefix(domain, "www.")
		// }

		// Decode and parse loc URL
		loc, err := url.QueryUnescape(parsedURL.Query().Get("loc"))
		if err != nil {
			fmt.Println("Error decoding loc URL:", err)

		}

		locURL, err := url.Parse(loc)
		if err != nil {
			fmt.Println("Error parsing loc URL:", err)

		}

		if loc == "" {
			domain := parsedURL.Host
			if strings.HasPrefix(domain, "www.") {
				domain = strings.TrimPrefix(domain, "www.")
			}
			reqPub = domain
		} else {
			domain := locURL.Host
			if strings.HasPrefix(domain, "www.") {
				domain = strings.TrimPrefix(domain, "www.")
			}
			reqPub = domain
			// fmt.Println("locURL.Get() :", domain)
			//reqPub = strings.ToLower(locURL.Host)
		}
		if cmd.Dsp_id == 46 {
			fmt.Println("App DSP Targeting Domain :", reqPub)
		}

	} else {
		return false
	}

	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))

	str := cmd.Args[0]

	// fmt.Println("arg :", str)
	str = strings.Replace(str, "'", "", -1)
	// Split the string by ","
	parts := strings.Split(str, "|")

	// fmt.Println("parts :", parts[0])
	dspid := strconv.Itoa(cmd.Dsp_id)
	// fmt.Println("cmd.Dsp_id :", cmd.Dsp_id)
	// fmt.Println("dspid :", dspid)
	if dspid == parts[0] {
		// fmt.Println("called condition dspid")
		partss := strings.Split(parts[1], ",")
		// fmt.Println("cmd.Args[0] :", partss)

		for _, val := range partss {

			argPub = append(argPub, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
		}

		if reqPub != "" {

			if op == "==" {
				return djextrafunc.In_array(reqPub, argPub)
			} else if op == "!=" {
				return !djextrafunc.In_array(reqPub, argPub)
			} else {

				return false
			}
		}

		return false
	}

	return true
}

// DSP Domain end

// category start
func (c Commander) MAX_checkClient_SiteCategory(cmd Command) bool {
	var argCat []string
	var reqCat []string
	if siteobj25 != nil {
		for _, cat := range siteobj25.Cat {
			reqCat = append(reqCat, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argCat = append(argCat, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqCat != nil {
		if op == "=~" {
			return !djextrafunc.CheckEqualCat(reqCat, argCat)
		} else if op == "!~" {
			return djextrafunc.CheckEqualCat(reqCat, argCat)
		} else {
			return false
		}
	}
	return false
}

//category end

// Page category start
func (c Commander) MAX_checkClient_SitePageCategory(cmd Command) bool {
	var argpCat []string
	var reqpCat []string
	if siteobj25 != nil {
		for _, cat := range siteobj25.PageCat {
			reqpCat = append(reqpCat, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argpCat = append(argpCat, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqpCat != nil {
		if op == "=~" {
			return !djextrafunc.CheckEqualCat(reqpCat, argpCat)
		} else if op == "!~" {
			return djextrafunc.CheckEqualCat(reqpCat, argpCat)
		} else {
			return false
		}
	}
	return false
}

// page category end

// section category start
func (c Commander) MAX_checkClient_SiteSectionCategory(cmd Command) bool {
	var argsCat []string
	var reqsCat []string
	if siteobj25 != nil {
		for _, cat := range siteobj25.SectionCat {
			reqsCat = append(reqsCat, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argsCat = append(argsCat, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqsCat != nil {
		if op == "=~" {
			return !djextrafunc.CheckEqualCat(reqsCat, argsCat)
		} else if op == "!~" {
			return djextrafunc.CheckEqualCat(reqsCat, argsCat)
		} else {
			return false
		}
	}
	return false
}

// section category end

// page start
func (c Commander) MAX_checkSite_Pageurl(cmd Command) bool {
	var argPage string
	var reqPage string
	if siteobj25 != nil {
		reqPage = strings.ToLower(siteobj25.Page)
	}
	argPage = strings.ToLower(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqPage != "" {
		if op == "==" {
			return reqPage == argPage
		} else if op == "=~" {
			if strings.Contains(reqPage, argPage) {
				return true
			} else {
				return false
			}
		} else if op == "!=" {
			return reqPage != argPage
		} else if op == "!~" {
			if strings.Contains(reqPage, argPage) {
				return false
			} else {
				return true
			}
		} else if op == "=x" {
			// Create a regular expression object
			regex, err := regexp.Compile(argPage)
			if err != nil {
				fmt.Println("Error compiling regex:", err)
			}
			if regex.MatchString(reqPage) {
				return true
			} else {
				return false
			}
		} else if op == "!x" {
			regex, err := regexp.Compile(argPage)
			if err != nil {
				fmt.Println("Error compiling regex:", err)
			}
			if regex.MatchString(reqPage) {
				return false
			} else {
				return true
			}
		}
	}
	return false
}

// page end

// refering page start
func (c Commander) MAX_checkSite_Referingpage(cmd Command) bool {
	var argRefer string
	var reqRefer string
	if siteobj25 != nil {
		reqRefer = strings.ToLower(siteobj25.Ref)
	}
	argRefer = strings.ToLower(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqRefer != "" {
		if op == "==" {
			return reqRefer == argRefer
		} else if op == "=~" {
			if strings.Contains(reqRefer, argRefer) {
				return true
			} else {
				return false
			}
		} else if op == "!=" {
			return reqRefer != argRefer
		} else if op == "!~" {
			if strings.Contains(reqRefer, argRefer) {
				return false
			} else {
				return true
			}
		} else if op == "=x" {
			// Create a regular expression object
			regex, err := regexp.Compile(argRefer)
			if err != nil {
				fmt.Println("Error compiling regex:", err)
			}
			if regex.MatchString(reqRefer) {
				return true
			} else {
				return false
			}
		} else if op == "!x" {
			regex, err := regexp.Compile(argRefer)
			if err != nil {
				fmt.Println("Error compiling regex:", err)
			}
			if regex.MatchString(reqRefer) {
				return false
			} else {
				return true
			}
		}
	}
	return false
}

// refering page end

// Amp page start
func (c Commander) MAX_checkClient_SiteAmp(cmd Command) bool {
	var reqAmp int
	if siteobj25 != nil {
		reqAmp = siteobj25.Amp
	}
	argAmp, _ := strconv.Atoi(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if op == "==" {
		return reqAmp == argAmp
	} else if op == "!=" {
		return reqAmp != argAmp
	} else {
		return false
	}
}

// Amp page end

// Mobile page start
func (c Commander) MAX_checkClient_SiteMobile(cmd Command) bool {
	var reqMob int
	if siteobj25 != nil {
		reqMob = siteobj25.Mobile
	}
	argMob, _ := strconv.Atoi(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if op == "==" {
		return reqMob == argMob
	} else if op == "!=" {
		return reqMob != argMob
	} else {
		return false
	}
}

// Mobile page end
/* -----------------------------------------------------------------------------------
					Site Targetting End(19-12-19 to 20-12-19)
--------------------------------------------------------------------------------------*/

/*------------------------------------------------------
	App Targeting Start : domain,category,bundle,storeurl,ver <==> 19/12/2019 - 20/12/2019
--------------------------------------------------------*/

// PublisherDomain Start
func (c Commander) MAX_checkClient_AppPubDomain(cmd Command) bool {
	var argAppDomain []string
	var reqAppDomain string
	if appobj25 != nil {
		reqAppDomain = appobj25.Publisher.Domain
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppDomain = append(argAppDomain, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqAppDomain != "" {
		if op == "==" {
			return djextrafunc.In_array(reqAppDomain, argAppDomain)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqAppDomain, argAppDomain)
		} else {
			return false
		}
	}
	return false
}

// PublisherDomain End

// Category Start
func (c Commander) MAX_checkClient_AppCategory(cmd Command) bool {
	var reqAppCategory []string
	var argAppCategory []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if appobj25 != nil {
		for _, cat := range appobj25.Cat {
			reqAppCategory = append(reqAppCategory, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppCategory = append(argAppCategory, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqAppCategory != nil {
		if op == "=~" {
			return djextrafunc.CheckEqual(reqAppCategory, argAppCategory)
		} else if op == "!~" {
			return !djextrafunc.CheckEqual(reqAppCategory, argAppCategory)
		}
	}
	return false
}

// Category End

// Bundle Start
func (c Commander) MAX_checkClient_Appid(cmd Command) bool {
	var argAppBundle []string
	var reqAppBundle string
	if appobj25 != nil {
		reqAppBundle = appobj25.Bundle
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppBundle = append(argAppBundle, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqAppBundle != "" {
		if op == "==" {
			return djextrafunc.In_array(reqAppBundle, argAppBundle)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqAppBundle, argAppBundle)
		}
	}
	return false
}

// Bundle End

// StoreUrl Start
func (c Commander) MAX_checkClient_AppStoreUrl(cmd Command) bool {
	var argAppStoreurl []string
	var reqAppStoreurl string
	if appobj25 != nil {
		reqAppStoreurl = appobj25.StoreURL
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppStoreurl = append(argAppStoreurl, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqAppStoreurl != "" {
		if op == "==" {
			return djextrafunc.In_array(reqAppStoreurl, argAppStoreurl)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqAppStoreurl, argAppStoreurl)
		}
	}
	return false
}

// StoreUrl End

// Version Start
func (c Commander) MAX_checkClient_AppVersion(cmd Command) bool {
	var argAppVersion []string
	var reqAppVersion string
	if appobj25 != nil {
		reqAppVersion = appobj25.Ver
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppVersion = append(argAppVersion, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqAppVersion != "" {
		if op == "==" {
			return djextrafunc.In_array(reqAppVersion, argAppVersion)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqAppVersion, argAppVersion)
		} else {
			return false
		}
	}
	return false
}

// Version End
/*------------------------------------------------------
	App Targeting End: domain,category,bundle,storeurl,ver <==> 19/12/2019 - 20/12/2019
--------------------------------------------------------*/

/* -----------------------------------------------------------------------------------
					Audience Targetting Start(08-05-20)
--------------------------------------------------------------------------------------*/
// Audience Segment start
func (c Commander) MAX_checkClient_Segment(cmd Command) bool {
	var argAud []string
	viewer_id := cookie
	found := 0
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if viewer_id != "" && cmd.Args[0] != "" {
		for _, val := range strings.Split(cmd.Args[0], ",") {
			argAud = append(argAud, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
		}
		for _, val := range argAud {
			lines, err := ReadCsv(djconstants.SegmentPath + "seg_" + val + ".csv")
			if err != nil {
				djlogger.Log.Println("Error in reading segment csv file : ", err.Error())
			}
			// Loop through lines & turn into object
			var data []string
			for _, line := range lines {
				data = append(data, line[0])
			}
			if found == 0 {
				if djextrafunc.In_array(viewer_id, data) {
					found = 1
				}
			}
		}
	} else {
		return false
	}
	if (op == "=~" && found == 1) || (op == "!~" && found == 0) {
		return true
	} else {
		return false
	}
}

// Audience Segment end
/* -----------------------------------------------------------------------------------
					Audience Targetting Start(08-05-20)
--------------------------------------------------------------------------------------*/

// ReadCsv accepts a file and returns its content as a multi-dimentional type
// with lines and each column. Only parses to string type.
func ReadCsv(filename string) ([][]string, error) {

	// Open CSV file
	f, err := os.Open(filename)
	if err != nil {
		return [][]string{}, err
	}
	defer f.Close()

	// Read File into a Variable
	lines, err := csv.NewReader(f).ReadAll()
	if err != nil {
		return [][]string{}, err
	}

	return lines, nil
}

/* -----------------------------------------------------------------------------------
					Restriction Targetting Start(11-04-20)
--------------------------------------------------------------------------------------*/
// Blocked category start
func (c Commander) MAX_checkClient_BlockedCategory(cmd Command) bool {
	var reqBlockedCategory []string
	var argBlockedCategory []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if len(restrictobj25.Bcat) > 0 {
		for _, cat := range restrictobj25.Bcat {
			reqBlockedCategory = append(reqBlockedCategory, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argBlockedCategory = append(argBlockedCategory, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqBlockedCategory != nil {
		if op == "==" {
			return !djextrafunc.CheckEqual(reqBlockedCategory, argBlockedCategory)
		} else if op == "!=" {
			return djextrafunc.CheckEqual(reqBlockedCategory, argBlockedCategory)
		} else if op == "=~" {
			return !djextrafunc.CheckEqualCat(reqBlockedCategory, argBlockedCategory)
			// for _, v := range argBlockedCategory {
			// 	for _, v1 := range reqBlockedCategory {
			// 		fmt.Println("argcat", v, "reqcat", v1)
			// 		if v1 == v {
			// 			return false
			// 		}
			// 	}
			// }
			// return true
		} else if op == "!~" {
			return djextrafunc.CheckEqualCat(reqBlockedCategory, argBlockedCategory)
			// for _, v := range argBlockedCategory {
			// 	for _, v1 := range reqBlockedCategory {
			// 		fmt.Println("argcat", v, "reqcat", v1)
			// 		if v1 == v {
			// 			return true
			// 		}
			// 	}
			// }
			// return false
		}
	}
	return true
}

// Blocked category end

// Blocked advertisers start
func (c Commander) MAX_checkClient_BlockedAdvertiser(cmd Command) bool {
	var reqBlockedAdvertiser []string
	var argBlockedAdvertiser []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if len(restrictobj25.Badv) > 0 {
		for _, cat := range restrictobj25.Badv {
			reqBlockedAdvertiser = append(reqBlockedAdvertiser, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argBlockedAdvertiser = append(argBlockedAdvertiser, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqBlockedAdvertiser != nil {
		if op == "==" {
			return !djextrafunc.CheckEqual(reqBlockedAdvertiser, argBlockedAdvertiser)
		} else if op == "!=" {
			return djextrafunc.CheckEqual(reqBlockedAdvertiser, argBlockedAdvertiser)
		} else if op == "=~" {
			for _, v := range argBlockedAdvertiser {
				for _, v1 := range reqBlockedAdvertiser {
					if v1 == v {
						return false
					}
				}
			}
			return true
		} else if op == "!~" {
			for _, v := range argBlockedAdvertiser {
				for _, v1 := range reqBlockedAdvertiser {
					if v1 == v {
						return true
					}
				}
			}
			return false
		}
	}
	return true
}

// Blocked advertisers end

// Blocked apps start
func (c Commander) MAX_checkClient_BlockedApps(cmd Command) bool {
	var reqBlockedApps []string
	var argBlockedApps []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if len(restrictobj25.Bapp) > 0 {
		for _, cat := range restrictobj25.Bapp {
			reqBlockedApps = append(reqBlockedApps, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argBlockedApps = append(argBlockedApps, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqBlockedApps != nil {
		if op == "==" {
			return !djextrafunc.CheckEqual(reqBlockedApps, argBlockedApps)
		} else if op == "!=" {
			return djextrafunc.CheckEqual(reqBlockedApps, argBlockedApps)
		} else if op == "=~" {
			for _, v := range argBlockedApps {
				for _, v1 := range reqBlockedApps {
					if v1 == v {
						return false
					}
				}
			}
		} else if op == "!~" {
			for _, v := range argBlockedApps {
				for _, v1 := range reqBlockedApps {
					if v1 == v {
						return true
					}
				}
			}
			return false
		}
	}
	return true
}

// Blocked apps end
/* -----------------------------------------------------------------------------------
					Restriction Targetting End(11-04-20)
--------------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------------
					Regs Targetting Start(06-04-20)
--------------------------------------------------------------------------------------*/

// Coppa start
func (c Commander) MAX_checkClient_Regcoppa(cmd Command) bool {
	var reqCoppa int
	var argCoppa []int
	if regsobj25 != nil {
		reqCoppa = regsobj25.Coppa
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		ac, _ := strconv.Atoi(strings.ToLower(strings.Replace(val, "'", "", -1)))
		argCoppa = append(argCoppa, ac)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if op == "=~" || op == "==" {
		return djextrafunc.In_array(reqCoppa, argCoppa)
	} else if op == "!=" || op == "!~" {
		return !djextrafunc.In_array(reqCoppa, argCoppa)
	} else {
		return false
	}
}

// Coppa end

/* -----------------------------------------------------------------------------------
					Regs Targetting End(06-04-20)
--------------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------------
					User Targetting Start(19-12-19)
--------------------------------------------------------------------------------------*/
// Gender Tagetting start
func (c Commander) MAX_checkClient_Gender(cmd Command) bool {
	var argGen []string
	var reqGen string
	if userobj25 != nil {
		reqGen = strings.ToLower(userobj25.Gender)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argGen = append(argGen, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqGen != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqGen, argGen)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqGen, argGen)
		} else {
			return false
		}
	}
	return false
}

// Gender Tagetting  end

// YoB Tagetting start
func (c Commander) MAX_checkClient_useryob(cmd Command) bool {
	var argYOB []string
	var reqYOB string
	if userobj25 != nil {
		reqYOB = strconv.Itoa(userobj25.YOB)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argYOB = append(argYOB, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqYOB != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqYOB, argYOB)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqYOB, argYOB)
		} else {
			return false
		}
	}
	return false
}

// Yob Tagetting  end

// Consent Tagetting start
func (c Commander) MAX_checkClient_Consent(cmd Command) bool {
	var argcon []string
	var reqcon string
	if userobj25 != nil {
		reqcon = strings.ToLower(userobj25.Consent)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argcon = append(argcon, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqcon != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqcon, argcon)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqcon, argcon)
		} else {
			return false
		}
	}
	return false
}

// Consent Tagetting  end

// buyeruid Tagetting start
func (c Commander) MAX_checkClient_Buyeruid(cmd Command) bool {
	var arguid []string
	var requid string
	if userobj25 != nil {
		requid = strings.ToLower(userobj25.BuyerUID)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		arguid = append(arguid, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if requid != "" {
		if op == "==" {
			return djextrafunc.In_array(requid, arguid)
		} else if op == "!=" {
			return !djextrafunc.In_array(requid, arguid)
		} else {
			return false
		}
	}
	return false
}

// buyeruid Tagetting  end
/* -----------------------------------------------------------------------------------
					User Targetting End(19-12-19)
--------------------------------------------------------------------------------------*/
