package djsite_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	"fmt"
	"net/url"
	"reflect"
	"strconv"
	"strings"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name   string
	Args   []string
	Dsp_id int
}

type Commander struct{}

var (
	siteobj25 *openrtb.Site
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall site targeting criteria
func CheckSiteCriteria(siteChannel chan []djgetad.GetAd, site25 *openrtb.Site, ads []djgetad.GetAd, dspid int) {
	fmt.Println("CheckSiteCriteria called")
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			siteChannel <- filterads
		}
	}()
	if site25 != nil {

		siteobj25 = site25
	}
	validate_campaign := make(map[int]int)
	fmt.Printf("Array of Compiledlimitation : %+v\n", ads)

	for _, ad := range ads {

		if validate_campaign[ad.Placement_id] == 1 {

			filterads = append(filterads, ad)

			continue
		}

		if validate_campaign[ad.Placement_id] == 2 {

			continue
		}

		validate_campaign[ad.Placement_id] = 2 // by default not match

		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			fmt.Println("Compiledlimitation :", ad.Compiledlimitation)
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					fmt.Printf("funcName :%+v\n", funcName)
					// funcName = "MAX_checkClient_PubDomain('51|adserver.unitdsp.com,rvphp.djaxbidder.com', '!=') and MAX_checkClient_PubDomain('54|revphpe.djaxbidder.com,rvphp.djaxbidder.com', '!=')"

					command := StringCommandParser(funcName)
					if command.Name == "MAX_checkClient_DSPDomain" {
						fmt.Printf("condition called")
						command.Dsp_id = dspid
					}
					fmt.Printf("command :%+v\n", command)

					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(fmt.Sprint(command.Name))

					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}

						fu := f.Call(inputs)

						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {

							ex = true
						}
					} else {

						ex = true
					}
				}
			}
			if ex != false {

				filterads = append(filterads, ad)
				validate_campaign[ad.Placement_id] = 1 // match
			}
		} else {

			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match
		}
	}

	siteChannel <- filterads
}

/* -----------------------------------------------------------------------------------
					Site Targetting (19-12-19 to 20-12-19)
--------------------------------------------------------------------------------------*/
// Domain start
func (c Commander) MAX_checkClient_Domain(cmd Command) bool {
	fmt.Println("MAX_checkClient_Domain called", siteobj25.Domain)
	var argDomain []string
	var reqDomain string
	if siteobj25 != nil {
		reqDomain = strings.ToLower(siteobj25.Domain)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argDomain = append(argDomain, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqDomain != "" {
		if op == "==" || op == "=~" {
			return djextrafunc.In_array(reqDomain, argDomain)
		} else if op == "!=" || op == "!~" {
			return !djextrafunc.In_array(reqDomain, argDomain)
		} else {
			return false
		}
	}
	return false
}

// Domain end

// publisher Domain start
func (c Commander) MAX_checkClient_PubDomain(cmd Command) bool {
	fmt.Printf("MAX_checkClient_PubDomain called %+v\n", siteobj25.Page)
	var argPub []string
	var reqPub string
	if siteobj25 != nil {
		reqPub = strings.ToLower(siteobj25.Domain)
	}

	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {

		argPub = append(argPub, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}

	if reqPub != "" {

		if op == "==" {

			return djextrafunc.In_array(reqPub, argPub)
		} else if op == "!=" {

			return !djextrafunc.In_array(reqPub, argPub)
		} else {

			return false
		}
	}
	return false
}

// publisher Domain end

// DSP Domain start
func (c Commander) MAX_checkClient_DSPDomain(cmd Command) bool {
	fmt.Printf("MAX_checkClient_PubDomain called %+v\n", siteobj25.Page, cmd.Dsp_id)
	var argPub []string
	var reqPub string
	if siteobj25 != nil {

		parsedURL, err := url.Parse(siteobj25.Page)
		if err != nil {
			fmt.Println("Error parsing URL:", err)

		}

		// Decode and parse loc URL
		loc, err := url.QueryUnescape(parsedURL.Query().Get("loc"))
		if err != nil {
			fmt.Println("Error decoding loc URL:", err)

		}

		locURL, err := url.Parse(loc)
		if err != nil {
			fmt.Println("Error parsing loc URL:", err)

		}
		fmt.Println("locURL.Get() :", locURL.Host)
		reqPub = strings.ToLower(locURL.Host)
		fmt.Println("reqPub :", reqPub)
	}

	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))

	str := cmd.Args[0]

	fmt.Println("arg :", str)
	str = strings.Replace(str, "'", "", -1)
	// Split the string by ","
	parts := strings.Split(str, "|")

	fmt.Println("parts :", parts[0])
	dspid := strconv.Itoa(cmd.Dsp_id)
	fmt.Println("cmd.Dsp_id :", cmd.Dsp_id)
	fmt.Println("dspid :", dspid)
	if dspid == parts[0] {
		fmt.Println("called condition dspid")
		partss := strings.Split(parts[1], ",")
		fmt.Println("cmd.Args[0] :", partss)

		for _, val := range partss {

			argPub = append(argPub, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
		}

		if reqPub != "" {

			if op == "==" {
				fmt.Println("return 249")
				fmt.Println("djextrafunc.In_array(reqPub, argPub) :", djextrafunc.In_array(reqPub, argPub))
				return djextrafunc.In_array(reqPub, argPub)
			} else if op == "!=" {
				fmt.Println("return 252")
				fmt.Println("!djextrafunc.In_array(reqPub, argPub) :", !djextrafunc.In_array(reqPub, argPub))
				return !djextrafunc.In_array(reqPub, argPub)
			} else {
				fmt.Println("return 256")

				return false
			}
		}
		fmt.Println("return 261")

		return false
	}
	fmt.Println("return 265")

	return true
}

// DSP Domain end

// category start
func (c Commander) MAX_checkClient_SiteCategory(cmd Command) bool {
	fmt.Println("MAX_checkClient_SiteCategory")
	var argCat []string
	var reqCat []string
	if siteobj25 != nil {
		for _, cat := range siteobj25.Cat {
			fmt.Println("reqcategory", cat)
			reqCat = append(reqCat, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argCat = append(argCat, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	fmt.Println("reqcat", reqCat, "argCat", argCat)
	if reqCat != nil {

		if op == "=~" {
			return !djextrafunc.CheckEqualCat(reqCat, argCat)
		} else if op == "!~" {
			return djextrafunc.CheckEqualCat(reqCat, argCat)
		} else {
			return false
		}
	}
	return false
}

//category end

// Page category start
func (c Commander) MAX_checkClient_SitePageCategory(cmd Command) bool {
	fmt.Println("MAX_checkClient_SitePageCategory")
	var argpCat []string
	var reqpCat []string
	if siteobj25 != nil {
		for _, cat := range siteobj25.PageCat {
			reqpCat = append(reqpCat, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argpCat = append(argpCat, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqpCat != nil {
		fmt.Println("230")
		if op == "=~" {
			fmt.Println("232")
			return !djextrafunc.CheckEqualCat(reqpCat, argpCat)
		} else if op == "!~" {
			return djextrafunc.CheckEqualCat(reqpCat, argpCat)
		} else {
			return false
		}
	}
	return false
}

// page category end

// section category start
func (c Commander) MAX_checkClient_SiteSectionCategory(cmd Command) bool {
	fmt.Println("MAX_checkClient_SiteSectionCategory")
	var argsCat []string
	var reqsCat []string
	if siteobj25 != nil {
		for _, cat := range siteobj25.SectionCat {
			reqsCat = append(reqsCat, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argsCat = append(argsCat, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqsCat != nil {
		if op == "=~" {
			return !djextrafunc.CheckEqualCat(reqsCat, argsCat)
		} else if op == "!~" {
			return djextrafunc.CheckEqualCat(reqsCat, argsCat)
		} else {
			return false
		}
	}
	return false
}

// section category end

// page start
func (c Commander) MAX_checkSite_Pageurl(cmd Command) bool {
	fmt.Println("MAX_checkSite_Pageurl")
	var argPage string
	var reqPage string
	if siteobj25 != nil {
		reqPage = strings.ToLower(siteobj25.Page)
	}
	argPage = strings.ToLower(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqPage != "" {
		if op == "==" || op == "=~" {
			return reqPage == argPage
		} else if op == "!=" || op == "!~" {
			return reqPage != argPage
		} else {
			return false
		}
	}
	return false
}

// page end

// refering page start
func (c Commander) MAX_checkSite_Referingpage(cmd Command) bool {
	fmt.Println("MAX_checkSite_Referingpage")
	var argRefer string
	var reqRefer string
	if siteobj25 != nil {
		reqRefer = strings.ToLower(siteobj25.Ref)
	}
	argRefer = strings.ToLower(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqRefer != "" {
		if op == "==" || op == "=~" {
			return reqRefer == argRefer
		} else if op == "!=" || op == "!~" {
			return reqRefer != argRefer
		} else {
			return false
		}
	}
	return false
}

// refering page end

// Amp page start
func (c Commander) MAX_checkClient_SiteAmp(cmd Command) bool {
	fmt.Println("MAX_checkClient_SiteAmp")
	var reqAmp int
	if siteobj25 != nil {
		reqAmp = siteobj25.Amp
	}
	argAmp, _ := strconv.Atoi(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if op == "==" {
		return reqAmp == argAmp
	} else if op == "!=" {
		return reqAmp != argAmp
	} else {
		return false
	}
}

// Amp page end

// Mobile page start
func (c Commander) MAX_checkClient_SiteMobile(cmd Command) bool {
	fmt.Println("MAX_checkClient_SiteMobile")
	var reqMob int
	if siteobj25 != nil {
		reqMob = siteobj25.Mobile
	}
	argMob, _ := strconv.Atoi(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if op == "==" {
		return reqMob == argMob
	} else if op == "!=" {
		return reqMob != argMob
	} else {
		return false
	}
}

// Mobile page end
/* -----------------------------------------------------------------------------------
					Site Targetting End(19-12-19 to 20-12-19)
--------------------------------------------------------------------------------------*/
