package djsegment_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	"reflect"
	"strings"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	segmentobj25 openrtb.Segment
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "-", "", count), "-")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall segment targeting criteria
func CheckSegmentCriteria(segmentChannel chan []djgetad.GetAd, s int, segment25 openrtb.Segment, ads []djgetad.GetAd) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			segmentChannel <- filterads
		}
	}()
	if s == 2 {
		segmentobj25 = segment25
	}

	validate_campaign := make(map[int]int)

	for _, ad := range ads {
		if validate_campaign[ad.Placement_id] == 1 {

			filterads = append(filterads, ad)
			continue
		}

		if validate_campaign[ad.Placement_id] == 2 {
			continue

		}

		validate_campaign[ad.Placement_id] = 2 // by default not match

		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
				validate_campaign[ad.Placement_id] = 1 // match
			}
		} else {
			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match
		}
	}
	segmentChannel <- filterads
}

/* ------------------------------------------------------------------------------------
			Segment Targetting Start(20/12/19)
---------------------------------------------------------------------------------------*/
// Segmentname start
func (c Commander) MAX_checkClient_Segmentname(cmd Command) bool {
	var reqSN string
	if segmentobj25.Name != "" {
		reqSN = segmentobj25.Name
	}
	argSN := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqSN != "" {
		if op == "=~" || op == "==" {
			return reqSN == argSN
		} else if op == "!=" || op == "!~" {
			return reqSN != argSN
		} else {
			return false
		}
	}
	return false
}

//Segmentname end

// Segmentvalue end
func (c Commander) MAX_checkClient_Segmentvalue(cmd Command) bool {
	var reqSV string
	if segmentobj25.Value != "" {
		reqSV = segmentobj25.Value
	}
	argSV := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqSV != "" {
		if op == "=~" || op == "==" {
			return reqSV == argSV
		} else if op == "!=" || op == "!~" {
			return reqSV != argSV
		} else {
			return false
		}
	}
	return false
}

//Segmentvalue end
/* ------------------------------------------------------------------------------------
			Segment Targetting End(20/12/19)
---------------------------------------------------------------------------------------*/
