package djgetad_models

import (
	"database/sql"
	"djconstants"
	"djdb"
	"djextrafunc"
	"djgetad"
	"djlogger"
	"djredis"
	"encoding/json"
	"fmt"
	php "go-php-serialize"
	"log"
	_ "mysql"
	openrtb "openrtb/openrtb2.5"
	"sort"
	"strconv"
	"strings"
	"time"
)

var (
	err error
)

// Function for searching banner ad from db
func BannerSearch25(width_val int, height_val int, bid_floor float64, dsp_ids int, storage_type string, is_pmp int8, deals25 []openrtb.Deal, redisClient *djredis.RedisClient) ([]djgetad.GetAd, error) {
	fmt.Println("Bannersearch called")
	var rows *sql.Rows
	key := fmt.Sprintf("dj_%d_%d_%d_%s_%d", width_val, height_val, dsp_ids, storage_type, is_pmp)

	getads := []djgetad.GetAd{}
	fmt.Println("Redis key Name : ", key)
	err = redisClient.GetKey(key, &getads)
	if err != nil {
		djlogger.Log.Println("Key : "+key+" expired or error in getting redis key: ", err.Error())
	}

	if len(getads) > 0 && err == nil {

		return getads, nil
	} else if err != nil {

		if storage_type == "NULL" {

			rows, err = djdb.DbQuery("call getAd(?, ?, ?, "+storage_type+", ?,?)", width_val, height_val, dsp_ids, is_pmp, bid_floor)
			fmt.Println("44", "call getAd(?, ?, ?, "+storage_type+", ?,?)", width_val, height_val, dsp_ids, is_pmp, bid_floor)
		} else {

			rows, err = djdb.DbQuery("call getAd(?, ?, ?, '"+storage_type+"', ?,?)", width_val, height_val, dsp_ids, is_pmp, bid_floor)
			fmt.Println("47", "call getAd(?, ?, ?, '"+storage_type+"', ?,?)", width_val, height_val, dsp_ids, is_pmp, bid_floor)
		}
		// defer func() {
		// 	err = rows.Close()
		// 	if err != nil {
		// 		djlogger.Log.Println("Error : ", err)
		// 	}
		// }()

		if err != nil {
			return nil, err
		} else {
			for rows.Next() {
				var (
					ad_id        int
					clientid     int
					agencyid     int
					client_name  string
					placement_id int
					name         string
					storagetype  string
					filename     string
					imageurl     string
					width        int
					height       int
					weight       int
					url          string
					bannertext   string
					// block_ad           int
					// cap_ad             int
					// session_cap_ad     int
					compiledlimitation sql.NullString
					revenue            sql.NullString
					// secondrevenue      sql.NullString
					revenue_type    int
					campaign_weight int
					htmltemplate    string
					pmp             int
					deal_id         string
					// block_campaign int
					// cap_campaign int
					// session_cap_campaign int
					// show_capped_no_cookie int
				)
				err = rows.Scan(&ad_id, &clientid, &agencyid, &client_name, &placement_id, &name, &storagetype, &filename, &imageurl, &width, &height, &weight, &url, &bannertext, &compiledlimitation, &revenue, &revenue_type, &campaign_weight, &htmltemplate, &pmp, &deal_id)
				if err != nil {
					return nil, err
				} else {
					getad := djgetad.GetAd{Ad_id: ad_id, Clientid: clientid, Agencyid: agencyid, Clientname: client_name, Placement_id: placement_id, Name: name, Storagetype: storagetype, Filename: filename, Imageurl: imageurl, Width: width, Height: height, Weight: weight, Url: url, Bannertext: bannertext, Compiledlimitation: compiledlimitation.String, Revenue: revenue.String, Revenue_type: revenue_type, Campaign_weight: campaign_weight, Htmltemplate: htmltemplate, Pmp: pmp, Deal_id: deal_id}
					getad.Revenue_float, _ = strconv.ParseFloat(getad.Revenue, 64)
					if is_pmp == 1 {
						dealid := strings.Split(getad.Deal_id, ",")
						if deals25 != nil {
							for _, v := range deals25 {
								exist := djextrafunc.In_array(v.ID, dealid)
								if exist == true {
									if djextrafunc.StringToFloat(getad.Revenue, 64) > v.BidFloor {
										getads = append(getads, getad)
									}
								}
							}
						}
					} else {
						getads = append(getads, getad)
					}
				}
			}

			sort.Slice(getads, func(i, j int) bool {
				return getads[i].Revenue_float > getads[j].Revenue_float
			})

			if len(getads) > 1 {
				secondLargest := djgetad.GetAd{}

				secondLargest = getads[0]
				for i := 1; i < len(getads); i++ {

					if int(getads[i].Revenue_float) < int(getads[0].Revenue_float) {
						secondLargest = getads[i]
						break
					}
				}

				for a := 0; a < len(getads); a++ {
					getads[a].SecondRevenue = sql.NullString{secondLargest.Revenue, true}
				}
			} else if len(getads) == 1 {
				for a := 0; a < len(getads); a++ {
					getads[a].SecondRevenue = sql.NullString{getads[0].Revenue, true}
				}
			}
		}
		rows.Close()

		err = redisClient.SetKey(key, &getads, time.Minute*djconstants.RedisExpInMin)
		if err != nil {
			fmt.Println("error in redis inserting")

			djlogger.Log.Println("Error in setting redis key: ", err.Error())
		}
		return getads, nil
	} else {
		return getads, nil
	}

}

// Function for searching video ad from db
func VideoSearch(bid_floor float64, mime []string, ctype []int, lineartype int, width int, height int, minDuration int, maxDuration int, minBitRate int, maxBitRate int, maxExtended int, dsp_ids int, is_pmp int8, deals25 []openrtb.Deal, redisClient *djredis.RedisClient) ([]djgetad.GetAd, error) {
	var rows *sql.Rows
	ctype1, inWrap, ovWrap := djextrafunc.Vasttype(ctype)
	getads := []djgetad.GetAd{}

	key := fmt.Sprintf("dj_%d_%d_%d_%d_%d_%d_%d", width, height, minDuration, maxDuration, dsp_ids, lineartype, is_pmp)
	err = redisClient.GetKey(key, &getads)
	if err != nil {
		djlogger.Log.Println("Key : "+key+" expired or error in getting redis key: ", err.Error())
	}

	if len(getads) > 0 && err == nil {

		return getads, nil
	} else if err != nil {
		mime1 := strings.Join(mime, ",")
		ctype2 := djextrafunc.ArrayToString(ctype1, ",")
		inWrap1 := djextrafunc.ArrayToString(inWrap, ",")
		ovWrap1 := djextrafunc.ArrayToString(ovWrap, ",")
		if lineartype == 0 {
			rows, err = djdb.DbQuery("call getVideoAd('"+mime1+"', '"+ctype2+"', NULL,  '"+inWrap1+"', '"+ovWrap1+"',?, ?,?)", dsp_ids, is_pmp, bid_floor)
			fmt.Println("call 266 getVideoAd('"+mime1+"', '"+ctype2+"', NULL,  '"+inWrap1+"', '"+ovWrap1+"',?, ?)", dsp_ids, is_pmp)
		} else {
			if lineartype == 1 {
				ovWrap1 = ""
			} else if lineartype == 2 {
				inWrap1 = "0"
			}
			rows, err = djdb.DbQuery("call getVideoAd('"+mime1+"', '"+ctype2+"', ?,  '"+inWrap1+"', '"+ovWrap1+"',?, ?,?)", lineartype, dsp_ids, is_pmp, bid_floor)
			fmt.Println("274", "call getVideoAd('"+mime1+"', '"+ctype2+"', ?,  '"+inWrap1+"', '"+ovWrap1+"',?, ?)", lineartype, dsp_ids, is_pmp, bid_floor)
		}

		// defer func() {
		// 	err := rows.Close()
		// 	if err != nil {
		// 		djlogger.Log.Println(err)
		// 	}
		// }()
		if err != nil {
			return nil, err
		} else {
			for rows.Next() {
				var (
					ad_id              int
					client_id          int
					agencyid           int
					client_name        string
					placement_id       int
					name               string
					storagetype        string
					filename           string
					imageurl           string
					width              int
					height             int
					weight             int
					url                string
					bannertext         string
					compiledlimitation sql.NullString
					revenue            sql.NullString
					// secondrevenue                            sql.NullString
					revenue_type                             int
					campaign_weight                          int
					htmltemplate                             string
					pmp                                      int
					deal_id                                  string
					parameters                               string
					status                                   int
					banner_vast_element_id                   int
					banner_id                                int
					vast_element_type                        string
					vast_video_id                            sql.NullString
					vast_type                                int
					vast_video_duration                      sql.NullInt64
					vast_video_delivery                      sql.NullString
					get_third_internal_type                  sql.NullInt64
					vast_video_type                          sql.NullString
					vast_video_bitrate                       sql.NullString
					vast_net_connection_url                  sql.NullString
					vast_video_filename                      sql.NullString
					vast_video_height                        sql.NullInt64
					vast_video_width                         sql.NullInt64
					vast_video_outgoing_filename             sql.NullString
					vast_companion_banner_id                 int
					vast_overlay_height                      sql.NullInt64
					vast_overlay_width                       sql.NullInt64
					vast_video_clickthrough_url              sql.NullString
					vast_overlay_action                      sql.NullString
					vast_overlay_format                      sql.NullString
					vast_overlay_text_title                  sql.NullString
					vast_overlay_text_description            sql.NullString
					vast_overlay_text_call                   sql.NullString
					vast_creative_type                       sql.NullString
					vast_thirdparty_impression               sql.NullString
					vast_wrapper_url                         sql.NullString
					vast_version                             sql.NullString
					vast_overlay_wrapper                     sql.NullString
					vast_overlay_version                     sql.NullString
					vast_video_skip_duration                 sql.NullString
					vast_video_skip_progress_duration        sql.NullString
					vast_thirdparty_clicktracking            sql.NullString
					vast_thirdparty_clickcustom              sql.NullString
					vast_overlay_expanded_width              sql.NullInt64
					vast_overlay_expanded_height             sql.NullInt64
					vast_thirdparty_companion_expandedwidth  int
					vast_thirdparty_companion_expandedheight int
					vast_thirdparty_companion_clicktracking  string
					vast_overlay_expandedminduration         sql.NullString
					vast_wrapper_followadditional            int
					vast_wrapper_allowmultipleads            int
					vast_wrapper_fallbacknoads               int
					vast_thirdparty_companion_assetwidth     sql.NullInt64
					vast_thirdparty_companion_assetheight    sql.NullInt64
					vast_thirdparty_companion_pxratio        sql.NullString
					vast_thirdparty_companion_alttext        sql.NullString
					vast4_min_bitrate                        sql.NullInt64
					vast4_max_bitrate                        sql.NullInt64
					vast4_verificationurl2                   sql.NullString
					vast4_verificationurl1                   sql.NullString
					vast4_adverificationtype2                sql.NullString
					vast4_adverificationtype1                sql.NullString
					is_conditionalad                         sql.NullInt64
					vast_icon_filename                       sql.NullString
					vast_icon_xposition                      sql.NullInt64
					vast_icon_yposition                      sql.NullInt64
					vast_icon_duration                       sql.NullString
					vast_icon_offset                         sql.NullString
					vast_icon_height                         sql.NullString
					vast_icon_width                          sql.NullString
					icon_click_url                           sql.NullString
					icon_track_url                           sql.NullString
					iabcategory                              sql.NullString
					vast_video_outgoing_filename1            sql.NullString
					vast_video_type_1                        sql.NullString
					vast_video_bitrate_1                     sql.NullString
					vast_video_outgoing_filename2            sql.NullString
					vast_video_type_2                        sql.NullString
					vast_video_bitrate_2                     sql.NullString
					ad_type                                  sql.NullInt64
					audio_type                               sql.NullString
					interactive_mediafile                    sql.NullString
					is_mezzininefile                         sql.NullInt64
					mezzanine_en                             sql.NullInt64
					internal_file                            sql.NullString
					url_file                                 sql.NullString
					vast_4_1_url                             sql.NullString
					vast_4_1_type_file                       sql.NullString
					vast_4_1_language                        sql.NullString
					vast_4_1_url_1                           sql.NullString
					vast_4_1_type_file_1                     sql.NullString
					vast_4_1_language_1                      sql.NullString
					vast_4_1_url_2                           sql.NullString
					vast_4_1_type_file_2                     sql.NullString
					vast_4_1_language_2                      sql.NullString
					blocked_category                         sql.NullString
					vid_upload_type                          sql.NullString
				)
				err2 := rows.Scan(&ad_id, &client_id, &agencyid, &client_name, &placement_id, &name, &storagetype, &filename, &imageurl, &width, &height, &weight, &url, &bannertext, &compiledlimitation, &revenue, &revenue_type, &campaign_weight, &htmltemplate, &pmp, &deal_id, &parameters, &status, &banner_vast_element_id, &banner_id, &vast_element_type, &vast_video_id, &vast_type, &vast_video_duration, &vast_video_delivery, &get_third_internal_type, &vast_video_type, &vast_video_bitrate, &vast_net_connection_url, &vast_video_filename, &vast_video_height, &vast_video_width, &vast_video_outgoing_filename, &vast_companion_banner_id, &vast_overlay_height, &vast_overlay_width, &vast_video_clickthrough_url, &vast_overlay_action, &vast_overlay_format, &vast_overlay_text_title, &vast_overlay_text_description, &vast_overlay_text_call, &vast_creative_type, &vast_thirdparty_impression, &vast_wrapper_url, &vast_version, &vast_overlay_wrapper, &vast_overlay_version, &vast_video_skip_duration, &vast_video_skip_progress_duration, &vast_thirdparty_clicktracking, &vast_thirdparty_clickcustom, &vast_overlay_expanded_width, &vast_overlay_expanded_height, &vast_thirdparty_companion_expandedwidth, &vast_thirdparty_companion_expandedheight, &vast_thirdparty_companion_clicktracking, &vast_overlay_expandedminduration, &vast_wrapper_followadditional, &vast_wrapper_allowmultipleads, &vast_wrapper_fallbacknoads, &vast_thirdparty_companion_assetwidth, &vast_thirdparty_companion_assetheight, &vast_thirdparty_companion_pxratio, &vast_thirdparty_companion_alttext, &vast4_min_bitrate, &vast4_max_bitrate, &vast4_verificationurl2, &vast4_verificationurl1, &vast4_adverificationtype2, &vast4_adverificationtype1, &is_conditionalad, &vast_icon_filename, &vast_icon_width, &vast_icon_height, &vast_icon_xposition, &vast_icon_yposition, &vast_icon_duration, &vast_icon_offset, &icon_click_url, &icon_track_url, &iabcategory, &vast_video_outgoing_filename1, &vast_video_type_1, &vast_video_bitrate_1, &vast_video_outgoing_filename2, &vast_video_type_2, &vast_video_bitrate_2, &ad_type, &audio_type, &interactive_mediafile, &is_mezzininefile, &mezzanine_en, &internal_file, &url_file, &vast_4_1_url, &vast_4_1_type_file, &vast_4_1_language, &vast_4_1_url_1, &vast_4_1_type_file_1, &vast_4_1_language_1, &vast_4_1_url_2, &vast_4_1_type_file_2, &vast_4_1_language_2, &blocked_category, &vid_upload_type)

				fmt.Println("ERRORSCAN :", err2)
				if err2 != nil {
					if err2 == sql.ErrNoRows {
						fmt.Println("No rows found.")
					} else {
						log.Println(err2)
					}
				}

				// fmt.Println("vid_upload_type", vid_upload_type)

				if err2 != nil {
					return nil, err2
				} else {
					getad := djgetad.GetAd{Ad_id: ad_id, Clientid: client_id, Agencyid: agencyid, Clientname: client_name, Placement_id: placement_id, Name: name, Storagetype: storagetype, Filename: filename, Imageurl: imageurl, Width: width, Height: height, Weight: weight, Url: url, Bannertext: bannertext, Compiledlimitation: compiledlimitation.String, Revenue: revenue.String, Revenue_type: revenue_type, Campaign_weight: campaign_weight, Htmltemplate: htmltemplate, Pmp: pmp, Deal_id: deal_id, Parameters: parameters, Status: status, Banner_vast_element_id: banner_vast_element_id, Vast_element_type: vast_element_type, Vast_video_id: vast_video_id, Vast_type: vast_type, Vast_video_duration: vast_video_duration, Vast_video_delivery: vast_video_delivery, Get_third_internal_type: get_third_internal_type, Vast_video_type: vast_video_type, Vast_video_bitrate: vast_video_bitrate, Vast_net_connection_url: vast_net_connection_url, Vast_video_filename: vast_video_filename, Vast_video_height: vast_video_height, Vast_video_width: vast_video_width, Vast_video_outgoing_filename: vast_video_outgoing_filename, Vast_companion_banner_id: vast_companion_banner_id, Vast_overlay_height: vast_overlay_height, Vast_overlay_width: vast_overlay_width, Vast_video_clickthrough_url: vast_video_clickthrough_url, Vast_overlay_action: vast_overlay_action, Vast_overlay_format: vast_overlay_format, Vast_overlay_text_title: vast_overlay_text_title, Vast_overlay_text_description: vast_overlay_text_description, Vast_overlay_text_call: vast_overlay_text_call, Vast_creative_type: vast_creative_type, Vast_thirdparty_impression: vast_thirdparty_impression, Vast_wrapper_url: vast_wrapper_url, Vast_version: vast_version.String, Vast_overlay_wrapper: vast_overlay_wrapper, Vast_overlay_version: vast_overlay_version, Vast_video_skip_duration: vast_video_skip_duration, Vast_video_skip_progress_duration: vast_video_skip_progress_duration, Vast_thirdparty_clicktracking: vast_thirdparty_clicktracking, Vast_thirdparty_clickcustom: vast_thirdparty_clickcustom, Vast_overlay_expanded_width: vast_overlay_expanded_width, Vast_overlay_expanded_height: vast_overlay_expanded_height, Vast_thirdparty_companion_expandedwidth: vast_thirdparty_companion_expandedwidth, Vast_thirdparty_companion_expandedheight: vast_thirdparty_companion_expandedheight, Vast_thirdparty_companion_clicktracking: vast_thirdparty_companion_clicktracking, Vast_overlay_expandedminduration: vast_overlay_expandedminduration, Vast_wrapper_followadditional: vast_wrapper_followadditional, Vast_wrapper_allowmultipleads: vast_wrapper_allowmultipleads, Vast_wrapper_fallbacknoads: vast_wrapper_fallbacknoads, Vast_thirdparty_companion_assetwidth: vast_thirdparty_companion_assetwidth, Vast_thirdparty_companion_assetheight: vast_thirdparty_companion_assetheight, Vast_thirdparty_companion_pxratio: vast_thirdparty_companion_pxratio, Vast_thirdparty_companion_alttext: vast_thirdparty_companion_alttext, Vast4_min_bitrate: vast4_min_bitrate, Vast4_max_bitrate: vast4_max_bitrate, Vast4_verificationurl2: vast4_verificationurl2, Vast4_verificationurl1: vast4_verificationurl1, Vast4_adverificationtype2: vast4_adverificationtype2.String, Vast4_adverificationtype1: vast4_adverificationtype1.String, Is_conditionalad: is_conditionalad, Vast_icon_filename: vast_icon_filename, Vast_icon_xposition: vast_icon_xposition, Vast_icon_yposition: vast_icon_yposition, Vast_icon_duration: vast_icon_duration, Vast_icon_offset: vast_icon_offset, Vast_icon_height: vast_icon_height, Vast_icon_width: vast_icon_width, Icon_click_url: icon_click_url, Icon_track_url: icon_track_url, Iabcategory: iabcategory, Vast_video_outgoing_filename1: vast_video_outgoing_filename1, Vast_video_type_1: vast_video_type_1, Vast_video_bitrate_1: vast_video_bitrate_1, Vast_video_outgoing_filename2: vast_video_outgoing_filename2, Vast_video_type_2: vast_video_type_2, Vast_video_bitrate_2: vast_video_bitrate_2, Ad_type: ad_type, Audio_type: audio_type, Interactive_mediafile: interactive_mediafile, Is_mezzininefile: is_mezzininefile, Mezzanine_en: mezzanine_en, Internal_file: internal_file, Url_file: url_file, Vast_4_1_url: vast_4_1_url, Vast_4_1_type_file: vast_4_1_type_file, Vast_4_1_language: vast_4_1_language, Vast_4_1_url_1: vast_4_1_url_1, Vast_4_1_type_file_1: vast_4_1_type_file_1, Vast_4_1_language_1: vast_4_1_language_1, Vast_4_1_url_2: vast_4_1_url_2, Vast_4_1_type_file_2: vast_4_1_type_file_2, Vast_4_1_language_2: vast_4_1_language_2, Blocked_category: blocked_category, Vid_upload_type: vid_upload_type}
					getad.Revenue_float, _ = strconv.ParseFloat(getad.Revenue, 64)
					if lineartype == 1 || lineartype == 0 {
						var mxE int
						mxD := int(getad.Vast_video_duration.Int64)
						if mxD > 0 {
							if maxExtended > 0 {
								mxE = maxExtended + maxDuration
							} else {
								mxE = maxDuration
							}
							if maxExtended != -1 || maxExtended == 0 {
								if minDuration != 0 && maxDuration != 0 {
									if minDuration > mxD || mxE < mxD {
										continue
									}
								} else if minDuration != 0 && maxDuration == 0 {
									if minDuration < mxD {
										continue
									}
								} else if minDuration == 0 && maxDuration != 0 {
									if mxD > mxE {
										continue
									}
								}
							}
						}
						br, err := strconv.Atoi(getad.Vast_video_bitrate.String)
						if err != nil {
							br = 0
						}
						if br > 0 {
							if minBitRate != 0 && maxBitRate != 0 {
								if minBitRate > br || maxBitRate < br {
									continue
								}
							} else if minBitRate != 0 && maxBitRate == 0 {
								if minBitRate > br {
									continue
								}
							} else if minBitRate == 0 && maxBitRate != 0 {
								if maxBitRate < br {
									continue
								}
							}
						}
					}
					if is_pmp == 1 {
						dealid := strings.Split(getad.Deal_id, ",")
						if deals25 != nil {
							for _, v := range deals25 {
								exist := djextrafunc.In_array(v.ID, dealid)
								if exist == true {
									if djextrafunc.StringToFloat(getad.Revenue, 64) > v.BidFloor {
										getads = append(getads, getad)
									}
								}
							}
						}
					} else {
						getads = append(getads, getad)
					}
				}
			}
			sort.Slice(getads, func(i, j int) bool {
				return getads[i].Revenue_float > getads[j].Revenue_float
			})

			if len(getads) > 1 {
				secondLargest := djgetad.GetAd{}

				secondLargest = getads[0]
				for i := 1; i < len(getads); i++ {

					if int(getads[i].Revenue_float) < int(getads[0].Revenue_float) {
						secondLargest = getads[i]
						break
					}
				}

				for a := 0; a < len(getads); a++ {
					getads[a].SecondRevenue = sql.NullString{secondLargest.Revenue, true}
				}
			} else if len(getads) == 1 {
				for a := 0; a < len(getads); a++ {
					getads[a].SecondRevenue = sql.NullString{getads[0].Revenue, true}
				}
			}
			rows.Close()
		}
		err = redisClient.SetKey(key, &getads, time.Minute*djconstants.RedisExpInMin)
		if err != nil {
			fmt.Println("error in redis inserting")

			djlogger.Log.Println("Error in setting redis key: ", err.Error())
		}
		return getads, nil
	} else {
		return getads, nil
	}
}

// Function for searching native ad from db
func NativeSearch(bid_floor float64, nativefmt map[string]interface{}, dsp_ids int, storage_type string, is_pmp int8, deals25 []openrtb.Deal) ([]djgetad.GetAd, error) {

	var rows *sql.Rows
	var err error
	getads := []djgetad.GetAd{}
	rows, err = djdb.DbQuery("call getNativeAd( ?, ?,'"+nativefmt["imgMime"].(string)+"','"+storage_type+"', ?, ?)", nativefmt["imgW"].(int), nativefmt["imgH"].(int), dsp_ids, is_pmp)
	fmt.Println("call getNativeAd( ?, ?,'"+nativefmt["imgMime"].(string)+"','"+storage_type+"', ?, ?)", nativefmt["imgW"].(int), nativefmt["imgH"].(int), dsp_ids, is_pmp, bid_floor)
	// defer func() {
	// 	err := rows.Close()
	// 	if err != nil {
	// 		djlogger.Log.Println(err)
	// 	}
	// }()
	if err != nil {

		return nil, err

	} else {

		for rows.Next() {
			var (
				ad_id              int
				client_id          int
				agencyid           int
				client_name        string
				placement_id       int
				name               string
				storagetype        string
				filename           string
				ext_bannertype     string
				imageurl           string
				width              int
				height             int
				weight             int
				url                string
				bannertext         string
				compiledlimitation sql.NullString
				revenue            sql.NullString
				revenue_type       int
				campaign_weight    int
				pmp                int
				deal_id            string
				parameters         string
				secondrevenue      sql.NullString
			)
			err2 := rows.Scan(&ad_id, &client_id, &agencyid, &client_name, &placement_id, &name, &storagetype, &filename, &ext_bannertype, &imageurl, &width, &height, &weight, &url, &bannertext, &compiledlimitation, &revenue, &revenue_type, &campaign_weight, &pmp, &deal_id, &parameters, &secondrevenue)
			if err2 != nil {

				return nil, err2

			} else {

				val, err := php.Decode(parameters)
				if err != nil {
					djlogger.Log.Println(err)
				}
				paramValue := val.(map[interface{}]interface{})

				fmt.Println("577", fmt.Sprint(paramValue["title"]))
				fmt.Println("472", nativefmt["titleLen"].(int))
				if len(fmt.Sprint(paramValue["title"])) <= nativefmt["titleLen"].(int) {

					dataObject := getnativeDataObject(nativefmt, paramValue["data_objects"].(string))

					if paramValue["native_width"] != nil {
						width, _ = strconv.Atoi(paramValue["native_width"].(string))
					}
					if paramValue["native_height"] != nil {

						height, _ = strconv.Atoi(paramValue["native_height"].(string))

					}

					filename = paramValue["filename"].(string)

					getad := djgetad.GetAd{Ad_id: ad_id, Clientid: client_id, Agencyid: agencyid, Clientname: client_name, Placement_id: placement_id, Name: name, Storagetype: storagetype, Filename: filename, Ext_bannertype: ext_bannertype, Icon_image: paramValue["icon_image"].(string), Imageurl: imageurl, Data_objects: dataObject, Width: width, Height: height, Weight: weight, Url: url, Bannertext: bannertext, Compiledlimitation: compiledlimitation.String, Revenue: revenue.String, Revenue_type: revenue_type, Campaign_weight: campaign_weight, Title: fmt.Sprint(paramValue["title"]), Length: len(fmt.Sprint(paramValue["title"])), Pmp: pmp, Deal_id: deal_id, Parameters: parameters}
					getad.Revenue_float, _ = strconv.ParseFloat(getad.Revenue, 64)
					if paramValue["is_icon_image"] != nil {

						getad.Is_icon_image = paramValue["is_icon_image"].(string)
					}

					if is_pmp == 1 {
						dealid := strings.Split(getad.Deal_id, ",")
						if deals25 != nil {

							for _, v := range deals25 {
								exist := djextrafunc.In_array(v.ID, dealid)
								if exist == true {
									if djextrafunc.StringToFloat(getad.Revenue, 64) > v.BidFloor {
										getads = append(getads, getad)
									}
								}
							}
						}
					} else {

						getads = append(getads, getad)
					}

				}
			}
		}
		sort.Slice(getads, func(i, j int) bool {
			return getads[i].Revenue_float > getads[j].Revenue_float
		})

		if len(getads) > 1 {
			secondLargest := djgetad.GetAd{}

			secondLargest = getads[0]
			for i := 1; i < len(getads); i++ {

				if int(getads[i].Revenue_float) < int(getads[0].Revenue_float) {
					secondLargest = getads[i]
					break
				}
			}

			for a := 0; a < len(getads); a++ {
				getads[a].SecondRevenue = sql.NullString{secondLargest.Revenue, true}
			}
		} else if len(getads) == 1 {
			for a := 0; a < len(getads); a++ {
				getads[a].SecondRevenue = sql.NullString{getads[0].Revenue, true}
			}
		}
		rows.Close()
	}

	return getads, nil
}

// Function for getting native data object value
func getnativeDataObject(nativefmt map[string]interface{}, dataObject string) map[int]string {
	var (
		dat map[string]interface{}
	)

	value := make(map[int]string)

	if err := json.Unmarshal([]byte(dataObject), &dat); err != nil {
		djlogger.Log.Println(err)
		fmt.Println(err)

		return value
	}

	//~ return value
	//~ if nativefmt["dataType"].(int) == 1 {
	if dat["dj_data_sponsored"] != nil {
		//~ if len(dat["dj_data_sponsored"].(string)) <= nativefmt["dataLen"].(int) {
		value[1] = dat["dj_data_sponsored"].(string)
		//~ }
	}

	//~ } else if nativefmt["dataType"].(int) == 2 {
	if dat["dj_data_desc"] != nil {
		//~ if len(dat["dj_data_desc"].(string)) <= nativefmt["dataLen"].(int) {
		value[2] = dat["dj_data_desc"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 3 {
	if dat["dj_data_rating"] != nil {
		//~ if nativefmt["dataLen"]== nil || len(dat["dj_data_rating"].(string)) <= nativefmt["dataLen"].(int) {
		value[3] = dat["dj_data_rating"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 4 {
	if dat["dj_data_likes"] != nil {
		//~ if nativefmt["dataLen"]== nil || len(dat["dj_data_likes"].(string)) <= nativefmt["dataLen"].(int) {
		value[4] = dat["dj_data_likes"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 5 {
	if dat["dj_data_downloads"] != nil {
		//~ if len(dat["dj_data_downloads"].(string)) <= nativefmt["dataLen"].(int) {
		value[5] = dat["dj_data_downloads"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 6 {
	if dat["dj_data_price"] != nil {
		if nativefmt["dataLen"] == nil || len(dat["dj_data_price"].(string)) <= nativefmt["dataLen"].(int) {
			value[6] = dat["dj_data_price"].(string)
		}
	}
	//~ } else if nativefmt["dataType"].(int) == 7 {
	if dat["dj_data_salesprice"] != nil {
		//~ if nativefmt["dataLen"]== nil || len(dat["dj_data_salesprice"].(string)) <= nativefmt["dataLen"].(int) {
		value[7] = dat["dj_data_salesprice"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 8 {
	if dat["dj_data_phoneno"] != nil {
		//~ if nativefmt["dataLen"]== nil || len(dat["dj_data_phoneno"].(string)) <= nativefmt["dataLen"].(int) {
		value[8] = dat["dj_data_phoneno"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 9 {
	if dat["dj_data_address"] != nil {
		//~ if nativefmt["dataLen"]== nil || len(dat["dj_data_address"].(string)) <= nativefmt["dataLen"].(int) {
		//~ value[9] = dat["dj_data_address"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 10 {
	if dat["dj_data_desc2"] != nil {
		//~ if nativefmt["dataLen"]== nil || len(dat["dj_data_desc2"].(string)) <= nativefmt["dataLen"].(int) {
		value[10] = dat["dj_data_desc2"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 11 {
	if dat["dj_data_displayurl"] != nil {
		//~ if nativefmt["dataLen"]== nil || len(dat["dj_data_displayurl"].(string)) <= nativefmt["dataLen"].(int) {
		value[11] = dat["dj_data_displayurl"].(string)
		//~ }
	}
	//~ } else if nativefmt["dataType"].(int) == 12 {
	if dat["dj_data_ctatext"] != nil {
		//~ if nativefmt["dataLen"]== nil || len(dat["dj_data_ctatext"].(string)) <= nativefmt["dataLen"].(int) {
		value[12] = dat["dj_data_ctatext"].(string)
		//~ }
	}
	//~ } else {
	//~ value = ""
	//~ }

	return value
}

// Function for searching audio ad from db
func AudioSearch(mime []string, ctype []int, minDuration int, maxDuration int, minBitRate int, maxBitRate int, maxExtended int, dsp_ids int, is_pmp int8, deals25 []openrtb.Deal) ([]djgetad.GetAd, error) {
	var rows *sql.Rows
	ctype1, inWrap, _ := djextrafunc.Vasttype(ctype)
	inWrap1 := djextrafunc.ArrayToString(inWrap, ",")
	getads := []djgetad.GetAd{}
	mime1 := strings.Join(mime, ",")
	ctype2 := djextrafunc.ArrayToString(ctype1, ",")
	rows, err = djdb.DbQuery("call getAudioAd('"+mime1+"', '"+ctype2+"', '"+inWrap1+"', ?, ?)", dsp_ids, is_pmp)
	fmt.Println("call getAudioAd('"+mime1+"', '"+ctype2+"', '"+inWrap1+"', ?, ?)", dsp_ids, is_pmp)
	// defer func() {
	// 	err := rows.Close()
	// 	if err != nil {
	// 		djlogger.Log.Println(err)
	// 	}
	// }()
	if err != nil {
		return nil, err
	} else {
		for rows.Next() {
			var (
				ad_id                                    int
				client_id                                int
				agencyid                                 int
				client_name                              string
				placement_id                             int
				name                                     string
				storagetype                              string
				filename                                 string
				imageurl                                 string
				width                                    int
				height                                   int
				weight                                   int
				url                                      string
				bannertext                               string
				compiledlimitation                       string
				revenue                                  sql.NullString
				revenue_type                             int
				campaign_weight                          int
				htmltemplate                             string
				pmp                                      int
				deal_id                                  string
				parameters                               string
				status                                   int
				banner_vast_element_id                   int
				banner_id                                int
				vast_element_type                        string
				vast_video_id                            sql.NullString
				vast_type                                int
				vast_video_duration                      sql.NullInt64
				vast_video_delivery                      sql.NullString
				get_third_internal_type                  sql.NullInt64
				vast_video_type                          sql.NullString
				vast_video_bitrate                       sql.NullString
				vast_net_connection_url                  sql.NullString
				vast_video_filename                      sql.NullString
				vast_video_height                        sql.NullInt64
				vast_video_width                         sql.NullInt64
				vast_video_outgoing_filename             sql.NullString
				vast_companion_banner_id                 int
				vast_overlay_height                      sql.NullInt64
				vast_overlay_width                       sql.NullInt64
				vast_video_clickthrough_url              sql.NullString
				vast_overlay_action                      sql.NullString
				vast_overlay_format                      sql.NullString
				vast_overlay_text_title                  sql.NullString
				vast_overlay_text_description            sql.NullString
				vast_overlay_text_call                   sql.NullString
				vast_creative_type                       sql.NullString
				vast_thirdparty_impression               sql.NullString
				vast_wrapper_url                         sql.NullString
				vast_version                             string
				vast_overlay_wrapper                     sql.NullString
				vast_overlay_version                     sql.NullString
				vast_video_skip_duration                 sql.NullString
				vast_video_skip_progress_duration        sql.NullString
				vast_thirdparty_clicktracking            sql.NullString
				vast_thirdparty_clickcustom              sql.NullString
				vast_overlay_expanded_width              sql.NullInt64
				vast_overlay_expanded_height             sql.NullInt64
				vast_thirdparty_companion_expandedwidth  int
				vast_thirdparty_companion_expandedheight int
				vast_thirdparty_companion_clicktracking  string
				vast_overlay_expandedminduration         sql.NullString
				vast_wrapper_followadditional            int
				vast_wrapper_allowmultipleads            int
				vast_wrapper_fallbacknoads               int
				vast_thirdparty_companion_assetwidth     sql.NullInt64
				vast_thirdparty_companion_assetheight    sql.NullInt64
				vast_thirdparty_companion_pxratio        sql.NullString
				vast_thirdparty_companion_alttext        sql.NullString
				vast4_min_bitrate                        sql.NullInt64
				vast4_max_bitrate                        sql.NullInt64
				vast4_verificationurl2                   sql.NullString
				vast4_verificationurl1                   sql.NullString
				vast4_adverificationtype2                string
				vast4_adverificationtype1                string
				is_conditionalad                         sql.NullInt64
				vast_icon_filename                       sql.NullString
				vast_icon_xposition                      sql.NullInt64
				vast_icon_yposition                      sql.NullInt64
				vast_icon_duration                       sql.NullString
				vast_icon_offset                         sql.NullString
				vast_icon_height                         sql.NullString
				vast_icon_width                          sql.NullString
				icon_click_url                           sql.NullString
				icon_track_url                           sql.NullString
				iabcategory                              sql.NullString
				vast_video_outgoing_filename1            sql.NullString
				vast_video_type_1                        sql.NullString
				vast_video_bitrate_1                     sql.NullString
				vast_video_outgoing_filename2            sql.NullString
				vast_video_type_2                        sql.NullString
				vast_video_bitrate_2                     sql.NullString
				ad_type                                  sql.NullInt64
				audio_type                               sql.NullString
				interactive_mediafile                    sql.NullString
				is_mezzininefile                         sql.NullInt64
				mezzanine_en                             sql.NullInt64
				internal_file                            sql.NullString
				url_file                                 sql.NullString
				vast_4_1_url                             sql.NullString
				vast_4_1_type_file                       sql.NullString
				vast_4_1_language                        sql.NullString
				vast_4_1_url_1                           sql.NullString
				vast_4_1_type_file_1                     sql.NullString
				vast_4_1_language_1                      sql.NullString
				vast_4_1_url_2                           sql.NullString
				vast_4_1_type_file_2                     sql.NullString
				vast_4_1_language_2                      sql.NullString
				blocked_category                         sql.NullString
				secondrevenue                            sql.NullString
				vid_upload_type                          sql.NullString
			)
			err2 := rows.Scan(&ad_id, &client_id, &agencyid, &client_name, &placement_id, &name, &storagetype, &filename, &imageurl, &width, &height, &weight, &url, &bannertext, &compiledlimitation, &revenue, &revenue_type, &campaign_weight, &htmltemplate, &pmp, &deal_id, &parameters, &status, &banner_vast_element_id, &banner_id, &vast_element_type, &vast_video_id, &vast_type, &vast_video_duration, &vast_video_delivery, &get_third_internal_type, &vast_video_type, &vast_video_bitrate, &vast_net_connection_url, &vast_video_filename, &vast_video_height, &vast_video_width, &vast_video_outgoing_filename, &vast_companion_banner_id, &vast_overlay_height, &vast_overlay_width, &vast_video_clickthrough_url, &vast_overlay_action, &vast_overlay_format, &vast_overlay_text_title, &vast_overlay_text_description, &vast_overlay_text_call, &vast_creative_type, &vast_thirdparty_impression, &vast_wrapper_url, &vast_version, &vast_overlay_wrapper, &vast_overlay_version, &vast_video_skip_duration, &vast_video_skip_progress_duration, &vast_thirdparty_clicktracking, &vast_thirdparty_clickcustom, &vast_overlay_expanded_width, &vast_overlay_expanded_height, &vast_thirdparty_companion_expandedwidth, &vast_thirdparty_companion_expandedheight, &vast_thirdparty_companion_clicktracking, &vast_overlay_expandedminduration, &vast_wrapper_followadditional, &vast_wrapper_allowmultipleads, &vast_wrapper_fallbacknoads, &vast_thirdparty_companion_assetwidth, &vast_thirdparty_companion_assetheight, &vast_thirdparty_companion_pxratio, &vast_thirdparty_companion_alttext, &vast4_min_bitrate, &vast4_max_bitrate, &vast4_verificationurl2, &vast4_verificationurl1, &vast4_adverificationtype2, &vast4_adverificationtype1, &is_conditionalad, &vast_icon_filename, &vast_icon_xposition, &vast_icon_yposition, &vast_icon_duration, &vast_icon_offset, &vast_icon_height, &vast_icon_width, &icon_click_url, &icon_track_url, &iabcategory, &vast_video_outgoing_filename1, &vast_video_type_1, &vast_video_bitrate_1, &vast_video_outgoing_filename2, &vast_video_type_2, &vast_video_bitrate_2, &ad_type, &audio_type, &interactive_mediafile, &is_mezzininefile, &mezzanine_en, &internal_file, &url_file, &vast_4_1_url, &vast_4_1_type_file, &vast_4_1_language, &vast_4_1_url_1, &vast_4_1_type_file_1, &vast_4_1_language_1, &vast_4_1_url_2, &vast_4_1_type_file_2, &vast_4_1_language_2, &blocked_category, &vid_upload_type, &secondrevenue)
			if err2 != nil {
				return nil, err2
			} else {
				getad := djgetad.GetAd{Ad_id: ad_id, Clientid: client_id, Agencyid: agencyid, Clientname: client_name, Placement_id: placement_id, Name: name, Storagetype: storagetype, Filename: filename, Imageurl: imageurl, Width: width, Height: height, Weight: weight, Url: url, Bannertext: bannertext, Compiledlimitation: compiledlimitation, Revenue: revenue.String, Revenue_type: revenue_type, Campaign_weight: campaign_weight, Htmltemplate: htmltemplate, Pmp: pmp, Deal_id: deal_id, Parameters: parameters, Status: status, Banner_vast_element_id: banner_vast_element_id, Vast_element_type: vast_element_type, Vast_video_id: vast_video_id, Vast_type: vast_type, Vast_video_duration: vast_video_duration, Vast_video_delivery: vast_video_delivery, Get_third_internal_type: get_third_internal_type, Vast_video_type: vast_video_type, Vast_video_bitrate: vast_video_bitrate, Vast_net_connection_url: vast_net_connection_url, Vast_video_filename: vast_video_filename, Vast_video_height: vast_video_height, Vast_video_width: vast_video_width, Vast_video_outgoing_filename: vast_video_outgoing_filename, Vast_companion_banner_id: vast_companion_banner_id, Vast_overlay_height: vast_overlay_height, Vast_overlay_width: vast_overlay_width, Vast_video_clickthrough_url: vast_video_clickthrough_url, Vast_overlay_action: vast_overlay_action, Vast_overlay_format: vast_overlay_format, Vast_overlay_text_title: vast_overlay_text_title, Vast_overlay_text_description: vast_overlay_text_description, Vast_overlay_text_call: vast_overlay_text_call, Vast_creative_type: vast_creative_type, Vast_thirdparty_impression: vast_thirdparty_impression, Vast_wrapper_url: vast_wrapper_url, Vast_version: vast_version, Vast_overlay_wrapper: vast_overlay_wrapper, Vast_overlay_version: vast_overlay_version, Vast_video_skip_duration: vast_video_skip_duration, Vast_video_skip_progress_duration: vast_video_skip_progress_duration, Vast_thirdparty_clicktracking: vast_thirdparty_clicktracking, Vast_thirdparty_clickcustom: vast_thirdparty_clickcustom, Vast_overlay_expanded_width: vast_overlay_expanded_width, Vast_overlay_expanded_height: vast_overlay_expanded_height, Vast_thirdparty_companion_expandedwidth: vast_thirdparty_companion_expandedwidth, Vast_thirdparty_companion_expandedheight: vast_thirdparty_companion_expandedheight, Vast_thirdparty_companion_clicktracking: vast_thirdparty_companion_clicktracking, Vast_overlay_expandedminduration: vast_overlay_expandedminduration, Vast_wrapper_followadditional: vast_wrapper_followadditional, Vast_wrapper_allowmultipleads: vast_wrapper_allowmultipleads, Vast_wrapper_fallbacknoads: vast_wrapper_fallbacknoads, Vast_thirdparty_companion_assetwidth: vast_thirdparty_companion_assetwidth, Vast_thirdparty_companion_assetheight: vast_thirdparty_companion_assetheight, Vast_thirdparty_companion_pxratio: vast_thirdparty_companion_pxratio, Vast_thirdparty_companion_alttext: vast_thirdparty_companion_alttext, Vast4_min_bitrate: vast4_min_bitrate, Vast4_max_bitrate: vast4_max_bitrate, Vast4_verificationurl2: vast4_verificationurl2, Vast4_verificationurl1: vast4_verificationurl1, Vast4_adverificationtype2: vast4_adverificationtype2, Vast4_adverificationtype1: vast4_adverificationtype1, Is_conditionalad: is_conditionalad, Vast_icon_filename: vast_icon_filename, Vast_icon_xposition: vast_icon_xposition, Vast_icon_yposition: vast_icon_yposition, Vast_icon_duration: vast_icon_duration, Vast_icon_offset: vast_icon_offset, Vast_icon_height: vast_icon_height, Vast_icon_width: vast_icon_width, Icon_click_url: icon_click_url, Icon_track_url: icon_track_url, Iabcategory: iabcategory, Vast_video_outgoing_filename1: vast_video_outgoing_filename1, Vast_video_type_1: vast_video_type_1, Vast_video_bitrate_1: vast_video_bitrate_1, Vast_video_outgoing_filename2: vast_video_outgoing_filename2, Vast_video_type_2: vast_video_type_2, Vast_video_bitrate_2: vast_video_bitrate_2, Ad_type: ad_type, Audio_type: audio_type, Interactive_mediafile: interactive_mediafile, Is_mezzininefile: is_mezzininefile, Mezzanine_en: mezzanine_en, Internal_file: internal_file, Url_file: url_file, Vast_4_1_url: vast_4_1_url, Vast_4_1_type_file: vast_4_1_type_file, Vast_4_1_language: vast_4_1_language, Vast_4_1_url_1: vast_4_1_url_1, Vast_4_1_type_file_1: vast_4_1_type_file_1, Vast_4_1_language_1: vast_4_1_language_1, Vast_4_1_url_2: vast_4_1_url_2, Vast_4_1_type_file_2: vast_4_1_type_file_2, Vast_4_1_language_2: vast_4_1_language_2, Blocked_category: blocked_category, SecondRevenue: secondrevenue, Vid_upload_type: vid_upload_type}
				var mxE int
				mxD := int(getad.Vast_video_duration.Int64)
				if mxD > 0 {
					if maxExtended > 0 {
						mxE = maxExtended + maxDuration
					} else {
						mxE = maxDuration
					}
					if maxExtended != -1 || maxExtended == 0 {
						if minDuration != 0 && maxDuration != 0 {
							if minDuration > mxD || mxE < mxD {
								continue
							}
						} else if minDuration != 0 && maxDuration == 0 {
							if minDuration < mxD {
								continue
							}
						} else if minDuration == 0 && maxDuration != 0 {
							if mxD > mxE {
								continue
							}
						}
					}
				}
				br, err := strconv.Atoi(getad.Vast_video_bitrate.String)
				if err != nil {
					br = 0
				}
				if minBitRate != 0 && maxBitRate != 0 {
					if minBitRate > br || maxBitRate < br {
						continue
					}
				} else if minBitRate != 0 && maxBitRate == 0 {
					if minBitRate > br {
						continue
					}
				} else if minBitRate == 0 && maxBitRate != 0 {
					if maxBitRate < br {
						continue
					}
				}
				if is_pmp == 1 {
					dealid := strings.Split(getad.Deal_id, ",")
					if deals25 != nil {
						for _, v := range deals25 {
							exist := djextrafunc.In_array(v.ID, dealid)
							if exist == true {
								if djextrafunc.StringToFloat(getad.Revenue, 64) > v.BidFloor {
									getads = append(getads, getad)
								}
							}
						}
					}
				} else {
					getads = append(getads, getad)
				}
			}
		}
		rows.Close()
	}
	return getads, nil
}
