package djextrafunc

import (
	"bytes"
	"database/sql"
	"djconstants"
	"djdb"
	"net/http"
	"regexp"
	"sort"
	"sync"

	//  "djlogger"
	"djredis"
	"errors"
	"fmt"
	"math"
	"math/rand"
	"net"
	"reflect"
	"strconv"
	"strings"
	"time"
)

// Function for getting DSP id from db
func GetDspId(dsp_name string, key string, bid int, redisClient *djredis.RedisClient) (int, string, float64, string, string, string) {
	type valueEx struct {
		Dsp_id            int
		Dmp_pixel         string
		Admin_share       float64
		WebResponseType   string
		VideoResponseType string
		DS                string
	}
	var where string
	if bid != 0 {
		where = "id=" + strconv.Itoa(bid)
		dsp_name = "dsp" + strconv.Itoa(bid)

	} else {
		where = "dsp_portal_name='" + dsp_name + "'"
		where += " and auth_key='" + key + "'"
	}

	v := &valueEx{}

	//  errs := redisClient.GetKey(dsp_name, v)

	// 		 fmt.Println(dsp_name);

	//  if errs != nil {
	// 	 djlogger.Log.Println("Key expired or error in getting redis key: ", errs.Error())
	//  }
	// fmt.Println("dsp :",v)
	//  if v != nil && errs == nil {
	// 	fmt.Println("Fetching dsp data from redis")
	// 	 return v.Dsp_id, v.Dmp_pixel, v.Admin_share, v.WebResponseType, v.VideoResponseType, v.DS
	//  } else {

	djdb.DbQueryRow("SELECT id,admin_share,web_response_type,video_response_type,digital_signature from "+djconstants.TablePrefix+"dj_dsp where "+where+" and status='1'").Scan(&v.Dsp_id, &v.Admin_share, &v.WebResponseType, &v.VideoResponseType, &v.DS)

	//  errs := redisClient.SetKey(dsp_name, &valueEx{Dsp_id: v.Dsp_id, Dmp_pixel: v.Dmp_pixel, Admin_share: v.Admin_share, WebResponseType: v.WebResponseType, VideoResponseType: v.VideoResponseType, DS: v.DS}, time.Minute*djconstants.RedisExpInMin)
	//  errs = redisClient.SetKey("dsp"+ strconv.Itoa(v.Dsp_id), &valueEx{Dsp_id: v.Dsp_id, Dmp_pixel: v.Dmp_pixel, Admin_share: v.Admin_share, WebResponseType: v.WebResponseType, VideoResponseType: v.VideoResponseType, DS: v.DS}, time.Minute*djconstants.RedisExpInMin)
	//  if errs != nil {
	// 	 djlogger.Log.Println("Error in setting redis key: ", errs.Error())
	//  }
	fmt.Printf("DSP details :%+v\n", v)
	return v.Dsp_id, v.Dmp_pixel, v.Admin_share, v.WebResponseType, v.VideoResponseType, v.DS
	//  }
}

// Function for coverting float to string
func FloatToString(input_num float64) string {
	return strconv.FormatFloat(input_num, 'f', 6, 64)
}

// Function for coverting float to string
func StringToFloat(str string, bit int) float64 {
	if flt, err := strconv.ParseFloat(str, bit); err == nil {
		return flt
	}
	return 0
}

// Function for replacing Nth character in a string
func ReplaceNth(s, old, old1, new string, new1 string, n int) string {
	if old1 != "" && new1 != "" {
		s = strings.Replace(s, old1, new1, -1)
	}
	i := 0
	for m := 1; m <= n; m++ {
		x := strings.Index(s[i:], old)
		if x < 0 {
			break
		}
		i += x
		if m == n {
			if old1 != "" && new1 != "" {
				u := s[:i] + new + s[i+len(old):]
				return u[:strings.IndexByte(u, ' ')]
			}
			return s[:i] + new + s[i+len(old):]
		}
		i += len(old)
	}
	return s
}

// Function for checking value in an array
func In_array(val interface{}, array interface{}) (exists bool) {
	exists = false
	switch reflect.TypeOf(array).Kind() {
	case reflect.Slice:
		s := reflect.ValueOf(array)
		for i := 0; i < s.Len(); i++ {
			if reflect.DeepEqual(val, s.Index(i).Interface()) == true {
				exists = true
				return
			}
		}
	}
	return
}

func ContainsKeywordInArray(slice string, keyword []string) bool {
	// for _, item := range slice {
	for _, v := range keyword {
		if strings.Contains(slice, v) {
			return true
		}
	}
	// }
	return false
}

// Function for checking both arrays are equal
func CheckEqual(a, b []string) bool {
	// If one is nil, the other must also be nil.
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for i := range a {
		if a[i] == b[i] {
			return false
		} else {
			return true
		}
	}
	return true
}

// Function for checking both arrays are equal
func CheckEqualCat(a, b []string) bool {
	// If one is nil, the other must also be nil.
	catlen := findLength(a, b)
	if (a == nil) != (b == nil) {
		return false
	}
	if len(catlen) == len(a) {
		for i := range catlen {
			for j := range b {
				if a[i] == b[j] {
					return false
				}
			}
		}
	} else {
		for i := range catlen {
			for j := range a {
				if b[i] == a[j] {
					return false
				}
			}
		}
	}
	return true
}

func CheckContains(a string, b []string) bool {

	if len(b) != 0 && a != "" {
		if len(b) == 1 {
			if strings.Contains(a, b[0]) {
				return true
			} else {
				return false
			}
		} else if len(b) > 1 {
			for i := range b {
				if strings.Contains(a, b[i]) {
					return true
				}
			}
			return false
		}
	}
	return false
}

func CheckRegexMatch(a string, b []string) bool {

	if len(b) != 0 && a != "" {
		if len(b) == 1 {
			regex, err := regexp.Compile(a)
			if err != nil {
				fmt.Println("Error compiling regex:", err)
			}
			if regex.MatchString(b[0]) {
				return true
			} else {
				return false
			}
		} else if len(b) > 1 {
			for i := range b {
				regex, err := regexp.Compile(a)
				if err != nil {
					fmt.Println("Error compiling regex:", err)
				}
				if regex.MatchString(b[i]) {
					return true
				}
			}
			return false
		}
	}
	return false
}

func findLength(a, b []string) []string {

	len_a := len(a)
	len_b := len(b)
	if len_a > len_b {
		return a
	} else {
		return b
	}
}

// Function for generating random token
func RandToken(len int) string {
	b := make([]byte, len)
	rand.Read(b)
	return fmt.Sprintf("%x", b)
}

// Function for coverting array to string
func ArrayToString(a interface{}, delim string) string {
	return strings.Trim(strings.Replace(fmt.Sprint(a), " ", delim, -1), "[]")
}

// Function for generating random number
func RandNumber(len int) int {
	l := "1"
	for i := 0; i < len; i++ {
		l += "0"
	}
	stri, _ := strconv.Atoi(l)
	rand.Seed(time.Now().UnixNano())
	return rand.Intn(stri)
}

// Function for getting vast type
func Vasttype(ctype interface{}) (interface{}, interface{}, interface{}) {
	var ctypeArr, inWrap, ovWrap []interface{}
	switch reflect.TypeOf(ctype).Kind() {
	case reflect.Slice:
		s := reflect.ValueOf(ctype)
		for i := 0; i < s.Len(); i++ {
			if s.Index(i).Interface() == 2 {
				ctypeArr = append(ctypeArr, 1)
				inWrap = append(inWrap, 1)
				ovWrap = append(ovWrap, "image_overlay")
			}
			if s.Index(i).Interface() == 3 {
				ctypeArr = append(ctypeArr, 2)
				inWrap = append(inWrap, 1)
				ovWrap = append(ovWrap, "image_overlay")
			}
			if s.Index(i).Interface() == 5 {
				ctypeArr = append(ctypeArr, 1)
				inWrap = append(inWrap, 2)
				ovWrap = append(ovWrap, "wrapper_overlay")
			}
			if s.Index(i).Interface() == 6 {
				ctypeArr = append(ctypeArr, 2)
				inWrap = append(inWrap, 2)
				ovWrap = append(ovWrap, "wrapper_overlay")
			}
			if s.Index(i).Interface() == 7 {
				ctypeArr = append(ctypeArr, 3)
				inWrap = append(inWrap, 1)
				ovWrap = append(ovWrap, "image_overlay")
			}
			if s.Index(i).Interface() == 8 {
				ctypeArr = append(ctypeArr, 3)
				inWrap = append(inWrap, 2)
				ovWrap = append(ovWrap, "wrapper_overlay")
			}
			if s.Index(i).Interface() == 11 {
				ctypeArr = append(ctypeArr, 4)
				inWrap = append(inWrap, 1)
				ovWrap = append(ovWrap, "image_overlay")
			}
			if s.Index(i).Interface() == 12 {
				ctypeArr = append(ctypeArr, 4)
				inWrap = append(inWrap, 2)
				ovWrap = append(ovWrap, "wrapper_overlay")
			}
		}
	}
	return RemoveDuplicates(ctypeArr), RemoveDuplicates(inWrap), RemoveDuplicates(ovWrap)
}

// Function for removing duplicate values of array
func RemoveDuplicates(elements []interface{}) []interface{} {
	var result []interface{}
	// Use map to record duplicates as we find them.
	encountered := map[interface{}]bool{}
	switch reflect.TypeOf(elements).Kind() {
	case reflect.Slice:
		s := reflect.ValueOf(elements)
		for i := 0; i < s.Len(); i++ {
			if encountered[s.Index(i).Interface()] == true {
				// Do not add duplicate.
			} else {
				// Record this element as an encountered element.
				encountered[s.Index(i).Interface()] = true
				// Append to result slice.
				result = append(result, s.Index(i).Interface())
			}
		}
	}
	// Return the new slice.
	return result
}

// Function for converting second to time format
func SecondsToTime(input int) (result string) {
	if input < 86400 {
		seconds := input % (60 * 60 * 24)
		hours := math.Floor(float64(seconds) / 60 / 60)
		seconds = input % (60 * 60)
		minutes := math.Floor(float64(seconds) / 60)
		seconds = input % 60
		if hours > 0 {
			result = AddZeros(int(hours)) + ":" + AddZeros(int(minutes)) + ":" + AddZeros(int(seconds))
		} else if minutes > 0 {
			result = "00:" + AddZeros(int(minutes)) + ":" + AddZeros(int(seconds))
		} else {
			result = "00:00:" + AddZeros(int(seconds))
		}
	}
	return
}

// Function for adding extra zeros
func AddZeros(count int) (result string) {
	if len(strconv.Itoa(count)) == 1 {
		result = "0" + strconv.Itoa(count)
	} else {
		result = strconv.Itoa(count)
	}
	return
}

// Function for getting application IP
func ExternalIP() (string, error) {
	ifaces, err := net.Interfaces()
	if err != nil {
		return "", err
	}
	for _, iface := range ifaces {
		if iface.Flags&net.FlagUp == 0 {
			continue // interface down
		}
		if iface.Flags&net.FlagLoopback != 0 {
			continue // loopback interface
		}
		addrs, err := iface.Addrs()
		if err != nil {
			return "", err
		}
		for _, addr := range addrs {
			var ip net.IP
			switch v := addr.(type) {
			case *net.IPNet:
				ip = v.IP
			case *net.IPAddr:
				ip = v.IP
			}
			if ip == nil || ip.IsLoopback() {
				continue
			}
			ip = ip.To4()
			if ip == nil {
				continue // not an ipv4 address
			}
			return ip.String(), nil
		}
	}
	return "", errors.New("are you connected to the network?")
}

// Function for getting image mime type
func ImageMimeType(array []string) string {
	var (
		mimetypeArr []string
		mimetype    string
	)
	if len(array) > 0 {
		for _, v := range array {
			if "image/jpg" == v {
				mimetype = "jpg"
			} else if "image/gif" == v {
				mimetype = "gif"
			} else if "image/jpeg" == v {
				mimetype = "jpeg"
			} else if "image/png" == v {
				mimetype = "png"
			}
			mimetypeArr = append(mimetypeArr, mimetype)
		}
	} else {
		mimetype = "jpg,gif,jpeg,png"
		return mimetype
	}
	return ArrayToString(mimetypeArr, ",")
}

// NameMapper is the function used to convert struct fields which do not have sql tags
// into database column names.
//
// The default mapper converts field names to lower case. If instead you would prefer
// field names converted to snake case, simply assign sqlstruct.ToSnakeCase to the variable:
//
//	sqlstruct.NameMapper = sqlstruct.ToSnakeCase
//
// Alternatively for a custom mapping, any func(string) string can be used instead.
var NameMapper func(string) string = strings.ToLower

// A cache of fieldInfos to save reflecting every time. Inspried by encoding/xml
var finfos map[reflect.Type]fieldInfo
var finfoLock sync.RWMutex

// TagName is the name of the tag to use on struct fields
var TagName = "sql"

// fieldInfo is a mapping of field tag values to their indices
type fieldInfo map[string][]int

func init() {
	finfos = make(map[reflect.Type]fieldInfo)
}

// Rows defines the interface of types that are scannable with the Scan function.
// It is implemented by the sql.Rows type from the standard library
type Rows interface {
	Scan(...interface{}) error
	Columns() ([]string, error)
}

// getFieldInfo creates a fieldInfo for the provided type. Fields that are not tagged
// with the "sql" tag and unexported fields are not included.
func getFieldInfo(typ reflect.Type) fieldInfo {
	finfoLock.RLock()
	finfo, ok := finfos[typ]
	finfoLock.RUnlock()
	if ok {
		return finfo
	}

	finfo = make(fieldInfo)

	n := typ.NumField()
	for i := 0; i < n; i++ {
		f := typ.Field(i)
		tag := f.Tag.Get(TagName)

		// Skip unexported fields or fields marked with "-"
		if f.PkgPath != "" || tag == "-" {
			continue
		}

		// Handle embedded structs
		if f.Anonymous && f.Type.Kind() == reflect.Struct {
			for k, v := range getFieldInfo(f.Type) {
				finfo[k] = append([]int{i}, v...)
			}
			continue
		}

		// Use field name for untagged fields
		if tag == "" {
			tag = f.Name
		}
		tag = NameMapper(tag)

		finfo[tag] = []int{i}
	}

	finfoLock.Lock()
	finfos[typ] = finfo
	finfoLock.Unlock()

	return finfo
}

// Scan scans the next row from rows in to a struct pointed to by dest. The struct type
// should have exported fields tagged with the "sql" tag. Columns from row which are not
// mapped to any struct fields are ignored. Struct fields which have no matching column
// in the result set are left unchanged.
func Scan(dest interface{}, rows Rows) error {
	return doScan(dest, rows, "")
}

// ScanAliased works like scan, except that it expects the results in the query to be
// prefixed by the given alias.
//
// For example, if scanning to a field named "name" with an alias of "user" it will
// expect to find the result in a column named "user_name".
//
// See ColumnAliased for a convenient way to generate these queries.
func ScanAliased(dest interface{}, rows Rows, alias string) error {
	return doScan(dest, rows, alias)
}

// Columns returns a string containing a sorted, comma-separated list of column names as
// defined by the type s. s must be a struct that has exported fields tagged with the "sql" tag.
func Columns(s interface{}) string {
	return strings.Join(cols(s), ", ")
}

// ColumnsAliased works like Columns except it prefixes the resulting column name with the
// given alias.
//
// For each field in the given struct it will generate a statement like:
//
//	alias.field AS alias_field
//
// It is intended to be used in conjunction with the ScanAliased function.
func ColumnsAliased(s interface{}, alias string) string {
	names := cols(s)
	aliased := make([]string, 0, len(names))
	for _, n := range names {
		aliased = append(aliased, alias+"."+n+" AS "+alias+"_"+n)
	}
	return strings.Join(aliased, ", ")
}

func cols(s interface{}) []string {
	v := reflect.ValueOf(s)
	fields := getFieldInfo(v.Type())

	names := make([]string, 0, len(fields))
	for f := range fields {
		names = append(names, f)
	}

	sort.Strings(names)
	return names
}

func doScan(dest interface{}, rows Rows, alias string) error {
	destv := reflect.ValueOf(dest)
	typ := destv.Type()

	if typ.Kind() != reflect.Ptr || typ.Elem().Kind() != reflect.Struct {
		panic(fmt.Errorf("dest must be pointer to struct; got %T", destv))
	}
	fieldInfo := getFieldInfo(typ.Elem())

	elem := destv.Elem()
	var values []interface{}

	cols, err := rows.Columns()
	if err != nil {
		return err
	}

	for _, name := range cols {
		if len(alias) > 0 {
			name = strings.Replace(name, alias+"_", "", 1)
		}
		idx, ok := fieldInfo[strings.ToLower(name)]
		var v interface{}
		if !ok {
			// There is no field mapped to this column so we discard it
			v = &sql.RawBytes{}
		} else {
			v = elem.FieldByIndex(idx).Addr().Interface()
		}
		values = append(values, v)
	}

	return rows.Scan(values...)
}

// ToSnakeCase converts a string to snake case, words separated with underscores.
// It's intended to be used with NameMapper to map struct field names to snake case database fields.
func ToSnakeCase(src string) string {
	thisUpper := false
	prevUpper := false

	buf := bytes.NewBufferString("")
	for i, v := range src {
		if v >= 'A' && v <= 'Z' {
			thisUpper = true
		} else {
			thisUpper = false
		}
		if i > 0 && thisUpper && !prevUpper {
			buf.WriteRune('_')
		}
		prevUpper = thisUpper
		buf.WriteRune(v)
	}
	return strings.ToLower(buf.String())
}

func GetUrlParam(r *http.Request, val string) string {

	value := r.URL.Query()[val]
	if len(value) != 0 {
		return value[0]
	} else {
		return ""
	}
}

func IntToString(in int) string {

	return strconv.Itoa(in)
}

func StringToInt(str string) int {

	r, _ := strconv.Atoi(str)

	return r
}
