package djconstants

// Declared app Global Constants
const (
	AppName                 = "Golang DSP Server"
	AppProtocol             = "https://"
	AppHost                 = "localhost"
	AppPort                 = ":8080"
	DSPEndPoint             = "/dsp_request"
	WinNoticeEndPoint       = "/win_notice"
	BillingNoticeEndPoint   = "/billing_notice"
	LossNoticeEndPoint      = "/loss_notice"
	ClickUrlEndPoint        = "/click_url"
	ImpUrlEndPoint          = "/imp_url"
	DmpPixelEndPoint        = "/dmp_pixel"
	RubiconDmpPixelEndPoint = "/cookiesync"
	RubiconDmpURL           = ""
	RubiconExpireDays       = "30"
	RubiconSspName          = "Rubicon Project"
	MongoCronEndPoint       = "/mongo_cron"
	MysqlCronEndPoint       = "/mysql_cron"
	LogFile                 = "/log/dspdefault.log"
	SegmentPath             = "https://DOMAIN_NAME/www/admin/plugins/dmp/csv/"
	AdsTxt_Path             = "https://DOMAIN_NAME/adstxt/"

	DbDriver    = "mysql"
	DbHost      = ${REVIVE_DB_HOST}
	DbPort      = "3306"
	DbProtocal  = "tcp"
	DbUser      = ${REVIVE_DB_USER}
	DbPass      = ${REVIVE_DB_PASSWORD}
	DbName      = ${REVIVE_DB_NAME}
	BlowfishKey = "advanceddspgo"
	TablePrefix = "rv_"

	RedisHost     = ${REDIS_HOST}
	RedisPort     = "6379"
	RedisPass     = ""
	RedisDbName   = 0
	RedisExpInMin = 1

	ClickHost   = ${CLICKHOUSE_HOST}
	ClickPort   = "9000"
	ClickUser   = ${LICKHOUSE_USER}
	ClickPass   = ${CLICKHOUSE_PASSWORD}
	ClickDbName = ${CLICKHOUSE_DB}

	ReviveProtocol = "https://"
	ReviveRoot     = "localhost"
	ReviveAdmin    = "localhost/www/admin"
	ReviveDelivery = "localhost/www/delivery"
	SQLDelivery    = "localhost/www/delivery/ai.php?filename="
	ReviveImages   = "localhost/www/images"
	MezzaninePath  = "localhost/www/admin/plugins/rmvideoReport/transcoded_video/"
	//CertFile       = "/etc/letsencrypt/live/revphpe.djaxbidder.com/fullchain.pem"
	//KeyFile        = "/etc/letsencrypt/live/revphpe.djaxbidder.com/privkey.pem"
)
