package djclickclient

import (
	"context"
	"djclickConnect"
	"djredis"
	"djtracking"
	"fmt"
	"log"
	"sync"
	"time"

	"github.com/ClickHouse/ch-go"

	uuid "github.com/google/uuid"
)

var Client *ch.Client
var ctx = context.Background()
var mu sync.Mutex
var redisClient = djredis.Initialize()

func init() {
	Client = djclickConnect.ClickhouseConnection()
}

func Track_ad_request(request_id string, bidder_id uint16, country_code string, city string, domain string, os string, ip string, user_agent string, language string, currency string, user_age string, user_gender string, device_type string, device_make string, device_model string, page_url string, ref_url string) error {

	var Track_Req djtracking.Track_ad_request

	var req_count uint64
	req_count = 1
	var country_name string

	country_1 := make(map[string]interface{})
	country_2 := make(map[string]interface{})
	country_3 := make(map[string]interface{})
	country_4 := make(map[string]interface{})

	if country_code != "" {
		arr1 := redisClient.GetKey("country_1", &country_1)
		if arr1 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr1.Error())
		}
		arr2 := redisClient.GetKey("country_2", &country_2)
		if arr2 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr2.Error())
		}
		arr3 := redisClient.GetKey("country_3", &country_3)
		if arr3 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr3.Error())
		}
		arr4 := redisClient.GetKey("country_4", &country_4)
		if arr4 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr4.Error())
		}

		if val1, err1 := country_1[fmt.Sprint(country_code)]; err1 {
			country_name = fmt.Sprint(val1)
		} else if val2, err2 := country_2[fmt.Sprint(country_code)]; err2 {
			country_name = fmt.Sprint(val2)
		} else if val3, err3 := country_3[fmt.Sprint(country_code)]; err3 {
			country_name = fmt.Sprint(val3)
		} else if val4, err4 := country_4[fmt.Sprint(country_code)]; err4 {
			country_name = fmt.Sprint(val4)
		}
	}

	Track_Req.Request_id.Append(StringToUUID(request_id))
	Track_Req.Bidderid.Append(bidder_id)
	Track_Req.Country_code.Append(country_code)
	Track_Req.Country_Name.Append(country_name)
	Track_Req.City.Append(city)
	Track_Req.Domain.Append(domain)
	Track_Req.Os.Append(os)
	Track_Req.Ip.Append(ip)
	Track_Req.User_agent.Append(user_agent)
	Track_Req.Language.Append(language)
	Track_Req.Currency.Append(currency)
	Track_Req.User_age.Append(user_age)
	Track_Req.User_gender.Append(user_gender)
	Track_Req.Device_type.Append(device_type)
	Track_Req.Device_make.Append(device_make)
	Track_Req.Device_model.Append(device_model)
	Track_Req.Page_url.Append(page_url)
	Track_Req.Ref_url.Append(ref_url)
	Track_Req.Req_count.Append(req_count)
	Track_Req.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := djtracking.Track_ad_req(Client, &Track_Req)

	if err != nil {
		// fmt.Printf("error %+v", err)
		// fmt.Println(err)
	}
	mu.Unlock()

	return nil

}

// func Track_request(request_id string, bidderid uint16, ad_id uint16, request_Count uint64) error {

// 	var Request_Stats djtracking.Track_Request

// 	Request_Stats.Request_id.Append(StringToUUID(request_id))
// 	Request_Stats.Bidderid.Append(bidderid)
// 	Request_Stats.Ad_id.Append(ad_id)
// 	Request_Stats.Req_count.Append(request_Count)
// 	Request_Stats.Date_time.Append(time.Now())

// 	mu.Lock()
// 	// if Client.IsClosed() == true {
// 	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
// 	// 	ClickhouseConnection()
// 	// }
// 	err := djtracking.Track_req(Client, &Request_Stats)
// 	if err != nil {
// 		log.Printf("Insert product failed with error %s", err)
// 		return err
// 	}
// 	mu.Unlock()

// 	return nil
// }

func Track_response(request_id string, bidderid uint16, adid uint16, agency_id uint16, client_id uint16, campaignid uint16, response_Count uint64) error {
	var Response_Stats djtracking.Track_Response

	Response_Stats.Request_id.Append(StringToUUID(request_id))
	Response_Stats.Bidderid.Append(bidderid)
	Response_Stats.Adid.Append(adid)
	Response_Stats.Agencyid.Append(agency_id)
	Response_Stats.Clientid.Append(client_id)
	Response_Stats.Campaignid.Append(campaignid)
	Response_Stats.ADid = int(adid)
	Response_Stats.Res_count.Append(response_Count)
	Response_Stats.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := djtracking.Track_res(Client, &Response_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()
	return nil
}

func Track_win(request_id string, bidderid uint16, adid uint16, agency_id uint16, client_id uint16, campaignid uint16, win_Count uint64) error {
	var win_Stats djtracking.Win_notice
	win_Stats.Request_id.Append(StringToUUID(request_id))
	win_Stats.Bidderid.Append(bidderid)
	win_Stats.Adid.Append(adid)
	win_Stats.Agencyid.Append(agency_id)
	win_Stats.Clientid.Append(client_id)
	win_Stats.Campaignid.Append(campaignid)
	win_Stats.Win_count.Append(win_Count)
	win_Stats.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := djtracking.Track_win(Client, &win_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func Track_imp(request_id string, bidderid uint16, adid uint16, agency_id uint16, client_id uint16, campaignid uint16, impression_count uint64, won_price float64, admin_share float64) error {
	var imp_Stats djtracking.Bkt_m

	imp_Stats.Request_id.Append(StringToUUID(request_id))
	imp_Stats.Bidderid.Append(bidderid)
	imp_Stats.Adid.Append(adid)
	imp_Stats.Agencyid.Append(agency_id)
	imp_Stats.Clientid.Append(client_id)
	imp_Stats.Campaignid.Append(campaignid)
	imp_Stats.Imp_count.Append(impression_count)
	imp_Stats.Won_price.Append(won_price)
	imp_Stats.Admin_share.Append(admin_share)
	imp_Stats.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := djtracking.Track_imp(Client, &imp_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func Track_click(request_id string, bidderid uint16, adid uint16, agency_id uint16, client_id uint16, campaignid uint16, click_count uint64) error {

	var click_Stats djtracking.Bkt_c

	click_Stats.Request_id.Append(StringToUUID(request_id))
	click_Stats.Bidderid.Append(bidderid)
	click_Stats.Adid.Append(adid)
	click_Stats.Agencyid.Append(agency_id)
	click_Stats.Clientid.Append(client_id)
	click_Stats.Campaignid.Append(campaignid)
	click_Stats.ADid = int(adid)
	click_Stats.Click_count.Append(click_count)
	click_Stats.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := djtracking.Track_click(Client, &click_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func StringToUUID(id string) uuid.UUID {
	u3, err := uuid.Parse(id)
	if err != nil {
		log.Printf("failed to parse UUID %q: %v", u3, err)
	}
	return u3
}
