package djclickConnect

import (
	"context"
	"djconstants"
	"fmt"
	"net"

	"github.com/ClickHouse/ch-go"
)

func ClickhouseConnection() *ch.Client {
	// fmt.Println("CLICKHOUSE CONNECTED")

	ctx := context.Background()

	conn, err := net.Dial("tcp", djconstants.ClickHost+":"+djconstants.ClickPort)
	if err != nil {
		// handle error
	}

	Client, _ := ch.Connect(ctx, conn, ch.Options{
		Address:  djconstants.ClickHost + ":" + djconstants.ClickPort,
		Database: djconstants.ClickDbName,
		User:     djconstants.ClickUser,
		Password: djconstants.ClickPass,
	})

	err2 := Client.Ping(ctx)
	if err2 != nil {
		fmt.Println(err2)
	} else {
		fmt.Println("clickhouse connected")
	}
	return Client

}
