package djaudience_target

import (
	"djconstants"
	"djextrafunc"
	"djgetad"
	"djlogger"
	"encoding/csv"
	"os"
	"reflect"
	"strings"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	cookie string
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "-", "", count), "-")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall restrict targeting criteria
func CheckAudienceCriteria(audienceChannel chan []djgetad.GetAd, cookieid string, ads []djgetad.GetAd) {
	cookie = cookieid
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			audienceChannel <- filterads
		}
	}()

	validate_campaign := make(map[int]int)

	for _, ad := range ads {

		if validate_campaign[ad.Placement_id] == 1 {

			filterads = append(filterads, ad)
			return
			// continue
		}

		if validate_campaign[ad.Placement_id] == 2 {
			return
			// continue
		}

		validate_campaign[ad.Placement_id] = 2 // by default not match
		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}

			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}

			if ex != false {
				filterads = append(filterads, ad)
				validate_campaign[ad.Placement_id] = 1 // match
			}

		} else {

			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match

		}

	}

	audienceChannel <- filterads
}

/* -----------------------------------------------------------------------------------
					Audience Targetting Start(08-05-20)
--------------------------------------------------------------------------------------*/
// Audience Segment start
func (c Commander) MAX_checkClient_Segment(cmd Command) bool {
	var argAud []string
	viewer_id := cookie
	found := 0
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if viewer_id != "" && cmd.Args[0] != "" {
		for _, val := range strings.Split(cmd.Args[0], ",") {
			argAud = append(argAud, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
		}
		for _, val := range argAud {
			lines, err := ReadCsv(djconstants.SegmentPath + "seg_" + val + ".csv")
			if err != nil {
				djlogger.Log.Println("Error in reading segment csv file : ", err.Error())
			}
			// Loop through lines & turn into object
			var data []string
			for _, line := range lines {
				data = append(data, line[0])
			}
			if found == 0 {
				if djextrafunc.In_array(viewer_id, data) {
					found = 1
				}
			}
		}
	} else {
		return false
	}
	if (op == "=~" && found == 1) || (op == "!~" && found == 0) {
		return true
	} else {
		return false
	}
}

// Audience Segment end
/* -----------------------------------------------------------------------------------
					Audience Targetting Start(08-05-20)
--------------------------------------------------------------------------------------*/

// ReadCsv accepts a file and returns its content as a multi-dimentional type
// with lines and each column. Only parses to string type.
func ReadCsv(filename string) ([][]string, error) {

	// Open CSV file
	f, err := os.Open(filename)
	if err != nil {
		return [][]string{}, err
	}
	defer f.Close()

	// Read File into a Variable
	lines, err := csv.NewReader(f).ReadAll()
	if err != nil {
		return [][]string{}, err
	}

	return lines, nil
}
