/*

	Golang DSP Openrtb v2.5
	Author : MK

*/

package main

import (
	"bytes"
	"compress/gzip"
	"context"
	"djad"
	"djclickConnect"
	"djclickclient"
	"math"
	"sync"

	//~ "djblowfish"
	"djconstants"
	"djdb"
	"djextrafunc"
	"djlogger"

	"encoding/base64"

	//~ "encoding/hex"

	"djredis"
	"encoding/json"
	"fmt"
	"gocron"
	"gorilla/mux"
	"io"
	"io/ioutil"
	"log"
	"net/http"
	"strconv"
	"time"

	"crypto/tls"
	openrtb "openrtb/openrtb2.5"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"

	openrtb2 "github.com/mxmCherry/openrtb/openrtb2"
)

var redisClient = djredis.Initialize()

var Client *ch.Client
var ctx = context.Background()
var mu sync.Mutex

func init() {
	Client = djclickConnect.ClickhouseConnection()
}

// addCookie will apply a new cookie to the response of a http
// request, with the key/value this method is passed.
func addCookie(w http.ResponseWriter, name string, value string) {
	expire := time.Now().AddDate(0, 0, 1)
	cookie := http.Cookie{
		Name:    name,
		Value:   value,
		Expires: expire,
	}
	http.SetCookie(w, &cookie)
}

// Home Function
func home(w http.ResponseWriter, r *http.Request) {
	html := `<html>
				<title>Golang DSP API</title>    
					<body>
						<h1>` + djconstants.AppName + `</h1>
					</body>
			</html>`
	w.Write([]byte(fmt.Sprintf(html)))
}
func validataion(w http.ResponseWriter, r *http.Request) {
	html := `loaderio-a830c237c5dad1f2c11b564b098ccca2`
	w.Write([]byte(fmt.Sprintf(html)))
}

func samplerequest(w http.ResponseWriter, r *http.Request) {

	w.Header().Add("Accept-Charset", "utf-8")
	w.Header().Add("Content-Type", "application/json")

	html := `{"bidid":"255fc47cbbbc568978151f82cb_2020113050","cur":"USD","ext":{"pixelurl":""},"id":"255fc47cbbbc568978151f82cb_2020113050","seatbid":[{"bid":[{"id":"89827f2142b37822","impid":"1","price":12,"adid":"154","nurl":"http://69.61.32.103:8090/win_notice?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE:BF}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}","burl":"http://69.61.32.103:8090/billing_notice?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE:BF}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}","lurl":"http://69.61.32.103:8090/loss_notice?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE:BF}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}","adm":"<a href='http://69.61.32.103:8090/click_url?bannerid=154&zoneid=0&oadest=http://google.com&bidid=255fc47cbbbc568978151f82cb_2020113050&cookieid=7099d748911383080b4ae323236b678c7322&campaignid=42' target='_blank'><img src='http://13.234.135.218/advanceddspgo/www/images/b6e5b7d03d0f5359569076b820d9ff95.jpg' width='300' height='250' alt='' title='' border='0'></a><div id='beacon_7c6e120e13' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='http://69.61.32.103:8090/imp_url?bannerid=154&campaignid=42&zoneid=0&bidid=255fc47cbbbc568978151f82cb_2020113050' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='http://69.61.32.103:8090/rubicon_dmp_pixel?nid={ad_network_id}&cookieid=7099d748911383080b4ae323236b678c7322' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>","adomain":["69.61.32.103"],"cid":"42","crid":"154","h":250,"w":300,"ext":{"btype":1}}],"seat":"abcd_Advertiser_66"}]}`
	w.Write([]byte(fmt.Sprintf(html)))
}

// Function for calculating request elapsed time
func elapsed(what string) func() {
	start := time.Now()
	return func() {
		djlogger.Log.Printf("%s took %v\n", what, time.Since(start))
	}
}

// Function for getting incoming request details
func getRequestDetails(r *http.Request) map[string]interface{} {
	req_details := make(map[string]interface{})
	req_details["dsp_name"] = r.URL.Query().Get("dsp")
	req_details["key"] = r.URL.Query().Get("secret_key")
	req_details["Method"] = r.Method
	req_details["URL"] = r.URL.String()
	req_details["Proto"] = r.Proto
	req_details["Host"] = r.Host
	req_details["RemoteAddr"] = r.RemoteAddr
	for k, v := range r.Header {
		req_details[k] = v
	}
	return req_details
}

// Function for getting incoming process details
func getProcessDetails(r *http.Request) map[string]interface{} {
	pro_details := make(map[string]interface{})
	pro_details["bidid"] = r.URL.Query().Get("bidid")
	pro_details["auctionId"] = r.URL.Query().Get("auctionId")

	if djextrafunc.StringToFloat(r.URL.Query().Get("price"), 64) != 0 {
		pro_details["price"] = r.URL.Query().Get("price")
	} else {
		pro_details["price"] = r.URL.Query().Get("price")
		if pro_details["price"] != "SCREENING" {

			//~ fmt.Println(pro_details["price"].(string))
			//~ decoded, err := hex.DecodeString(pro_details["price"].(string))
			//~ if err != nil {
			//~ djlogger.Log.Println(err)
			//~ } else {
			//~ pro_details["price"] = djblowfish.BlowfishDecrypt([]byte(decoded), []byte(djconstants.BlowfishKey))
			//~ }
		}
	}

	pro_details["currency"] = r.URL.Query().Get("cur")
	pro_details["impid"] = r.URL.Query().Get("impid")
	pro_details["seatid"] = r.URL.Query().Get("seatid")
	pro_details["adid"] = r.URL.Query().Get("adid")
	pro_details["lossid"] = r.URL.Query().Get("lossid")
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
		}
	}()
	return pro_details
}

// Function to convert gzip request body
func Getgzip(body io.ReadCloser) (*gzip.Reader, error) {
	buf := new(bytes.Buffer)
	buf.ReadFrom(body)
	newStr := buf.String()
	z, err := base64.StdEncoding.DecodeString(newStr)
	if err != nil {
		rgzip, err := gzip.NewReader(bytes.NewReader([]byte(newStr)))
		defer rgzip.Close()
		if err != nil {
			return nil, err
		}
		return rgzip, nil
	}
	rgzip, err := gzip.NewReader(bytes.NewReader(z))
	defer rgzip.Close()
	if err != nil {
		return nil, err
	}
	return rgzip, nil
}

// Function for processing incoming request
func processRequest(w http.ResponseWriter, r *http.Request) {
	var cookieDmp string
	// Read cookie
	cookie, err := r.Cookie("dmp")
	if err == http.ErrNoCookie {
		djlogger.Log.Println("Cannot able to find dmp cookie")
	} else {
		cookieDmp = cookie.Value
	}
	defer elapsed("Request")()
	RequestDetails := getRequestDetails(r)
	RequestDetails["cookie"] = cookieDmp
	ResponseArray := make(map[string]interface{})
	if r.Header.Get("x-openrtb-version") == "" || r.Header.Get("x-openrtb-version") == "2.5" {
		RequestArray := &openrtb.BidRequest{}
		switch r.Header.Get("Content-Encoding") {
		case "gzip", "application/gzip":
			// create header
			w.Header().Add("Accept-Charset", "utf-8")
			w.Header().Add("Content-Type", "application/json")
			w.Header().Set("Content-Encoding", "gzip")
			rgzip, errr := Getgzip(r.Body)
			if errr != nil {
				//ResponseArray["message"] = "Request Content-Encoding Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			result, _ := ioutil.ReadAll(rgzip)
			err := json.NewDecoder(bytes.NewReader(result)).Decode(&RequestArray)
			if err != nil {
				//ResponseArray["message"] = "Request Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			ResponseArray = getAD25(RequestArray, RequestDetails)
			if len(ResponseArray) == 0 {
				w.WriteHeader(http.StatusNoContent)
				return
			} else {
				w.WriteHeader(http.StatusOK)
				gz := gzip.NewWriter(w)
				json.NewEncoder(gz).Encode(ResponseArray)
				gz.Close()
				return
			}
		default:
			// create header
			w.Header().Add("Content-Type", "application/json")
			err := json.NewDecoder(r.Body).Decode(&RequestArray)
			if err != nil {
				//ResponseArray["message"] = "Request Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			ResponseArray = getAD25(RequestArray, RequestDetails)
			if len(ResponseArray) == 0 {
				w.WriteHeader(http.StatusNoContent)
				return
			} else {
				w.WriteHeader(http.StatusOK)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
		}
	} else if r.Header.Get("x-openrtb-version") == "2.6" {
		fmt.Println("Request 2.6 called")
		RequestArray := &openrtb2.BidRequest{}
		switch r.Header.Get("Content-Encoding") {
		case "gzip", "application/gzip":
			// create header
			w.Header().Add("Accept-Charset", "utf-8")
			w.Header().Add("Content-Type", "application/json")
			w.Header().Set("Content-Encoding", "gzip")
			rgzip, errr := Getgzip(r.Body)
			if errr != nil {
				//ResponseArray["message"] = "Request Content-Encoding Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			result, _ := ioutil.ReadAll(rgzip)
			err := json.NewDecoder(bytes.NewReader(result)).Decode(&RequestArray)
			if err != nil {
				//ResponseArray["message"] = "Request Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}

			ResponseArray = getAD26(RequestArray, RequestDetails)
			if len(ResponseArray) == 0 {
				w.WriteHeader(http.StatusNoContent)
				return
			} else {
				w.WriteHeader(http.StatusOK)
				gz := gzip.NewWriter(w)
				json.NewEncoder(gz).Encode(ResponseArray)
				gz.Close()
				return
			}
		default:
			// create header
			w.Header().Add("Content-Type", "application/json")
			err := json.NewDecoder(r.Body).Decode(&RequestArray)
			if err != nil {
				//ResponseArray["message"] = "Request Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			ResponseArray = getAD26(RequestArray, RequestDetails)
			if len(ResponseArray) == 0 {
				w.WriteHeader(http.StatusNoContent)
				return
			} else {
				w.WriteHeader(http.StatusOK)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
		}
	} else {
		// create header
		w.Header().Add("Content-Type", "application/json")
		ResponseArray["nbr"] = 2
		w.WriteHeader(http.StatusBadRequest)
		json.NewEncoder(w).Encode(ResponseArray)
		return
	}
}

// Function for getting AD v2.5
func getAD25(RequestArray *openrtb.BidRequest, RequestDetails map[string]interface{}) map[string]interface{} {
	Channel := make(chan map[string]interface{})
	ResponseArray := make(map[string]interface{})
	// ErrorArray := djvalidate.ValidateRequest25(RequestArray)
	// if len(ErrorArray) == 0 {
	go djad.Dsp_adprocessing25(Channel, RequestArray, RequestDetails)
	ResponseArray = <-Channel
	return ResponseArray
	// } else {
	//ResponseArray["message"] = "Request Error"
	// ResponseArray["nbr"] = 2
	// return ResponseArray
	// }
}

// Function for getting AD v2.6
func getAD26(RequestArray *openrtb2.BidRequest, RequestDetails map[string]interface{}) map[string]interface{} {
	// Channel := make(chan map[string]interface{})
	fmt.Println("2.6 Request :%+v\n", RequestArray)
	ResponseArray := make(map[string]interface{})
	// ErrorArray := djvalidate.ValidateRequest26(RequestArray)
	// if len(ErrorArray) == 0 {
	// 	go djad.Dsp_adprocessing26(Channel, RequestArray, RequestDetails)
	// 	ResponseArray = <-Channel
	// 	return ResponseArray
	// } else {
	// 	ResponseArray["message"] = "Request Error"
	// 	ResponseArray["nbr"] = 2
	return ResponseArray
	// }
}

// Function for processing Ad Click request
func processClickUrl(w http.ResponseWriter, r *http.Request) {
	var sync_table = djconstants.TablePrefix + "dj_dsp_cookie_sync"
	ProcessDetails := make(map[string]interface{})
	ProcessDetails["bidid"] = r.URL.Query().Get("bidid")
	ProcessDetails["bannerid"] = r.URL.Query().Get("bannerid")
	ProcessDetails["campaignid"] = r.URL.Query().Get("campaignid")
	ProcessDetails["agencyid"] = r.URL.Query().Get("agencyid")
	ProcessDetails["clientid"] = r.URL.Query().Get("clientid")
	ProcessDetails["oadest"] = r.URL.Query().Get("oadest")
	ProcessDetails["cookieid"] = r.URL.Query().Get("cookieid")
	ProcessDetails["bidderid"] = r.URL.Query().Get("bidder_id")
	ProcessDetails["requestid"] = r.URL.Query().Get("request_id")

	bidder_id_str := ProcessDetails["bidderid"].(string)
	banner_id_str := ProcessDetails["bannerid"].(string)
	agency_id_str := ProcessDetails["agencyid"].(string)
	client_id_str := ProcessDetails["clientid"].(string)
	campaign_id_str := ProcessDetails["campaignid"].(string)

	bidderid, _ := strconv.Atoi(bidder_id_str)
	bannerid, _ := strconv.Atoi(banner_id_str)
	agencyid, _ := strconv.Atoi(agency_id_str)
	clientid, _ := strconv.Atoi(client_id_str)
	campaignid, _ := strconv.Atoi(campaign_id_str)

	Trackclick(ProcessDetails["requestid"].(string), uint16(bidderid), uint16(bannerid), uint16(agencyid), uint16(clientid), uint16(campaignid))

	rows, err := djdb.DbQuery("INSERT INTO " + sync_table + " (adid,cookieid,bidid,campaignid) VALUES (" + ProcessDetails["bannerid"].(string) + ",'" + ProcessDetails["cookieid"].(string) + "','" + ProcessDetails["bidid"].(string) + "'," + ProcessDetails["campaignid"].(string) + ")	ON DUPLICATE KEY UPDATE adid = " + ProcessDetails["bannerid"].(string) + " ,  bidid = '" + ProcessDetails["bidid"].(string) + "' , campaignid = " + ProcessDetails["campaignid"].(string))
	if err != nil {
		djlogger.Log.Println("Error in inserting data in ", sync_table, " : ", err)
	}
	rows.Close()
	http.Redirect(w, r, ProcessDetails["oadest"].(string), http.StatusSeeOther)
}

func Trackwin(req_id string, bidder_id uint16, adid uint16, agencyid uint16, clientid uint16, campaignid uint16) {
	djclickclient.Track_win(req_id, bidder_id, adid, agencyid, clientid, campaignid, 1)
}

func Trackimp(request_id string, bidder_id uint16, adid uint16, agencyid uint16, clientid uint16, campaignid uint16, auction_price float64) {
	var admin_share float64
	_, _, admin_share, _, _, _ = djextrafunc.GetDspId("", "", int(bidder_id), nil)
	admin_share = (auction_price) * (admin_share / 100)
	admin_share = roundFloat(admin_share, 6)
	auction_price = roundFloat(auction_price, 6)
	djclickclient.Track_imp(request_id, bidder_id, adid, agencyid, clientid, campaignid, 1, auction_price, admin_share)
}

func Trackclick(request_id string, bidder_id uint16, adid uint16, agencyid uint16, clientid uint16, campaignid uint16) {

	djclickclient.Track_click(request_id, bidder_id, adid, agencyid, clientid, campaignid, 1)
}

func roundFloat(val float64, precision uint) float64 {
	ratio := math.Pow(10, float64(precision))
	return math.Round(val*ratio) / ratio
}

// Function for processing Ad Click request
func processImpUrl(w http.ResponseWriter, r *http.Request) {
	fmt.Println("processing the imp url")
	ProcessDetails := make(map[string]interface{})
	ProcessDetails["bidid"] = r.URL.Query().Get("bidid")
	ProcessDetails["bannerid"] = r.URL.Query().Get("bannerid")
	ProcessDetails["campaignid"] = r.URL.Query().Get("campaignid")
	ProcessDetails["agencyid"] = r.URL.Query().Get("agencyid")
	ProcessDetails["clientid"] = r.URL.Query().Get("clientid")
	ProcessDetails["bidderid"] = r.URL.Query().Get("bidder_id")
	ProcessDetails["requestid"] = r.URL.Query().Get("request_id")
	ProcessDetails["price"] = r.URL.Query().Get("price")
	key := r.URL.Query().Get("key")

	// To decrypt the original StringToEncrypt
	src1, _ := base64.StdEncoding.DecodeString(key)
	decText := string(src1)

	var auction_price float64

	bidder_id_str := ProcessDetails["bidderid"].(string)
	banner_id_str := ProcessDetails["bannerid"].(string)
	agency_id_str := ProcessDetails["agencyid"].(string)
	client_id_str := ProcessDetails["clientid"].(string)
	campaign_id_str := ProcessDetails["campaignid"].(string)

	bidderid, _ := strconv.Atoi(bidder_id_str)
	bannerid, _ := strconv.Atoi(banner_id_str)
	agencyid, _ := strconv.Atoi(agency_id_str)
	clientid, _ := strconv.Atoi(client_id_str)
	campaignid, _ := strconv.Atoi(campaign_id_str)

	Trackwin(ProcessDetails["requestid"].(string), uint16(bidderid), uint16(bannerid), uint16(agencyid), uint16(clientid), uint16(campaignid))
	if ProcessDetails["bannerid"].(string) == "SCREENING" {
		auction_price = 0.0
	} else {
		var reqPrice string
		switch v := ProcessDetails["price"].(type) {
		case []byte:
			reqPrice = string(v)
		default:
			reqPrice = v.(string)
		}
		auction_price = djextrafunc.StringToFloat(reqPrice, 64)
		auction_price /= 1000
	}

	Trackimp(ProcessDetails["requestid"].(string), uint16(bidderid), uint16(bannerid), uint16(agencyid), uint16(clientid), uint16(campaignid), auction_price)
	var view_count int
	var imp_count uint64
	var daily_budget float64
	var imp_status bool
	imp_status = false
	currentTime := time.Now()
	currentDate := currentTime.Format("2006-01-02")

	fetch, err := djdb.DbQuery("SELECT views,daily_budget,daily_impression FROM  rv_campaigns where campaignid = '" + fmt.Sprint(ProcessDetails["campaignid"]) + "'")
	if err == nil {
		for fetch.Next() {
			fetch.Scan(&view_count, &daily_budget, &imp_count)
		}
		fetch.Close()

	}
	if view_count > 1 {
		fmt.Println("462")
		view_count = view_count - 1
		conn, _ := djdb.DbQuery("Update rv_campaigns SET views=" + fmt.Sprint(view_count) + "  where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
		fmt.Println("Update rv_campaigns SET views=" + fmt.Sprint(view_count) + "  where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
		conn.Close()
	} else if view_count == 1 {

		fmt.Println("")
		connn, _ := djdb.DbQuery("Update rv_campaigns SET views=" + fmt.Sprint(view_count) + "  where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
		connn.Close()
		conn, _ := djdb.DbQuery("Update rv_campaigns SET status= 3  where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
		conn.Close()
	}

	fmt.Println("impression count", imp_count)
	if imp_count > 0 {

		query := `SELECT SUM(a.imp_count) AS imp_count FROM(SELECT SUM(h.impression_count) AS imp_count FROM dj_hourly_table AS h INNER JOIN rv_banners AS b ON h.ad_id = b.bannerid INNER JOIN rv_campaigns AS c ON c.campaignid = b.campaignid WHERE (toStartOfDay(h.datatime) = '` + currentDate + `') AND (c.campaignid = '` + ProcessDetails["campaignid"].(string) + `') GROUP BY c.campaignid UNION ALL SELECT SUM(m.impression_count) AS imp_count FROM dj_data_bkt_m AS m INNER JOIN rv_banners AS b ON m.ad_id = b.bannerid INNER JOIN rv_campaigns AS c ON c.campaignid = b.campaignid WHERE (toStartOfDay(m.datatime) = '` + currentDate + `') AND (c.campaignid = '` + ProcessDetails["campaignid"].(string) + `') GROUP BY c.campaignid) AS a`

		Client := djclickConnect.ClickhouseConnection()
		defer Client.Close()

		var res proto.ColUInt64

		if err4 := Client.Do(ctx, ch.Query{
			Body:   query,
			Result: proto.ResultColumn{Data: &res},
		}); err4 != nil {

			fmt.Println(err4)
		}
		if len(res) > 0 {
			imp_counts := ((imp_count * 99) / 100)
			count := res[0]
			fmt.Println("spent impression count", count, imp_counts, imp_status)
			if imp_counts <= count {
				imp_status = true
			} else {
				imp_status = false
			}
		}

	}

	if imp_status == true {

		fmt.Println("Campaign deactivated because of impression reached")
		conn, _ := djdb.DbQuery("Update rv_campaigns SET status = 1,budgetstatus=1 where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
		conn.Close()
		err := redisClient.Delkey(decText)
		if err != nil {
			djlogger.Log.Println("Key : "+key+" Deleting redis key: ", err.Error())
		}
	} else if imp_status == false && daily_budget != 0 {

		query := `SELECT SUM(a.total_amount) AS total_amount FROM(SELECT SUM(h.total_amount) AS total_amount FROM dj_hourly_table AS h
		INNER JOIN rv_banners AS b ON h.ad_id = b.bannerid INNER JOIN rv_campaigns AS c ON c.campaignid = b.campaignid WHERE (c.campaignid = '` + ProcessDetails["campaignid"].(string) + `') AND (toStartOfDay(h.datatime) = '` + currentDate + `') GROUP BY c.campaignid UNION ALL SELECT SUM(m.won_price) AS total_amount FROM dj_data_bkt_m AS m INNER JOIN rv_banners AS b ON m.ad_id = b.bannerid INNER JOIN rv_campaigns AS c ON c.campaignid = b.campaignid WHERE (c.campaignid = '` + ProcessDetails["campaignid"].(string) + `') AND (toStartOfDay(m.datatime) = '` + currentDate + `') GROUP BY c.campaignid) AS a`

		Client := djclickConnect.ClickhouseConnection()
		defer Client.Close()

		var res proto.ColFloat64

		if err4 := Client.Do(ctx, ch.Query{
			Body:   query,
			Result: proto.ResultColumn{Data: &res},
		}); err4 != nil {

			fmt.Println(err4)
		}

		if len(res) > 0 {
			spend_amount := res[0]
			spend := roundFloat(spend_amount, 4)
			fmt.Println("Before budget", daily_budget)
			daily_budget = ((daily_budget * 97) / 100)
			daily_budget_val := roundFloat(daily_budget, 4)
			fmt.Println("After budget", daily_budget_val)

			if spend >= daily_budget_val {
				fmt.Println("spend amount", spend, "budget", daily_budget)

				fmt.Println(ProcessDetails["campaignid"].(string), "Campaign deactivated at", currentTime)
				conn, _ := djdb.DbQuery("Update rv_campaigns SET status = 1,budgetstatus=1 where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
				conn.Close()
				err := redisClient.Delkey(decText)
				if err != nil {
					djlogger.Log.Println("Key : "+key+" Deleting redis key: ", err.Error())
				}
			}
		}
	}

}

// Function for processing Ad Click request
func processRubiconDmpPixel(w http.ResponseWriter, r *http.Request) {
	cookieid := r.URL.Query().Get("cookieid")
	v := r.URL.Query().Get("v")
	url := djconstants.RubiconDmpURL + "?v=" + v + "&put=" + cookieid + "&expire=" + djconstants.RubiconExpireDays
	http.Redirect(w, r, url, http.StatusSeeOther)
}

// Function for processing Win Notice request
func processWinnotice(w http.ResponseWriter, r *http.Request) {

}

// Function for processing Win Notice request
func processBillingnotice(w http.ResponseWriter, r *http.Request) {

	// var dspPrice_table = djconstants.TablePrefix + "djax_data_dsp_prices"
	var auction_price float64

	RequestDetails := getRequestDetails(r)
	ProcessDetails := getProcessDetails(r)
	ProcessDetails["url"] = RequestDetails["Host"].(string) + RequestDetails["URL"].(string)

	if ProcessDetails["adid"].(string) == "SCREENING" {
		auction_price = 0.0
	} else {
		var reqPrice string
		switch v := ProcessDetails["price"].(type) {
		case []byte:
			reqPrice = string(v)
		default:
			reqPrice = v.(string)
		}
		auction_price = djextrafunc.StringToFloat(reqPrice, 64)
		auction_price /= 1000
	}

	// rows, err := djdb.DbQuery("INSERT INTO "+dspPrice_table+" (ad_id,price,datetime) values ('"+ProcessDetails["adid"].(string)+"',?, ?)", auction_price, time.Now().UTC().Format("2006-01-02 15:04:05"))

	// if err != nil {
	// 	djlogger.Log.Println("Error in inserting data in ", dspPrice_table, " : ", err)
	// }
	// rows.Close()
}

// Function for processing Loss Notice request
func processLossnotice(w http.ResponseWriter, r *http.Request) {
	RequestDetails := getRequestDetails(r)
	ProcessDetails := getProcessDetails(r)
	ProcessDetails["url"] = RequestDetails["Host"].(string) + RequestDetails["URL"].(string)

}

// Function for processing DMP Pixel URL
func processDmpPixel(w http.ResponseWriter, r *http.Request) {
	var (
		count      int
		campaignid int
		cookieid   string
		viewer_id  string
	)
	adid := r.URL.Query().Get("campaignid")   //Campaign ID
	cookieid = r.URL.Query().Get("Dmp_id")    //DMP ID
	viewer_id = r.URL.Query().Get("viewerid") //"98e4e89jndf8y"

	fetch, err := djdb.DbQuery("SELECT count,campaignid, cookieid,viewer_id FROM djax_dmp_track where campaignid = '" + adid + "' AND cookieid = '" + cookieid + "' AND viewer_id= '" + viewer_id + "'")
	if err == nil {
		for fetch.Next() {
			fetch.Scan(&count, &campaignid, &cookieid, &viewer_id)
		}
	}
	fetch.Close()
	t := time.Now().Format("2006-01-02 15:04:05")
	if viewer_id != "" {
		count = count + 1
		updcount, err := djdb.PrepareData("Update djax_dmp_track SET count = ? ,interval_start = ? where campaignid = ? AND cookieid = ? AND viewer_id= ?")
		if err == nil {
			updcount.Exec(count, t, campaignid, cookieid, viewer_id)
		}
	}
	if viewer_id != "" && cookieid != "" {
		var count1 int
		djdb.DbQueryRow("SELECT count,campaignid, cookieid,viewer_id FROM djax_dmp_track where viewer_id= '"+viewer_id+"'").Scan(&count1, &campaignid, &cookieid, &viewer_id)
		rows, _ := djdb.DbNumRows("SELECT count,campaignid, cookieid,viewer_id FROM djax_dmp_track where viewer_id= '" + viewer_id + "'")
		if rows > 0 {
			if count1 > 0 || campaignid > 0 || cookieid != "" || viewer_id != "" {
				count1 = count1 + 1
				upd, err := djdb.PrepareData("Update djax_dmp_track SET count= ? , cookieid= ? where  viewer_id= ?")
				if err == nil {
					upd.Exec(count1, cookieid, viewer_id)
				}
			}
		} else {
			ins, _ := djdb.PrepareData("INSERT INTO djax_dmp_track (interval_start, campaignid, cookieid,viewer_id,count)	VALUES (?,?,?,?,?)")
			ins.Exec(t, campaignid, cookieid, viewer_id, 1)
		}

		if viewer_id != "" && cookieid == "" {
			djdb.DbQueryRow("DELETE FROM djax_dmp_track where viewer_id= '" + viewer_id + "'")
		}
	}
	addCookie(w, "dmp", cookieid)
	w.Header().Add("Content-Type", "image/gif")
	w.Header().Add("Content-Length", "43")
	base64.StdEncoding.DecodeString("R0lGODlhAQABAIAAAP///wAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==")
}

func Clickhouse_Cron() {

	ctx := context.Background()
	t := time.Now()
	// t := time.Date(2024, time.January, 5, 13, 00, 0, 0, time.UTC)
	// fmt.Println("New Time:", t)
	/* layout := "2006-01-02 15:04:05"
	str := "2020-04-28 18:00:00"
	t, _ := time.Parse(layout, str)
	log.Println(t) */
	yC := t.Year()
	monC := djextrafunc.AddZeros(int(t.Month()))
	dC := djextrafunc.AddZeros(t.Day())
	hC := djextrafunc.AddZeros(t.Hour())
	layout := "2006-01-02 15:04:00"
	str := strconv.Itoa(yC) + "-" + monC + "-" + dC + " " + hC + ":00:00"
	t, _ = time.Parse(layout, str)
	start := t.Add(time.Duration(-60) * time.Minute).Format("2006-01-02 15:04:05")

	// Example query
	query := `INSERT INTO dj_hourly_table ( * ) SELECT bidderid, agencyid, clientid, campaignid, ad_id, TEMP.country_code, TEMP.country_name, TEMP.domain, TEMP.language, TEMP.currency, TEMP.user_age, TEMP.user_gender, TEMP.device_type, SUM(TEMP.req_c) AS req_c, SUM(TEMP.res_c) AS res_c, SUM(TEMP.win_c) AS win_c, SUM(TEMP.imp_c) AS imp_c, SUM(TEMP.clk_c) AS clk_c, SUM(TEMP.won_p) AS won_p, SUM(TEMP.adm_r) AS adm_r, TEMP.time FROM( SELECT toStartOfHour(t1.datatime) AS time, t1.bidderid AS bidderid, t2.agencyid AS agencyid, t2.clientid AS clientid, t2.campaignid AS campaignid, t2.ad_id AS ad_id, t1.country_code AS country_code, t1.country_name AS country_name, t1.domain AS domain,  t1.language AS language, t1.currency AS currency, t1.user_age AS user_age, t1.user_gender AS user_gender, t1.device_type AS device_type, SUM(ifNull(t1.request_count, 0)) AS req_c, SUM(ifNull(t2.response_count, 0)) AS res_c, 0 AS win_c, 0 AS imp_c, 0 AS clk_c, 0 AS won_p, 0 AS adm_r FROM dj_track_ad_request AS t1 LEFT JOIN dj_response_stats AS t2 ON t1.request_id = t2.request_id WHERE toStartOfHour(t1.datatime) = '` + start + `' GROUP BY t1.request_id, t1.bidderid, t2.agencyid, t2.clientid, t2.campaignid, t2.ad_id, t1.country_code, t1.country_name, t1.domain,  t1.language, t1.currency, t1.user_age, t1.user_gender, t1.device_type, toStartOfHour(t1.datatime) UNION ALL SELECT toStartOfHour(t1.datatime) AS time, t1.bidderid AS bidderid, t3.agencyid AS agencyid, t3.clientid AS clientid, t3.campaignid AS campaignid, t3.ad_id AS ad_id, t1.country_code AS country_code, t1.country_name AS country_name, t1.domain AS domain,  t1.language AS language, t1.currency AS currency, t1.user_age AS user_age, t1.user_gender AS user_gender, t1.device_type AS device_type, 0 AS req_c, 0 AS res_c, SUM(ifNull(t3.win_count, 0)) AS win_c, 0 AS imp_c, 0 AS clk_c, 0 AS won_p, 0 AS adm_r FROM dj_track_ad_request AS t1 INNER JOIN dj_win_stats AS t3 ON t1.request_id = t3.request_id WHERE toStartOfHour(t1.datatime) = '` + start + `' GROUP BY t1.request_id, t1.bidderid, t3.agencyid, t3.clientid, t3.campaignid, t3.ad_id, t1.country_code, t1.country_name, t1.domain,  t1.language, t1.currency, t1.user_age, t1.user_gender, t1.device_type, toStartOfHour(t1.datatime) UNION ALL SELECT toStartOfHour(t1.datatime) AS time, t1.bidderid AS bidderid, t4.agencyid AS agencyid, t4.clientid AS clientid, t4.campaignid AS campaignid, t4.ad_id AS ad_id, t1.country_code AS country_code, t1.country_name AS country_name, t1.domain AS domain,  t1.language AS language, t1.currency AS currency, t1.user_age AS user_age, t1.user_gender AS user_gender, t1.device_type AS device_type, 0 AS req_c, 0 AS res_c, 0 AS win_c, SUM(ifNull(t4.impression_count, 0)) AS imp_c, 0 AS clk_c, Round(SUM(ifNull(CAST(t4.won_price, 'Decimal64(6)'), 0)), 4) AS won_p, Round(SUM(ifNull(CAST(t4.admin_share, 'Decimal64(6)'), 0)), 4) AS adm_r FROM dj_track_ad_request AS t1 INNER JOIN dj_data_bkt_m AS t4 ON t1.request_id = t4.request_id WHERE toStartOfHour(t1.datatime) = '` + start + `' GROUP BY t1.request_id, t1.bidderid, t4.agencyid, t4.clientid, t4.campaignid, t4.ad_id, t1.country_code, t1.country_name, t1.domain,  t1.language, t1.currency, t1.user_age, t1.user_gender, t1.device_type, toStartOfHour(t1.datatime) UNION ALL SELECT toStartOfHour(t1.datatime) AS time, t1.bidderid AS bidderid, t5.agencyid AS agencyid, t5.clientid AS clientid, t5.campaignid AS campaignid, t5.ad_id AS ad_id, t1.country_code AS country_code, t1.country_name AS country_name, t1.domain AS domain, t1.language AS language, t1.currency AS currency, t1.user_age AS user_age, t1.user_gender AS user_gender, t1.device_type AS device_type, 0 AS req_c, 0 AS res_c, 0 AS win_c, 0 AS imp_c, SUM(ifNull(t5.click_count, 0)) AS clk_c, 0 AS won_p, 0 AS adm_r FROM dj_track_ad_request AS t1 INNER JOIN dj_data_bkt_c AS t5 ON t1.request_id = t5.request_id WHERE toStartOfHour(t1.datatime) = '` + start + `' GROUP BY t1.request_id, t1.bidderid, t5.agencyid, t5.clientid, t5.campaignid, t5.ad_id, t1.country_code, t1.country_name, t1.domain,  t1.language, t1.currency, t1.user_age, t1.user_gender, t1.device_type, toStartOfHour(t1.datatime)) AS TEMP GROUP BY TEMP.time, bidderid, agencyid, clientid, campaignid, ad_id, TEMP.country_code, TEMP.country_name, TEMP.domain,  TEMP.language, TEMP.currency, TEMP.user_age, TEMP.user_gender, TEMP.device_type`

	Client := djclickConnect.ClickhouseConnection()
	defer Client.Close()
	input := proto.Input{}
	if err4 := Client.Do(ctx, ch.Query{
		Body:  query,
		Input: input,
	}); err4 != nil {

		fmt.Println(err4)

	}

	table_name := []string{"dj_track_ad_request", "dj_response_stats", "dj_win_stats", "dj_data_bkt_m", "dj_data_bkt_c"}
	for i := 0; i < len(table_name); i++ {
		truncate_query := `ALTER TABLE ` + table_name[i] + ` DELETE WHERE toStartOfHour(datatime)='` + start + `'`
		djlogger.Log.Println(truncate_query)
		if err5 := Client.Do(ctx, ch.Query{
			Body:  truncate_query,
			Input: input,
		}); err5 != nil {
			fmt.Println(err5)
		}
	}

}

// Cron Function
func executeCronJob() {

	// migration cron for every hour
	gocron.Every(1).Hour().Do(Clickhouse_Cron)

	<-gocron.Start()
}

// Main Function
func main() {
	// Concurrently execute cron functions
	// check()
	go executeCronJob()

	//ipAddr, err := djextrafunc.ExternalIP()
	//if err != nil {
	//djlogger.Log.Println(err)
	ipAddr := djconstants.AppHost
	//}

	djlogger.Log.Println("Server started at " + djconstants.AppProtocol + ipAddr + djconstants.AppPort)
	log.Println("Server started at " + djconstants.AppProtocol + ipAddr + djconstants.AppPort)
	// djlogger.Log.Println("Server started at " + djconstants.ApphttpProtocol + ipAddr + djconstants.ApphttpPort)
	// log.Println("Server started at " + djconstants.ApphttpProtocol + ipAddr + djconstants.ApphttpPort)
	// http.Handler
	router := mux.NewRouter().StrictSlash(true)
	router.HandleFunc("/api", home)
	router.HandleFunc(djconstants.DSPEndPoint, processRequest).Methods("POST")
	router.HandleFunc("/samplerequest", samplerequest).Methods("POST")
	router.HandleFunc("/loaderio-a830c237c5dad1f2c11b564b098ccca2.txt", validataion).Methods("GET")

	router.HandleFunc(djconstants.WinNoticeEndPoint, processWinnotice).Methods("GET")
	router.HandleFunc(djconstants.BillingNoticeEndPoint, processBillingnotice).Methods("GET")
	router.HandleFunc(djconstants.LossNoticeEndPoint, processLossnotice).Methods("GET")
	router.HandleFunc(djconstants.ClickUrlEndPoint, processClickUrl).Methods("GET")
	router.HandleFunc(djconstants.ImpUrlEndPoint, processImpUrl).Methods("GET")
	router.HandleFunc(djconstants.DmpPixelEndPoint, processDmpPixel).Methods("GET")
	router.HandleFunc(djconstants.RubiconDmpPixelEndPoint, processRubiconDmpPixel).Methods("GET")

	srv := &http.Server{
		Addr:         djconstants.AppPort,
		Handler:      router,
		ReadTimeout:  5 * time.Second,   // Maximum duration for reading the entire request
		WriteTimeout: 10 * time.Second,  // Maximum duration before timing out writes of the response
		IdleTimeout:  120 * time.Second, // Maximum duration the server should keep connections open
		TLSConfig: &tls.Config{
			MinVersion:               tls.VersionTLS12,
			MaxVersion:               tls.VersionTLS13,
			PreferServerCipherSuites: true,
		},
	}

	// srvs := &http.Server{
	// 	Addr:    djconstants.ApphttpPort,
	// 	Handler: router,
	// 	TLSConfig: &tls.Config{
	// 		MinVersion:               tls.VersionTLS12,
	// 		MaxVersion:               tls.VersionTLS13,
	// 		PreferServerCipherSuites: true,
	// 	},
	// }

	// srv.SetKeepAlivesEnabled(false)
	// srvs.SetKeepAlivesEnabled(false)

	// go func() {
	// 	if err := srvs.ListenAndServe(); err != nil {
	// 		panic(err)
	// 	}
	// }()

	// go func() {
	if err := srv.ListenAndServeTLS(djconstants.CertFile, djconstants.KeyFile); err != nil {
		panic(err)
	}
	// }()
	// select {}

}

func check() {
	currentTime := time.Now()
	currentDate := currentTime.Format("2006-01-02")

	query := `SELECT SUM(a.total_amount) AS total_amount FROM(SELECT SUM(h.total_amount) AS total_amount FROM dj_hourly_table AS h INNER JOIN rv_banners AS b ON h.ad_id = b.bannerid INNER JOIN rv_campaigns AS c ON c.campaignid = b.campaignid WHERE c.campaignid = 12 and toStartOfDay(h.datatime)='` + currentDate + `' GROUP BY c.campaignid UNION ALL SELECT SUM(m.won_price) AS total_amount FROM dj_data_bkt_m AS m INNER JOIN rv_banners AS b ON m.ad_id = b.bannerid INNER JOIN rv_campaigns AS c ON c.campaignid = b.campaignid WHERE c.campaignid = 12 and toStartOfDay(m.datatime)='` + currentDate + `' GROUP BY c.campaignid) AS a`

	Client := djclickConnect.ClickhouseConnection()
	defer Client.Close()

	var res proto.ColFloat64

	if err4 := Client.Do(ctx, ch.Query{
		Body:   query,
		Result: proto.ResultColumn{Data: &res},
	}); err4 != nil {

		fmt.Println(err4)
	}
	fmt.Printf("result %T", res)
}
