<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';
require_once MAX_PATH . '/lib/OA/Creative/File.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/max/other/common.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/OA/Admin/UI/component/Form.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dll.php';
require_once MAX_PATH . '/lib/OX/Admin/UI/ViewHooks.php';


// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql') {
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql') {
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli') {
  require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

// Create a new option object for displaying the setting's page's HTML form
$oOptions = new OA_Admin_Option('mobile');
$prefSection = "custom-profile";
// Set the correct section of the settings pages and display the drop-down menu
$setPref = $oOptions->getSettingsPreferences($prefSection);
$title = $setPref[$prefSection]['name'];
// Display the settings page's header and sections
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('custom-profile-index', $oHeaderModel);
require_once MAX_PATH . '/lib/OA/Admin/Template.php';

$oTpl = new OA_Admin_Template('custom-profile.html');
$query = OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}profile ORDER BY profileid ASC");
$profiles = array();
$i =1;
while($row = OA_Dal_Delivery_fetchAssoc($query))
{
  $profiles[$i]['name'] = $row['name'];
  $profiles[$i]['profileid'] = $row['profileid'];
  $profiles[$i]['type'] = 0;
  $i++;
}

$aCount = array(
    'profiles'        => count($profiles)
);


$oTpl->assign('aProfiles', $profiles);
$oTpl->assign('aCount', $aCount);
OX_Admin_UI_ViewHooks::registerPageView($oTpl, 'account-settings-custom-profile');
$oTpl->display();

function buildHeaderModel()
{
    $builder = new OA_Admin_UI_Model_InventoryPageHeaderModelBuilder();
    return $builder->buildEntityHeader(array(), 'profiles', 'list');
}

phpAds_PageFooter();

?>
  
