<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage InvocationTags
 *
 */

require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_banner extends Plugins_InvocationTags
{
    /**
     * Return name of plugin
     *
     * @return string
     */
    public function getName()
    {
        return $this->translate("Banner Ads");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    public function getNameEN()
    {
        return 'Banner Ads';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    public function isAllowed($extra = null)
    {
        $isAllowed = parent::isAllowed($extra);
        return true;
    }

    public function getOrder()
    {
        parent::getOrder();
        return 11;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
    public function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
        // $options = [];
        $options = array (
            'Targeting'      => 1,
        );

        return $options;
    }

    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    public function Targeting()
    {
        $maxInvocation = &$this->maxInvocation;
        $maxInvocation->Targeting = $_POST['Targeting']; 
      
        $option = '';
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>Targeting</td><td width='370'>";
        $option .= "<input class='flat' type='text' name='Targeting' size='' value='" . (isset($maxInvocation->Targeting) ? htmlspecialchars(stripslashes($maxInvocation->Targeting), ENT_QUOTES) : $this->defaultValues['Targeting']) . "' style='width:175px;' tabindex='" . ($maxInvocation->tabindex++) . "'></td></tr>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath() . "/images/spacer.gif' height='5' width='100%'></td></tr>";
        return $option;

    }
    public function generateInvocationCode()
    {
        $aComments = [
            'Comment' => $this->translate("
  * This noscript section of this tag only shows image banners. There
  * is no width or height in these banners, so if you want these tags to
  * allocate space for the ad before it shows, you will need to add this
  * information to the <img> tag.
  *
  * If you do not want to deal with the intricities of the noscript
  * section, delete the tag (from <noscript>... to </noscript>). On
  * average, the noscript tag is called from less than 1% of internet
  * users."),
            ];
        parent::prepareCommonInvocationData($aComments);

        $conf = $GLOBALS['_MAX']['CONF'];
        $mi = &$this->maxInvocation;
      
		$buffer = $mi->buffer;
       
		$path = $conf['webpath']['deliverapiUrl'];
        if (isset($_POST['Targeting']) && !empty($_POST['Targeting'])) {
            $mi->parameters['Targeting'] = $_POST['Targeting'];
        }
        unset($mi->parameters['cb']);
        unset($mi->parameters['zoneid']);
        $exp=explode(",",$mi->parameters['Targeting']);
        $imp_mi=implode("&",$exp);
     
		$zoneid=$mi->zoneid;

		if ($GLOBALS['_MAX']['SSL_REQUEST']) 
		{
			$djprotocol='https://';
		}
		else
		{
			$djprotocol='http://';
		}
        if (count($mi->parameters) > 0) 
        {
            $buffer=$djprotocol.$path."/api/request.php?zoneid=".$zoneid."&".$imp_mi;
        }
        else
        {
		$buffer=$djprotocol.$path."/api/request.php?zoneid=".$zoneid;
        }
        return $buffer;
    }

    public function setInvocation(&$invocation)
    {
        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;
    }

}

