package openrtb

import "encoding/json"

// This object represents a native type impression. Native ad units are intended to blend seamlessly into
// the surrounding content (e.g., a sponsored Twitter or Facebook post). As such, the response must be
// well-structured to afford the publisher fine-grained control over rendering.
// The presence of a Native as a subordinate of the Imp object indicates that this impression is offered as
// a native type impression. At the publisher’s discretion, that same impression may also be offered as
// banner and/or video by also including as Imp subordinates the Banner and/or Video objects,
// respectively. However, any given bid for the impression must conform to one of the offered types.
type Native struct {
	Request    *Nativefmt      `json:"request,omitempty"`    // Request payload complying with the Native Ad Specification.
	RequestObj *Nativefmt      `json:"requestobj,omitempty"` // Request payload complying with the Native Ad Specification.
	Ver        string          `json:"ver,omitempty"`        // Version of the Native Ad Specification to which request complies; highly recommended for efficient parsing.
	API        []int           `json:"api,omitempty"`        // List of supported API frameworks for this impression.
	BAttr      []int           `json:"battr,omitempty"`      // Blocked creative attributes
	Ext        json.RawMessage `json:"ext,omitempty"`
}

type Nativefmt struct {
	Asset []*Asset `json:"assets"`
}

type Asset struct {
	Id    int    `json:"id,omitempty"`
	Req   int    `json:"req,omitempty"`
	Title *Title `json:"title,omitempty"`
	Img   *Img   `json:"img,omitempty"`
	Data  *DataN `json:"data,omitempty"`
	Video *Video `json:"video,omitempty"`
}

type Title struct {
	Len int `json:"len,omitempty"`
}

type Img struct {
	Type int      `json:"type,omitempty"`
	W    int      `json:"w,omitempty"`
	Wmin int      `json:"wmin,omitempty"`
	H    int      `json:"h,omitempty"`
	Hmin int      `json:"hmin,omitempty"`
	Mime []string `json:"mime,omitempty"`
} 

type DataN struct {
	Type int `json:"type,omitempty"`
	Len  int `json:"len,omitempty"` 
}
