package djtracking

import (
	"context"
	"djclickConnect"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Win_notice struct {
	Request_id proto.ColUUID
	Bidderid   proto.ColUInt16
	Adid       proto.ColUInt16
	Agencyid   proto.ColUInt16
	Clientid   proto.ColUInt16
	Campaignid proto.ColUInt16
	Win_count  proto.ColUInt64
	Date_time  proto.ColDateTime
}

func Track_win(Client *ch.Client, ad_win *Win_notice) error {
	ctx := context.Background()

	input := proto.Input{
		{Name: "request_id", Data: &ad_win.Request_id},
		{Name: "bidderid", Data: &ad_win.Bidderid},
		{Name: "ad_id", Data: &ad_win.Adid},
		{Name: "agencyid", Data: &ad_win.Agencyid},
		{Name: "clientid", Data: &ad_win.Clientid},
		{Name: "campaignid", Data: &ad_win.Campaignid},
		{Name: "win_count", Data: &ad_win.Win_count},
		{Name: "datatime", Data: &ad_win.Date_time},
	}

	Client = djclickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("dj_win_stats"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
