package djtracking

import (
	"context"
	"djclickConnect"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Track_ad_request struct {
	Request_id   proto.ColUUID
	Bidderid     proto.ColUInt16
	Country_code proto.ColStr
	Country_Name proto.ColStr
	City         proto.ColStr
	Domain       proto.ColStr
	Os           proto.ColStr
	Ip           proto.ColStr
	User_agent   proto.ColStr
	Language     proto.ColStr
	Currency     proto.ColStr
	User_age     proto.ColStr
	User_gender  proto.ColStr
	Device_type  proto.ColStr
	Device_make  proto.ColStr
	Device_model proto.ColStr
	Page_url     proto.ColStr
	Ref_url      proto.ColStr
	Req_count    proto.ColUInt64
	Date_time    proto.ColDateTime
}

func Track_ad_req(Client *ch.Client, ad_req *Track_ad_request) error {

	//fmt.Println("INSIDE am_track_ad_requests_Inserted Tracking calleds ")

	ctx := context.Background()

	input := proto.Input{
		{Name: "request_id", Data: &ad_req.Request_id},
		{Name: "bidderid", Data: &ad_req.Bidderid},
		{Name: "country_code", Data: &ad_req.Country_code},
		{Name: "country_name", Data: &ad_req.Country_Name},
		{Name: "city", Data: &ad_req.City},
		{Name: "domain", Data: &ad_req.Domain},
		// {Name: "os", Data: &ad_req.Os},
		// {Name: "ip", Data: &ad_req.Ip},
		// {Name: "user_agent", Data: &ad_req.User_agent},
		{Name: "language", Data: &ad_req.Language},
		{Name: "currency", Data: &ad_req.Currency},
		{Name: "user_age", Data: &ad_req.User_age},
		{Name: "user_gender", Data: &ad_req.User_gender},
		{Name: "device_type", Data: &ad_req.Device_type},
		// {Name: "device_make", Data: &ad_req.Device_make},
		// {Name: "device_model", Data: &ad_req.Device_model},
		{Name: "page_url", Data: &ad_req.Page_url},
		// {Name: "ref_url", Data: &ad_req.Ref_url},
		{Name: "request_count", Data: &ad_req.Req_count},
		{Name: "datatime", Data: ad_req.Date_time},
	}

	Client = djclickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("dj_track_ad_request"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {

		fmt.Println("clickhouse track ad request table error :", err4)

	}
	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
