package djtracking

import (
	"context"
	"djclickConnect"
	"djconstants"
	"djdb"
	"djlogger"
	"fmt"
	"time"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Track_Response struct {
	Request_id proto.ColUUID
	Bidderid   proto.ColUInt16
	Adid       proto.ColUInt16
	Agencyid   proto.ColUInt16
	Clientid   proto.ColUInt16
	Campaignid proto.ColUInt16
	ADid       int
	Res_count  proto.ColUInt64
	Date_time  proto.ColDateTime
}

func Track_res(Client *ch.Client, ad_res *Track_Response) error {
	ctx := context.Background()
	var report_table = djconstants.TablePrefix + "data_bkt_r"
	input := proto.Input{
		{Name: "request_id", Data: &ad_res.Request_id},
		{Name: "bidderid", Data: &ad_res.Bidderid},
		{Name: "ad_id", Data: &ad_res.Adid},
		{Name: "agencyid", Data: &ad_res.Agencyid},
		{Name: "clientid", Data: &ad_res.Clientid},
		{Name: "campaignid", Data: &ad_res.Campaignid},
		{Name: "response_count", Data: &ad_res.Res_count},
		{Name: "datatime", Data: &ad_res.Date_time},
	}
	Client = djclickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("dj_response_stats"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}
	_, err := djdb.DbQuery("INSERT INTO "+report_table+" (interval_start,creative_id,zone_id,	count) VALUES(?,?,?,?)", time.Now().Format("2006-01-02 15:04:05"), ad_res.ADid, 0, 1)
	if err != nil {
		djlogger.Log.Println(err)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	fmt.Println("response status end")
	return nil
}
