package djtracking

import (
	"context"
	"djclickConnect"
	"djconstants"
	"djdb"
	"djlogger"
	"fmt"
	"time"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Bkt_c struct {
	Request_id  proto.ColUUID
	Bidderid    proto.ColUInt16
	Adid        proto.ColUInt16
	Agencyid    proto.ColUInt16
	Clientid    proto.ColUInt16
	Campaignid  proto.ColUInt16
	ADid        int
	Click_count proto.ColUInt64
	Date_time   proto.ColDateTime
}

func Track_click(Client *ch.Client, ad_clk *Bkt_c) error {

	var report_table = djconstants.TablePrefix + "data_bkt_c"
	ctx := context.Background()

	input := proto.Input{
		{Name: "request_id", Data: &ad_clk.Request_id},
		{Name: "bidderid", Data: &ad_clk.Bidderid},
		{Name: "ad_id", Data: &ad_clk.Adid},
		{Name: "agencyid", Data: &ad_clk.Agencyid},
		{Name: "clientid", Data: &ad_clk.Clientid},
		{Name: "campaignid", Data: &ad_clk.Campaignid},
		{Name: "click_count", Data: &ad_clk.Click_count},
		{Name: "datatime", Data: &ad_clk.Date_time},
	}

	Client = djclickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("dj_data_bkt_c"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	_, err := djdb.DbQuery("INSERT INTO "+report_table+" (interval_start,creative_id,zone_id,	count) VALUES(?,?,?,?)", time.Now().Format("2006-01-02 15:04:05"), ad_clk.ADid, 0, 1)
	if err != nil {

		djlogger.Log.Println(err)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
