package djsource

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	"reflect"
	"strconv"
	"strings"
	"time"

	openrtb "openrtb/openrtb2.5"
)

type ADS_Cert struct {
	transaction_id []string
	ts             []string
	certfile       []string
}

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	srcobj25 *openrtb.Source
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "-", "", count), "-")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

/* func ReadAds_Certfile() *ADS_Cert {
	dat, _ := ioutil.ReadFile(djconstants.AdsCert_Path)
	lines1 := strings.Split(string(dat), "\n")
	tid := make([]string, len(lines1))
	ts_val := make([]string, len(lines1))
	adscertfile := make([]string, len(lines1))
	for m, lines := range lines1 {
		if lines[:0] == "#" {
			break
		}
		values := strings.Split(string(lines), ";")
		for i, data := range values {
			if i == 0 {
				tid[m] = data
			} else if i == 1 {
				ts_val[m] = data
			} else if i == 2 {
				adscertfile[m] = data
			}
		}
	}

	return &ADS_Cert{
		transaction_id: tid,
		ts:             ts_val,
		certfile:       adscertfile,
	}
} */

func GetSourceObj(sourceChannel chan []djgetad.GetAd, source25 *openrtb.Source, ads []djgetad.GetAd, req_details map[string]interface{}) {
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			sourceChannel <- ads
		}
	}()
	if source25 != nil {
		if source25.FinalSaleDecision == 0 || source25.TransactionID != "" {
			fdChannel := make(chan []djgetad.GetAd)
			go CheckSourceCriteria(fdChannel, source25, ads)
			ads = <-fdChannel
		}
		/* if source.PChain != "" {
			pchainChannel := make(chan []djgetad.GetAd)
			go checkPChainCriteria(pchainChannel, source.PChain, ads)
			ads = <-pchainChannel
		} */
	}
	sourceChannel <- ads
}

// Function for checking overall user targeting criteria
func CheckSourceCriteria(sourceChannel chan []djgetad.GetAd, source25 *openrtb.Source, ads []djgetad.GetAd) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			sourceChannel <- filterads
		}
	}()
	if source25 != nil {
		srcobj25 = source25
	}
	for _, ad := range ads {
		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
			}
		} else {
			filterads = append(filterads, ad)
		}
	}
	sourceChannel <- filterads
}

func (c Commander) MAX_checkClient_Exchange(cmd Command) bool {
	var reqFd string
	if srcobj25 != nil {
		reqFd = strconv.Itoa(srcobj25.FinalSaleDecision)
	}
	argFd := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqFd != "" {
		if op == "==" {
			return reqFd == argFd
		} else if op == "!=" {
			return reqFd != argFd
		} else {
			return false
		}
	}
	return false
}

func (c Commander) MAX_checkClient_SourceTid(cmd Command) bool {
	var reqTid string
	if srcobj25 != nil {
		reqTid = srcobj25.TransactionID
	}
	argTid := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqTid != "" {
		if op == "==" {
			return reqTid == argTid && len(reqTid) > 11 && len(reqTid) < 19
		} else if op == "!=" {
			return reqTid != argTid && len(reqTid) > 11 && len(reqTid) < 19
		} else {
			return false
		}
	}
	return false
}

func CheckTSCriteria(tsChannel chan []djgetad.GetAd, tsobj int64, ads []djgetad.GetAd) bool {
	ts := strconv.FormatInt(tsobj, 10)
	str, err := strconv.ParseInt(ts, 10, 64)
	validcheck := time.Unix(str, 0)
	if err == nil && validcheck != time.Now() {
		return true
	}
	return false
}

/* func CheckCertCriteria(certChannel chan []djgetad.GetAd, certobj string, ads []djgetad.GetAd) bool {
	file_content := ReadAds_Certfile()
	if certobj != "" {
		for _, certads := range file_content.certfile {
			if certads == certobj {
				return true
			}
		}
	}
	return false
} */

/* func checkPChainCriteria(pchainChannel chan []djgetad.GetAd, pchainobj string, ads []djgetad.GetAd) bool {
	if len(pchainobj) > 11 && len(pchainobj) < 19 {
		return true
	}
	return false
} */
