package djrestrict_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	"fmt"
	"reflect"
	"strings"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	restrictobj25 openrtb.Restrictions
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	fmt.Println("parts", parts)
	parts2 := strings.Split(parts[1], ")")
	fmt.Println("parts2", parts2)
	count := strings.Count(parts2[0], ",")
	fmt.Println("count", count)
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "^", "", count), "^")
	fmt.Println("parts3", parts3)
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall restrict targeting criteria
func CheckRestrictCriteria(restrictChannel chan []djgetad.GetAd, r int, restrict25 openrtb.Restrictions, ads []djgetad.GetAd) {
	fmt.Println("CheckRestrictCriteria called")
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			restrictChannel <- filterads
		}
	}()
	if r == 2 {
		restrictobj25 = restrict25
	}
	validate_campaign := make(map[int]int)

	for _, ad := range ads {

		if validate_campaign[ad.Placement_id] == 1 {

			filterads = append(filterads, ad)
			continue
		}

		if validate_campaign[ad.Placement_id] == 2 {
			continue
		}

		validate_campaign[ad.Placement_id] = 2 // by default not match

		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			fmt.Println("Compiledlimitation", ad.Compiledlimitation)
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					fmt.Println("82", command)
					f := reflect.ValueOf(c).MethodByName(command.Name)
					fmt.Printf("84 %+v\n", f)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fmt.Println("inputs", inputs)
						fu := f.Call(inputs)
						fmt.Println("fu", fu)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads)
				validate_campaign[ad.Placement_id] = 1 // match
			}
		} else {
			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match
		}
	}
	restrictChannel <- filterads
}

/* -----------------------------------------------------------------------------------
					Restriction Targetting Start(11-04-20)
--------------------------------------------------------------------------------------*/
// Blocked category start
func (c Commander) MAX_checkClient_BlockedCategory(cmd Command) bool {
	var reqBlockedCategory []string
	var argBlockedCategory []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	fmt.Println("i", i, "op", op)
	if len(restrictobj25.Bcat) > 0 {
		for _, cat := range restrictobj25.Bcat {
			fmt.Println("reqcat", cat)
			reqBlockedCategory = append(reqBlockedCategory, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
			fmt.Println("reqBlockedCategory", reqBlockedCategory)
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		fmt.Println("argval", val)
		argBlockedCategory = append(argBlockedCategory, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
		fmt.Println("argBlockedCategory", argBlockedCategory)
	}
	if reqBlockedCategory != nil {
		if op == "==" {
			return !djextrafunc.CheckEqual(reqBlockedCategory, argBlockedCategory)
		} else if op == "!=" {
			return djextrafunc.CheckEqual(reqBlockedCategory, argBlockedCategory)
		} else if op == "=~" {
			return !djextrafunc.CheckEqualCat(reqBlockedCategory, argBlockedCategory)
			// for _, v := range argBlockedCategory {
			// 	for _, v1 := range reqBlockedCategory {
			// 		fmt.Println("argcat", v, "reqcat", v1)
			// 		if v1 == v {
			// 			return false
			// 		}
			// 	}
			// }
			// return true
		} else if op == "!~" {
			return djextrafunc.CheckEqualCat(reqBlockedCategory, argBlockedCategory)
			// for _, v := range argBlockedCategory {
			// 	for _, v1 := range reqBlockedCategory {
			// 		fmt.Println("argcat", v, "reqcat", v1)
			// 		if v1 == v {
			// 			return true
			// 		}
			// 	}
			// }
			// return false
		}
	}
	return true
}

// Blocked category end

// Blocked advertisers start
func (c Commander) MAX_checkClient_BlockedAdvertiser(cmd Command) bool {
	fmt.Println("MAX_checkClient_BlockedAdvertiser called")
	var reqBlockedAdvertiser []string
	var argBlockedAdvertiser []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if len(restrictobj25.Badv) > 0 {
		for _, cat := range restrictobj25.Badv {
			reqBlockedAdvertiser = append(reqBlockedAdvertiser, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argBlockedAdvertiser = append(argBlockedAdvertiser, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqBlockedAdvertiser != nil {
		if op == "==" {
			fmt.Println("173", !djextrafunc.CheckEqual(reqBlockedAdvertiser, argBlockedAdvertiser))
			return !djextrafunc.CheckEqual(reqBlockedAdvertiser, argBlockedAdvertiser)
		} else if op == "!=" {
			fmt.Println("reqBlockedAdvertiser", reqBlockedAdvertiser)
			fmt.Println("argBlockedAdvertiser", argBlockedAdvertiser)
			fmt.Println("176", djextrafunc.CheckEqual(reqBlockedAdvertiser, argBlockedAdvertiser))
			return djextrafunc.CheckEqual(reqBlockedAdvertiser, argBlockedAdvertiser)
		} else if op == "=~" {
			for _, v := range argBlockedAdvertiser {
				for _, v1 := range reqBlockedAdvertiser {
					if v1 == v {
						return false
					}
				}
			}
			return true
		} else if op == "!~" {
			fmt.Println("186")
			for _, v := range argBlockedAdvertiser {
				for _, v1 := range reqBlockedAdvertiser {
					fmt.Println("v1", v1, "v", v)
					if v1 == v {
						return true
					}
				}
			}
			return false
		}
	}
	return true
}

// Blocked advertisers end

// Blocked apps start
func (c Commander) MAX_checkClient_BlockedApps(cmd Command) bool {
	var reqBlockedApps []string
	var argBlockedApps []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if len(restrictobj25.Bapp) > 0 {
		for _, cat := range restrictobj25.Bapp {
			reqBlockedApps = append(reqBlockedApps, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argBlockedApps = append(argBlockedApps, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqBlockedApps != nil {
		if op == "==" {
			return !djextrafunc.CheckEqual(reqBlockedApps, argBlockedApps)
		} else if op == "!=" {
			return djextrafunc.CheckEqual(reqBlockedApps, argBlockedApps)
		} else if op == "=~" {
			for _, v := range argBlockedApps {
				for _, v1 := range reqBlockedApps {
					if v1 == v {
						return false
					}
				}
			}
		} else if op == "!~" {
			for _, v := range argBlockedApps {
				for _, v1 := range reqBlockedApps {
					if v1 == v {
						return true
					}
				}
			}
			return false
		}
	}
	return true
}

// Blocked apps end
/* -----------------------------------------------------------------------------------
					Restriction Targetting End(11-04-20)
--------------------------------------------------------------------------------------*/
