package djredis

import (
	"djconstants"
	"djlogger"
	"encoding/json"
	"github.com/redis/go-redis"
	"time"
	"context"
	"fmt"
	
)

var cxt = context.Background()

var (
	client = &RedisClient{}
)

type RedisClient struct {
	c *redis.Client
}

//GetClient get the redis client
func Initialize() *RedisClient {
	c := redis.NewClient(&redis.Options{
		Addr:       djconstants.RedisHost + ":" + djconstants.RedisPort,
		Password:   djconstants.RedisPass,
		DB:         djconstants.RedisDbName,
		// MaxConnAge: 1,
	})
	//defer c.Close()
	if err := c.Ping(cxt).Err(); err != nil {
		djlogger.Log.Println("Unable to connect to redis " + err.Error())
	}
	client.c = c
	return client
}

//GetKey get key
func (client *RedisClient) GetKey(key string, src interface{}) error {
	val, err := client.c.Get(cxt, key).Result()
	

	if err == redis.Nil || err != nil {
		return err
	}
	err = json.Unmarshal([]byte(val), &src)
	if err != nil {
		return err
	}
	return nil
}




//SetKey set key
func (client *RedisClient) SetKey(key string, value interface{}, expiration time.Duration) error {
	cacheEntry, err := json.Marshal(value)
	if err != nil {
		return err
	}
	
	err1 := client.c.Set(cxt, key, cacheEntry,expiration).Err()
	if err1 != nil {
		return err1
	}
	return nil
}



func (client *RedisClient) SetKeyy(key string, value interface{}, expire int) error {


	cacheEntry, err1 := json.Marshal(value)
	if err1 != nil {
		return err1
	}
fmt.Println("json conbert :",cacheEntry)
	var expiration time.Duration
	switch {
	case expire == 0:
		expiration = time.Minute * 0
	case expire == 1:
		expiration = time.Second * 300
	}

	err := client.c.Set(cxt, key, cacheEntry, expiration).Err()
	if err != nil {
		return err
	}
	return nil
}

func(client *RedisClient)Delkey(key string)error{
	_, err := client.c.Do(cxt,"del",key).Result()
    if err != nil {
        fmt.Println("Error deleting key:", err)
        
    }
	return nil
}

