package djnativead

import (
	"djgetad"
	"djgetad_models"
	"djlogger"

	openrtb "openrtb/openrtb2.5"
)

// Function to get native ad 2.5
func GetNativeads25(nativeChannel chan []djgetad.GetAd, bid_floor float64, nativefmt map[string]interface{}, req_details map[string]interface{}, pmp int8, deals []openrtb.Deal) {
	storagetype := "bannerTypeHtml:oxHtml:native"
	nativeads, err := djgetad_models.NativeSearch(bid_floor, nativefmt, req_details["dsp_id"].(int), storagetype, pmp, deals)
	if err != nil {
		djlogger.Log.Println(err)
	}
	nativeChannel <- nativeads
}
