package djcompanionad

import (
	"database/sql"
	"djconstants"
	"djdb"
	"djextrafunc"
	"djgetad"
	"djredis"
	"fmt"
	openrtb "openrtb/openrtb2.5"
	"strconv"
	"time"
)

func GetCompanionVideo(videoad djgetad.GetAd, video25 *openrtb.Video, redisClient *djredis.RedisClient) string {

	var fc_path, companions, companionads, companionclicks, companionassetheight, companionassetwidth, companionexpandedheight, companionexpandedwidth, companiontrack, companion_banner, companionclickthrough, pxRatio, companionid, UID, attr string

	fc_path = djconstants.ReviveProtocol + djconstants.ReviveRoot + "/fc.php"

	if video25.CompanionAd != nil && video25.CompanionAd[0].H != 0 && video25.CompanionAd[0].W != 0 {

		if videoad.Vast_thirdparty_companion_assetheight.Int64 != 0 {
			companionassetheight = ` assetHeight="` + strconv.Itoa(int(videoad.Vast_thirdparty_companion_assetheight.Int64)) + `"`
		}
		if videoad.Vast_thirdparty_companion_assetwidth.Int64 != 0 {
			companionassetwidth = ` assetWidth="` + strconv.Itoa(int(videoad.Vast_thirdparty_companion_assetwidth.Int64)) + `"`
		}
		if videoad.Vast_thirdparty_companion_expandedheight != 0 {
			companionexpandedheight = ` expandedHeight="` + strconv.Itoa(videoad.Vast_thirdparty_companion_expandedheight) + `"`
		}
		if videoad.Vast_thirdparty_companion_expandedwidth != 0 {
			companionexpandedwidth = ` expandedWidth="` + strconv.Itoa(videoad.Vast_thirdparty_companion_expandedwidth) + `"`
		}
		if videoad.Vast_creative_type.String != "" {
			//companionresource = `<StaticResource creativeType="` + videoad.Vast_creative_type.String + `">`
		}

		if videoad.Vast_companion_banner_id != 0 {

			Details := AdDetails{}
			allAdDetails := GetAd(videoad.Vast_companion_banner_id, Details, redisClient)

			if video25.CompanionAd[0].H == allAdDetails.Height && video25.CompanionAd[0].W == allAdDetails.Width {
				fmt.Println("all ad details", allAdDetails)
				width := ` width="` + strconv.Itoa(allAdDetails.Width) + `"`
				height := ` height="` + strconv.Itoa(allAdDetails.Height) + `"`
				rand1 := djextrafunc.RandToken(5)

				filename := djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + allAdDetails.Filename

				clickurl := ""
				clickTag_start := ""
				clickTag_end := ""

				if allAdDetails.Url != "" {
					clickurl = djconstants.AppProtocol + djconstants.ReviveDelivery + "/cl.php?oaparams=2&bannerid=" + strconv.Itoa(allAdDetails.Ad_id) + "&campaignid=" + strconv.Itoa(allAdDetails.Placement_id) + "&zoneid=0___oadest=" + allAdDetails.Url

					clickTag_start = `<a href='` + clickurl + `' target='_blank'>`
					clickTag_end = `</a>`

				}

				impurl := djconstants.AppProtocol + djconstants.ReviveDelivery + "/lg.php?bannerid=" + strconv.Itoa(allAdDetails.Ad_id) + "&amp;campaignid=" + strconv.Itoa(allAdDetails.Placement_id) + "&amp;zoneid=0"

				if allAdDetails.Type == "web" {
					companion_banner = `<HTMLResource>
			<![CDATA[ ` + clickTag_start + `<img src='` + filename + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_c5a0d3e41e' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
			</HTMLResource>`
				} else if allAdDetails.Type == "sql" {
					companion_banner = `<HTMLResource>
				<![CDATA[` + clickTag_start + ` <img src='` + djconstants.AppProtocol + djconstants.ReviveDelivery + `/ai.php?filename=` + allAdDetails.Filename + `&contenttype=` + allAdDetails.Contenttype + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
				</HTMLResource>`
				} else if allAdDetails.Type == "url" {
					companion_banner = `<HTMLResource>
				<![CDATA[` + clickTag_start + ` <img src='` + allAdDetails.Imageurl + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_c5a0d3e41e' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
				</HTMLResource>`
				} else if allAdDetails.Type == "txt" {
					companion_banner = `<HTMLResource>
				<![CDATA[ ` + clickTag_start + allAdDetails.Bannertext + `` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
				</HTMLResource>`
				} else if allAdDetails.Type == "html" {
					if allAdDetails.Filename != "" {
						companion_banner = `<HTMLResource>
					<![CDATA[ ` + clickTag_start + `<iframe id='rv-h5-` + rand1 + `' name='rv-h5-` + rand1 + `' src='` + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + allAdDetails.Filename + `/index.html?CkT={CRL}'  "marginwidth='0' marginheight='0' scrolling='no'  frameborder='0' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Width) + `' style='width: ` + strconv.Itoa(allAdDetails.Width) + `px; height: ` + strconv.Itoa(allAdDetails.Width) + `px; border: 0'></iframe>` + clickTag_end + ` ]]>
					</HTMLResource>`
					} else {
						companion_banner = `<HTMLResource>
					 <![CDATA[ <div>` + allAdDetails.Htmltemplate + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div></div>  ]]>
					 </HTMLResource>`
					}
				}

				if videoad.Vast_type == 1 || videoad.Vast_type == 2 {

					companionads = "<CompanionAds>"
					companionid = "companion"
					if videoad.Width == -2 && videoad.Height == -2 {
						attr = ` scalable="true" maintainAspectRatio="true"`
					}

				} else if videoad.Vast_type == 3 || videoad.Vast_type == 4 {
					companionads = `<CompanionAds required="any">`
					companionid = strconv.Itoa(videoad.Vast_companion_banner_id)
					UID = `<UniversalAdId idRegistry="unknown">unknown</UniversalAdId>`
				}

				if videoad.Vast_thirdparty_companion_pxratio.String != "" {
					pxRatio = ` pxRatio="` + videoad.Vast_thirdparty_companion_pxratio.String + `"`
				}

				if videoad.Vast_thirdparty_companion_alttext.String != "" {
					companion_banner += `<AltText>
				<![CDATA[ ` + videoad.Vast_thirdparty_companion_alttext.String + ` ]]>
				</AltText>`
				}

				if videoad.Vast_thirdparty_companion_clicktracking != "" {
					companionclicks = `<CompanionClickTracking><![CDATA[` + videoad.Vast_thirdparty_companion_clicktracking + `]]></CompanionClickTracking>`
				}
				if allAdDetails.Url != "" {
					companionclickthrough = `<CompanionClickThrough><![CDATA[` + allAdDetails.Url + `]]></CompanionClickThrough>`
				}
				companiontrack = `<TrackingEvents>
			<Tracking event="creativeView">
			<![CDATA[` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(allAdDetails.Ad_id) + `&zoneid=0&event=creativeView]]>
			</Tracking></TrackingEvents>`

				companions = `<Creative sequence="1">
			` + companionads + `
			<Companion id="` + companionid + `"` + width + height + companionassetwidth + companionassetheight + companionexpandedwidth + companionexpandedheight + pxRatio + attr + `>
			` + companion_banner + companiontrack + `
			` + companionclicks + companionclickthrough + `
			</Companion>
			</CompanionAds>	
			` + UID + `		
			</Creative>`
			}
		}
	}
	return companions
}

func GetCompanionAudio(videoad djgetad.GetAd, audio25 *openrtb.Audio, redisClient *djredis.RedisClient) string {

	var fc_path, companions, companionads, companionclicks, companionassetheight, companionassetwidth, companionexpandedheight, companionexpandedwidth, companiontrack, companion_banner, companionclickthrough, pxRatio, companionid, UID, attr string

	fc_path = djconstants.ReviveProtocol + djconstants.ReviveRoot + "/fc.php"

	if audio25.CompanionAd != nil && audio25.CompanionAd[0].H != 0 && audio25.CompanionAd[0].W != 0 {

		if videoad.Vast_thirdparty_companion_assetheight.Int64 != 0 {
			companionassetheight = ` assetHeight="` + strconv.Itoa(int(videoad.Vast_thirdparty_companion_assetheight.Int64)) + `"`
		}
		if videoad.Vast_thirdparty_companion_assetwidth.Int64 != 0 {
			companionassetwidth = ` assetWidth="` + strconv.Itoa(int(videoad.Vast_thirdparty_companion_assetwidth.Int64)) + `"`
		}
		if videoad.Vast_thirdparty_companion_expandedheight != 0 {
			companionexpandedheight = ` expandedHeight="` + strconv.Itoa(videoad.Vast_thirdparty_companion_expandedheight) + `"`
		}
		if videoad.Vast_thirdparty_companion_expandedwidth != 0 {
			companionexpandedwidth = ` expandedWidth="` + strconv.Itoa(videoad.Vast_thirdparty_companion_expandedwidth) + `"`
		}
		if videoad.Vast_creative_type.String != "" {
			//companionresource = `<StaticResource creativeType="` + videoad.Vast_creative_type.String + `">`
		}

		if videoad.Vast_companion_banner_id != 0 {

			Details := AdDetails{}
			allAdDetails := GetAd(videoad.Vast_companion_banner_id, Details, redisClient)

			if audio25.CompanionAd[0].H == allAdDetails.Height && audio25.CompanionAd[0].W == allAdDetails.Width {
				fmt.Println("all ad details", allAdDetails)
				width := ` width="` + strconv.Itoa(allAdDetails.Width) + `"`
				height := ` height="` + strconv.Itoa(allAdDetails.Height) + `"`
				rand1 := djextrafunc.RandToken(5)

				filename := djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + allAdDetails.Filename

				clickurl := ""
				clickTag_start := ""
				clickTag_end := ""

				if allAdDetails.Url != "" {
					clickurl = djconstants.AppProtocol + djconstants.ReviveDelivery + "/cl.php?oaparams=2&bannerid=" + strconv.Itoa(allAdDetails.Ad_id) + "&campaignid=" + strconv.Itoa(allAdDetails.Placement_id) + "&zoneid=0___oadest=" + allAdDetails.Url

					clickTag_start = `<a href='` + clickurl + `' target='_blank'>`
					clickTag_end = `</a>`

				}

				impurl := djconstants.AppProtocol + djconstants.ReviveDelivery + "/lg.php?bannerid=" + strconv.Itoa(allAdDetails.Ad_id) + "&amp;campaignid=" + strconv.Itoa(allAdDetails.Placement_id) + "&amp;zoneid=0"

				if allAdDetails.Type == "web" {
					companion_banner = `<HTMLResource>
			<![CDATA[ ` + clickTag_start + `<img src='` + filename + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_c5a0d3e41e' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
			</HTMLResource>`
				} else if allAdDetails.Type == "sql" {
					companion_banner = `<HTMLResource>
				<![CDATA[` + clickTag_start + ` <img src='` + djconstants.AppProtocol + djconstants.ReviveDelivery + `/ai.php?filename=` + allAdDetails.Filename + `&contenttype=` + allAdDetails.Contenttype + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
				</HTMLResource>`
				} else if allAdDetails.Type == "url" {
					companion_banner = `<HTMLResource>
				<![CDATA[` + clickTag_start + ` <img src='` + allAdDetails.Imageurl + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_c5a0d3e41e' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
				</HTMLResource>`
				} else if allAdDetails.Type == "txt" {
					companion_banner = `<HTMLResource>
				<![CDATA[ ` + clickTag_start + allAdDetails.Bannertext + `` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
				</HTMLResource>`
				} else if allAdDetails.Type == "html" {
					if allAdDetails.Filename != "" {
						companion_banner = `<HTMLResource>
					<![CDATA[ ` + clickTag_start + `<iframe id='rv-h5-` + rand1 + `' name='rv-h5-` + rand1 + `' src='` + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + allAdDetails.Filename + `/index.html?CkT={CRL}'  "marginwidth='0' marginheight='0' scrolling='no'  frameborder='0' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' style='width: ` + strconv.Itoa(allAdDetails.Width) + `px; height: ` + strconv.Itoa(allAdDetails.Height) + `px; border: 0'></iframe>` + clickTag_end + ` ]]>
					</HTMLResource>`
					} else {
						companion_banner = `<HTMLResource>
					 <![CDATA[ <div>` + allAdDetails.Htmltemplate + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div></div>  ]]>
					 </HTMLResource>`
					}
				}

				if videoad.Vast_type == 1 || videoad.Vast_type == 2 {

					companionads = "<CompanionAds>"
					companionid = "companion"
					if videoad.Width == -2 && videoad.Height == -2 {
						attr = ` scalable="true" maintainAspectRatio="true"`
					}

				} else if videoad.Vast_type == 3 || videoad.Vast_type == 4 {
					companionads = `<CompanionAds required="any">`
					companionid = strconv.Itoa(videoad.Vast_companion_banner_id)
					UID = `<UniversalAdId idRegistry="unknown">unknown</UniversalAdId>`
				}

				if videoad.Vast_thirdparty_companion_pxratio.String != "" {
					pxRatio = ` pxRatio="` + videoad.Vast_thirdparty_companion_pxratio.String + `"`
				}

				if videoad.Vast_thirdparty_companion_alttext.String != "" {
					companion_banner += `<AltText>
				<![CDATA[ ` + videoad.Vast_thirdparty_companion_alttext.String + ` ]]>
				</AltText>`
				}

				if videoad.Vast_thirdparty_companion_clicktracking != "" {
					companionclicks = `<CompanionClickTracking><![CDATA[` + videoad.Vast_thirdparty_companion_clicktracking + `]]></CompanionClickTracking>`
				}
				if allAdDetails.Url != "" {
					companionclickthrough = `<CompanionClickThrough><![CDATA[` + allAdDetails.Url + `]]></CompanionClickThrough>`
				}
				companiontrack = `<TrackingEvents>
			<Tracking event="creativeView">
			<![CDATA[` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(allAdDetails.Ad_id) + `&zoneid=0&event=creativeView]]>
			</Tracking></TrackingEvents>`

				companions = `<Creative sequence="1">
			` + companionads + `
			<Companion id="` + companionid + `"` + width + height + companionassetwidth + companionassetheight + companionexpandedwidth + companionexpandedheight + pxRatio + attr + `>
			` + companion_banner + companiontrack + `
			` + companionclicks + companionclickthrough + `
			</Companion>
			</CompanionAds>	
			` + UID + `		
			</Creative>`
			}
		}
	}
	return companions
}

func GetAd(ad_id int, adDetails AdDetails, redisClient *djredis.RedisClient) AdDetails {

	ad_id_str := strconv.Itoa(ad_id)

	redisClient.GetKey("adid"+ad_id_str, &adDetails)

	if adDetails.Ad_id != 0 {

		return adDetails
	}

	table_prefix := "rv_"

	adQuery := "SELECT d.bannerid AS ad_id, d.campaignid AS placement_id, d.status AS status, d.description AS name, d.storagetype AS type, d.contenttype AS contenttype, d.pluginversion AS pluginversion, d.filename AS filename, d.imageurl AS imageurl, d.htmltemplate AS htmltemplate, d.htmlcache AS htmlcache, d.width AS width, d.height AS height, d.weight AS weight, d.seq AS seq, d.target AS target, d.url AS url, d.alt AS alt, d.statustext AS statustext, d.bannertext AS bannertext, d.adserver AS adserver, d.block AS block_ad, d.capping AS cap_ad, d.session_capping AS session_cap_ad, d.compiledlimitation AS compiledlimitation, d.acl_plugins AS acl_plugins, d.prepend AS prepend, d.append AS append, d.bannertype AS bannertype, d.alt_filename AS alt_filename, d.alt_imageurl AS alt_imageurl, d.alt_contenttype AS alt_contenttype, d.parameters AS parameters, d.transparent AS transparent, IF(d.ext_bannertype != NULL,d.ext_bannertype, '') as ext_bannertype, d.iframe_friendly AS iframe_friendly, c.campaignid AS campaign_id, c.block AS block_campaign, c.capping AS cap_campaign, c.session_capping AS session_cap_campaign, c.show_capped_no_cookie AS show_capped_no_cookie, m.clientid AS client_id, c.clickwindow AS clickwindow, c.viewwindow AS viewwindow, m.advertiser_limitation AS advertiser_limitation, m.agencyid AS agency_id, c.status AS campaign_status FROM " + table_prefix + "banners AS d, " + table_prefix + "campaigns AS c, " + table_prefix + "clients AS m WHERE d.bannerid=%d AND budget_status=0  AND d.campaignid = c.campaignid AND m.clientid = c.clientid"

	adQuery = fmt.Sprintf(adQuery, ad_id)

	rows, err := djdb.DbQuery(adQuery)

	if err != nil {
		fmt.Println("Failed to run query", err)
	}

	for rows.Next() {

		err = djextrafunc.Scan(&adDetails, rows)

		redisClient.SetKey("adid"+ad_id_str, adDetails, time.Minute*djconstants.RedisExpInMin)

		if err != nil {
			fmt.Println("Failed to run query", err)
		}

	}
	defer rows.Close()
	return adDetails

}

type AdDetails struct {
	Ad_id                 int
	Placement_id          int
	Status                int
	Name                  string
	Type                  string
	Contenttype           string
	Pluginversion         int
	Filename              string
	Imageurl              string
	Htmltemplate          string
	Htmlcache             string
	Width                 int
	Height                int
	Weight                int
	Seq                   int
	Target                string
	Url                   string
	Alt                   string
	Statustext            string
	Bannertext            string
	Adserver              string
	Block_ad              int
	Cap_ad                int
	Session_cap_ad        int
	Compiledlimitation    string
	Acl_plugins           sql.NullString
	Prepend               string
	Append                string
	Bannertype            int
	Alt_filename          string
	Alt_imageurl          string
	Alt_contenttype       string
	Parameters            string
	Transparent           int
	Ext_bannertype        string
	Iframe_friendly       int
	Campaign_id           int
	Block_campaign        int
	Cap_campaign          int
	Session_cap_campaign  int
	Show_capped_no_cookie int
	Client_id             int
	Clickwindow           int
	Viewwindow            int
	Advertiser_limitation int
	Agency_id             int
	Campaign_status       int
	Html                  string
	Imp_url               string
	Click_url             string
}
