package djbannerad

import (
	"djgetad"
	"djgetad_models"
	"djlogger"
	"djmime"
	"djredis"
	"fmt"

	openrtb "openrtb/openrtb2.5"
)

// Function to get banner ad
func GetBannerads25(banChannel chan []djgetad.GetAd, imp *openrtb.Banner, bid_floor float64, req_details map[string]interface{}, pmp int8, deals []openrtb.Deal, redisClient *djredis.RedisClient) {
	width := imp.W
	height := imp.H
	storagetype := djmime.Mime_type(imp.Mimes)
	bannerads, err := djgetad_models.BannerSearch25(width, height, bid_floor, req_details["dsp_id"].(int), storagetype, pmp, deals, redisClient)
	if err != nil {
		fmt.Println("db errror", err)
		djlogger.Log.Println("Error : ", err)
	}

	banChannel <- bannerads
}
