package djaudioad

import (
	"crypto/md5"
	"djcompanionad"
	"djconstants"
	"djdb"
	"djextrafunc"
	"djgetad"
	"djgetad_models"
	"djlogger"
	"djredis"
	"encoding/hex"
	"fmt"
	openrtb "openrtb/openrtb2.5"
	"path"
	"strconv"
	"strings"
	"time"
)

type Cadv struct {
	Clientid   int
	Clientname string
	Clientexp  time.Time
}

type Ccat struct {
	Cname string
}

var client_table = djconstants.TablePrefix + "clients"
var campaign_table = djconstants.TablePrefix + "campaigns"
var sitCat_table = "djax_site_categories"

// Function to get audio ad 2.5
func GetAudioads25(audChannel chan []djgetad.GetAd, audio *openrtb.Audio, req_details map[string]interface{}, pmp int8, deals []openrtb.Deal) {
	audioads, err := djgetad_models.AudioSearch(audio.Mimes, audio.Protocols, audio.MinDuration, audio.MaxDuration, audio.MinBitrate, audio.MaxBitrate, audio.MaxExtended, req_details["dsp_id"].(int), pmp, deals)
	if err != nil {
		djlogger.Log.Println(err)
	}
	audChannel <- audioads
}

// Function to get vast XML
func GetVastXML(audioad djgetad.GetAd, bid_floor float64, audio25 *openrtb.Audio, req_details map[string]interface{}, resID string, cookieid string, redisClient *djredis.RedisClient, request_id string, won_price float64) (string, int) {

	vA := &Cadv{}
	var (
		protocol, bannerid, vastxml, fc_path, impression, impurlRevive, logurl, rubiconDmpurl, pricingtype, error_code, adVerifications, viewableImpression, iabcategory, url_1, url_2, trackingUrl, adservingid, advertiser, expiretime, clientname, companions string
		clientid, aAttr                                                                                                                                                                                                                                          int
		clientexp                                                                                                                                                                                                                                                time.Time
		aapi                                                                                                                                                                                                                                                     []int
	)
	// if audio25 != nil {
	// 	aapi = audio25.API
	// 	/*Companion Ads*/
	// 	if audio25.CompanionAd != nil {
	// 		companionads = `<Creative><CompanionAds>`
	// 		for _, v := range audio25.CompanionAd {
	// 			banChannel := make(chan []djgetad.GetAd)
	// 			go djbannerad.GetBannerads25(banChannel, &v, bid_floor, req_details, 0, nil, redisClient)
	// 			banads := <-banChannel
	// 			if len(banads) > 0 {
	// 				creativeType := strings.Split(banads[0].Filename, ".")
	// 				companionads += `
	// 					<Companion width="` + strconv.Itoa(banads[0].Width) + `" height="` + strconv.Itoa(banads[0].Height) + `">
	// 						<StaticResource creativeType="image/` + creativeType[1] + `">` + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + banads[0].Filename + `</StaticResource>
	// 						<CompanionClickThrough>` + djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + strconv.Itoa(banads[0].Ad_id) + "&zoneid=0&oadest=" + banads[0].Url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + strconv.Itoa(banads[0].Placement_id) + "&request_id=" + request_id + "&bidder_id=" + fmt.Sprint(req_details["dsp_id"]) + `</CompanionClickThrough>
	// 					</Companion>`
	// 			}
	// 		}
	// 		companionads += `</CompanionAds></Creative>`
	// 	}
	// 	/*Companion Ads*/
	// }

	companions = djcompanionad.GetCompanionAudio(audioad, audio25, redisClient)

	fmt.Println("companions", companions)

	bannerid = strconv.Itoa(audioad.Ad_id)
	protocol = djconstants.ReviveProtocol
	logurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + bannerid + "&campaignid=" + strconv.Itoa(audioad.Placement_id) + "&agencyid=" + strconv.Itoa(audioad.Agencyid) + "&clientid=" + strconv.Itoa(audioad.Clientid) + "&zoneid=0&bidid=" + resID + "&request_id=" + request_id + "&price=" + fmt.Sprint(won_price) + "&bidder_id=" + fmt.Sprint(req_details["dsp_id"])
	impurlRevive = djconstants.AppProtocol + djconstants.ReviveDelivery + "/lg.php?bannerid=" + bannerid + "&amp;campaignid=" + strconv.Itoa(audioad.Placement_id) + "&amp;zoneid=0"
	rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?cookieid=" + cookieid + "&dspid=" + strconv.Itoa(req_details["dsp_id"].(int))
	fc_path = protocol + djconstants.ReviveRoot + "/fc.php"
	trackingUrl = fc_path + "?script=djaxvideoAds:djaxvastEvent&bannerid=" + bannerid + "&zoneid=0"
	adservingid = req_details["Host"].(string) + djextrafunc.RandToken(5) + bannerid
	hasher := md5.New()
	hasher.Write([]byte(adservingid))
	adservingid = hex.EncodeToString(hasher.Sum(nil))
	/*Advertiser*/
	err := redisClient.GetKey("djaAdv"+strconv.Itoa(audioad.Placement_id), vA)
	if err != nil {
		djlogger.Log.Println("Key expired or error in getting redis key: ", err.Error())
	}
	if vA != nil && err == nil {
		clientid = vA.Clientid
		clientname = vA.Clientname
		clientexp = vA.Clientexp
	} else {
		djdb.DbQueryRow("select cl.clientid as clientid,cl.clientname as name,c.expire_time as expire_time from "+client_table+" as cl,"+campaign_table+" as c where c.clientid=cl.clientid and c.campaignid=?", audioad.Placement_id).Scan(&clientid, &clientname, &clientexp)
		err := redisClient.SetKey("djaAdv"+strconv.Itoa(audioad.Placement_id), &Cadv{Clientid: clientid, Clientname: clientname, Clientexp: clientexp}, time.Minute*djconstants.RedisExpInMin)
		if err != nil {
			djlogger.Log.Println("Error in setting redis key: ", err.Error())
		}
	}
	advertiser = `<Advertiser id="` + strconv.Itoa(clientid) + `">` + clientname + `</Advertiser>`
	/*Advertiser*/
	/*Expires*/
	if clientexp.String() != "" {
		expiretime = `<Expires>` + clientexp.String() + `</Expires>`
	}
	/*Expires*/
	/*Pricingtype*/
	if audioad.Revenue_type == 1 {
		pricingtype = "CPM"
	} else if audioad.Revenue_type == 2 {
		pricingtype = "CPC"
	} else if audioad.Revenue_type == 3 {
		pricingtype = "CPA"
	}
	/*Pricingtype*/
	/*Impression*/
	impression = `<Impression><![CDATA[` + logurl + `]]></Impression>`
	impression += `<Impression><![CDATA[` + impurlRevive + `]]></Impression>`
	impression += `<Impression><![CDATA[` + rubiconDmpurl + `]]></Impression>`
	if audioad.Vast_thirdparty_impression.String != "" {
		impression += `<Impression>
							<![CDATA[` + audioad.Vast_thirdparty_impression.String + `]]>
						</Impression>`
	}
	/*Impression*/
	/*Error code Add*/
	error_code = `<Error><![CDATA[` + protocol + djconstants.ReviveDelivery + `/errorcode.php?zoneid=0&errorcode=[ERRORCODE]]]></Error>`
	/*Errorcode add*/
	/*Adverification for Vast4*/
	if audioad.Vast4_verificationurl1.String != "" || audioad.Vast4_verificationurl2.String != "" {
		if audioad.Vast4_adverificationtype1 == "1" {
			url_1 = `<Verification>
						<JavaScriptResource>
							<![CDATA[` + audioad.Vast4_verificationurl1.String + `]]>
						</JavaScriptResource>
					</Verification>`
		} else if audioad.Vast4_adverificationtype1 == "2" {
			url_1 = `<Verification>
						<FlashResource>
							<![CDATA[` + audioad.Vast4_verificationurl1.String + `]]>
						</FlashResource>
					</Verification>`
		}
		if audioad.Vast4_adverificationtype2 == "1" {
			url_2 = `<Verification>
							<JavaScriptResource>
								<![CDATA[` + audioad.Vast4_verificationurl2.String + `]]>
							</JavaScriptResource>
						</Verification>`
		} else if audioad.Vast4_adverificationtype2 == "2" {
			url_2 = `<Verification>
							<FlashResource>
								<![CDATA[` + audioad.Vast4_verificationurl2.String + `]]>
							</FlashResource>
						</Verification>`
		}
		adVerifications = `<AdVerifications>
								` + url_1 + `
								` + url_2 + `
							</AdVerifications>`
	}
	/*Adverification for Vast4*/
	/*Viewable Impression*/
	viewableImpression = `<ViewableImpression id="` + strconv.Itoa(djextrafunc.RandNumber(10)) + `">
								<Viewable><![CDATA[` + trackingUrl + `&event=viewable]]></Viewable>
								<NotViewable><![CDATA[` + trackingUrl + `&event=notviewable]]></NotViewable>
								<ViewUndetermined><![CDATA[` + trackingUrl + `&event=viewundetermined]]></ViewUndetermined>
							</ViewableImpression>`
	/*Viewable Impression*/
	/*IAB Category in vast response*/
	if audioad.Iabcategory.String != "" {
		category := strings.Split(audioad.Iabcategory.String, ",")
		for _, v := range category {
			var cname string
			vC := &Ccat{}
			err := redisClient.GetKey("djaCat"+v, vC)
			if err != nil {
				djlogger.Log.Println("Key expired or error in getting redis key: ", err.Error())
			}
			if vC != nil && err == nil {
				cname = vC.Cname
			} else {
				djdb.DbQueryRow("SELECT category_name FROM `" + sitCat_table + "` where value = '" + v + "'").Scan(&cname)
				err := redisClient.SetKey("djaCat"+v, &Ccat{Cname: cname}, time.Minute*djconstants.RedisExpInMin)
				if err != nil {
					djlogger.Log.Println("Error in setting redis key: ", err.Error())
				}
			}
			iabcategory += `<Category authority='http://www.iabtechlab.com/categoryauthority'><![CDATA[` + cname + `]]></Category>`
		}
	}
	/*IAB Category in vast response*/
	/*Inline Ad XML Response*/
	if audioad.Width == -3 && audioad.Height == -3 {
		var api, iprog, clickurl, skip, skip_progress_duration, mediafile, mediafile1, mediafile2, videoClicksVast, videoClickstrackVast, videocustomClicksVast, closedcaption, closedcaption2, closedcaption3, type1, type2, type3, lang, lang1, lang2, interactivemediafile, Mezzaninefile, maxbitrate, minbitrate, icontype1, resource, icon, pricing, adType string
		adservingid = req_details["Host"].(string) + djextrafunc.RandToken(5) + bannerid
		hasher := md5.New()
		hasher.Write([]byte(adservingid))
		adservingid = hex.EncodeToString(hasher.Sum(nil))
		api = djextrafunc.ArrayToString(aapi, ",")
		iprog = ""
		/*Icontype*/
		k := strings.Split(path.Base(audioad.Vast_icon_filename.String), ".")
		icontype1 = string(k[1])
		if icontype1 == "jpg" || icontype1 == "jpeg" {
			icontype1 = "image/jpeg"
		} else if icontype1 == "png" {
			icontype1 = "image/png"
		} else if icontype1 == "gif" {
			icontype1 = "Image/gif"
		} else if icontype1 == "htm" {
			icontype1 = "Image/htm"
		} else {
			icontype1 = ""
		}
		/*Icontype*/
		/*Clickurl*/
		if audioad.Vast_video_clickthrough_url.String != "" {
			clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + bannerid + "&zoneid=0&oadest=" + audioad.Vast_video_clickthrough_url.String + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + strconv.Itoa(audioad.Placement_id) + "&agencyid=" + strconv.Itoa(audioad.Agencyid) + "&clientid=" + strconv.Itoa(audioad.Clientid) + "&request_id=" + request_id + "&bidder_id=" + fmt.Sprint(req_details["dsp_id"])
		}
		/*Clickurl*/

		/*Skip Progress*/
		if audioad.Vast_video_skip_progress_duration.String != "" {
			skip_progress_duration = `offset="` + audioad.Vast_video_skip_progress_duration.String + `"`
		} else {
			skip_progress_duration = ""
		}
		/*Skip Progress*/
		/*Vast_video_type*/
		if audioad.Vast_video_type.String == "video/x-mp4" {
			audioad.Vast_video_type.String = "video/mp4"
		}
		/*Vast_video_type*/
		/*Min Max Bitrate*/
		if audioad.Vast4_max_bitrate.Int64 != 0 {
			maxbitrate = `"maxBitrate="` + `"` + strconv.Itoa(int(audioad.Vast4_max_bitrate.Int64)) + `"`
		}
		if audioad.Vast4_min_bitrate.Int64 != 0 {
			minbitrate = `"minBitrate="` + `"` + strconv.Itoa(int(audioad.Vast4_min_bitrate.Int64)) + `"`
		}
		/*Min Max Bitrate*/
		/*Ad_type*/
		if audioad.Ad_type.Int64 == 1 {
			adType = "audio"
		} else {
			adType = "video"
		}
		/*Ad_type*/
		/*Pricing*/
		pricing = `<Pricing model='` + pricingtype + `' currency='USD'><![CDATA[` + audioad.Revenue + `]]></Pricing>`
		/*Pricing*/
		/*<Icon>*/

		var Icon_duration string
		if audioad.Vast_icon_duration.Valid {
			Icon_duration = audioad.Vast_icon_duration.String
		} else {
			Icon_duration = "00:00:00"
		}

		if audioad.Vast_icon_filename.String != "" {
			if icontype1 == "image/jpeg" {
				resource = `<StaticResource creativeType="` + icontype1 + `"><![CDATA[` + audioad.Vast_icon_filename.String + `]]></StaticResource>`
			} else {
				resource = `<HTMLResource><![CDATA[` + audioad.Vast_icon_filename.String + `]]></HTMLResource>`
			}
			icon = `<Icons>
							<Icon program="` + iprog + `" height= "` + audioad.Vast_icon_height.String + `" width= "` + audioad.Vast_icon_width.String + `" xPosition= "` + strconv.Itoa(int(audioad.Vast_icon_xposition.Int64)) + `" yPosition= "` + strconv.Itoa(int(audioad.Vast_icon_yposition.Int64)) + `" apiFramework="` + api + `" offset= "` + audioad.Vast_icon_offset.String + `" duration= "` + Icon_duration + `">
							` + resource + `
								<IconClicks>
									<IconClickThrough><![CDATA[` + trackingUrl + `&event=iconclick]]> </IconClickThrough>
									<IconClickTracking><![CDATA[` + trackingUrl + `&event=icontrack]]></IconClickTracking>
								</IconClicks>
								<IconViewTracking>
									<![CDATA[` + trackingUrl + `&event=iconimpression]]>
								</IconViewTracking>
							</Icon>
						</Icons>`
		}
		/*<Icon>*/
		/*<Clickthrough_url>*/
		if audioad.Vast_video_clickthrough_url.String != "" {
			if audioad.Vast_thirdparty_clicktracking.String != "" {
				videoClickstrackVast = `<ClickTracking>
											<![CDATA[` + audioad.Vast_thirdparty_clicktracking.String + `]]>
										</ClickTracking>`
			}
			if audioad.Vast_thirdparty_clickcustom.String != "" {
				videocustomClicksVast = `<CustomClick>
											<![CDATA[` + audioad.Vast_thirdparty_clickcustom.String + `]]>
										</CustomClick >`
			}
			videoClicksVast = `<VideoClicks>
									<ClickThrough>
										<![CDATA[` + clickurl + `]]>
									</ClickThrough> ` + videoClickstrackVast + videocustomClicksVast + `
								</VideoClicks>`
		}
		/*<Clickthrough_url>*/
		/*<InteractiveCreativeFile>*/
		if audioad.Interactive_mediafile.String != "" {
			interactivemediafile = `<InteractiveCreativeFile><![CDATA[` + audioad.Interactive_mediafile.String + `]]></InteractiveCreativeFile>`
		}
		/*<InteractiveCreativeFile>*/
		/*<Mezzanine>*/
		/*If upload the Mezzanine file there should be folder available in the path */
		if audioad.Is_mezzininefile.Int64 == 1 {
			if audioad.Mezzanine_en.Int64 == 1 && audioad.Internal_file.String != "" {
				Videofilepath := protocol + djconstants.MezzaninePath + audioad.Internal_file.String
				Mezzaninefile = `<Mezzanine><![CDATA[` + Videofilepath + `]]></Mezzanine>`
			} else if audioad.Mezzanine_en.Int64 == 2 {
				Mezzaninefile = `<Mezzanine><![CDATA[` + audioad.Url_file.String + `]]></Mezzanine>`
			}
		}
		/*<Mezzanine>*/
		/*CLosed Captions*/

		if audioad.Vast_4_1_type_file.String == "1" {
			type1 = "text/srt"
		} else if audioad.Vast_4_1_type_file.String == "2" {
			type1 = "text/vtt"
		} else if audioad.Vast_4_1_type_file.String == "3" {
			type1 = "application/ttml+xml"
		}

		if audioad.Vast_4_1_type_file_1.String == "1" {
			type2 = "text/srt"
		} else if audioad.Vast_4_1_type_file_1.String == "2" {
			type2 = "text/vtt"
		} else if audioad.Vast_4_1_type_file_1.String == "3" {
			type2 = "application/ttml+xml"
		}

		if audioad.Vast_4_1_type_file_2.String == "1" {
			type3 = "text/srt"
		} else if audioad.Vast_4_1_type_file_2.String == "2" {
			type3 = "text/vtt"
		} else if audioad.Vast_4_1_type_file_2.String == "3" {
			type3 = "application/ttml+xml"
		}

		if audioad.Vast_4_1_language.String == "1" {
			lang = "en"
		} else if audioad.Vast_4_1_language.String == "2" {
			lang = "zh-TW"
		} else if audioad.Vast_4_1_language.String == "3" {
			lang = "zh-CH"
		}

		if audioad.Vast_4_1_language_1.String == "1" {
			lang1 = "en"
		} else if audioad.Vast_4_1_language_1.String == "2" {
			lang1 = "zh-TW"
		} else if audioad.Vast_4_1_language_1.String == "3" {
			lang1 = "zh-CH"
		}

		if audioad.Vast_4_1_language_2.String == "1" {
			lang2 = "en"
		} else if audioad.Vast_4_1_language_2.String == "2" {
			lang2 = "zh-TW"
		} else if audioad.Vast_4_1_language_2.String == "3" {
			lang2 = "zh-CH"
		}
		if audioad.Vast_4_1_url.String != "" {
			if audioad.Vast_4_1_url_1.String != "" {
				closedcaption2 = `<ClosedCaptionFile type='` + type2 + `' language='` + lang1 + `'>
										<![CDATA[` + audioad.Vast_4_1_url_1.String + `]]>
									</ClosedCaptionFile>`
			}
			if audioad.Vast_4_1_url_2.String != "" {
				closedcaption3 = `<ClosedCaptionFile type='` + type3 + `' language='` + lang2 + `'>
										<![CDATA[` + audioad.Vast_4_1_url_2.String + `]]>
									</ClosedCaptionFile>`
			}
			closedcaption = `<ClosedCaptionFiles>
									<ClosedCaptionFile type='` + type1 + `' language='` + lang + `'>
										<![CDATA[` + audioad.Vast_4_1_url.String + `]]>
									</ClosedCaptionFile>` + closedcaption2 + closedcaption3 + `
								</ClosedCaptionFiles>`
		}
		/*CLosed Captions*/
		/*Mediafile*/
		fmt.Println("audioad.Vid_upload_type.String", audioad.Vid_upload_type.String)
		if audioad.Vid_upload_type.String == "Internal" {
			fmt.Println("if called")
			audioad.Vast_video_outgoing_filename.String = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + audioad.Vast_video_outgoing_filename.String
		}
		mediafile = `<MediaFile delivery="` + audioad.Vast_video_delivery.String + `" bitrate="` + audioad.Vast_video_bitrate.String + `" width="25" height="25" ` + maxbitrate + ` ` + minbitrate + ` type="` + audioad.Vast_video_type.String + `" scalable="true" maintainAspectRatio="true">
					<![CDATA[ ` + audioad.Vast_video_outgoing_filename.String + ` ]]>
		</MediaFile>`
		if audioad.Vast_video_outgoing_filename1.String != "" {
			mediafile1 = `<MediaFile delivery="` + audioad.Vast_video_delivery.String + `" bitrate="` + audioad.Vast_video_bitrate_1.String + `" width="25" height="25" ` + maxbitrate + ` ` + minbitrate + ` type="` + audioad.Vast_video_type_1.String + `" scalable="true" maintainAspectRatio="true">
					<![CDATA[ ` + audioad.Vast_video_outgoing_filename1.String + ` ]]>
			</MediaFile>`
		}
		if audioad.Vast_video_outgoing_filename2.String != "" {
			mediafile2 = `<MediaFile delivery="` + audioad.Vast_video_delivery.String + `" bitrate="` + audioad.Vast_video_bitrate_2.String + `" width="25" height="25" ` + maxbitrate + ` ` + minbitrate + ` type="` + audioad.Vast_video_type_2.String + `" scalable="true" maintainAspectRatio="true">
					<![CDATA[ ` + audioad.Vast_video_outgoing_filename2.String + ` ]]>
			</MediaFile>`
		}
		djlogger.Log.Println(skip)
		/*Mediafile*/

		audioadGet_third_internal_type := int(audioad.Get_third_internal_type.Int64)

		if audioad.Vast_type == 4 {
			if audioadGet_third_internal_type == 1 {
				vastxml = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + bannerid + `" adType="` + adType + `">
										<InLine>
											<AdSystem version="4.1">
												<![CDATA[ ` + djconstants.AppName + ` ]]>
											</AdSystem>
											<AdServingId>` + adservingid + `</AdServingId>
											` + advertiser + `
											<Description>` + audioad.Name + `</Description>
											` + expiretime + `
											` + error_code + `
											<AdTitle>
												<![CDATA[ ` + audioad.Name + ` ]]>
											</AdTitle>
											` + adVerifications + `
											` + viewableImpression + `
											` + iabcategory + `
											` + pricing + `
											` + impression + `
											<Creatives>
												<Creative>
													
													<Linear>
														<Duration>` + djextrafunc.SecondsToTime(int(audioad.Vast_video_duration.Int64)) + `</Duration>
														<TrackingEvents>
															<Tracking event="start">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=start
															]]>
															</Tracking>
															<Tracking event="firstQuartile">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=firstquartile
															]]>
															</Tracking>
															<Tracking event="midpoint">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=midpoint
															]]>
															</Tracking>
															<Tracking event="thirdQuartile">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=thirdquartile
															]]>
															</Tracking>
															<Tracking event="complete">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=complete
															]]>
															</Tracking>
															<Tracking event="pause">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=pause
															]]>
															</Tracking>
															<Tracking event="mute">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=mute
															]]>
															</Tracking>
															<Tracking event="unmute">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=unmute
															]]>
															</Tracking>
															<Tracking event="acceptInvitationLinear">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=acceptInvitationLinear
															]]>
															</Tracking>
															<Tracking event="skip">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=skip
															]]>
															</Tracking>
															<Tracking event="progress" ` + skip_progress_duration + `>
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=progress
															]]>
															</Tracking>
															<Tracking event="rewind">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=rewind
															]]>
															</Tracking>
															<Tracking event="resume">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=resume
															]]>
															</Tracking>
															<Tracking event="timeSpentViewing">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=timeSpentViewing
															]]>
															</Tracking>
															<Tracking event="otherAdInteraction">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=otherAdInteraction
															]]>
															</Tracking>
															<Tracking event="playerExpand">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerExpand
															]]>
															</Tracking>
															<Tracking event="playerCollapse">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + bannerid + `&zoneid=0&event=playerCollapse
															]]>
															</Tracking>
														</TrackingEvents>
														` + videoClicksVast + `
														<MediaFiles>
															` + closedcaption + `
															` + mediafile + `
															` + mediafile1 + `
															` + mediafile2 + `
															` + interactivemediafile + `
															` + Mezzaninefile + `
														</MediaFiles>
														` + icon + `
													</Linear>
												</Creative>
												` + companions + `
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
			}
		}
	}
	//fmt.Println("vastxml",vastxml)
	/*Inline Ad XML Response*/
	return vastxml, aAttr
}
