package djapp_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	"reflect"
	"strings"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	appobj25 *openrtb.App
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall app targeting criteria
func CheckAppCriteria(appChannel chan []djgetad.GetAd, app25 *openrtb.App, ads []djgetad.GetAd) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			appChannel <- filterads
		}
	}()
	if app25 != nil {
		appobj25 = app25
	}

	validate_campaign := make(map[int]int)

	for _, ad := range ads {

		if validate_campaign[ad.Placement_id] == 1 {

			filterads = append(filterads, ad)

			continue
		}

		if validate_campaign[ad.Placement_id] == 2 {

			continue
		}

		validate_campaign[ad.Placement_id] = 2 // by default not match

		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
				validate_campaign[ad.Placement_id] = 1 // match

			}
		} else {
			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match
		}
	}
	appChannel <- filterads
}

/*------------------------------------------------------
	App Targeting Start : domain,category,bundle,storeurl,ver <==> 19/12/2019 - 20/12/2019
--------------------------------------------------------*/

// PublisherDomain Start
func (c Commander) MAX_checkClient_AppPubDomain(cmd Command) bool {
	var argAppDomain []string
	var reqAppDomain string
	if appobj25 != nil {
		reqAppDomain = appobj25.Publisher.Domain
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppDomain = append(argAppDomain, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqAppDomain != "" {
		if op == "==" {
			return djextrafunc.In_array(reqAppDomain, argAppDomain)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqAppDomain, argAppDomain)
		} else {
			return false
		}
	}
	return false
}

// PublisherDomain End

// Category Start
func (c Commander) MAX_checkClient_AppCategory(cmd Command) bool {
	var reqAppCategory []string
	var argAppCategory []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if appobj25 != nil {
		for _, cat := range appobj25.Cat {
			reqAppCategory = append(reqAppCategory, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppCategory = append(argAppCategory, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqAppCategory != nil {
		if op == "=~" {
			return djextrafunc.CheckEqual(reqAppCategory, argAppCategory)
		} else if op == "!~" {
			return !djextrafunc.CheckEqual(reqAppCategory, argAppCategory)
		}
	}
	return false
}

// Category End

// Bundle Start
func (c Commander) MAX_checkClient_Appid(cmd Command) bool {
	var argAppBundle []string
	var reqAppBundle string
	if appobj25 != nil {
		reqAppBundle = appobj25.Bundle
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppBundle = append(argAppBundle, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqAppBundle != "" {
		if op == "==" {
			return djextrafunc.In_array(reqAppBundle, argAppBundle)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqAppBundle, argAppBundle)
		}
	}
	return false
}

// Bundle End

// StoreUrl Start
func (c Commander) MAX_checkClient_AppStoreUrl(cmd Command) bool {
	var argAppStoreurl []string
	var reqAppStoreurl string
	if appobj25 != nil {
		reqAppStoreurl = appobj25.StoreURL
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppStoreurl = append(argAppStoreurl, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqAppStoreurl != "" {
		if op == "==" {
			return djextrafunc.In_array(reqAppStoreurl, argAppStoreurl)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqAppStoreurl, argAppStoreurl)
		}
	}
	return false
}

// StoreUrl End

// Version Start
func (c Commander) MAX_checkClient_AppVersion(cmd Command) bool {
	var argAppVersion []string
	var reqAppVersion string
	if appobj25 != nil {
		reqAppVersion = appobj25.Ver
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argAppVersion = append(argAppVersion, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqAppVersion != "" {
		if op == "==" {
			return djextrafunc.In_array(reqAppVersion, argAppVersion)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqAppVersion, argAppVersion)
		} else {
			return false
		}
	}
	return false
}

// Version End
/*------------------------------------------------------
	App Targeting End: domain,category,bundle,storeurl,ver <==> 19/12/2019 - 20/12/2019
--------------------------------------------------------*/
