package djad

import (
	"djaudioad"
	"djbannerad"
	"djclickclient"
	"djconstants"
	"djdb"
	"djmime"

	"github.com/gofrs/uuid"

	// "djcapping"

	"djextrafunc"
	"djgetad"
	"djlogger"
	"djmetric"

	// "djmongo"
	"djnativead"
	"djredis"
	"djsource"
	"djtarget"
	"djvideoad"
	"encoding/json"
	"fmt"
	"strconv"
	"strings"
	"time"

	"encoding/base64"
	openrtb "openrtb/openrtb2.5"
)

type Ccookie struct {
	Adid       int
	Campaignid int
}

var sync_table = djconstants.TablePrefix + "dj_dsp_cookie_sync"
var redisClient = djredis.Initialize()

// Function for getting minutes
func GetMin(k int) (m int) {
	if k <= 15 && k >= 0 {
		m = 0
	} else if k <= 30 && k > 15 {
		m = 15
	} else if k <= 45 && k > 30 {
		m = 30
	} else if k <= 59 && k > 45 {
		m = 45
	}
	return
}

func TrackRequest(request_id string, dsp_id int, req *openrtb.BidRequest) {

	t := time.Now()
	y := t.Year()
	var user_age int
	var cur, country, city, domain, os, ip, ua, lan, make, model, device_type, page, ref, gender string

	if req.Cur != nil {
		if len(req.Cur) > 0 {
			cur = djextrafunc.ArrayToString(req.Cur, ",")
		}
	}
	if req.Device.Geo != nil {

		country = req.Device.Geo.Country
		city = req.Device.Geo.City
		fmt.Println("City", city)
	}
	if req.Site != nil {
		domain = req.Site.Domain
	}
	if req.Device != nil {
		os = req.Device.OS
		ip = req.Device.IP
		ua = req.Device.UA
		lan = req.Device.Language
		make = req.Device.Make
		model = req.Device.Model
		// device_type = fmt.Sprint(req.Device.DeviceType)
		if req.Device.DeviceType == 1 || req.Device.DeviceType == 4 {
			device_type = "Mobile"
		} else if req.Device.DeviceType == 2 {
			device_type = "Personal Computer"
		} else if req.Device.DeviceType == 3 {
			device_type = "Connected TV"
		} else if req.Device.DeviceType == 5 {
			device_type = "Tablet"
		} else if req.Device.DeviceType == 6 {
			device_type = "Connected Device"
		} else if req.Device.DeviceType == 7 {
			device_type = "Set top Box"
		}
	}
	if req.Site != nil {
		page = req.Site.Page
		ref = req.Site.Ref
	}
	if req.User != nil {
		gender = req.User.Gender
		if req.User.YOB != 0 {
			user_age = y - req.User.YOB
		}
	}

	djclickclient.Track_ad_request(request_id, uint16(dsp_id), country, city, domain, os, ip, ua, lan, cur, fmt.Sprint(user_age), gender, device_type, make, model, page, ref)
}

// func Request_Stats(request_id string, dsp_id int, ad_id int) {

// 	djclickclient.Track_request(request_id, uint16(dsp_id), uint16(ad_id), 1)
// }

// Function for returing all requested ads 2.5
func Dsp_adprocessing25(channel chan map[string]interface{}, req *openrtb.BidRequest, req_details map[string]interface{}) {
	u1 := uuid.Must(uuid.NewV4())
	request_Id := u1.String()
	var (
		banads, videoads, audioads, nativeads                           []djgetad.GetAd
		seatbidArr                                                      []openrtb.SeatBid
		cookieid                                                        string
		adomain                                                         []string
		syncAdid, syncCampaignid, AD_ID, agencyId, clientId, campaignId int
	)
	vC := &Ccookie{}
	output := make(map[string]interface{})
	req_details["dsp_id"], req_details["dmp_pixel"], _, req_details["web_response_type"], req_details["video_response_type"], req_details["DS"] = djextrafunc.GetDspId(req_details["dsp_name"].(string), req_details["key"].(string), 0, redisClient)
	// resID, objid, reqData, insertRequest := djmongo.MongoSaveRequest25(req_details["dsp_id"].(int), req)

	TrackRequest(request_Id, req_details["dsp_id"].(int), req)
	t := time.Now()
	y := t.Year()
	mon := int(t.Month())
	d := t.Day()
	h := t.Hour()
	min := GetMin(t.Minute())
	tableSuffix := strconv.Itoa(y) + strconv.Itoa(mon) + strconv.Itoa(d) + strconv.Itoa(h) + strconv.Itoa(min)
	idString := fmt.Sprintf(request_Id)
	idString = idString[:8] + idString[9:13] + idString[14:18] + idString[19:23] + idString[24:28]
	resID := "25" + idString + "_" + tableSuffix

	// if insertRequest != true {
	// 	djlogger.Log.Println("Request not inserted in Mongodb")
	// 	output["nbr"] = 1
	// 	channel <- output
	// 	return
	// }
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			output["id"] = resID
			output["nbr"] = 1
			output["seatbid"] = seatbidArr
			channel <- output
		}
	}()
	if req_details["dsp_id"].(int) != 0 {
		domain := strings.Split(req_details["Host"].(string), ":")
		adomain = []string{domain[0]}
		if req.User.BuyerUID != "" {
			cookieid = req.User.BuyerUID
			err := redisClient.GetKey(cookieid, vC)
			if err != nil {
				djlogger.Log.Println("Key expired or error in getting redis key: ", err.Error())
			}
			if vC != nil && err == nil {
				syncAdid = vC.Adid
				syncCampaignid = vC.Campaignid
			} else {

				djdb.DbQueryRow("SELECT adid,campaignid FROM "+sync_table+" where cookieid= '"+cookieid+"'").Scan(&syncAdid, &syncCampaignid)
				err := redisClient.SetKey(cookieid, &Ccookie{Adid: syncAdid, Campaignid: syncCampaignid}, time.Minute*djconstants.RedisExpInMin)
				if err != nil {
					djlogger.Log.Println("Error in setting redis key: ", err.Error())
				}
			}
		} else {
			cookieid = djextrafunc.RandToken(18)
		}
		for _, imp := range req.Imp {
			var (
				seatbid                                                                                                                       openrtb.SeatBid
				bidArr                                                                                                                        []*openrtb.Bid
				dls                                                                                                                           []openrtb.Deal
				revenue_flt                                                                                                                   float64
				pvt                                                                                                                           int8
				width, height                                                                                                                 int
				attr                                                                                                                          []int
				seat, adm, clickurl, impurl, iurl, rubiconDmpurl, cid, ad_id, url, filename, deal_id, titleText, imageurl, agencyid, clientid string
				agency_id, client_id, campaignid                                                                                              int
				dataObject                                                                                                                    map[int]string
			)
			if imp.Banner != nil {
				var bid *openrtb.Bid
				if imp.Pmp != nil {
					pvt = imp.Pmp.Private
					dls = imp.Pmp.Deals
				}
				banChannel := make(chan []djgetad.GetAd)
				go djbannerad.GetBannerads25(banChannel, imp.Banner, imp.BidFloor, req_details, pvt, dls, redisClient)
				banads = <-banChannel
				fmt.Println("banad", banads)

				tarChannel := make(chan []djgetad.GetAd)
				go djtarget.Targeting(tarChannel, req, banads, req_details["cookie"].(string), req_details["dsp_id"].(int))
				banads = <-tarChannel
				fmt.Println("banads", banads)

				sourceChannel := make(chan []djgetad.GetAd)
				go djsource.GetSourceObj(sourceChannel, req.Source, banads, req_details)
				banads = <-sourceChannel
				// if strconv.Itoa(banads[0].Ad_id) == "133" {
				// 	fmt.Println("capping check start")
				// 	capChannel := make(chan []djgetad.GetAd)
				// 	go djcapping.Capping(capChannel, banads,redisClient)
				// 	banads = <-capChannel
				// 	fmt.Println("capping check stop")
				// }

				if len(imp.Metric) > 0 {

					metricChannel := make(chan []djgetad.GetAd)
					go djmetric.CheckMetricCriteria(metricChannel, imp.Metric, banads, redisClient)
					banads = <-metricChannel
				}
				if len(banads) > 0 {
					var adIndex int
					if syncAdid != 0 && syncCampaignid != 0 {
						for k, v := range banads {
							if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
								adIndex = k
							}
						}
					}
					if req.AuctionType == 1 {
						revenue_flt = djextrafunc.StringToFloat(banads[adIndex].Revenue, 64)
					} else {
						if banads[adIndex].SecondRevenue.String != "" {
							revenue_flt = djextrafunc.StringToFloat(banads[adIndex].SecondRevenue.String, 64) + 0.01
						} else {
							revenue_flt = djextrafunc.StringToFloat(banads[adIndex].Revenue, 64)
						}
					}
					width = banads[adIndex].Width
					height = banads[adIndex].Height
					cid = strconv.Itoa(banads[adIndex].Placement_id)
					agencyid = strconv.Itoa(banads[adIndex].Agencyid)
					clientid = strconv.Itoa(banads[adIndex].Clientid)
					ad_id = strconv.Itoa(banads[adIndex].Ad_id)
					agency_id = banads[adIndex].Agencyid
					client_id = banads[adIndex].Clientid
					campaignid = banads[adIndex].Placement_id
					url = banads[adIndex].Url
					filename = banads[adIndex].Filename
					imageurl = banads[adIndex].Imageurl

					fmt.Println("adIndex", adIndex)

					seat = strings.Replace(banads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(banads[adIndex].Clientid)
					deal_id = banads[adIndex].Deal_id
					bidext, err := json.Marshal(openrtb.BidExt{Btype: banads[adIndex].Revenue_type})
					if err != nil {
						djlogger.Log.Println("Error ", err.Error())
					}

					var Key string
					storagetype := djmime.Mime_type(imp.Banner.Mimes)
					Key = fmt.Sprintf("dj_%d_%d_%d_%s_%d", width, height, req_details["dsp_id"].(int), storagetype, pvt)
					// To encrypt the StringToEncrypt
					encText := base64.StdEncoding.EncodeToString([]byte(Key))

					clickurl := ""
					clickTag_start := ""
					clickTag_end := ""

					if url != "" {
						clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + ad_id + "&zoneid=0&oadest=" + url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + cid + "&agencyid=" + agencyid + "&clientid=" + clientid + "&bidder_id=" + fmt.Sprint(req_details["dsp_id"]) + "&request_id=" + request_Id
						clickTag_start = `<a href='` + clickurl + `' target='_blank'>`
						clickTag_end = `</a>`
					}

					impurlRevive := djconstants.AppProtocol + djconstants.ReviveDelivery + "/lg.php?bannerid=" + ad_id + "&amp;campaignid=" + cid + "&amp;zoneid=0"
					ImgTagRevive := `<img src='` + impurlRevive + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
					impurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + ad_id + "&campaignid=" + cid + "&agencyid=" + agencyid + "&clientid=" + clientid + "&zoneid=0&bidid=" + resID + "&bidder_id=" + fmt.Sprint(req_details["dsp_id"]) + "&request_id=" + request_Id + "&price=" + fmt.Sprint(revenue_flt) + "&key=" + encText
					rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?v={ad_network_id}&cookieid=" + cookieid
					if banads[adIndex].Storagetype == "web" {
						adm = "<?xml version='1.0'?><ad xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'modelVersion='0.9'><imageAd><clickUrl>" + clickurl + "</clickUrl><imgUrl>" + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + filename + "</imgUrl><width>" + strconv.Itoa(width) + "</width><height>" + strconv.Itoa(height) + "</height><additionalText></additionalText><beacons><beacon>" + impurl + "</beacon><beacon>" + rubiconDmpurl + "</beacon><beacon>" + req_details["dmp_pixel"].(string) + "</beacon></beacons></imageAd></ad>"
						iurl = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + filename
						if req_details["web_response_type"].(string) == "html" {
							rand1 := djextrafunc.RandToken(5)
							adm = clickTag_start + `<img src='` + djconstants.ReviveProtocol + djconstants.ReviveImages + `/` + filename + `' width='` + strconv.Itoa(width) + `' height='` + strconv.Itoa(height) + `' alt='' title='' border='0'>` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />` + ImgTagRevive + `<img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`
							iurl = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + filename
						}
					} else if banads[adIndex].Storagetype == "html" {
						rand1 := djextrafunc.RandToken(5)
						if filename != "" {

							adm = clickTag_start + `<iframe id='rv-h5-` + rand1 + `' name='rv-h5-` + rand1 + `' src='` + djconstants.ReviveProtocol + djconstants.ReviveImages + `/` + filename + `/index.html?CkT={CRL}'  "marginwidth='0' marginheight='0' scrolling='no'  frameborder='0' width='` + strconv.Itoa(width) + `' height='` + strconv.Itoa(height) + `' style='width: ` + strconv.Itoa(width) + `px; height: ` + strconv.Itoa(height) + `px; border: 0'></iframe>` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />` + ImgTagRevive + `<img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`

						} else {

							adm = banads[adIndex].Htmltemplate + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />` + ImgTagRevive + `<img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`
						}
					} else if banads[adIndex].Storagetype == "txt" {
						rand1 := djextrafunc.RandToken(5)
						adm = clickTag_start + banads[adIndex].Bannertext + `` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />` + ImgTagRevive + `<img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`

					} else if banads[adIndex].Storagetype == "url" {
						rand1 := djextrafunc.RandToken(5)
						adm = clickTag_start + `<img src='` + imageurl + `' width='` + strconv.Itoa(width) + `' height='` + strconv.Itoa(height) + `' alt='' title='' border='0'>` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />` + ImgTagRevive + `<img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`
					} else if banads[adIndex].Storagetype == "sql" {
						contenttype := strings.Split(filename, ".")
						lastValue := contenttype[len(contenttype)-1]

						adm = "<?xml version='1.0'?><ad xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'modelVersion='0.9'><imageAd><clickUrl>" + clickurl + "</clickUrl><imgUrl>" + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + filename + "</imgUrl><width>" + strconv.Itoa(width) + "</width><height>" + strconv.Itoa(height) + "</height><additionalText></additionalText><beacons><beacon>" + impurl + "</beacon><beacon>" + rubiconDmpurl + "</beacon><beacon>" + req_details["dmp_pixel"].(string) + "</beacon></beacons></imageAd></ad>"
						iurl = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + filename
						if req_details["web_response_type"].(string) == "html" {
							rand1 := djextrafunc.RandToken(5)
							adm = clickTag_start + `<img src='` + djconstants.ReviveProtocol + djconstants.SQLDelivery + filename + `&contenttype=` + lastValue + `' width='` + strconv.Itoa(width) + `' height='` + strconv.Itoa(height) + `' alt='' title='' border='0'>` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />` + ImgTagRevive + `<img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`

							iurl = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + filename
						}
					}
					bid = &openrtb.Bid{
						ID:         djextrafunc.RandToken(8),
						ImpID:      imp.ID,
						Price:      revenue_flt,
						AdID:       ad_id,
						NURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						BURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						LURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}",
						IURL:       iurl,
						AdMarkup:   adm,
						CampaignID: cid,
						CreativeID: ad_id,
						AdvDomain:  adomain,
						DealID:     deal_id,
						W:          width,
						H:          height,
						Ext:        json.RawMessage(bidext),
					}
					fmt.Printf("response %+v", bid)
					if req_details["dsp_name"].(string) == djconstants.RubiconSspName {
						bid.NURL = ""
						bid.LURL = ""
						bid.BURL = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE}"
						bid.Ext = json.RawMessage("")
					}
					bidArr = append(bidArr, bid)
					seatbid.Bid = bidArr
					seatbid.Seat = seat
				}
			}
			if imp.Video != nil {
				var bid *openrtb.Bid
				if imp.Pmp != nil {
					pvt = imp.Pmp.Private
					dls = imp.Pmp.Deals
				}
				vidChannel := make(chan []djgetad.GetAd)
				go djvideoad.GetVideoads25(vidChannel, imp.Video, imp.BidFloor, req_details, pvt, dls, redisClient)
				videoads = <-vidChannel
				// req_ad_id := videoads[0].Ad_id
				// Request_Stats(request_Id, req_details["dsp_id"].(int), req_ad_id)

				tarChannel := make(chan []djgetad.GetAd)
				go djtarget.Targeting(tarChannel, req, videoads, req_details["cookie"].(string), req_details["dsp_id"].(int))
				videoads = <-tarChannel

				sourceChannel := make(chan []djgetad.GetAd)
				go djsource.GetSourceObj(sourceChannel, req.Source, videoads, req_details)
				videoads = <-sourceChannel
				if len(imp.Metric) > 0 {
					metricChannel := make(chan []djgetad.GetAd)
					go djmetric.CheckMetricCriteria(metricChannel, imp.Metric, videoads, redisClient)
					videoads = <-metricChannel
				}

				if len(videoads) > 0 {
					var adIndex int
					if syncAdid != 0 && syncCampaignid != 0 {
						for k, v := range videoads {
							if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
								adIndex = k
							}
						}
					}
					if req.AuctionType == 1 {
						revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].Revenue, 64)
					} else {
						if videoads[adIndex].SecondRevenue.String != "" {
							revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].SecondRevenue.String, 64) + 0.01
						} else {
							revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].Revenue, 64)
						}
					}
					cid = strconv.Itoa(videoads[adIndex].Placement_id)
					ad_id = strconv.Itoa(videoads[adIndex].Ad_id)
					agency_id = videoads[adIndex].Agencyid
					client_id = videoads[adIndex].Clientid
					campaignid = videoads[adIndex].Placement_id
					url = videoads[adIndex].Url
					filename = videoads[adIndex].Filename
					seat = strings.Replace(videoads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(videoads[adIndex].Clientid)
					deal_id = videoads[adIndex].Deal_id
					bidext, err := json.Marshal(openrtb.BidExt{Btype: videoads[adIndex].Revenue_type})
					if err != nil {
						djlogger.Log.Println("Error ", err.Error())
					}

					vAdm, vAttr := djvideoad.GetVastXML(videoads[adIndex], imp.Video, req_details, resID, cookieid, redisClient, request_Id, revenue_flt, imp.BidFloor, pvt, dls)

					if vAttr == 1 {
						attr = []int{16}
					}
					bid = &openrtb.Bid{
						ID:         djextrafunc.RandToken(8),
						ImpID:      imp.ID,
						Price:      revenue_flt,
						AdID:       ad_id,
						NURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						BURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						LURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}",
						AdMarkup:   vAdm,
						CampaignID: cid,
						CreativeID: ad_id,
						AdvDomain:  adomain,
						Attr:       attr,
						DealID:     deal_id,
						W:          width,
						H:          height,
						Ext:        json.RawMessage(bidext),
					}

					if req_details["dsp_name"].(string) == djconstants.RubiconSspName {
						bid.LURL = ""
						bid.BURL = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE}"
						bid.Ext = json.RawMessage("")
					}
					bidArr = append(bidArr, bid)
					seatbid.Bid = bidArr
					seatbid.Seat = seat
				}
			}
			if imp.Audio != nil {
				var bid *openrtb.Bid
				if imp.Pmp != nil {
					pvt = imp.Pmp.Private
					dls = imp.Pmp.Deals
				}
				audChannel := make(chan []djgetad.GetAd)
				go djaudioad.GetAudioads25(audChannel, imp.Audio, req_details, pvt, dls)
				audioads = <-audChannel

				// req_ad_id := audioads[0].Ad_id
				// Request_Stats(request_Id, req_details["dsp_id"].(int), req_ad_id)

				tarChannel := make(chan []djgetad.GetAd)
				go djtarget.Targeting(tarChannel, req, audioads, req_details["cookie"].(string), req_details["dsp_id"].(int))
				audioads = <-tarChannel

				sourceChannel := make(chan []djgetad.GetAd)
				go djsource.GetSourceObj(sourceChannel, req.Source, audioads, req_details)
				audioads = <-sourceChannel
				if len(imp.Metric) > 0 {
					metricChannel := make(chan []djgetad.GetAd)
					go djmetric.CheckMetricCriteria(metricChannel, imp.Metric, audioads, redisClient)
					audioads = <-metricChannel
				}
				if len(audioads) > 0 {
					var adIndex int
					if syncAdid != 0 && syncCampaignid != 0 {
						for k, v := range audioads {
							if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
								adIndex = k
							}
						}
					}
					if req.AuctionType == 1 {
						revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].Revenue, 64)
					} else {
						if audioads[adIndex].SecondRevenue.String != "" {
							revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].SecondRevenue.String, 64) + 0.01
						} else {
							revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].Revenue, 64)
						}
					}
					cid = strconv.Itoa(audioads[adIndex].Placement_id)
					ad_id = strconv.Itoa(audioads[adIndex].Ad_id)
					agency_id = audioads[adIndex].Agencyid
					client_id = audioads[adIndex].Clientid
					campaignid = audioads[adIndex].Placement_id
					url = audioads[adIndex].Url
					filename = audioads[adIndex].Filename
					seat = strings.Replace(audioads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(audioads[adIndex].Clientid)
					deal_id = audioads[adIndex].Deal_id
					bidext, err := json.Marshal(openrtb.BidExt{Btype: audioads[adIndex].Revenue_type})
					if err != nil {
						djlogger.Log.Println("Error ", err.Error())
					}
					aAdm, aAttr := djaudioad.GetVastXML(audioads[adIndex], 0.00, imp.Audio, req_details, resID, cookieid, redisClient, request_Id, revenue_flt)

					if aAttr == 1 {
						attr = []int{16}
					}
					bid = &openrtb.Bid{
						ID:         djextrafunc.RandToken(8),
						ImpID:      imp.ID,
						Price:      revenue_flt,
						AdID:       ad_id,
						NURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						BURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						LURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}",
						AdMarkup:   aAdm,
						CampaignID: cid,
						CreativeID: ad_id,
						AdvDomain:  adomain,
						Attr:       attr,
						DealID:     deal_id,
						W:          width,
						H:          height,
						Ext:        json.RawMessage(bidext),
					}
					if req_details["dsp_name"].(string) == djconstants.RubiconSspName {
						bid.NURL = ""
						bid.LURL = ""
						bid.BURL = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE}"
						bid.Ext = json.RawMessage("")
					}
					bidArr = append(bidArr, bid)
					seatbid.Bid = bidArr
					seatbid.Seat = seat
				}
			}
			if imp.Native != nil {
				if imp.Native.Request != nil || imp.Native.RequestObj != nil {
					var (
						//natVideoad *openrtb.Video
						bid       *openrtb.Bid
						nassetArr []openrtb.Assetval
						img       string
					)
					nativeMap := make(map[string]interface{})
					if imp.Pmp != nil {
						pvt = imp.Pmp.Private
						dls = imp.Pmp.Deals
					}
					for _, nativefmt := range imp.Native.Request.Asset {
						if nativefmt.Title != nil {
							nativeMap["titleLen"] = nativefmt.Title.Len
						}

						if nativefmt.Img != nil {
							nativeMap["imgType"] = nativefmt.Img.Type
							nativeMap["imgW"] = nativefmt.Img.W
							nativeMap["imgH"] = nativefmt.Img.H
							nativeMap["imgWmin"] = nativefmt.Img.Wmin
							nativeMap["imgHmin"] = nativefmt.Img.Hmin
							if nativefmt.Img.Mime != nil {
								nativeMap["imgMime"] = djextrafunc.ImageMimeType(nativefmt.Img.Mime)
							} else {
								nativeMap["imgMime"] = "jpg,gif,jpeg,png"
							}
						}

						//~ if nativefmt.Data != nil {
						//~ nativeMap["dataType"] = nativefmt.Data.Type
						//~ nativeMap["dataLen"] = nativefmt.Data.Len
						//~ }
						/* if nativefmt.Video != nil {
							natVideoad = nativefmt.Video
						} */
					}
					nativeChannel := make(chan []djgetad.GetAd)
					go djnativead.GetNativeads25(nativeChannel, imp.BidFloor, nativeMap, req_details, pvt, dls)
					nativeads = <-nativeChannel

					// req_ad_id := nativeads[0].Ad_id
					// Request_Stats(request_Id, req_details["dsp_id"].(int), req_ad_id)

					tarChannel := make(chan []djgetad.GetAd)
					go djtarget.Targeting(tarChannel, req, nativeads, req_details["cookie"].(string), req_details["dsp_id"].(int))
					nativeads = <-tarChannel
					sourceChannel := make(chan []djgetad.GetAd)
					go djsource.GetSourceObj(sourceChannel, req.Source, nativeads, req_details)
					nativeads = <-sourceChannel
					//~ if len(imp.Metric) > 0 {
					//~ metricChannel := make(chan []djgetad.GetAd)
					//~ go djmetric.CheckMetricCriteria(metricChannel, nil, imp.Metric, nativeads, redisClient)
					//~ nativeads = <-metricChannel
					//~ }
					if len(nativeads) > 0 {
						var adIndex int
						if syncAdid != 0 && syncCampaignid != 0 {
							for k, v := range nativeads {
								if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
									adIndex = k
								}
							}
						}
						if req.AuctionType == 1 {
							revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].Revenue, 64)
						} else {
							if nativeads[adIndex].SecondRevenue.String != "" {
								revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].SecondRevenue.String, 64) + 0.01
							} else {
								revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].Revenue, 64)
							}
						}
						cid = strconv.Itoa(nativeads[adIndex].Placement_id)
						ad_id = strconv.Itoa(nativeads[adIndex].Ad_id)
						agency_id = nativeads[adIndex].Agencyid
						client_id = nativeads[adIndex].Clientid
						campaignid = nativeads[adIndex].Placement_id
						agencyid = strconv.Itoa(nativeads[adIndex].Agencyid)
						clientid = strconv.Itoa(nativeads[adIndex].Clientid)
						filename = nativeads[adIndex].Filename
						width = nativeads[adIndex].Width
						height = nativeads[adIndex].Height
						titleText = nativeads[adIndex].Title
						dataObject = nativeads[adIndex].Data_objects
						url = nativeads[adIndex].Url
						seat = strings.Replace(nativeads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(nativeads[adIndex].Clientid)
						var imgLogo string
						if nativeads[adIndex].Icon_image != "" {
							imgLogo = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + nativeads[adIndex].Icon_image
						}
						img = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + nativeads[adIndex].Filename

						deal_id = nativeads[adIndex].Deal_id
						/* vidChannel := make(chan []djgetad.GetAd)
						go djvideoad.GetVideoads25(vidChannel, natVideoad, req_details, pvt, dls)
						videoads = <-vidChannel */
						bidext, err := json.Marshal(openrtb.BidExt{Btype: nativeads[0].Revenue_type})
						if err != nil {
							djlogger.Log.Println("Error ", err.Error())
						}
						clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + ad_id + "&zoneid=0&oadest=" + url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + cid + "&agencyid=" + agencyid + "&clientid=" + clientid + "&bidder_id=" + fmt.Sprint(req_details["dsp_id"]) + "&request_id=" + request_Id
						impurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + ad_id + "&campaignid=" + cid + "&agencyid=" + agencyid + "&clientid=" + clientid + "&zoneid=0&bidid=" + resID + "&bidder_id=" + fmt.Sprint(req_details["dsp_id"]) + "&request_id=" + request_Id + "&price=" + fmt.Sprint(revenue_flt)
						rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?v={ad_network_id}&cookieid=" + cookieid

						for _, nativefmt := range imp.Native.Request.Asset {
							var na openrtb.Assetval
							if nativefmt.Title != nil {
								na = openrtb.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Title: &openrtb.TitleRes{
										Text: titleText,
									},
								}
								nassetArr = append(nassetArr, na)
							}

							if nativefmt.Img != nil {
								if nativefmt.Img.Type == 1 {
									na = openrtb.Assetval{
										Id:       nativefmt.Id,
										Required: nativefmt.Req,
										Img: &openrtb.Imgres{
											Url: imgLogo,
										},
									}
								} else {
									na = openrtb.Assetval{
										Id:       nativefmt.Id,
										Required: nativefmt.Req,
										Img: &openrtb.Imgres{
											Url: img,
											W:   width,
											H:   height,
										},
									}
								}

								nassetArr = append(nassetArr, na)
							}

							if nativefmt.Data != nil {
								na = openrtb.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Data: &openrtb.Datares{
										Value: dataObject[nativefmt.Data.Type],
									},
								}
								nassetArr = append(nassetArr, na)
								fmt.Printf("na %+v\n", na)
							}
							/* if nativefmt.Video != nil {
								na = openrtb.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Video: &openrtb.VideoRes{
										Vasttag: djvideoad.GetVastXML(videoads[0], nil, natVideoad, req_details, "", ""),
									},
								}
								nassetArr = append(nassetArr, na)
							} */
						}
						natres := &openrtb.Admobject{
							&openrtb.Nativeres{
								Asset: nassetArr,
								Link: &openrtb.Link{
									Url: clickurl,
								},
								Imptrackers: []string{impurl, rubiconDmpurl, req_details["dmp_pixel"].(string)},
							},
						}
						nataiveAd, err := json.Marshal(natres)
						if err != nil {
							djlogger.Log.Println("Error ", err.Error())
						}
						bid = &openrtb.Bid{
							ID:         djextrafunc.RandToken(8),
							ImpID:      imp.ID,
							Price:      revenue_flt,
							AdID:       ad_id,
							NURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
							BURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
							LURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}",
							AdMarkup:   string(nataiveAd),
							CampaignID: cid,
							CreativeID: ad_id,
							AdvDomain:  adomain,
							DealID:     deal_id,
							W:          width,
							H:          height,
							Ext:        json.RawMessage(bidext),
						}
						fmt.Printf("response %+v", bid)
						if req_details["dsp_name"].(string) == djconstants.RubiconSspName {
							bid.NURL = ""
							bid.LURL = ""
							bid.BURL = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE}"
							bid.AdMarkup = ""
							bid.Admobject = natres
							bid.Ext = json.RawMessage("")
						}
						bidArr = append(bidArr, bid)
						seatbid.Bid = bidArr
						seatbid.Seat = seat

					}
				}
			}
			seatbidArr = append(seatbidArr, seatbid)
			ad_idd, _ := strconv.Atoi(ad_id)
			AD_ID = ad_idd
			agencyId = agency_id
			clientId = client_id
			campaignId = campaignid
		}
		_, err := json.Marshal(openrtb.MainExt{PixelURL: req_details["dmp_pixel"].(string)})
		if err != nil {
			djlogger.Log.Println("Error ", err.Error())
		}
		if len(seatbidArr) != 0 && len(seatbidArr[0].Bid) != 0 {
			output["id"] = resID
			output["bidid"] = resID
			output["cur"] = "USD"
			output["seatbid"] = seatbidArr
		} else {
			output["id"] = resID
			output["nbr"] = 0
			output["seatbid"] = seatbidArr
		}
		if req_details["dsp_name"].(string) != djconstants.RubiconSspName {
			// output["ext"] = json.RawMessage(mainext)
		}
	} else {
		output["id"] = resID
		output["nbr"] = 2
		output["seatbid"] = seatbidArr
	}
	channel <- output
	djlogger.Log.Println(output)
	seatBool := false
	for _, v := range seatbidArr {
		if v.Bid != nil {
			seatBool = true
			break
		}
	}
	if seatBool != false {
		Response_Stats(request_Id, req_details["dsp_id"].(int), AD_ID, agencyId, clientId, campaignId)
		// fmt.Printf("request %+v", req)
		// fmt.Println("Response", seatbidArr)
		// fmt.Printf("response %s", seatbidArr)
		// insertResponse := djmongo.MongoSaveResponse25(resID, objid, req_details["dsp_id"].(int), AD_ID, reqData, output)
		// if insertResponse != true {
		// 	djlogger.Log.Println("Response not inserted in Mongodb")
		// }
	}
}

func Response_Stats(request_id string, dsp_id int, ad_id int, agency_id int, client_id int, campaignid int) {
	djclickclient.Track_response(request_id, uint16(dsp_id), uint16(ad_id), uint16(agency_id), uint16(client_id), uint16(campaignid), 1)
}
