
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>HTML5 demo with localStorage and saving images and files in it</title>
        <link rel="stylesheet" href="base.css" type="text/css" media="screen">
    </head>

    <body>

        <div class="container">

            <header class="header" role="banner">
                <h1>HTML5 demo with localStorage and saving images and files in it</h1>
            </header>

            <div class="main">
                <article class="main-content" role="main">

                    <aside class="additional-content" aria-live="polite" aria-relevant="additions" aria-atomic="true">
                        <p>This is a demo page displaying how you can use localStorage to save image files in it as Data URLs. The first time you load this page the picture of the elephant is saved in localStorage, and for following page loads the same date, it uses the image stored in localStorage.</p>
                        <p>The second image of the rhino is read through an XMLHttpRequest as an ArrayBuffer, put into a Blob and then read out as a Data URL through a FileReader object.</p>
                        <p>In the <a href="/base.js">base.js</a> file you can see the code to achieve this.</p>
                        <p>All the <a href="https://github.com/robnyman/robnyman.github.com">code is available at GitHub</a>, for this page and other related demos.
                        </p>
                    </aside>

                    <h2>An elephant, with localStorage</h2>

                    <figure>
                        <img id="elephant" src="about:blank" alt="A close up of an elephant">
                        <noscript>
                            <p><i>You need to have JavaScript enabled to save images in localStorage.</i></p>
                            <img src="elephant.png" alt="">
                        </noscript>    
                        <figcaption>A mighty big elephant, and mighty close too!</figcaption>
                    </figure>

                    
                    <h2>Rhino with XMLHttpRequest and reading file data</h2>
                    <figure>
                        <img id="rhino" src="about:blank" alt="A close up of a rhino">
                        <figcaption>Rhinos are big!</figcaption>
                    </figure>

                </article>
            </div>

            <footer class="page-footer" role="contentinfo">
                Created by <a href="http://robertnyman.com/">Robert Nyman</a><br>
                <a href="https://github.com/robnyman/robnyman.github.com">All demo code at GitHub</a>.
            </footer>

        </div>

        <script src="base.js"></script>

    </body>
</html>
