! function(e) {
    "use strict";
    e.closest = e.closest || function(css) {
        for (var node = this; node;) {
            if (node.matches(css)) return node;
            node = node.parentElement
        }
        return null
    }
}(Element.prototype),
function(window, document, undefined) {
    "use strict";
    var cssEvents = function() {
        var endEventNames = {
                WebkitTransition: ["webkitTransitionEnd", "webkitAnimationEnd"],
                MozTransition: ["transitionend", "animationend"],
                OTransition: ["oTransitionEnd", "oAnimationEnd"],
                transition: ["transitionend", "animationend"]
            },
            el = document.createElement("acost");
        for (var name in endEventNames)
            if (el.style[name] !== undefined) return endEventNames[name];
        return ["transitionend", "animationend"]
    }();
    Element.prototype.daTransitionEnd = function(callback) {
        var internalCb = function(event) {
            callback.call(this, event), this.removeEventListener(cssEvents[0], internalCb)
        };
        this.addEventListener(cssEvents[0], internalCb)
    }, Element.prototype.daAnimationEnd = function(callback) {
        var internalCb = function(event) {
            callback.call(this, event), this.removeEventListener(cssEvents[1], internalCb)
        };
        this.addEventListener(cssEvents[1], internalCb)
    }
}(window, document, void 0),
function(window, undefined) {
    "use strict";
    Element.prototype.daAppear = function(cb) {
        var element = this,
            rect = element.getBoundingClientRect();
        if (window.innerHeight - rect.top > 0 && rect.bottom > 0) return void cb.call(this);
        var daCb = function(event) {
            var rect = element.getBoundingClientRect();
            window.innerHeight - rect.top > 0 && rect.bottom > 0 && (window.removeEventListener("scroll", daCb), window.removeEventListener("resize", daCb), cb.call(this, event))
        };
        window.addEventListener("scroll", daCb), window.addEventListener("resize", daCb)
    }
}(window);
var directAdsUISettings = {    
    assetsURI: "http://"+window.location.hostname+"/template/ui-assets",
    clickEvent: "ontouchstart" in document.documentElement ? "touchstart" : "click",
    banners: {
        desktop: {
            "728x90": {
                x: 320,
                y: 0,
                width: 460,
                height: 60,
                href: "http://directads.com"
            },
            "160x600": {
                x: 0,
                y: 80,
                width: 140,
                height: 420
            },
            "120x600": {
                x: 680,
                y: 80,
                width: 100,
                height: 420
            },
            "300x250": {
                x: 400,
                y: 280,
                width: 260,
                height: 220
            }
        },
        mobile: {
            "320x50": {
                x: 31,
                y: 305,
                width: 159,
                height: 30,
                href: "http://mobile.com"
            }
        },
        defaultSizes: {
            direct: [780, 500],
            imac: [637, 483],
            mobile: [218, 401]
        }
    }
};
! function(window, document, settings, undefined) {
    "use strict";

    function AcostUISelect(node) {
        var instance = this;
        AcostUISelect.currentInstance = this, instance.node = node, instance.init = function() {
            instance.replacer = document.createElement("div"), instance.replacer.className = "aui-select", instance.replacerId = instance.replacer.id = "aui-select-" + (instance.node.id || Math.round(1e3 * Math.random())), instance.responder = document.createElement("div"), instance.responder.className = "aui-select-responder placeholder", instance.responder.addEventListener("click", instance.toggleResponder), instance.responderIcon = document.createElement("i"), instance.responderText = document.createElement("span"), instance.responder.appendChild(instance.responderIcon), instance.responder.appendChild(instance.responderText), instance.node.addEventListener("change", instance.updateResponder), instance.replacer.appendChild(instance.responder), AcostUISelect.list === undefined && (AcostUISelect.list = document.createElement("ul"), AcostUISelect.list.id = "aui-select-list", AcostUISelect.list.addEventListener("click", instance.optionClick), document.body.appendChild(AcostUISelect.list), window.addEventListener("resize", function() {
                AcostUISelect.list.classList.remove("open")
            })), instance.updateList(), instance.node.dataset.placeholder !== undefined ? (instance.responderText.innerHTML = instance.node.dataset.placeholder, instance.node.dataset.icon !== undefined && (instance.responderIcon.className = instance.node.dataset.icon)) : (instance.responderText.innerHTML = instance.node.options[0].label, instance.node.options[0].dataset.icon !== undefined && (instance.responderIcon.className = instance.node.options[0].dataset.icon)), instance.node.parentNode.insertBefore(instance.replacer, instance.node), instance.replacer.appendChild(instance.node), instance.node.className = "sr-only"//instance.node.style.display = "none" - DAC120
        }, this.updateList = function() {
            if (AcostUISelect.list.replacerId !== instance.replacerId) {
                AcostUISelect.list.innerHTML = "";
                for (var i = 0; i < instance.node.options.length; i++) {
                    var li = document.createElement("li"),
                        liText = document.createElement("span"),
                        liIcon = document.createElement("i");
                    liText.innerHTML = instance.node.options[i].label, li.dataset.index = i, instance.node.options[i].dataset.icon !== undefined && (li.classList.add("with-icon"), liIcon.className = instance.node.options[i].dataset.icon), instance.node.options[i].hasAttribute("active-item") && li.classList.add("active-item"), li.appendChild(liIcon), li.appendChild(liText), AcostUISelect.list.appendChild(li)
                }
                AcostUISelect.list.replacerId = instance.replacerId
            }
        }, instance.toggleResponder = function(evt) {
            if (AcostUISelect.currentInstance = instance, evt !== undefined && (evt.stopPropagation(), evt.preventDefault()), instance.replacer.classList.toggle("open"), instance.updateList(), instance.replacer.classList.contains("open")) {
                var rect = AcostUISelect.currentInstance.responder.getBoundingClientRect();
                AcostUISelect.list.style.left = rect.left + "px", AcostUISelect.list.style.top = rect.top + rect.height + (window.pageYOffset || document.documentElement.scrollTop) - (document.documentElement.clientTop || 0) + "px", AcostUISelect.list.style.width = AcostUISelect.currentInstance.responder.offsetWidth + "px"
            }
            AcostUISelect.list.classList.toggle("open"), window[(instance.replacer.classList.contains("open") === !0 ? "add" : "remove") + "EventListener"]("click", instance.clickOutside)
        }, this.updateResponder = function() {
            var selectedItem = AcostUISelect.currentInstance.node.options[AcostUISelect.currentInstance.node.selectedIndex];
            console.log(selectedItem, AcostUISelect.currentInstance.node.selectedIndex), AcostUISelect.currentInstance.responderText.innerHTML = selectedItem.label, selectedItem.dataset.icon ? (AcostUISelect.currentInstance.responderIcon.className = selectedItem.dataset.icon, AcostUISelect.currentInstance.responder.classList.add("with-icon")) : (AcostUISelect.currentInstance.responder.classList.remove("with-icon"), AcostUISelect.currentInstance.responderIcon.removeAttribute("class"))
        }, this.optionClick = function(event) {
            var li = event.target.closest("li");
            if (null !== li) {
                var index = parseInt(li.dataset.index);
                console.log(AcostUISelect.currentInstance), AcostUISelect.currentInstance.node.selectedIndex = index, AcostUISelect.currentInstance.node.options[index].selected = !0, AcostUISelect.currentInstance.node.value = AcostUISelect.currentInstance.node.options[index].value, AcostUISelect.currentInstance.node.dispatchEvent(new CustomEvent("change"));
                var activeItem = AcostUISelect.list.querySelector(".active-item");
                null !== activeItem && activeItem.classList.remove("active-item"), li.classList.add("active-item"), instance.toggleResponder(), instance.responder.classList.remove("placeholder")
            }
        }, this.clickOutside = function(event) {
            null === event.target.closest("#aui-select-list") && instance.toggleResponder()
        }, this.init(instance.node)
    }
    window.AcostUISelect = AcostUISelect, window.addEventListener("DOMContentLoaded", function() {
        for (var elements = document.getElementsByTagName("select"), i = 0; i < elements.length; i++)
        { 
			var last_segment = window.location.href.split("/");
			if(last_segment['3'] != 'direct_demo')
			{
				var selectclass_name = elements[i].className;
				var index_count = selectclass_name.indexOf("search_select");
				var cl_name = selectclass_name.indexOf("empty_select");
				if(index_count < 0 && cl_name < 0)
				{
					new AcostUISelect(elements[i])
				}
			}
		}
    })
}(window, document, directAdsUISettings),
function(window, settings, undefined) {
    "use strict";
    window.addEventListener("DOMContentLoaded", function() {
        for (var checkboxes = document.getElementsByClassName("acost-checkbox-container"), callback = function(box, input) {
                box.classList.toggle("checked"), input !== undefined && (input.checked = box.classList.contains("checked"), box.classList.contains("checked") ? input.setAttribute("checked", "checked") : input.removeAttribute("checked"))
            }, i = 0; i < checkboxes.length; i++) {
            var container = checkboxes[i];
            container.addEventListener(settings.clickEvent, function() {
                callback(container.getElementsByClassName("acost-checkbox")[0], container.getElementsByTagName("input")[0])
            })
        }
    })
}(window, directAdsUISettings),
function(window, document, settings) {
    "use strict";

    function AcostModal(modalConfig) {
        var instance = this;
        this.init = function() {
            if (void 0 === AcostModal.container) {
                AcostModal.container = document.createElement("div"), AcostModal.container.className = "modal-container modal-container-bg", AcostModal.container.addEventListener(settings.clickEvent, this.clickOutside), document.body.appendChild(AcostModal.container);
                var baseXhr = new XMLHttpRequest;
                baseXhr.onload = function() {
                    instance.baseLoaded(baseXhr)
                }, baseXhr.open("POST", settings.assetsURI + "/modal.html"), baseXhr.send(null)
            } else this.fill()
        }, this.clickOutside = function(evt) {
            var isClickedOutslide = function(classes) {
                for (var i = 0; i < classes.length; i++)
                    if (evt.target.classList.contains(classes[i])) return !0;
                return !1
            }(["modal", "modal-container", "modal-close"]);
            isClickedOutslide === !0 && (evt.preventDefault(), instance.hide())
        }, this.pressEsc = function(evt) {
            27 === evt.keyCode && (evt.preventDefault(), instance.hide())
        }, this.fill = function() {
            switch (AcostModal.title.innerHTML = modalConfig.title, typeof modalConfig.content) {
                case "string":
                    AcostModal.content.innerHTML = modalConfig.content, this.loaded();
                    break;
                case "object":
                    AcostModal.content.innerHTML = "", AcostModal.content.appendChild(modalConfig.content), this.loaded();
                    break;
                case "undefined":
                    AcostModal.container.dataset.uri === modalConfig.url ? instance.show() : (this.load(modalConfig.url), AcostModal.container.dataset.uri = modalConfig.url)
            }
        }, this.loaded = function() {
            void 0 !== modalConfig.onLoad && modalConfig.onLoad.call(this), instance.show()
        }, this.baseLoaded = function(xhr) {
            200 === xhr.status && (AcostModal.container.innerHTML = xhr.responseText, AcostModal.title = AcostModal.container.querySelector(".modal-content > header"), AcostModal.content = AcostModal.container.querySelector(".modal-content > section"), instance.fill())
        }, this.contentLoaded = function(xhr) {
            200 === xhr.status && (AcostModal.content.innerHTML = xhr.responseText, this.loaded())
        }, this.load = function(url) {
            var contentXhr = new XMLHttpRequest;
            contentXhr.onload = function() {
                instance.contentLoaded(contentXhr)
            }, contentXhr.open("POST", url), contentXhr.send(null)
        }, this.show = function() {
            AcostModal.container.classList.add("visible"), document.body.style.overflow = "hidden", window.addEventListener("keyup", this.pressEsc), void 0 !== modalConfig.onShow && modalConfig.onShow.call(instance)
        }, this.hide = function() {
            AcostModal.container.daAnimationEnd(function() {
                this.classList.remove("visible"), this.classList.remove("out"), document.body.style.removeProperty("overflow")
            }), AcostModal.container.classList.add("out"), window.removeEventListener("keyup", this.pressEsc), void 0 !== modalConfig.onHide && modalConfig.onHide.call(instance)
        }, this.init()
    }
    window.AcostModal = AcostModal
}(window, document, directAdsUISettings),
function(window, document, settings, undefined) {
    "use strict";
    var banners = {
        process: function(node) {
            var mode = node.dataset.mode,
                type = node.dataset.type;
            if (banners.coords[mode] !== undefined && settings.banners[type] !== undefined) {
                var positions = settings.banners[type],
                    links = {};
                for (var p in positions) positions.hasOwnProperty(p) && (links[p] = document.createElement("a"), links[p].id = "banner-" + type + "-" + p, links[p].href = positions[p].href || "#", node.appendChild(links[p]));
                banners.links[type] = links, banners.modes[type] = mode, banners.nodes[type] = node, banners.types.push(type)
            }
        },
        update: function(type) {
            var defaultSize = settings.banners.defaultSizes[banners.modes[type]][0],
                changedSize = banners.nodes[type].offsetWidth,
                ratio = changedSize / defaultSize;
            console.log(defaultSize, changedSize, ratio);
            var positions = settings.banners[type],
                links = banners.links[type],
                mode = banners.modes[type];
            for (var p in positions)
                if (positions.hasOwnProperty(p)) {
                    var coords = banners.coords[mode](positions[p], ratio);
                    links[p].style.top = coords.y + "px", links[p].style.left = coords.x + "px", links[p].style.width = coords.width + "px", links[p].style.height = coords.height + "px"
                }
        },
        coords: {
            direct: function(coords, ratio) {
                var newCoords = {};
                for (var coord in coords) coords.hasOwnProperty(coord) && (newCoords[coord] = coords[coord] * ratio);
                return newCoords
            },
            imac: function(coords, ratio) {
                var newCoords = {};
                for (var coord in coords) coords.hasOwnProperty(coord) && (newCoords[coord] = coords[coord] * ratio * .6166);
                return newCoords.x += 75, newCoords.y += 23, newCoords
            },
            mobile: function(coords) {
                return coords
            }
        },
        links: {},
        nodes: {},
        modes: {},
        types: []
    };
    window.addEventListener("DOMContentLoaded", function() {
        for (var containers = document.getElementsByClassName("banners-example"), i = 0; i < containers.length; i++) banners.process(containers[i]);
        window.addEventListener("resize", function() {
            console.log("Resized");
            for (var i = 0; i < banners.types.length; i++) banners.update(banners.types[i])
        })
    })
}(window, document, directAdsUISettings),
function(window, document, settings, undefined) {
    "use strict";

    function DirectAdsCommon() {
        var overlay = null,
            header = null,
            navbar = null,
            topmenu = null,
            instance = this;
        this.fitHeaderOverlay = function() {
            if (0 !== overlay.length) {
                for (var height = Math.round(.15 * window.innerWidth), i = 0; i < overlay.length; i++) overlay[i].style.height = height + "px";
                for (i = 0; i < header.length; i++) header[i].style.paddingBottom = height + 30 + "px"
            }
        }, this.navbarResize = function() {
            window.innerWidth > 991 && navbar.style.height !== undefined && navbar.style.removeProperty("height")
        }, this.navbarScroll = function() {
            if (!(window.innerWidth < 992)) {
                var scrollTop = function() {
                    var doc = document.documentElement;
                    return (window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0)
                }();
                topmenu.classList[scrollTop > 40 ? "add" : "remove"]("scrolling")
            }
        }, this.toggleNavbar = function() {
            var aboutToExpand = "false" === this.getAttribute("aria-expanded");
            navbar.setAttribute("aria-expanded", aboutToExpand ? "true" : "false"), this.setAttribute("aria-expanded", aboutToExpand ? "true" : "false"), this.classList.toggle("collapsed"), aboutToExpand ? (navbar.classList.remove("collapsed"), navbar.classList.add("collapse"), navbar.classList.add("in"), navbar.dataset.realHeight === undefined ? (navbar.dataset.realHeight = navbar.offsetHeight, navbar.style.height = "0px", navbar.classList.add("da-animate-navbar"), setTimeout(function() {
                navbar.style.height = navbar.dataset.realHeight + "px"
            }, 0)) : navbar.style.height = navbar.dataset.realHeight + "px") : (navbar.classList.add("collapsed"), navbar.classList.remove("collapse"), navbar.classList.remove("in"), navbar.style.height = "0px")
        }, this.ready = function() {
            overlay = document.getElementsByClassName("da-landing-header-overlay"), header = document.getElementsByClassName("da-landing-header"), navbar = document.getElementById("da-landing-navbar"), topmenu = document.getElementsByClassName("da-landing-topmenu")[0], document.getElementById("da-navbar-toggle").addEventListener("ontouchstart" in document.documentElement ? "touchstart" : "click", this.toggleNavbar), window.dispatchEvent(new CustomEvent("resize"));
            var loginButton = document.querySelector("#da-landing-navbar a.login");
            null !== loginButton && loginButton.addEventListener("click", this.openLoginModal), topmenu !== undefined && topmenu.classList.contains("navbar-fixed-top") && window.addEventListener("scroll", instance.navbarScroll)
        }, this.openLoginModal = function(event) {
            event.preventDefault(), this.loginModal === undefined ? this.loginModal = new AcostModal({
                title: "Log In",
                url: settings.assetsURI + "/modal-login.html",
                onLoad: function() {
                    AcostModal.container.getElementsByClassName("login-selector")[0].addEventListener(settings.clickEvent, instance.loginModeSelector)
                },
                onShow: function() {
                    document.getElementsByName("username")[0].focus()
                }
            }) : this.loginModal.show()
        }, this.loginModeSelector = function(event) {
            if ("span" === event.target.tagName.toLowerCase() && !event.target.classList.contains("active")) {
                var parent = event.target.parentNode;
                parent.getElementsByClassName("active")[0].classList.remove("active"), event.target.classList.add("active"), parent.getElementsByTagName("input")[0].value = event.target.dataset.value
            }
        }, this.authPageSwitcher = function() {
            if (!this.classList.contains("active")) {
                for (var loginModeLabels = document.querySelectorAll("#login-mode-label > span"), siblings = this.parentNode.children, i = 0; i < siblings.length; i++) "span" === siblings[i].tagName.toLowerCase() && siblings[i].classList.toggle("active");
                this.parentNode.getElementsByTagName("input")[0].value = this.dataset.value, loginModeLabels.length > 0 && (loginModeLabels[0].classList.toggle("hidden"), loginModeLabels[1].classList.toggle("hidden"));
                var registerForm = document.getElementById("register-form");
                null !== registerForm && (registerForm.children[0].classList.toggle("hidden"), registerForm.children[1].classList.toggle("hidden"))
            }
        }, this.fadeInSequence = function(node) {
            var sections = node.getElementsByClassName("fadein"),
                currentSection = 0;
            if (0 !== sections.length) {
                var appearCb = function() {
                    sections[currentSection] !== undefined && (sections[currentSection].daTransitionEnd(appearCb), sections[currentSection].classList.add("faded-in")), currentSection++
                };
                node.daAppear(appearCb)
            }
        }
    }
    var common = new DirectAdsCommon;
    window.addEventListener("DOMContentLoaded", function() {
        common.ready();
        for (var fadeIns = document.getElementsByClassName("fadein-sequence"), i = 0; i < fadeIns.length; i++) common.fadeInSequence(fadeIns[i]);
        var loginModeSwitcher = document.querySelectorAll(".login-mode-switcher > span");
        if (loginModeSwitcher.length > 0)
            for (i = 0; i < loginModeSwitcher.length; i++) loginModeSwitcher[i].addEventListener(settings.clickEvent, common.authPageSwitcher)
    }), window.addEventListener("resize", function() {
        common.fitHeaderOverlay(), common.navbarResize()
    })
}(window, document, directAdsUISettings),
function(window, document, undefined) {
    "use strict";

    function DirectAdsCounter(node) {
        var endValue = parseInt(node.innerHTML),
            usePlus = endValue.toString().length !== node.innerHTML.length,
            instance = this,
            startTime = 0;
        node.innerHTML = "0" + (usePlus ? "+" : ""), this.setValue = function(n) {
            node.innerHTML = n + (usePlus ? "+" : "")
        }, this.getValue = function() {
            return parseInt(node.innerHTML)
        }, this.animate = function() {
            startTime = (new Date).getTime(), window.requestAnimationFrame(instance._step)
        }, this.easing = function(t, b, c, d) {
            return Math.ceil(c * t / d + b)
        }, this._step = function() {
            var easingResult = instance.easing((new Date).getTime() - startTime, Math.floor(.15 * endValue), instance.getValue(), countTime);
            instance.setValue(Math.min(easingResult, endValue)), instance.getValue() < endValue && window.requestAnimationFrame(instance._step)
        }
    }
    if (window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame, window.requestAnimationFrame !== undefined) {
        var countTime = 700;
        window.addEventListener("DOMContentLoaded", function() {
            var nodes = document.getElementsByClassName("da-landing-counter"),
                counters = [];
            if (0 !== nodes.length) {
                for (var i = 0; i < nodes.length; i++) counters.push(new DirectAdsCounter(nodes[i]));
                document.getElementsByClassName("da-landing-index-counters")[0].daAppear(function() {
                    for (var i = 0; i < counters.length; i++) counters[i].animate()
                })
            }
        })
    }
}(window, document),
function(window, document) {
    "use strict";

    function DirectAdsIndex() {
        var topColumns = null;
        this.equalizeTopColumns = function() {
            for (var height = 0, i = 0; i < topColumns.length; i++) topColumns[i].style.removeProperty("height");
            if (!(window.innerWidth < 992)) {
                for (i = 0; i < topColumns.length; i++) topColumns[i].offsetHeight > height && (height = topColumns[i].offsetHeight);
                for (i = 0; i < topColumns.length; i++) topColumns[i].style.height = height + "px"
            }
        }, this.resize = function() {
            null !== topColumns && 0 !== topColumns.length && this.equalizeTopColumns()
        }, this.ready = function() {
            topColumns = document.getElementsByClassName("da-landing-top-offset"), window.dispatchEvent(new CustomEvent("resize"))
        }
    }
    var index = new DirectAdsIndex;
    window.addEventListener("DOMContentLoaded", function() {
        index.ready()
    }), window.addEventListener("resize", function() {
        index.resize()
    })
}(window, document);
//# sourceMappingURL=../../sourcemaps/landing.js.map
