var german = ["DE", "BE", "AT", "CH", "LU", "LI"];
var french = ["DZ", "FR", "BE", "LU", "MA"];
var latin = ["MX", "ES", "BR", "AR", "CL", "CO", "PE", "DO", "VE", "CR", "EC", "PA", "SV", "NI", "PY"];
var english = ["US", "CA", "GB", "AU", "IE", "NZ", "PR", "ZA"];
var arabic = ["DZ", "BH", "EG", "IQ", "IL", "PS", "JO", "KW", "LB", "LY", "MR", "MA", "OM", "QA", "SA", "SD", "SY", "TN", "AE", "YE"];
var chinese = ["CN", "SG", "HK", "MO", "TW", "MY", "ZA"];
var data;
var options;
var chart;
var countryMultiSelect;

function initCountries() {
    data = google.visualization.arrayToDataTable([
        ['Country']
    ]);
    options = {
        'width': 650,
        'height': 450,
        'backgroundColor': 'transparent',
        'defaultColor': '#AEB6BF',//2c2e4c
        'datalessRegionColor': '#555676',
        'allowHtml': true
    };
    chart = new google.visualization.GeoChart(document.getElementById('chart_div'));
    chart.draw(data, options);
    google.visualization.events.addListener(chart, 'select', function(e) {
        var selectedItem = chart.getSelection()[0];
        if (selectedItem) {
            var curCountry = data.getFormattedValue(selectedItem.row, 0);
            data.removeRow(selectedItem.row);
            chart.draw(data, options);
            var res = countryMultiSelect.value().slice();
            $.each(res, function(key, value) {
                if (value == curCountry) {
                    res.splice(key, 1);
                }
            });
            setAlphaCountry(curCountry, false);
            countryMultiSelect.dataSource.filter({});
            countryMultiSelect.value(res)
            //getCPM();
            setCountryGroups();
            setTargetedCountries(res);
        }
    });
    google.visualization.events.addListener(chart, 'regionClick', function(e) {
        var numRows = data.getNumberOfRows();
        var exists = data.getFilteredRows([{
            column: 0,
            value: e.region
        }]);
        if (exists.length < 1) {
            data.addRows(1);
            data.setCell(numRows, 0, e.region);
            chart.draw(data, options);
            var res = countryMultiSelect.value().slice();
            res.push(e.region);
            countryMultiSelect.dataSource.filter({});
            countryMultiSelect.value(res)
            setAlphaCountry(e.region, true);
            //getCPM();
            setCountryGroups();
            setTargetedCountries(res);show_cities('include');
        }
    });
    $(function() {
        countryMultiSelect = $("#targ_geo_include").kendoMultiSelect({
            tagTemplate: $("#scriptTemplate").html(),
            dataTextField: "Name",
            dataValueField: "Id",
            placeholder: 'Type country name'
        }).data("kendoMultiSelect");
        countryMultiSelect.bind("change", function(e) {
            var numRows = data.getNumberOfRows();
            var newCountries = e.sender.value();
            var newNumRows = newCountries.length;
            data.removeRows(0, numRows);
            data.addRows(newNumRows);
            $('.alphaItem').removeClass('active1');
            $.each(newCountries, function(key, value) {
                data.setCell(key, 0, value);
                setAlphaCountry(value, true);
            });show_cities('include');
            chart.draw(data, options);
            setCountryGroups();
            setTargetedCountries(newCountries);
        });
        var temp = $("#targ_geo_include").val();
        if(temp == null)
        {
			temp = edit_country_data;
		}
        countryMultiSelect.value(temp);
        countryMultiSelect.trigger("change");
    });
    setCountryGroups();
    $('#premadeCountryGroups li').on('click', function(e) {
        var newCountries = $('#targ_geo_include').val();
        if (newCountries == null) {
            newCountries = new Array();
        }
        if ($(this).hasClass('active1')) {
            $(this).removeClass('active1');
            var rmCountries = eval($(this).attr('id'));
            newCountries = arraySubtract(newCountries, rmCountries);
        } else {
            $(this).addClass('active1');
            $('#premadeCountryGroups li').each(function(i) {
                if ($(this).attr('id') == 'english' && $(this).hasClass('active1')) {
                    newCountries = $.merge(newCountries, english);
                } else if ($(this).attr('id') == 'french' && $(this).hasClass('active1')) {
                    newCountries = $.merge(newCountries, french);
                } else if ($(this).attr('id') == 'latin' && $(this).hasClass('active1')) {
                    newCountries = $.merge(newCountries, latin);
                } else if ($(this).attr('id') == 'german' && $(this).hasClass('active1')) {
                    newCountries = $.merge(newCountries, german);
                } else if ($(this).attr('id') == 'arabic' && $(this).hasClass('active1')) {
                    newCountries = $.merge(newCountries, arabic);
                } else if ($(this).attr('id') == 'chinese' && $(this).hasClass('active1')) {
                    newCountries = $.merge(newCountries, chinese);
                }
            });
        }
        newCountries = removeArrayDuplicates(newCountries);
        countryMultiSelect.dataSource.filter({});
        $('#targ_geo_include').val(newCountries);
        countryMultiSelect.value(newCountries);
        countryMultiSelect.trigger('change');
        //getCPM();
    });
    $('.alphabetOptions a').on('click', function(e) {
        var letter = $(this).html();
        $('.alphabetOptions a').removeClass('active1');
        $(this).addClass('active1');
        if (letter == 'All') {
            $('.alphaItem, .alphaLetterTitle').show();
        } else {
            $('.alphaItem, .alphaLetterTitle').hide();
            $('div[letter=' + letter + ']').show();
        }
    });
    $('#alphaOptions li').on('click', function(e) {
        var type = $(this).attr('type');
        $('#alphaOptions li').removeClass('active1');
        $(this).addClass('active1');
        if (type == 'world') {
            $('.alphaItem, .alphaLetterTitle').show();
        } else {
            $('.alphaItem, .alphaLetterTitle').hide();
            $('div[' + type + '=true]').show();
        }
    });
    $('.alphaItem').on('click', function(e) {
        var type = $(this).attr('type');
        var curCountry = $(this).attr('code');
        if ($(this).hasClass('active1')) {
            $(this).removeClass('active1');
            var res = countryMultiSelect.value().slice();
            $.each(res, function(key, value) {
                if (value == curCountry) {
                    res.splice(key, 1);
                }
            });
            countryMultiSelect.dataSource.filter({});
            countryMultiSelect.value(res);
        } else {
            $(this).addClass('active1');
            var newCountries = $('#targ_geo_include').val();
            if (newCountries == null) {
                newCountries = new Array();
            }
            newCountries.push(curCountry);
            newCountries = removeArrayDuplicates(newCountries);
            countryMultiSelect.dataSource.filter({});
            //$('#targ_geo_include').val(newCountries);
            countryMultiSelect.value(newCountries);
        }
        countryMultiSelect.trigger('change');
        //getCPM();
        setCountryGroups();
    });
    $('#targ_geo_include').on('change', function(e) {
        //getCPM();
    });
    $('#countrySelectionType').on('click', function(e) {
        if ($('#countrySelectionTypeDD').css('display') == 'none') {
            $('#countrySelectionTypeDD').show();
        } else {
            $('#countrySelectionTypeDD').hide();
        }
    });
    $('#countrySelectionTypeDD .selectedOption').on('click', function(e) {
        $('.checkYes').remove();
        $('#currentSelectionType').val($(this).attr('data-type'));
        if ($(this).attr('data-type') == 'included') {
            $('.currentSelectionType').html('Included');
            $('.selectedOption[data-type="included"]').prepend('<img src="'+base_url+'template/flat/img/images/check_yes.png" class="checkYes" alt="" />');
        } else {
            $('.currentSelectionType').html('Excluded');
            $('.selectedOption[data-type="excluded"]').prepend('<img src="'+base_url+'template/flat/img/images/check_yes.png" class="checkYes" alt="" />');
        }
    });
    if (countrySelectionType == 'included') {
        $('.currentSelectionType').html('Included');
        $('.selectedOption[data-type="included"]').prepend('<img src="'+base_url+'template/flat/img/images/check_yes.png" class="checkYes" alt="" />');
    } else {
        $('.currentSelectionType').html('Excluded');
        $('.selectedOption[data-type="excluded"]').prepend('<img src="'+base_url+'template/flat/img/images/check_yes.png" class="checkYes" alt="" />');
    }
}

function setTargetedCountries(newCountries) {
    var countryString = newCountries.join(', ');
    if ($('#campaignsettings .countries').length > 0) {
        if (countryString == '') {
            $('#campaignsettings .countries').html('All Countries');
        } else {
            $('#campaignsettings .countries').html(countryString);
        }
    }
}

function toggleTab(el) {
    if ($(el).attr('id') == 'mapTab') {
        $('#alphaTab').removeClass('active1');
        //$('.mapContainer').css('width', '73%');
        $('#countryTargetOptions').show();
        $('#mapTab').removeClass('active1').addClass('active1');
        $('#alphaContents').hide();
        $('#mapContents').show();
    } else {
        $('#mapTab').removeClass('active1');
        //$('.mapContainer').css('width', '100%');
        $('#countryTargetOptions').hide();
        $('#alphaTab').removeClass('active1').addClass('active1');
        $('#alphaContents').show();
        $('#mapContents').hide();
    }
}

function setAlphaCountry(code, add) {
    if (add) {
        $('.alphaItem[code="' + code + '"]').addClass('active1');
    } else {
        $('.alphaItem[code="' + code + '"]').removeClass('active1');
    }
}

function setCountryGroups(vals) {
	if(vals == null)
	{	
		var curCountries = $('#targ_geo_include').val();
	}
	else
	{
	var all_countries = ["AD","AE","AF","AG","AI","AL","AM","AO","AP","AQ","AR","AS","AT","AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BQ","BR","BS","BT","BV","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","EU","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL","GM","GN","GP","GQ","GR","GS","GT","GU","GW","GY","HK","HM","HN","HR","HT","HU","ID","IE","IL","IM","IN","IO","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PN","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","SS","ST","SV","SX","SY","SZ","TC","TD","TF","TG","TH","TJ","TK","TL","TM","TN","TO","TR","TT","TV","TW","TZ","UA","UG","UM","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","YE","YT","ZA","ZM","ZW","A1","A2","O1"];	

		$.each(all_countries, function(index, value) {
			if ($.inArray(value, vals) < 0) {
				$('.alphaItem[code="'+value+'"]').removeClass('active1');
			}

		});		
		var curCountries = vals;
		
	}	
    var match = true;
    $.each(english, function(index, value) {
        if ($.inArray(value, curCountries) < 0) {
            match = false;
        }
    });
    if (match) {
        $('#english').addClass('active1');
    } else {
        $('#english').removeClass('active1');
    }
    var match = true;
    $.each(french, function(index, value) {
        if ($.inArray(value, curCountries) < 0) {
            match = false;
        }
    });
    if (match) {
        $('#french').addClass('active1');
    } else {
        $('#french').removeClass('active1');
    }
    var match = true;
    $.each(german, function(index, value) {
        if ($.inArray(value, curCountries) < 0) {
            match = false;
        }
    });
    if (match) {
        $('#german').addClass('active1');
    } else {
        $('#german').removeClass('active1');
    }
    var match = true;
    $.each(latin, function(index, value) {
        if ($.inArray(value, curCountries) < 0) {
            match = false;
        }
    });
    if (match) {
        $('#latin').addClass('active1');
    } else {
        $('#latin').removeClass('active1');
    }
    var match = true;
    $.each(arabic, function(index, value) {
        if ($.inArray(value, curCountries) < 0) {
            match = false;
        }
    });
    if (match) {
        $('#arabic').addClass('active1');
    } else {
        $('#arabic').removeClass('active1');
    }
    var match = true;
    $.each(chinese, function(index, value) {
        if ($.inArray(value, curCountries) < 0) {
            match = false;
        }
    });
    if (match) {
        $('#chinese').addClass('active1');
    } else {
        $('#chinese').removeClass('active1');
    }
}

function removeArrayDuplicates(inputArray) {
    var i;
    var len = inputArray.length;
    var outputArray = [];
    var temp = {};
    for (i = 0; i < len; i++) {
        temp[inputArray[i]] = 0;
    }
    for (i in temp) {
        outputArray.push(i);
    }
    return outputArray;
}
function clear_map_region(val){

$('#chinese').removeClass('active1');
$('#arabic').removeClass('active1');
$('#latin').removeClass('active1');
$('#german').removeClass('active1');
$('#french').removeClass('active1');
$('#english').removeClass('active1');
$('.alphaItem').removeClass('active1');
$('#alphaOptions li').removeClass('active1');
    data = google.visualization.arrayToDataTable([
        ['Country']
    ]);
    options = {
        'width': 650,
        'height': 450,
        'backgroundColor': 'transparent',
        'defaultColor': '#2c2e4c',      
        'datalessRegionColor': '#555676',  
        'allowHtml': true
    };
    chart = new google.visualization.GeoChart(document.getElementById('chart_div'));
    chart.draw(data, options);
    countryMultiSelect.value('');

    google.visualization.events.addListener(chart, 'select', function(e) {
        var selectedItem = chart.getSelection()[0];
        if (selectedItem) {
            var curCountry = data.getFormattedValue(selectedItem.row, 0);
            data.removeRow(selectedItem.row);
            chart.draw(data, options);
            var res = countryMultiSelect.value().slice();
            $.each(res, function(key, value) {
                if (value == curCountry) {
                    res.splice(key, 1);
                }
            });
            setAlphaCountry(curCountry, false);
            countryMultiSelect.dataSource.filter({});
            countryMultiSelect.value(res)
            //getCPM();
            setCountryGroups();
            setTargetedCountries(res);
        }
    });
        
    google.visualization.events.addListener(chart, 'regionClick', function(e) {
        var numRows = data.getNumberOfRows();
        var exists = data.getFilteredRows([{
            column: 0,
            value: e.region
        }]);
        if (exists.length < 1) {
            data.addRows(1);
            data.setCell(numRows, 0, e.region);
            chart.draw(data, options);
            var res = countryMultiSelect.value().slice();
            res.push(e.region);
            countryMultiSelect.dataSource.filter({});
            countryMultiSelect.value(res)
            setAlphaCountry(e.region, true);
            //getCPM();
            setCountryGroups();
            setTargetedCountries(res);show_cities('include');
        }
    });     
document.getElementById('include_clear').style.display='none';
}
function show_map_region(vals)
{	
	var countries = new Array();
	var i=1;
	$('select#targ_geo_include').find('option').each(function() {
	if(i==1)
	{
		countries =   $(this).val();
		i++;
	}
	else
	{
		countries =  countries + ',' + $(this).val();
		i++;
	}
	});	
	if(countries!='')
	{  
		document.getElementById('include_clear').style.display='block';
	}	
    else
	{  
		document.getElementById('include_clear').style.display='none';
	}	  	
    $('#chinese').addClass('active1');
    $('#arabic').addClass('active1');
    $('#latin').addClass('active1');
    $('#german').addClass('active1');
    $('#french').addClass('active1');
    $('#english').addClass('active1');
    $('.alphaItem').addClass('active1');


    data = google.visualization.arrayToDataTable([
        ['AD']
    ]);
    options = {
        'width': 650,
        'height': 450,
        'backgroundColor': 'transparent',
        'defaultColor': '#2c2e4c',  
        'datalessRegionColor': '#555676',      
        'allowHtml': true
    };
    if(vals != null)
    {
		newCountries = vals;
		setCountryGroups(newCountries);
		//$('.alphaItem1[code="RU"]').removeClass('active1');
	}
	else
	{    
	newCountries = ["AD","AE","AF","AG","AI","AL","AM","AO","AP","AQ","AR","AS","AT","AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BQ","BR","BS","BT","BV","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","EU","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL","GM","GN","GP","GQ","GR","GS","GT","GU","GW","GY","HK","HM","HN","HR","HT","HU","ID","IE","IL","IM","IN","IO","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PN","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","SS","ST","SV","SX","SY","SZ","TC","TD","TF","TG","TH","TJ","TK","TL","TM","TN","TO","TR","TT","TV","TW","TZ","UA","UG","UM","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","YE","YT","ZA","ZM","ZW","A1","A2","O1"];
	}
	var newNumRows = newCountries.length;

	data.addRows(newNumRows);	
	$.each(newCountries, function(key, value) {
		data.setCell(key, 0, value);
		
	});
	chart.draw(data, options);       
	countryMultiSelect.value(newCountries);show_cities('include');
    
    google.visualization.events.addListener(chart, 'select', function(e) {
        var selectedItem = chart.getSelection()[0];
        if (selectedItem) {
            var curCountry = data.getFormattedValue(selectedItem.row, 0);
            data.removeRow(selectedItem.row);
            chart.draw(data, options);
            var res = countryMultiSelect.value().slice();
            $.each(res, function(key, value) {
                if (value == curCountry) {
                    res.splice(key, 1);
                }
            });
            setAlphaCountry(curCountry, false);
            countryMultiSelect.dataSource.filter({});
            countryMultiSelect.value(res)
            //getCPM();
            setCountryGroups();
            setTargetedCountries(res);
        }
    });    
   
    google.visualization.events.addListener(chart, 'regionClick', function(e) {
        var numRows = data.getNumberOfRows();
        var exists = data.getFilteredRows([{
            column: 0,
            value: e.region
        }]);
        if (exists.length < 1) {
            data.addRows(1);
            data.setCell(numRows, 0, e.region);
            chart.draw(data, options);
            var res = countryMultiSelect.value().slice();
            res.push(e.region);
            countryMultiSelect.dataSource.filter({});
            countryMultiSelect.value(res)
            setAlphaCountry(e.region, true);
            //getCPM();
            setCountryGroups();
            setTargetedCountries(res);show_cities('include');
        }
    });    





}
