var validation = {
	// Helping functions
	wrap: function($element) {
		if(!$element.parent().hasClass('validate-wrapper')) {
			$element.wrap('<div class="validate-wrapper"></div>');
		}
	},

	// Call default parameters
	defaults: function() {
		$.validator.setDefaults({
			errorElement: 'div',
			errorClass: 'validate-error-in',
			errorPlacement: function(error, element) {
				validation.wrap( $(element) );

				$(element).parent().removeClass('validate-success').addClass('validate-error').append(error);
			},
			success: function(error, element) {
				validation.wrap( $(element) );

				$(element).parent().removeClass('validate-error').addClass('validate-success').find('div.validate-error-in').remove();
			}
		});
	},

	// FORMS
	// Don't forget to initialize them in 'init.ready' object below!
	registration: function() {
		$('#registration').validate({
			rules: {
				email: {
					email: true,
					required: true
				},
				username: {
					required: true
				},
				password: {
					required: true
				},
				password1: {
					equalTo: "#password"
				}
			},
//			messages: {
//				fio: {
//					cyrillic: 'Используйте только русские буквы.'
//				}
//			}
		});
	}
};