var all = {
	menuToggler: {
		init: function() {
			$('#header-menu-toggler').on('click', function(e) {
				e.preventDefault();

				$('.header-right').toggleClass('is-visible');
			});
		}
	},
	loginToggler: {
		init: function() {
			$('#login-button').on('click', function(e) {
				e.preventDefault();
				$('.login-form').toggleClass('is-visible');
			});

			all.loginToggler.documentClick();
		},
		documentClick: function() {
			$(document).on('click', function(e) {
				var $container = $('.header-login');

				if (!$container.is(e.target) && $container.has(e.target).length === 0) {
					$('.login-form').removeClass('is-visible');
				}
			});
		}
	},
	homeSlider: {
		init: function() {
			var $homeSlider = $('#home-slider');
			$homeSlider.owlCarousel({
				items: 1,
				margin: 30,
				mouseDrag: false,
				nav: true
			});

			$(window).on('keydown', function(e) {
				if(e.keyCode === 37) {
					$homeSlider.trigger('prev.owl.carousel');
					$homeSlider.find('.owl-prev').addClass('is-active');
				}
				if(e.keyCode === 39) {
					$homeSlider.trigger('next.owl.carousel');
					$homeSlider.find('.owl-next').addClass('is-active');
				}
			}).on('keyup', function() {
				$homeSlider.find('.owl-prev, .owl-next').removeClass('is-active');
			});
		}
	},
	partners: {
		init: function() {
			var $partnersCarousel = $('#partners-carousel');
			$partnersCarousel.owlCarousel({
				autoWidth: true,
				center: true,
				loop: true,
				mouseDrag: false,
				responsive: {
					0: {
						margin: 10,
					},
					480: {
						margin: 20,
					},
					768: {
						margin: 40,
					}
				}
			});

			$('.partners-controls-left').find('a').on('click', function(e) {
				e.preventDefault();

				$partnersCarousel.trigger('prev.owl.carousel');
			});
			$('.partners-controls-right').find('a').on('click', function(e) {
				e.preventDefault();

				$partnersCarousel.trigger('next.owl.carousel');
			});
		}
	}
};