module.exports = function(grunt) {
	grunt.initConfig({
		pkg: grunt.file.readJSON('package.json'),
		sass: {
			options: {
				style: 'compressed',
				sourcemap: 'auto'
			},
			develop: {
				files: {
					'css/style.css': 'src/scss/style.scss'
				}
			}
		},
		postcss: {
			options: {
				processors: [
					require('autoprefixer-core')({
						browsers: ['last 10 version', 'Firefox ESR', 'Opera 12.1', 'ie 9']
					}).postcss
				]
			},
			dist: {
				src: 'css/*.css'
			}
		},
		concat: {
			options: {
				separator: ';'
			},
			dist: {
				src: [
					'src/js/vendor/*.js',
					'src/js/custom/custom.js',
					'src/js/custom/validation.js',
					'src/js/custom/init.js'
				],
				dest: 'js/main.js'
			}
		},
		uglify: {
			options: {
				banner: '/*! Vladislav Bezenson | <%= pkg.name %> | <%= grunt.template.today("dd.mm.yyyy") %> */\n'
			},
			dist: {
				files: {
					'<%= concat.dist.dest %>': ['<%= concat.dist.dest %>']
				}
			}
		},
		compress: {
			preview: {
				options: {
					archive: '<%= pkg.name %> <%= grunt.template.today("dd-mm-yyyy HH-MM") %> (preview).zip',
					mode: 'zip'
				},
				files: [{
					src: ['css/**/*.css', 'img/**', 'js/**', '*.html']
				}]
			},
			full: {
				options: {
					archive: '<%= pkg.name %> <%= grunt.template.today("dd-mm-yyyy HH-MM") %> (full sources).zip',
					mode: 'zip'
				},
				files: [{
					src: ['css/**', 'img/**', 'js/**', 'src/**', '*.html', '*.js', '*.json', '*.MD']
				}]
			}
		},
		watch: {
			js: {
				files: ['<%= concat.dist.src %>'],
				tasks: ['concat', 'uglify']
			},
			sass: {
				files: ['src/scss/**/*.scss'],
				tasks: ['sass']
			}
		}
	});

	grunt.loadNpmTasks('grunt-contrib-sass');
	grunt.loadNpmTasks('grunt-contrib-concat');
	grunt.loadNpmTasks('grunt-contrib-uglify');
	grunt.loadNpmTasks('grunt-contrib-compress');
	grunt.loadNpmTasks('grunt-postcss');
	grunt.loadNpmTasks('grunt-contrib-watch');

	grunt.registerTask('default', ['sass', 'postcss', 'concat', 'uglify', 'compress']);
	grunt.registerTask('build', ['sass', 'postcss', 'concat', 'uglify']);
};