	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];

	//Define default

	var input = document.getElementById("topbar_creative_edit"),formdata = false;
	//Bind the event to onchange of the url file
	if(creative_type=='web' || creative_type=='sql')
	{
		input.addEventListener("change",handleFileSelect , false);
	}
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#topbar_creative_edit_form" );


	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFileSelect(evt)
 	{
		//var selcted_creative_size=jQuery('#topbar_creative_size').val();
		var selcted_creative_size = "120x60";
		var creative_size_split = selcted_creative_size.split('x');
		var iab_max_width= parseInt(creative_size_split[0], 10); 
		var iab_max_height= parseInt(creative_size_split[1], 10);

		var form = jQuery( "#topbar_creative_edit_form" );

		var isvalid_creative=true;		//form check list

		
		var i = 0, len = this.files.length, img, reader, file;

		file = this.files[i];
		var file, img;

		//Check weather it's image
		if ((file = this.files[0]))
		{				
			//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
			if(jQuery('#tmp_topbar_creative').val()!='')
			{
				var tmp_topbar_creative_name=jQuery('#tmp_topbar_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_topbar_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
						console.log(data.response);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#topbar_creative_edit'));
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			
			jQuery('#tmp_topbar_creative').val('');//empty temporary feild value
	
		
			if (!!file.type.match(/image.*/))
			{
				//To fetch wight and heigh of the selected image using File API.
				var freader = new FileReader();	
				
				freader.onload = function(evt) //After programatically loding selcted image get inside the method
				{
					img = new Image();
					img.src = evt.target.result;
					
					img.onload = function() //After programatically loding selcted image get inside the method
					{

						//Fetch creative attribute
						var creative_size=file.size;
						var creative_type=file.type;
						var creative_width=parseInt(this.width,10);
						var creative_height=parseInt(this.height,10);

						//VALIDATE THE SELECTED IMAGE
							//IAB type check
							var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
							if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
							{
								jQuery( "#topbar_creative_edit_form" ).validate().showErrors({"topbar_creative_edit": "Creative file format should be jpeg, png, jpg or gif"});
								isvalid_creative=false;
								jQuery('#creative_edit_element1').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#topbar_creative_edit').val('');
								jQuery('#tmp_topbar_creative').val('');
							}
							//IAB size check
							else if (creative_size > iab_max_size )
							{
								jQuery( "#topbar_creative_edit_form" ).validate().showErrors({"topbar_creative_edit": "Creative file size should not exceeds "+iab_size_kb});
								isvalid_creative=false;
								jQuery('#creative_edit_element1').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#topbar_creative_edit').val('');
								jQuery('#tmp_topbar_creative').val('');
							}

							//IAB width check
							else if (creative_width != iab_max_width || creative_height != iab_max_height)
							{
								jQuery( "#topbar_creative_edit_form" ).validate().showErrors({"topbar_creative_edit": "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions"});
								isvalid_creative=false;
								jQuery('#creative_edit_element1').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#topbar_creative_edit').val('');
								jQuery('#tmp_topbar_creative').val('');
							}


							
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("api_key", api_key);
							formdata.append("creative", file);
						}
						
						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#topbar_creative_edit'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response.file_name);
										if(data.response != 'error')
										{
											jQuery('#tmp_topbar_creative').val(data.response.file_name);
											jQuery('#tmp_topbar_creative_content_type').val(data.response.image_type);
											jQuery('#tmp_topbar_creative_url').val(data.response.full_path);
											jQuery('#tmp_topbar_creative_size').val(creative_size/1024);
										}
										else
										{
											//window.location.replace(data.redirect);
											jQuery('#tmp_topbar_creative').val('');
											var validator = form.validate();
											validator.showErrors({input_name: data.msg});
										}
									}
								});
							}
						}
					}
				}
				freader.readAsDataURL(file);
			}
			else
			{
				jQuery('#topbar_creative_edit').val('');
				jQuery('#creative_edit_element1').removeClass('fileupload-exists').addClass('fileupload-new');
				jQuery( "#topbar_creative_edit_form" ).validate().showErrors({"topbar_creative_edit": "Creative must be an image "});
			}	
		}	
	}
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the topbar creative form
	 * */
	jQuery(function(){
		
		jQuery( "#edit_topbar_creative" ).unbind().bind('click',function(evt){	
			//alert("hi");

			if(jQuery("#topbar_creative_edit_form").valid()==true)
			{
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					async:false,
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							jQuery('#edit_topbar_creative').unbind('click');
							jQuery("#topbar_creative_edit_form").validate().resetForm();
							jQuery("#topbar_creative_edit_form").get(0).reset();

							//RELOAD DATATABLES			
							jQuery('.dataTable').dataTable(custom_opt).fnDraw();
							jQuery('.dataTables_filter input').attr("placeholder", "Search here...");
							jQuery(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
							});
							jQuery("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if(jQuery(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if(jQuery(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();
							//RELOAD DATATABLES			
							
							//Reset hidden feilds
							jQuery('#tmp_topbar_creative').val('');
							jQuery('#tmp_topbar_creative_content_type').val('');
							jQuery('#tmp_topbar_creative_url').val('');
							jQuery('#tmp_topbar_creative_size').val('');
							//jQuery('#topbar_creative_id').val('');
							
							jQuery('#storage_type').val('');
							
							//Switch modal box
							$('#modal_topbar_creative_edit').one('hidden.bs.modal', function (e) {
								jQuery('.modal-backdrop').remove();
								jQuery('#modal_topbar_creative_edit_success').modal('show');
							}).modal('hide');							
						}
						else
						{
							jQuery("#topbar_creative_edit_form").validate().showErrors(data.msg);
							//$(this).modal('hide');
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});


	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){

			evt.preventDefault();
			jQuery('#topbar_creative_edit').attr('src','');
			
			jQuery( "#topbar_creative_edit_form" ).validate().element(jQuery('#topbar_creative_edit'));
			
			if(jQuery('#tmp_topbar_creative').val() !='')
			{				
				var tmp_topbar_creative_name=jQuery('#tmp_topbar_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_topbar_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
					
						jQuery( "#topbar_creative_edit_form" ).validate().element(jQuery('#topbar_creative_edit'));
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			
			jQuery('#tmp_topbar_creative').val('');
			
		});
	});
	
	/* name: 		
	 * @param:		null
	 * 
	 * Retorr to old creative
	 * */

	jQuery(function(){
		jQuery( "#restore" ).click(function(evt){

	//		evt.preventDefault();
			if(jQuery('#old_creative_url').val() !='')
			{
				console.log("restored");
				jQuery( "#topbar_creative_edit_form" ).validate().element(jQuery('#topbar_creative_edit'));
					
				var old_creative=jQuery('#old_creative').val();
				var old_creative_content_type=jQuery('#old_creative_content_type').val();
				var old_creative_url=jQuery('#old_creative_url').val();
				var old_creative_size=jQuery('#old_creative_size').val();

				jQuery( "#localdbban" ).removeClass( "error" ).addClass( "success" );
				jQuery( "#creative_edit_element1" ).removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
				
				jQuery('#tmp_topbar_creative').val(old_creative);
				jQuery('#tmp_topbar_creative_content_type').val(old_creative_content_type);
				jQuery('#tmp_topbar_creative_url').val(old_creative_url);
				jQuery('#tmp_topbar_creative_size').val(old_creative_size);
				
				jQuery('#preview_image').html("<img src='"+old_creative_url+"'/>");
		
				//jQuery('#web_creative_edit').bind('click');
	//			var input = document.getElementById("web_creative_edit"),formdata = false;
	//			input.addEventListener("change",handleFileSelect , false);
			}
			
		});
	});
	
