
	/* name: 		
	 * @param:		null
	 *
	 * Submit the HTML creative form
	 * */
	jQuery(function(){
		var form = jQuery("#text_creative_edit_form");
		var validator = form.validate();
		jQuery( "#edit_text_creative" ).unbind().bind('click',function(evt){

		 if(form.valid()==true && Check_html_tags())
		  {
			  //jQuery( "#edit_text_creative" ).unbind('click');
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					async:false,
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							jQuery( "#edit_text_creative" ).unbind('click');							
							validator.resetForm();
							form.get(0).reset();
							
							
							refresh_existing_creative(jQuery('#_campaign_id').val());

							//Switch modal box
							$('#modal_text_creative_edit').one('hidden.bs.modal', function (e) {
								$('#modal_text_creative_edit_success').modal('show');
							}).modal('hide');
							
						}
						else
						{
							validator.showErrors(data.msg);
							$(this).modal('hide');
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}else{
				
				if(Check_html_tags())
				 {
					validator.showErrors({"text_content": "Sorry HTML Tags are restricted.Please enter a valid content"});	
				}
			}
		});
	});
	
	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			async:false,
			url : site_url+"/site/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id,api_key:api_key},
			
			success : function(data){
				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	
	/*Function to check whether html tags is available or not */	
	function Check_html_tags(){

		var form = jQuery("#text_creative_edit_form");
		var validator = form.validate();

		var reg =/<(.|\n)*?>/g; 

		if (reg.test($('#text_content').val()) == true) {

			//var ErrorText ='do not allow HTMLTAGS';
				validator.showErrors({"text_content": "Sorry HTML Tags are restricted.Please enter a valid content"});
				return false ;
			}
		return true ;

	}	
