	//When form ready
	jQuery(document).ready(function ()
	{
		 //REINITIATE VALIDATE CLASS FOR MODAL BOX
		if($('.form-validate').length > 0)
		{
			$('.form-validate').each(function(){
			var id = $(this).attr('id');
				$("#"+id).validate({
					errorElement:'span',
					errorClass: 'help-block error',
					errorPlacement:function(error, element){
					element.parents('.custom_error_class').append(error);
					},
					highlight: function(label) {
					$(label).closest('.control-group').removeClass('error success').addClass('error');
					},
					success: function(label) {
					label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
					}
				});
			});
		}

	});

	//Define default
	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});

	var form = jQuery( "#slider_creative_edit_form" );
	
	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];
	

	/* name: handleFileSelect
	* @param: type of image such as base, slider, horizontal, vertical,
	* 
	* Description:Handle base creative select, validate and process through ajax.
	* */

	function handleFileSelect(target,creative_type)
 	{
		var input_element = creative_type+'_creative';
		if(creative_type=='base_portrait')
		{
			var iab_max_width	= '320'; 
			var iab_max_height	= '50';
		}
		else if(creative_type=='base_tab1')
		{
			var iab_max_width	= '768'; 
			var iab_max_height	= '90';
		}
		else if(creative_type=='base_tab2')
		{
			var iab_max_width	= '1024'; 
			var iab_max_height	= '90';
		}
		else if(creative_type=='base_land')
		{
			var iab_max_width	= '480'; 
			var iab_max_height	= '50';
		}
		else if(creative_type=='horiz_add_1' || creative_type=='verti_add_1')
		{
			var iab_max_width	= '1280'; 
			var iab_max_height	= '1280';
		}
		else if(creative_type=='horiz_add_2' || creative_type=='verti_add_2')
		{
			var iab_max_width	= '1024'; 
			var iab_max_height	= '1024';
		}
		else if(creative_type=='horiz_add_3' || creative_type=='verti_add_3')
		{
			var iab_max_width	= '800'; 
			var iab_max_height	= '800';
		}
		else if(creative_type=='horiz_add_4' || creative_type=='verti_add_4' || creative_type=='content_add_3')
		{
			var iab_max_width	= '480'; 
			var iab_max_height	= '480';
		}
		else if(creative_type=='content_add_1')
		{
			var iab_max_width	= '768'; 
			var iab_max_height	= '768';
		}
		else if(creative_type=='content_add_2')
		{
			var iab_max_width	= '600'; 
			var iab_max_height	= '600';
		}
		else if(creative_type=='content_add_4')
		{
			var iab_max_width	= '320'; 
			var iab_max_height	= '320';
		}		

		var form = jQuery( "#slider_creative_edit_form" );
					
		var isvalid_creative=true;		//form check list	

		var file, img;

		//Check weather it's image
		if ((file = target.files[0]))
		{
			//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
			if(jQuery('#tmp_'+creative_type+'_creative').val()!=jQuery('#old_'+creative_type+'_creative').val())
			{
				if(jQuery('#tmp_'+creative_type+'_creative').val()!='')
				{
					var tmp_creative_name=jQuery('#tmp_'+creative_type+'_creative').val();
		
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/mobile_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_creative_name, api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);
			
							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#'+creative_type+'_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
			}
			jQuery('#tmp_'+creative_type+'_creative').val('');//empty temporary feild value
			
			if (!!file.type.match(/image.*/))
			{
				var freader = new FileReader();	
					
				freader.onload = function(evt) //After programatically loding selcted image get inside the method
				{
					img = new Image();
					img.src = evt.target.result;
					//To fetch wight and heigh of the selected image using File API.
					
					img.onload = function() //After programatically loding selcted image get inside the method
					{				
						//Fetch creative attribute
						var creative_size=file.size;
						var creative_type_check=file.type;
						var creative_width=parseInt(this.width,10);
						var creative_height=parseInt(this.height,10);
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type_check, iab_file_type);
						//VALIDATE THE SELECTED IMAGE
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							var errorMessage = "Creative file format should be jpeg, png, jpg or gif";
							var obj = new Object();
							obj[input_element] = errorMessage;
							validator.showErrors(obj);
						
							isvalid_creative=false;

							jQuery('#'+creative_type+'_element').removeClass('fileupload-exists').addClass('fileupload-new');

							jQuery('#'+creative_type+'_creative').val('');
							jQuery('#tmp_'+creative_type+'_creative').val('');
						}
						else if (creative_size > iab_max_size )
						{
							var validator = form.validate();
							var errorMessage = "Creative file size should not exceeds "+iab_size_kb;
							var obj = new Object();
							obj[input_element] = errorMessage;
							validator.showErrors(obj);

							isvalid_creative=false;
							
							jQuery('#'+creative_type+'_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#'+creative_type+'_creative').val('');
							jQuery('#tmp_'+creative_type+'_creative').val('');
						}
						else if (creative_width != iab_max_width || creative_height != iab_max_height)
						{
							var validator = form.validate();
							var errorMessage = "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions";
							var obj = new Object();
							obj[input_element] = errorMessage;
							validator.showErrors(obj);

							isvalid_creative=false;

							jQuery('#'+creative_type+'_element').removeClass('fileupload-exists').addClass('fileupload-new');

							jQuery('#'+creative_type+'_creative').val('');
							jQuery('#tmp_'+creative_type+'_creative').val('');
						}
						/*else if (creative_height != iab_max_height )
						{
							var validator = form.validate();
							var errorMessage = "creative height is not upto Iab standard.";
							var obj = new Object();
							obj[input_element] = errorMessage;
							validator.showErrors(obj);

							isvalid_creative=false;

							jQuery('#'+creative_type+'_element').removeClass('fileupload-exists').addClass('fileupload-new');

							jQuery('#'+creative_type+'_creative').val('');
							jQuery('#tmp_'+creative_type+'_creative').val('');
						}
						else
						{
						}*/
							
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#'+creative_type+'_creative'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/mobile_creative/creative_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#tmp_'+creative_type+'_creative').val(data.response.file_name);
											jQuery('#tmp_'+creative_type+'_creative_content_type').val(data.response.image_type);
											jQuery('#tmp_'+creative_type+'_creative_url').val(data.response.full_path);
										}
										else
										{
											//window.location.replace(data.redirect);
											var validator = form.validate();
											validator.showErrors(data.msg);
											//jQuery('#tmp_interstitial_creative').val('');
										}
									}
								});
							}
						}
					}
				}
				freader.readAsDataURL(file);
			}
			else
			{
				jQuery('#'+creative_type+'_creative').val('');
				jQuery("#"+creative_type+"_element").removeClass('fileupload-exists').addClass('fileupload-new');

				var validator = form.validate();
				var errorMessage = "Creative must be an image";
				var obj = new Object();
				obj[input_element] = errorMessage;
				validator.showErrors(obj);
			}
		}
	}
	
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the mobile interstitial creative form
	 * */
	jQuery(function(){
		
		var validator = jQuery("#slider_creative_edit_form").validate();
		jQuery( "#upload_slider_creative" ).unbind().bind('click',function(evt){
															  
			if(jQuery("#slider_creative_edit_form").valid()==true)
			{				
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					async:false,
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
					
						if(data.response == 'ok')
						{
							jQuery('#upload_slider_creative').unbind('click');
														
							jQuery("#slider_creative_edit_form").validate().resetForm();
							form.get(0).reset();											
							//Reset base portrait creative hidden feilds
							jQuery('#tmp_base_portrait_creative').val('');
							jQuery('#tmp_base_portrait_creative_content_type').val('');
							jQuery('#tmp_base_portrait_creative_url').val('');
							
							//Reset tablet1 creative hidden feilds
							jQuery('#tmp_base_tab1_creative').val('');
							jQuery('#tmp_base_tab1_creative_content_type').val('');
							jQuery('#tmp_base_tab1_creative_url').val('');
							
							//Reset tablet2 creative hidden feilds
							jQuery('#tmp_base_tab2_creative').val('');
							jQuery('#tmp_base_tab2_creative_content_type').val('');
							jQuery('#tmp_base_tab2_creative_url').val('');
							
							//Reset base landscape creative hidden feilds
							jQuery('#tmp_base_land_creative').val('');
							jQuery('#tmp_base_land_creative_content_type').val('');
							jQuery('#tmp_base_land_creative_url').val('');
							
							//Reset swipe creative hidden feilds
							/*jQuery('#tmp_swipe_creative').val('');
							jQuery('#tmp_swipe_creative_content_type').val('');
							jQuery('#tmp_swipe_creative_url').val('');*/
							
							//Reset Horizontal 1 creative hidden feilds
							jQuery('#tmp_horiz_add_1_creative').val('');
							jQuery('#tmp_horiz_add_1_creative_content_type').val('');
							jQuery('#tmp_horiz_add_1_creative_url').val('');
							
							//Reset Horizontal 2 creative hidden feilds
							jQuery('#tmp_horiz_add_2_creative').val('');
							jQuery('#tmp_horiz_add_2_creative_content_type').val('');
							jQuery('#tmp_horiz_add_2_creative_url').val('');
							
							//Reset Horizontal 3 creative hidden feilds
							jQuery('#tmp_horiz_add_3_creative').val('');
							jQuery('#tmp_horiz_add_3_creative_content_type').val('');
							jQuery('#tmp_horiz_add_3_creative_url').val('');
							
							//Reset Horizontal 4 creative hidden feilds
							jQuery('#tmp_horiz_add_4_creative').val('');
							jQuery('#tmp_horiz_add_4_creative_content_type').val('');
							jQuery('#tmp_horiz_add_4_creative_url').val('');
							
							//Reset Vertical 1 creative hidden feilds
							jQuery('#tmp_verti_add_1_creative').val('');
							jQuery('#tmp_verti_add_1_creative_content_type').val('');
							jQuery('#tmp_verti_add_1_creative_url').val('');
							
							//Reset Vertical 2 creative hidden feilds
							jQuery('#tmp_verti_add_2_creative').val('');
							jQuery('#tmp_verti_add_2_creative_content_type').val('');
							jQuery('#tmp_verti_add_2_creative_url').val('');
							
							//Reset Vertical 3 creative hidden feilds
							jQuery('#tmp_verti_add_3_creative').val('');
							jQuery('#tmp_verti_add_3_creative_content_type').val('');
							jQuery('#tmp_verti_add_3_creative_url').val('');
							
							//Reset Vertical 4 creative hidden feilds
							jQuery('#tmp_verti_add_4_creative').val('');
							jQuery('#tmp_verti_add_4_creative_content_type').val('');
							jQuery('#tmp_verti_add_4_creative_url').val('');
							
							//Reset Content 1 creative hidden feilds
							jQuery('#tmp_content_add_1_creative').val('');
							jQuery('#tmp_content_add_1_creative_content_type').val('');
							jQuery('#tmp_content_add_1_creative_url').val('');
							
							//Reset Content 2 creative hidden feilds
							jQuery('#tmp_content_add_2_creative').val('');
							jQuery('#tmp_content_add_2_creative_content_type').val('');
							jQuery('#tmp_content_add_2_creative_url').val('');
							
							//Reset Content 3 creative hidden feilds
							jQuery('#tmp_content_add_3_creative').val('');
							jQuery('#tmp_content_add_3_creative_content_type').val('');
							jQuery('#tmp_content_add_3_creative_url').val('');
							
							//Reset Content 4 creative hidden feilds
							jQuery('#tmp_content_add_4_creative').val('');
							jQuery('#tmp_content_add_4_creative_content_type').val('');
							jQuery('#tmp_content_add_4_creative_url').val('');											
							
							//refresh the edit creatives
							refresh_existing_creative(jQuery('#_campaign_id').val());
							
							//Switch modal box
							$('#modal_slider_creative_edit').one('hidden.bs.modal', function (e) {
								jQuery('#modal_slider_creative_edit_success').modal('show');
							}).modal('hide');
							
						}
						else
						{
							validator.showErrors(data.msg);
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});

		/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			async:false,
			url : site_url+"/site/guest/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id,api_key:api_key},
			
			success : function(data){

				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	
	/* name: 		
	* @param:		null
	* 
	* Delete the base creative when remove button is clicked
	* */

	function remove(creative_type)
 	{
		var form = jQuery("#slider_creative_edit_form");
		form.validate().element(jQuery('#'+creative_type+'_creative'));

		if(jQuery('#tmp_'+creative_type+'_creative').val() !='')
		{
			var tmp_base_creative_name=jQuery('#tmp_'+creative_type+'_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/mobile_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_base_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#'+creative_type+'_creative'));
				}, 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
			
		jQuery('#tmp_'+creative_type+'_creative').val('');
	}
	
	/* name: 		
	* @param:		null
	* 
	* Retorr to old creative
	* */

	function restore(creative_type)
 	{
		remove(creative_type);
		if(jQuery('#old_'+creative_type+'_creative_url').val() !='')
		{
			jQuery( "#slider_creative_edit_form" ).validate().element(jQuery('#'+creative_type+'_creative'));
					
			var old_creative=jQuery('#old_'+creative_type+'_creative').val();
			var old_creative_content_type=jQuery('#old_'+creative_type+'_creative_content_type').val();
			var old_creative_url=jQuery('#old_'+creative_type+'_creative_url').val();

			jQuery( '#'+creative_type+'_group' ).removeClass( "error" ).addClass( "success" );
			jQuery( '#'+creative_type+'_element' ).removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
			
			jQuery('#tmp_'+creative_type+'_creative').val(old_creative);
			jQuery('#tmp_'+creative_type+'_creative_content_type').val(old_creative_content_type);
			jQuery('#tmp_'+creative_type+'_creative_url').val(old_creative_url);

			jQuery('#preview_'+creative_type).html("<img src='"+old_creative_url+"'/>");
		}
	}
