	//When form loads
	jQuery(document).ready(function (){
		
		// tag-input
		var blackcount = 0;
		$('#targ_blacklist').tagsInput({
			interactive:true,
			defaultText:"Add Zone IDs here, seperated by space",
			minChars:0,
			width:"520px",
			height:"80px",
			unique:true,
			placeholderColor: '#999',
			onAddTag: function(elem_tags)
			{
				var id	=	$(this).attr('id');					
						
				if(jQuery.isNumeric(elem_tags))
				{
					if(jQuery.inArray(elem_tags,JSON.parse(zonelist))!='-1')
					{
						$('#black_error').html('');
					}
					else
					{
						$(this).removeTag(escape(elem_tags));
						
						$('#black_error').html('Zone id does not exist '+elem_tags).css('color','#b94a48');			
					}
				}
				else
				{
					$(this).removeTag(escape(elem_tags));
					$('#black_error').html('Zone id must be number').css('color','#b94a48');					
				}
				//Maximum Count
				blackcount += $(this).length;
				if(blackcount > 500){
					$('#black_error').html('Tags exceeded maximum allowed zones').css('color','#b94a48');			
					$(this).removeTag(elem_tags);
				}			
			},
			onRemoveTag: function(){
				blackcount -= $(this).length;
			}
		});	
		
		var whitecount=0;
		$('#targ_whitelist').tagsInput({
			interactive:true,	
			defaultText:"Add Zone IDs here, seperated by space",			
			minChars:0,
			width:"520px",
			height:"80px",	
			unique:true,
			placeholderColor: '#999',
			onAddTag: function(elem_tags)
			{
				var id	=	$(this).attr('id');					
						
				if(jQuery.isNumeric(elem_tags))
				{
					if(jQuery.inArray(elem_tags,JSON.parse(zonelist))!='-1')
					{
						$('#white_error').html('');
					}
					else
					{
						$(this).removeTag(escape(elem_tags));
						
						$('#white_error').html('Zone id does not exist '+elem_tags).css('color','#b94a48');			
					}
				}
				else
				{
					$(this).removeTag(escape(elem_tags));
					$('#white_error').html('Zone id must be number').css('color','#b94a48');					
				}
				//Maximum Count
				whitecount += $(this).length;
				if(whitecount > 500){
					$('#black_error').html('Tags exceeded maximum allowed zones').css('color','#b94a48');			
					$(this).removeTag(elem_tags);
				}			
			},
			onRemoveTag: function(){
				whitecount -= $(this).length;
			}
		});
		
		var urlcount=0;
		
		$('#targ_url_keyword').tagsInput({
			interactive:true,	
			defaultText:"Add URL keywords here, seperated by space",
			minChars:0,
			width:"520px",
			height:"80px",
			unique:true,
			placeholderColor: '#999',
			onAddTag: function(elem_tags)
			{
				var id	=	$(this).attr('id');					
						
				if(jQuery.isNumeric(elem_tags))
				{
					$(this).removeTag(escape(elem_tags));
					
					$('#urlkey_error').html('Keyword must be alphabet characters').css('color','#b94a48');			
				}
				else
				{
					$('#urlkey_error').html('');					
				}
				
				//Maximum Count
				urlcount += $(this).length;
				if(urlcount > 500){
					$('#urlkey_error').html('Tags exceeded maximum allowed keywords').css('color','#b94a48');			
					$(this).removeTag(elem_tags);
				}			
			},
			onRemoveTag: function(){
				urlcount -= $(this).length;
			}	
		});
		
		//jQuery('#shedule_date_range').hide();
		jQuery('#start_end_range').daterangepicker({
			minDate: moment().startOf('day')
		});
		
		jQuery('#targ_date').daterangepicker({
			minDate: moment().startOf('day')
		});
				
		//Minimum Budget
		jQuery.validator.addMethod("minimum_campaign_budget",function(e,t){
			return  parseFloat(e)>= parseFloat(min_budget)
		},"Minimum budget is "+min_budget);
		
		//Minimum Bid Rate
		jQuery.validator.addMethod("minimum_bid_rate",function(e,t){
			if(parseFloat(e))
			{
				return  parseFloat(e)>= parseFloat(min_bid_rate)
			}
			else
			{
				return true;
			}
		},"Minimum Bid Rate is "+min_bid_rate);
			
		jQuery.validator.addMethod("valid_daily_budget",function(e,t){
			var campaign_budget=$("#campaign_budget").val();
			return  parseFloat(e)<= parseFloat(campaign_budget)
			},"Daily budget must be below campaign budget");
			
		jQuery.validator.addMethod("valid_bid_rate",function(e,t){
			var campaign_budget=$("#campaign_daily_budget").val();		
			return parseFloat(e)<= parseFloat(campaign_budget)
			},"Bid rate must be below daily budget");

		jQuery.validator.addMethod("valid_cpa_rate",function(e,t){
			var campaign_budget=$("#campaign_daily_budget").val();
			return parseFloat(e)<= parseFloat(campaign_budget)
			},"CPA rate must be below daily budget");

		 jQuery.validator.addMethod("valid_daily_bid_rate",function(e,t){
			var campaign_budget=$("#campaign_daily_budget").val();		
			return parseFloat(e)<= parseFloat(campaign_budget)
			},"Bid rate must be below daily budget");
			
			var camp_type= jQuery('#campaign_type').val();
		
			if(camp_type==3)
			{
				jQuery('#rev_cpa').show();
				jQuery('#rev_cpccpm').hide();
			}
			else
			{
				jQuery('#rev_cpccpm').show();
				jQuery('#rev_cpa').hide();
			}
			
			if($('#sources tbody tr').length==0)
			{
				$('#sources tbody').html('<tr id="nodata"><td colspan="4">No data is available.</td></tr>');
			}
			
			if($('#country_list tbody tr').length==0)
			{
				$('#country_list tbody').html('<tr id="nobiddata"><td colspan="5">No data is available.</td></tr>');
			}	
					
			//Targeting
			/*jQuery('.TABLE_WEB').removeClass('hide');
			jQuery('.TABLE_MOBILE').addClass('hide');
			jQuery('.TABLE_TABLET').addClass('hide');
			//jQuery('.TABLE_ALL').addClass('hide');
		
			//Creatives
			jQuery("#web_creative_anchor").removeClass('hide');
			jQuery("#mobile_creative_anchor").addClass('hide');
			jQuery("#tablet_creative_anchor").addClass('hide');
			jQuery("#all_creative_anchor").addClass('hide');*/
			
			// Retarget
			
			if(_flag==1)
			{
				enable_maxtime();
			}
			else
			{
				disable_maxtime();
			}
			
			if (jQuery('#retarget_yes').is(':checked'))
			{
				$("#targ_profile").data('rule-required',true);
			}
			else if (jQuery('#retarget_no').is(':checked'))
			{
				$("#targ_profile").data('rule-required',false);
			}
			else
			{
				$("#targ_profile").data('rule-required',false);
			}
			
			//Country Preset
			jQuery('#country_preset').hide();
			//OS Preset
			jQuery('#preset_os').hide();
			
			//No capping
			nocapping();
			
			//Black/white preset
			var targ_list	=	jQuery('input[name=targ_list]:checked').val();
			targlist(targ_list);
			
			//Country Include/Exclude
			var country_type	=	jQuery('input[name=country_type]:checked').val();
			country_targ_type(country_type);
			
			//Date preset
			
			if(jQuery('#targ_schedule').is(':checked'))
			{  
				jQuery('#date').show();
			}
			else
			{
				jQuery('#date').hide();
			}
			
			targeting_type(jQuery('#campaign_targeting_type').val());
			var cdate_range=jQuery('input[name=campaign_schedule]:checked').val();
			show_date_range(cdate_range);
			show_weekly(jQuery('input[name=weekly_distribute]:checked').val());
			
			traffic_editable();
			country_editable();
			jQuery('#advance_targeting').hide();	
			
			//Suggested CPM
			show_suggested_cpm();
	});
	
	function enable_maxtime(){ 
		jQuery('#retargetting_block').show();
		if(retargeting_max ==0){retargeting_max=1;}
		document.getElementById('retargetting_max_time').value=retargeting_max;
		document.getElementById('retargetting_max_time').disabled=false;
	}
	function disable_maxtime(){ 
		jQuery('#retargetting_block').hide();
		document.getElementById('retargetting_max_time').value='';
		document.getElementById('retargetting_max_time').disabled=true;
	}
	
	//Targeting
	function targeting_type(val)
	{	
		jQuery('#preset_os [id=targ_os_set_'+val+']').removeAttr('disabled');
		jQuery('#preset_os [id!=targ_os_set_'+val+']').attr('disabled','disabled');
		
		if(val=='WEB')
		{
			//Targeting
			jQuery('.TABLE_WEB').removeClass('hide');
			jQuery('.TABLE_MOBILE').addClass('hide');
			jQuery('.TABLE_TABLET').addClass('hide');
			
			//Creatives
			jQuery("#web_creative_anchor").removeClass('hide');
			jQuery("#mobile_creative_anchor").addClass('hide');
			jQuery("#tablet_creative_anchor").addClass('hide');
			jQuery("#all_creative_anchor").addClass('hide');
			jQuery('#preset_os [id=targ_os_set_LINUX]').removeAttr('disabled');
		}
		else if(val=='MOBILE')
		{
			//Targeting
			jQuery('.TABLE_WEB').addClass('hide');
			jQuery('.TABLE_MOBILE').removeClass('hide');
			jQuery('.TABLE_TABLET').addClass('hide');
			
			//Creatives	
			jQuery("#web_creative_anchor").addClass('hide');
			jQuery("#mobile_creative_anchor").removeClass('hide');
			jQuery("#tablet_creative_anchor").addClass('hide');
			jQuery("#all_creative_anchor").addClass('hide');
			jQuery('#preset_os [id=targ_os_set_GC]').removeAttr('disabled');			
		}
		else if(val=='TABLET')
		{
			//Targeting
			jQuery('.TABLE_WEB').addClass('hide');
			jQuery('.TABLE_MOBILE').addClass('hide');
			jQuery('.TABLE_TABLET').removeClass('hide');
			
			//Creatives	
			jQuery("#web_creative_anchor").addClass('hide');
			jQuery("#mobile_creative_anchor").addClass('hide');
			jQuery("#tablet_creative_anchor").removeClass('hide');
			jQuery("#all_creative_anchor").addClass('hide');
															
		}
		else if(val=='ALL')
		{
			//Targeting
			jQuery('.TABLE_WEB').removeClass('hide');
			jQuery('.TABLE_MOBILE').removeClass('hide');
			jQuery('.TABLE_TABLET').removeClass('hide');
			
			//Creatives	
			jQuery("#web_creative_anchor").addClass('hide');
			jQuery("#mobile_creative_anchor").addClass('hide');
			jQuery("#tablet_creative_anchor").addClass('hide');
			jQuery("#all_creative_anchor").removeClass('hide');	
			
			jQuery('#preset_os [id!=targ_os_set_'+val+']').removeAttr('disabled');		
		}
		else
		{
			//Targeting
			jQuery('.TABLE_WEB').removeClass('hide');
			jQuery('.TABLE_MOBILE').removeClass('hide');
			jQuery('.TABLE_TABLET').removeClass('hide');
			
			//Creatives	
			jQuery("#web_creative_anchor").addClass('hide');
			jQuery("#mobile_creative_anchor").addClass('hide');
			jQuery("#tablet_creative_anchor").addClass('hide');
			jQuery("#all_creative_anchor").removeClass('hide');	
			
			jQuery('#preset_os [id!=targ_os_set_'+val+']').removeAttr('disabled');	
		}
		
		//Devices
		
		if(val!='')
		{
			$('#targ_device').select2({
				width:'240px',
				placeholder: "Select Device",
				multiple:true,
				allowClear: true,
				data: ds_list[val]
			});	
			
			$('#targ_os').select2({
				placeholder: "Select OS",
				multiple:true,
				allowClear: true,
				data: oslist[val]
			});	
			
			$('#targ_browser').select2({
				placeholder: "Select Browser",
				multiple:true,
				allowClear: true,
				data: ((browlist[val])?browlist[val]:browlist['MOBILE'])
			});								
		}
		else
		{
			$('#targ_device').select2({
				width:'240px',
				placeholder: "Select Device",
				multiple:true,
				allowClear: true,
				data: []
			});
			
			$('#targ_os').select2({
				placeholder: "Select OS",
				multiple:true,
				allowClear: true,
				data: []
			});	
			
			$('#targ_browser').select2({
				placeholder: "Select Browser",
				multiple:true,
				allowClear: true,
				data: []
			});	
		}
	}
			
	// 
	// name: 
	// @param: value
	// @return
	// Intialize the spinner

	$(function () {
		$("#campaign_budget").spinner({
			'min': 1,step: 0.01,numberFormat: "n",
		});
		
		$("#campaign_daily_budget").spinner({
			'min': 1,step: 0.01,numberFormat: "n"
		});
		$("#campaign_bid_rate").spinner({
			'min': 0.10,step: 0.01,numberFormat: "n"
		});		 

	});

	function camp_type_chk()
	{
		var camp_type = document.getElementById("campaign_type").value;
		jQuery('#rev_camp_type').val(camp_type);
		
		jQuery("#popup").show();//Show Popup
		
		if(camp_type==1)
		{				
			jQuery('#rev_cpccpm').show();
			jQuery('#rev_cpa').hide();
			jQuery('#bid_rate_type').html('CPM');
		}
		else if(camp_type==2)
		{				
			jQuery('#rev_cpccpm').show();
			jQuery('#rev_cpa').hide();
			jQuery('#bid_rate_type').html('CPC');
			
			jQuery("#popup").hide();
		}
		else if(camp_type==3)
		{				
			jQuery('#rev_cpa').show();
			jQuery('#rev_cpccpm').hide();
			jQuery('#bid_rate_type').html('CPA');
			
			jQuery("#popup").hide();
		}
		else if(camp_type==4)
		{				
			jQuery('#rev_cpccpm').show();
			jQuery('#rev_cpa').hide();
			jQuery('#bid_rate_type').html('CPL');
		}
		else if(camp_type==5)
		{				
			jQuery('#rev_cpccpm').show();
			jQuery('#rev_cpa').hide();
			jQuery('#bid_rate_type').html('CPS');
		}
		else if(camp_type==6)
		{				
			jQuery('#rev_cpccpm').show();
			jQuery('#rev_cpa').hide();
			jQuery('#bid_rate_type').html('CPI');
		}
		else
		{				
			jQuery('#rev_cpccpm').show();
			jQuery('#rev_cpa').hide();
			jQuery('#bid_rate_type').html('CPM');
		}			
			
	}
	// 
	// name: show_date_range
	// @param: value
	// @return
	// Toggle the campaign start and end date
	
	function show_date_range(value)
	{		
		if (value == 'specific') {
			jQuery('#shedule_date_range').show();
		}
		else {
			jQuery('#shedule_date_range').hide();
		}
	}

	// 
	// name: unknown
	// @param
	// @return
	// This method will get triggered when the first next button is clicked in the wizard
	campaign_name	=	'';
	jQuery(function(){		
		var remoteAjax = {};
		var is_notified=false;
		var form = jQuery("#add_campaign");
		var validator = form.validate();
	
		jQuery("#firstStep").each(function(){ // for each step in the wizard, add an option to the remoteAjax object...
             jQuery('#back').addClass('hide');
			 remoteAjax[jQuery(this).attr("id")] = {
				url : site_url+"/api/v1/campaign/add_campaign", // the url which stores the stuff in db for each step
				
				dataType : 'json',
				success : function(data){
					console.log(data);
							if(data.response =="ok")
							{
								if(is_notified==false)
								{
									$('#add_campaign_msg').attr("data-notify-message","Campaign created sucessfully!");
									$('#add_campaign_msg').trigger('click');
									is_notified=true;
								}
								
								if(data.status =='1')
								{
									jQuery('div.alert').html('<i class="icon-info-sign"></i> This campaign is paused due to lower account balance than campaign budget');
									jQuery('div.alert').removeClass('hide');
								}else if(data.status =='2'){
									jQuery('div.alert').html('<i class="icon-info-sign"></i> This campaign is awaiting status and runs in future date');
									jQuery('div.alert').addClass('alert-info');
									jQuery('div.alert').removeClass('hide');
								}
							
								jQuery("#_camp_revenue_type").val(jQuery("#campaign_type").val());
								
								jQuery("#_camp_budget").val(jQuery("#campaign_budget").val());
								
								//HIDE SAVE AND EXIT BUTTON / SHOW BACK BUTTON
								jQuery("#save_exit").addClass('hide');
								jQuery('#back').show();
								jQuery("#_campaign_id").val(data.campaign_id);
								jQuery("#_camp_name").val(data.campaign_name);
								
								//Advertiser Id
								jQuery("#mobile_creative_anchor").attr('data-account-id',data.account_id);
								jQuery("#web_creative_anchor").attr('data-account-id',data.account_id);
								jQuery("#tablet_creative_anchor").attr('data-account-id',data.account_id);
								jQuery("#all_creative_anchor").attr('data-account-id',data.account_id);
								
								jQuery("#mobile_creative_anchor").attr('data-campaign-id',data.campaign_id);
								jQuery("#web_creative_anchor").attr('data-campaign-id',data.campaign_id);
								jQuery("#tablet_creative_anchor").attr('data-campaign-id',data.campaign_id);
								jQuery("#all_creative_anchor").attr('data-campaign-id',data.campaign_id);
								
								// Creatives step
								
								refresh_existing_creative();								
								
								if(jQuery("#_camp_revenue_type").val()=='2' || jQuery("#_camp_revenue_type").val()=='3')
								{
									jQuery("#popup").hide();
								}
								else
								{
									jQuery("#popup").show();
								}
								
								if(data!='')
								{
									jQuery("#_existing_creative").html(data);
								}
								
								var targ_type=jQuery("#campaign_targeting_type").val();
								targeting_type(targ_type);
								
								//Campaign Name
								jQuery("#_campaign_item").html(data.campaign_name);
															
								//Campaign Type
								var revtype	=	jQuery("#_camp_revenue_type").val();
								if(revtype==1)
									jQuery("#_campaign_type").html('CPM');
								else if(revtype==2)
									jQuery("#_campaign_type").html('CPC');
								else if(revtype==3)
									jQuery("#_campaign_type").html('CPA');
								else if(revtype==4)
									jQuery("#_campaign_type").html('CPL');
								else if(revtype==5)
									jQuery("#_campaign_type").html('CPS');
								else if(revtype==6)
									jQuery("#_campaign_type").html('CPI');
								else
									jQuery("#_campaign_type").html('CPM');
									
								//Campaign Budget
								jQuery("#_campaign_budget").html(currency+''+jQuery("#_camp_budget").val());
								
								jQuery("#_campaign_total_budget").html(currency+''+jQuery("#_camp_budget").val());							
											
													
								return true;
							}
							else
							{
								validator.showErrors(data.msg);
								return false;
							}
							
							//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
						}
				};
		});
				
		jQuery("#secondstep").each(function(){ // for each step in the wizard, add an option to the remoteAjax object...
          	var campaign_id= jQuery("#_campaign_id").val();
			
			
			remoteAjax[jQuery(this).attr("id")] = {
				dataType:'json',
				url : site_url+"/api/v1/campaign/checkout_campaign?api_key="+api_key, // the url which stores the stuff in db for each step
				success : function(data){
					var redir=data.redirect;
					window.location.href=redir;
				}
			};
		});
		
		jQuery("#add_campaign").formwizard("option", "remoteAjax", remoteAjax); // set the remoteAjax option for the wizard
		
	});

	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative()
	{
		var form = jQuery("#add_campaign");
			
		jQuery.ajax({
			type:'POST',
			data:form.serialize(),
			url : site_url+"/site/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			success : function(data){
							if(data!='')
							{
								jQuery("#_existing_creative").html(data);
							}
							return true;
							//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
						}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	
//Delete a creative

function delete_creative(creative_id)
{
	jQuery("#creative_id").val(creative_id);
    jQuery('#modal_del_creative_from_campaign').modal('show');	
}
$(function(){
	$("#campaign_budget, #campaign_bid_rate, #campaign_type , #cpa_goal").on('change', function(){
		
		max_impressions();
	});
});

function max_impressions()
{
	var camp_type= jQuery('#campaign_type').val();
	
	var campaign_budget=$("#campaign_budget").val()*1;
	
	if(camp_type==3)
	{
		var campaign_bid_rate=$("#cpa_goal").val()*1;
	}
	else
	{
		var campaign_bid_rate=$("#campaign_bid_rate").val()*1;
	}
	
	if(campaign_budget!='' && campaign_bid_rate!='')
	{
		if(campaign_budget >= campaign_bid_rate)
		{
			if(camp_type==1)
			{
				var value=parseInt(campaign_budget/campaign_bid_rate)*1000;
				$("#max_impressions").html("<b>Maximum number of impressions</b> : "+value);
			}
			else if(camp_type==2)
			{
				var value=parseInt(campaign_budget/campaign_bid_rate);		
				$("#max_impressions").html("<b>Maximum number of clicks</b> : "+value);
			}			
			else if(camp_type==3)
			{
				var value=parseInt(campaign_budget/campaign_bid_rate);
				$("#max_impressions").html("<b>Maximum number of conversions</b> : "+value);
			}
			else if(camp_type==4)
			{
				var value=parseInt(campaign_budget/campaign_bid_rate);
				$("#max_impressions").html("<b>Maximum number of leads</b> : "+value);
			}
			else if(camp_type==5)
			{
				var value=parseInt(campaign_budget/campaign_bid_rate);
				$("#max_impressions").html("<b>Maximum number of sale</b> : "+value);
			}
			else if(camp_type==6)
			{
				var value=parseInt(campaign_budget/campaign_bid_rate);
				$("#max_impressions").html("<b>Maximum number of install</b> : "+value);
			}
		}
		else
		{			
			$("#max_impressions").html("");
			$("#max_impressionsc").html("");
		}
		$("#suggested_cpm").show();
		$("#suggested_imp").show();
		
		var bestamt	=	jQuery('#best_amount').html();
		var bestimp	=	Math.floor((campaign_budget/bestamt)*1000);
		jQuery('#best_impression').html(bestimp);
	}
	else if(campaign_budget!='' && campaign_bid_rate=='')
	{
		if(camp_type==1)
		{
			var value=parseInt(campaign_budget/min_bid_rate)*1000;
			$("#max_impressions").html("<b>Maximum number of impressions</b> : "+value);
		}
		else if(camp_type==2)
		{
			var value=parseInt(campaign_budget/min_bid_rate);		
			$("#max_impressions").html("<b>Maximum number of clicks</b> : "+value);		
		}		
		else if(camp_type==3)
		{
			var value=parseInt(campaign_budget/min_bid_rate);
			$("#max_impressionsc").html("<b>Maximum number of conversions</b> : "+value);
		}
		else if(camp_type==4)
		{
			var value=parseInt(campaign_budget/min_bid_rate);
			$("#max_impressions").html("<b>Maximum number of leads</b> : "+value);
		}
		else if(camp_type==5)
		{
			var value=parseInt(campaign_budget/min_bid_rate);
			$("#max_impressions").html("<b>Maximum number of sale</b> : "+value);
		}
		else if(camp_type==6)
		{
			var value=parseInt(campaign_budget/min_bid_rate);
			$("#max_impressions").html("<b>Maximum number of install</b> : "+value);
		}
		
		$("#suggested_cpm").show();
		$("#suggested_imp").show();
		
		var bestamt	=	jQuery('#best_amount').html();
		var bestimp	=	Math.floor((campaign_budget/bestamt)*1000);
		jQuery('#best_impression').html(bestimp);
	}
	else
	{	
		$("#max_impressions").html("");
		$("#max_impressionsc").html("");
		$("#suggested_cpm").hide();
		$("#suggested_imp").hide();
	}
}


// Edit creative

function edit_creative(storagetype,dj_banner_type,creative_id)
{
		
	if(storagetype=='web' || storagetype=='url' || storagetype=='sql')
	{
		if(dj_banner_type=='W_SWF')
		{
			var edit_url = site_url+'/site/creatives/edit_flash_creative';
			var data_target="#modal_flash_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_MR_INT')
		{
			var edit_url = site_url+'/site/creatives/edit_interstitial_creative';
			var data_target="#modal_interstitial_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_MR_EXP')
		{
			var edit_url = site_url+'/site/creatives/edit_expand_creative';
			var data_target="#modal_expand_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_MR_REV')
		{
			var edit_url = site_url+'/site/creatives/edit_reveal_creative';
			var data_target="#modal_reveal_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_RS_FS')
		{
			var edit_url = site_url+'/site/creatives/edit_filmstrip_creative';
			var data_target="#modal_filmstrip_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_RS_ADH')
		{
			var edit_url = site_url+'/site/creatives/edit_adhesion_creative';
			var data_target="#modal_adhesion_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_RS_FL')
		{
			var edit_url = site_url+'/site/creatives/edit_flex_creative';
			var data_target="#modal_flex_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_RS_SL')
		{
			var edit_url = site_url+'/site/creatives/edit_slider_creative';
			var data_target="#modal_slider_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_RS_PL')
		{
			var edit_url = site_url+'/site/creatives/edit_pull_creative';
			var data_target="#modal_pull_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='M_IMG')
		{
			var edit_url = site_url+'/site/creatives/edit_image_creative';
			var data_target="#modal_image_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_TAB')
		{
			var edit_url = site_url+'/site/creatives/edit_tablet_creative';
			var data_target="#modal_tablet_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_POP')
		{
			var edit_url = site_url+'/site/creatives/edit_popup_creative';
			var data_target="#modal_popup_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_LAY')
		{
			var edit_url = site_url+'/site/creatives/edit_layer_creative';
			var data_target="#modal_layer_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_GB')
		{
			var edit_url = site_url+'/site/creatives/edit_gamebox_creative';
			var data_target="#modal_gamebox_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_BB')
		{
			var edit_url = site_url+'/site/creatives/edit_bannerbox_creative';
			var data_target="#modal_bannerbox_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_SL')
		{
			var edit_url = site_url+'/site/creatives/edit_sliderad_creative';
			var data_target="#modal_sliderad_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_CF')
		{
			var edit_url = site_url+'/site/creatives/edit_catfish_creative';
			var data_target="#modal_catfish_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_SS')
		{
			var edit_url = site_url+'/site/creatives/edit_siteskin_creative';
			var data_target="#modal_siteskin_creative_edit";
			var data_backdrop="static";
		}
		else
		{
			var edit_url = site_url+'/site/creatives/edit_web_creative';
			var data_target="#modal_web_creative_edit";
			var data_backdrop="static";
		}
	}
	else if(storagetype=='txt')
	{
		if(dj_banner_type=='M_TEXT')
		{
			var edit_url = site_url+'/site/creatives/edit_mob_text_creative';
			var data_target="#modal_mob_text_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_TEXT')
		{
			var edit_url = site_url+'/site/creatives/edit_text_creative';
			var data_target="#modal_text_creative_edit";
			var data_backdrop="static";
		}
	}
	else if(storagetype=='html')
	{
		if(dj_banner_type=='V_IN')
		{
			var edit_url = site_url+'/site/creatives/edit_video_inline_creative';
			var data_target="#modal_video_inline_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='V_OL')
		{
			var edit_url = site_url+'/site/creatives/edit_video_overlay_creative';
			var data_target="#modal_video_overlay_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_LAY')
		{
			var edit_url = site_url+'/site/creatives/edit_layer_creative';
			var data_target="#modal_layer_creative_edit";
			var data_backdrop="static";
		}
		else if(dj_banner_type=='W_SL')
		{
			var edit_url = site_url+'/site/creatives/edit_sliderad_creative';
			var data_target="#modal_sliderad_creative_edit";
			var data_backdrop="static";
		}
		else
		{
			var edit_url = site_url+'/site/creatives/edit_html_creative';
			var data_target="#modal_html_creative_edit";
			var data_backdrop="static";
		}
	}
	var url=	edit_url+"/"+creative_id+"/"+api_key;
	
	jQuery('a#edit_cre').attr('data-backdrop', data_backdrop);
	
	jQuery('a#edit_cre').attr('data-target', data_target);
	
	jQuery("a#edit_cre").attr("href", url);
	console.log(url);

}

function valid_bid_rate(data)
{
	//alert($(data).val());
	if($(data).val()=='' ||$(data).val()==null )
	{
		$('#bid_rate').css("border","#b94a48 solid 1px");
	}
	else
	{
		$('#bid_rate').css("border","green solid 1px");
	}
}

// gloable variable 
var j=1;

function remove_source(data)
{
	var id	=	$(data).attr('id');
	
	$('#traffic_source_'+id).remove();
	$("#source option[value='" +id+ "']").show();
	if($('#sources tbody tr').length==0)
	{
		$('#sources tbody').html('<tr id="nodata"><td colspan="4">No data is available.</td></tr>');
	}
}

function traffic_source(){
	
	var source		=	$('#source').val();
	var bid_rate	=	$('#bid_rate').val();
	var status		=	$('#source_status').val();
		
	if(source=="" || source==null)
	{
		$('#source').css("border","#b94a48 solid 1px");
	}
	else if(bid_rate== "" || bid_rate==null) 
	{
		$('#bid_rate').css("border","#b94a48 solid 1px");		
	}	
	
	var items =	{
					id			:	'',
					publisher_id: 	source,
					bid_rate	: 	bid_rate,
					status		: 	status					
				};	
				
	if (source!='' && bid_rate!='')
	{		
		var data 	=	"<tr id='traffic_source_"+source+"'>"+
							"<td id='source_"+source+"' >"+source+"</td>"+
							"<td>"+currency+"<a id='bid_"+source+"' name='bid_source' class='editable editable-click bid_source' data-original-title='Enter Bid Rate' data-type='text' >"+bid_rate+"</a></td>"+
							"<td><a id='status_"+source+"' name='t_status' class='editable editable-click t_status' data-original-title='Select Status' data-type='select2' data-value='"+status+"' >"+((status==1)?"Active":"In-Active")+"</a></td>"+
							"<td><input type='button' id="+source+" class='btn btn-primary btn-small' onclick='remove_source(this)' value='REMOVE'></td>"+
							"<input name='traffic_source[]' id='ts_"+source+"' type='hidden' value='"+JSON.stringify(items)+"' >"+
						"</tr>";	
		
		if($('#nodata').length)
		{
			$('#nodata').remove();			
		}
		$('#sources tbody').append(data);		
		$("#source option[value='" + source + "']").hide();
		$('#source').val('');
		$('#bid_rate').val('');	
		traffic_editable();	
	}
	
	j++;	
}

//Country Bidding
var k=1;

function remove_bidding(data)
{
	var id	=	$(data).attr('id');
	
	$('#country_bidding_'+id).remove();	
	if($('#country_list tbody tr').length==0)
	{
		$('#country_list tbody').html('<tr id="nobiddata"><td colspan="5">No data is available.</td></tr>');
	}
}

function country_bidding(){
	
	$('#bidding_error').html('');
	
	var country		=	$('#country').val();
	var pricing		=	$('#bidding_type').val();
	var bid_rate	=	$('#country_bid_rate').val();
	var status		=	$('#bidding_status').val();
		
	if(country=="" || country==null)
	{
		$('#country').css("border","#b94a48 solid 1px");
	}
	else if(pricing== "" || pricing==null) 
	{
		$('#bidding_type').css("border","#b94a48 solid 1px");		
	}	
	else if(bid_rate== "" || bid_rate==null) 
	{
		$('#country_bid_rate').css("border","#b94a48 solid 1px");		
	}	
	
	var items =	{
					id			:	'',
					country		: 	country,
					pricing		: 	pricing,
					bid_rate	: 	bid_rate,
					status		: 	status					
				};	
				
	if (country!='' && pricing!='' && bid_rate!='')
	{
		var bid_add	=	true;
		
		jQuery("[id^='cb_']").each(function(){
			var cbidding=JSON.parse($(this).val());	
			if(cbidding.country==country && cbidding.pricing==pricing)
			{
				bid_add	=	false;				
			}
		});
		
		if(bid_add==false)
		{
			$('#bidding_error').html('Bidding exist with same country & pricing.').css("color","#b94a48");
		}
		else
		{	
			var cdata 	=	"<tr id='country_bidding_"+country+"_"+pricing+"'>"+
								"<td id='country_"+country+"_"+pricing+"' >"+country+"</td>"+
								"<td><a id='pricing_"+country+"_"+pricing+"' name='bid_pricing' class='editable editable-click bid_pricing' data-original-title='Select Pricing' data-type='select2' data-value='"+pricing+"' >"+bidtype[pricing-1].text+"</a></td>"+
								"<td>"+currency+"<a id='cbid_"+country+"_"+pricing+"' name='cbid_rate' class='editable editable-click cbid_rate' data-original-title='Enter Bid Rate' data-type='text' >"+bid_rate+"</a></td>"+
								"<td><a id='bstatus_"+country+"_"+pricing+"' name='bid_status' class='editable editable-click bid_status' data-original-title='Select Status' data-type='select2' data-value='"+status+"' >"+((status==1)?"Active":"In-Active")+"</a></td>"+
								"<td><input type='button' id="+country+"_"+pricing+" class='btn btn-primary btn-small' onclick='remove_bidding(this)' value='REMOVE'></td>"+
								"<input name='country_bidding[]' id='cb_"+country+"_"+pricing+"' type='hidden' value='"+JSON.stringify(items)+"' >"+
							"</tr>";	
			
			if($('#nobiddata').length)
			{
				$('#nobiddata').remove();			
			}
			
			$('#country_list tbody').append(cdata);		
			
			$('#country').select2('val','');
			$('#bidding_type').select2('val','1');
			$('#country_bid_rate').val('');	
			country_editable();	
		}
	}
	
	k++;	
}

//Country Bidding

// Country preset
function country_targ_type(val)
{
	if(val=='include')
	{  
		jQuery('.include_country').show();
		jQuery('.exclude_country').hide();
	}
	else if(val=='exclude')
	{		
		jQuery('.include_country').hide();
		jQuery('.exclude_country').show();
	}
	else
	{		
		jQuery('.include_country').show();
		jQuery('.exclude_country').hide();
	}
}

// Country preset
function show_region()
{
	jQuery('#country_preset').toggle();
	
	if($('#country_preset').is(':visible'))
	{  
		if($('input[name=targ_region]:checked').val()=='ALL')
		{
			country_region('ALL');
		}
	}
	else
	{		
		//jQuery('#targ_geo').removeAttr('disabled');
	}
}

// Country preset
function show_os()
{
	jQuery('#preset_os').toggle();
	
	if($('#preset_os').is(':visible'))
	{  
		//jQuery('#targ_geo').attr('disabled','disabled');
	}
	else
	{		
		//jQuery('#targ_geo').removeAttr('disabled');
	}
}

function targlist(val)
{
	if(val=='black')
	{  
		jQuery('.blacklist').show();
		jQuery('.whitelist').hide();
	}
	else if(val=='white')
	{  
		jQuery('.blacklist').hide();
		jQuery('.whitelist').show();
	}
	else
	{
		jQuery('.blacklist').show();
		jQuery('.whitelist').hide();
	}
}

function traffic_editable(){
	//Edit Bidrate
	$('.bid_source').editable({
		validate: function(value) {
			if($.trim(value) == '') return 'Bid Rate is Required..';
			if(parseInt($.trim(value)) < 0 ) return 'Please Enter valid positive number.';
		},
		display: function(value) {
			var id 		= 	$(this).attr('id');
			var ts_id	=	id.replace('bid','ts');
			var ts		=	JSON.parse($('#'+ts_id).val());
			if(value) {						
				$('#'+id).html(value);
				ts.bid_rate=value;
				$('#'+ts_id).val(JSON.stringify(ts));
			} else {
				$('#'+id).empty();
			}
		}
	});
	
	//Edit Status
	$('.t_status').editable({
		source: [
		  {value: '1', text: 'Active'},
		  {value: '0', text: 'In-Active'}
		],
		validate: function(value) {
			if($.trim(value) == '') return 'Bid Status is Required..';
		},
		display: function(value) {
			var id 		= 	$(this).attr('id');
			var ts_id	=	id.replace('status','ts');
			var ts		=	JSON.parse($('#'+ts_id).val());
			
			$('#'+id).html(((value==1)?'Active':'In-Active'));
			ts.status=value;
			$('#'+ts_id).val(JSON.stringify(ts));
		}
	});
}

function country_editable(){
	
	//Edit Bidrate
	$('.bid_pricing').editable({
		source:bidtype,
		validate: function(value) {				
			if($.trim(value) == '') return 'Bid pricing is Required..';
		},
		display: function(value) {
			var id 		= 	$(this).attr('id');
			var cb_id	=	id.replace('pricing','cb');
			var cb		=	JSON.parse($('#'+cb_id).val());
			if(value) {						
				$('#'+id).html(bidtype[value-1].text);
				cb.pricing=value;
				$('#'+cb_id).val(JSON.stringify(cb));
			} else {
				$('#'+id).empty();
			}
		}
	});
	
	//Edit Bidrate
	$('.cbid_rate').editable({
		validate: function(value) {
			if($.trim(value) == '') return 'Bid Rate is Required..';
			if(parseInt($.trim(value)) < 0 ) return 'Please Enter valid positive number.';
		},
		display: function(value) {
			var id 		= 	$(this).attr('id');
			var cb_id	=	id.replace('cbid','cb');
			var cb		=	JSON.parse($('#'+cb_id).val());
			if(value) {						
				$('#'+id).html(value);
				cb.bid_rate=value;
				$('#'+cb_id).val(JSON.stringify(cb));
			} else {
				$('#'+id).empty();
			}
		}
	});
	
	//Edit Status
	$('.bid_status').editable({
		source: [
		  {value: '1', text: 'Active'},
		  {value: '0', text: 'In-Active'}
		],
		validate: function(value) {
			if($.trim(value) == '') return 'Bid Status is Required..';
		},
		display: function(value) {
			var id 		= 	$(this).attr('id');
			var cb_id	=	id.replace('bstatus','cb');
			var cb		=	JSON.parse($('#'+cb_id).val());
			
			$('#'+id).html(((value==1)?'Active':'In-Active'));
			cb.status=value;
			$('#'+cb_id).val(JSON.stringify(cb));
		}
	});
}

function nocapping()
{
	if(jQuery('#no_capping').is(':checked'))
	{
		jQuery('#targ_impression').attr('disabled','disabled');
		jQuery('#targ_hour').attr('disabled','disabled');
		//jQuery('#targ_impression').val('');
		//jQuery('#targ_hour').val('');
	}
	else
	{
		jQuery('#targ_impression').removeAttr('disabled','disabled');
		jQuery('#targ_hour').removeAttr('disabled','disabled');
	}	
}

function daypart(){
	jQuery('input[name=targ_day]').iCheck('uncheck');
	set_preset_day('');
}

function clear_region(val){
	jQuery('#country_preset [id=targ_region_ALL]').iCheck('check');
	jQuery('#country_preset [id!=targ_region_ALL]').iCheck('uncheck');
	country_region('');
}

// Country preset
function show_targeting()
{
	jQuery('#advance_targeting').toggle();	
	
	if($('#advance_targeting').is(':visible'))
	{  
		jQuery('#advtarget i').removeClass('icon-plus').addClass('icon-minus');
	}
	else
	{		
		jQuery('#advtarget i').removeClass('icon-minus').addClass('icon-plus');
	}
}

	// 
	// name: weekly distribution
	// @param: value
	// @return
	// Toggle the distribution
	
	function show_weekly(value)
	{		
		if (value == 'custom') {
			jQuery('#daypart_custom').show();
		}
		else {
			jQuery('#daypart_custom').hide();
		}
	}
	
	// 
	// name: weekly distribution
	// @param: value
	// @return
	// Toggle the distribution
	
	function show_suggested_cpm()
	{
		var budget	=	jQuery('#campaign_budget').val();		
		var price	=	jQuery('#campaign_bid_rate').val();		
		if (budget!= '' || price!=''){
			$('#suggested_cpm').show();
			$('#suggested_imp').show();			
		}
		else {
			$('#suggested_cpm').hide();
			$('#suggested_imp').hide();
		}
	}
	
	function bidding_data()
	{		
		if(jQuery('input[name=country_type]:checked').val()=='include')
		{
			var country	=	jQuery('#targ_geo_include').val();
		}
		else if(jQuery('input[name=country_type]:checked').val()=='exclude')
		{
			var country	=	jQuery('#targ_geo_exclude').val();
		} 
		
		jQuery.ajax({
			type	:	'GET',
			data	:	{api_key:api_key,country:country},
			dataType: 	'json',
			async	:	false,
			url 	: 	site_url+"/api/v1/campaign/fetch_realtime_bidding", // the url which stores the stuff in db for each step
			success	: 	function(data, textStatus, jqXHR){
				if(data !=="error")
				{	
					var best_amt	=	0;
					var max_amt		=	0;
					$.each(data,function(index,value){
						best_amt	+=	parseFloat(value.best_bid_rate);
						max_amt		+=	parseFloat(value.max_bid_rate);
					});
					var bestamt	=	(data.length>0)?(best_amt/data.length):best_amt;	
					var budget	=	(jQuery('#campaign_budget').val())?jQuery('#campaign_budget').val():min_budget;
					var bestimp	=	Math.floor((budget/bestamt)*1000);			
					jQuery('#best_amount').html(bestamt);
					jQuery('#best_impression').html(bestimp);
					jQuery('#max_amount').html(max_amt);
				}
				else
				{
					var budget	=	(jQuery('#campaign_budget').val())?jQuery('#campaign_budget').val():min_budget;
					var bestimp	=	Math.floor((budget/best_bid_rate)*1000);
					jQuery('#best_amount').html(best_bid_rate);
					jQuery('#best_impression').html(bestimp);
					jQuery('#max_amount').html(max_bid_rate);
				}
			}, 
			error: function(jqXHR, textStatus, errorThrown){
				//return false;
			}
		}); 
		
	}
	
