// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
        "oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sLengthMenu": "_MENU_ <span>entries per page</span>",
						"sEmptyTable": "Sorry, no Mobile Ad blocks has been found."
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/publisher/mobile_ad_blocks/fetch_adblocks",
        "aoColumnDefs": [
			{
				"aTargets": [0],
				"mData": "zonename"
			},
			{
				"aTargets": [1],
				"mData": "site_url"
			
			},
			{
				"aTargets": [2],
				"mData" : "ad_type",
			},
			{
				"aTargets": [3],
				"mData" : "zone_type",
			},
			{
				"aTargets": [4],
				"mData" : "zoneid",
				"mRender": function (data, type, full) {
					return mobile_sdk(data);
				}
			},
			{
				"aTargets": [5],
				"mData" : "zoneid",
				"sClass" : "no-print",
				"mRender": function (data, type, full) {
					return generate_ad_tag(data);
				}
			},
			{
				"aTargets": [6],
				"mData" : "zoneid",
				"sClass" : "no-print",
				"mRender": function (data, type, full) {
					return action_button(data);
				}
			},
		],
		"oTableTools": {
			//"sSwfPath": base_url+"template/flat/js/plugins/datatable/swf456/copy_csv_xls_pdf.swf",
        "aButtons": [
            {
                "sExtends": "copy",
                 "mColumns": [0,1,2,3,4]
            },
            {
                "sExtends": "csv",
                "mColumns": [0,1,2,3,4]
            },
            {
                "sExtends": "xls",
                "mColumns": [0,1,2,3,4]
            },
            {
                "sExtends": "pdf",
                "mColumns": [0,1,2,3,4]
            },
            {
                "sExtends": "print",
               // "bShowAll" :true,
                "bSelectedOnly": true,
               /* "sInfo": 'Click print or cancel <button>Print</button>',
                "fnClick": function (nButton, oConfig, oFlash) {
                  
                  $('td.no-print').hide(); 
                  
                } */
            },
        ]
    }
    };


//Mobile sdk
function mobile_sdk(data)
{
	var url = site_url+'/publisher/mobile_ad_blocks/mobile_sdk';
	var btn = '<a role="button" data-toggle="modal" class="btn btn-small"  data-target="#modal_mobile_sdk" data-zonename="'+data.zonename+'" href="'+url+'/'+data+'"><i class="icon-pencil"></i>&nbsp;&nbsp;Mobile SDK</a>';
	
	return btn;	
}


//Generate Ad Tag
function generate_ad_tag(data)
{
	var url = site_url+'/publisher/mobile_ad_blocks/generate_ad_tag';
	var btn = '<a role="button" data-toggle="modal" class="btn btn-small"  data-target="#modal_generate_ad_tags" href="'+url+'/'+data+'"><i class="icon-pencil"></i>&nbsp;&nbsp;Generate Ad Tag</a>';
	
	return btn;	
}

//Action
function action_button(data)
{
	var edit_url = site_url+'/publisher/mobile_ad_blocks/edit_mobile_adblock';
	var edit_btn = '<a data-toggle="modal" role="button"  class="btn btn-small"  data-target="#modal_edit_mobile_ad_block" data-backdrop="static" href="'+edit_url+'/'+data+'"><i class="icon-edit"></i>&nbsp;&nbsp;Edit</a>';
	 
	var del_url = '';
	var del_btn = '<button class="btn btn-small site confirm" data="'+data+'" data-bb="confirm"><i class="icon-trash"></i>&nbsp;&nbsp;Delete</button>';
	
	return edit_btn+del_btn;
}

	// Delete Functionality with Confirm Box
		
		
		$(document).on("click", ".confirm", function(e) {
	 
	 	bootbox.confirm("Are you sure you want to delete?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
				// URL from the link that was clicked on
				type:'GET',
				url: site_url+'/api/v1/web_adblock/delete/format/json',
				data:{'zone_id':$(e.target).attr('data'),'api_key':api_key},
				// Success function. the 'data' parameter is an array of objects that can be looped over
				success: function(data, textStatus, jqXHR){
				//console.log(jqXHR);
				if(data.response == 'ok'){
					 
					$('select').select2("val", "");
					
					$('.dataTable').dataTable(custom_opt).fnDraw();
					$('.dataTables_filter input').attr("placeholder", "Search here...");
					$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
						disable_search_threshold: 9999999
						});
					$("#check_all").click(function(e){
									$('input', oTable.fnGetNodes()).prop('checked',this.checked);
					});
					if($(this).hasClass("dataTable-fixedcolumn")){
						new FixedColumns( oTable );
					}
					if($(this).hasClass("dataTable-columnfilter")){
						oTable.columnFilter({
							"sPlaceHolder" : "head:after"
						});
					}
					resize_chosen();	
					
					//$('#save_site').unbind('click');
					$('#del_site_msg').attr("data-notify-message",data.msg);
					
					$('#del_site_msg').trigger('click');	
				}
				else
				{
					//validator.showErrors(data.msg);
				}
			
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Oh no! A problem with the AJAX request!');
				}
				}); 
				
			}
		}); 
	 
	 });
