
// dataTables

	//options dataTable
	var custom_opt = {
				"bProcessing": true,
				"bAutoWidth": true,
				"bDestroy" : true,
				"bSortable": false,	
				"iDisplayLength" : parseInt(app_configdefault_per_page),
				"oLanguage":{
								"sSearch": "<span>Search:</span> ",
								"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
								"sLengthMenu": "_MENU_ <span>entries per page</span>"
							},
				"sPaginationType": "full_numbers",
				"sAjaxSource": site_url+"/publisher/messages/fetch_message/inbox",
				"fnRowCallback": function( nRow, aData, iDisplayIndex ) {
					if(aData.status==1)
					{
						$(nRow).addClass('unread');
					}
					$(nRow).removeClass('odd');
					$(nRow).removeClass('even');
					return nRow;
				},	
			  "aoColumnDefs": [
				{
					"aTargets"	: [0],
					"mData"		:"id",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('checkbox_id'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{	
						var checkbox=	"<input class='checkbox_count' name='inbox_check' id='inbox_check' value='"+data+"' type='checkbox'>";
						return checkbox;
					}
				},
				{
					"aTargets"	: [1],
					"mData"		: "status",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-icon hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return get_status(full);
					}
				},
				{
					"aTargets"	: [2],
					"mData"		: "name",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-fixed-medium'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return full.name.charAt(0).toUpperCase()+full.name.slice(1);
					}
				},
				{
					"aTargets"	: [3],
					"mData"		: "subject",
					"mRender"	: function (data, type, full)
					{
						return get_subject(full,'inbox');
					}
				},
				{
					"aTargets"	: [4],
					"mData"		: "image_name",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-icon hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return get_file(full);
					}
				},
				{
					"aTargets"	: [5],
					"mData"		:"date",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-date hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full) {
						
						return get_date(full);
					}
				}
				
				],
				 dom:'Bfrtip',
	   "sDom": 'B<"clear">lfrtip',
				 'columnDefs': [
			         {
			         	
			            'checkboxes': {
			               'selectRow': true
			            }
			         }
					],
					buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'csvHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'excelHtml5',
               exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
                        {
                extend: 'print',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            }
         
        ]

			};
			
	//options dataTable
	var sent_opt = {
				"bProcessing": true,
				"bAutoWidth": false,
				"bDestroy" : true,
				"bSortable": false,
				"iDisplayLength" : parseInt(app_configdefault_per_page),
				"oLanguage":{
								"sSearch": "<span>Search:</span> ",
								"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
								"sLengthMenu": "_MENU_ <span>entries per page</span>"
							},
				"sPaginationType": "full_numbers",
				"sAjaxSource": site_url+"/publisher/messages/fetch_message/sent",
				"fnRowCallback": function( nRow, aData, iDisplayIndex ) {
					if(aData.status==1)
					{
						$(nRow).addClass('unread');
					}
					$(nRow).removeClass('odd');
					$(nRow).removeClass('even');
					return nRow;
				},			
				
			  "aoColumnDefs": [
				{
					"aTargets"	: [0],
					"mData"		:"id",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('checkbox_id'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						var checkbox=	"<input class='checkbox_count' type='checkbox' name='sent_check' id='sent_check' value='"+full.id+"' >";
						return checkbox;
					}
				},
				{
					"aTargets"	: [1],
					"mData"		: "status",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-icon hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return get_status(full);
					}
				},
				{
					"aTargets"	: [2],
					"mData"		: "name",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-fixed-medium'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return full.name;
					}
				},
				{
					"aTargets"	: [3],
					"mData"		: "subject",
					"mRender"	: function (data, type, full)
					{
						return get_subject(full,'sent');
					}
				},
				{
					"aTargets"	: [4],
					"mData"		: "image_name",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-icon hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return get_file(full);
					}
				},
				{
					"aTargets"	: [5],
					"mData"		:"date",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-date hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full) 
					{	
						return get_date(full);
					}
				}
				
				],
				dom:'Bfrtip',
	   "sDom": 'B<"clear">lfrtip',
				 'columnDefs': [
			         {
			         	
			            'checkboxes': {
			               'selectRow': true
			            }
			         }
					],
					buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'csvHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'excelHtml5',
               exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
                        {
                extend: 'print',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            }
         
        ]
			};
			
	//options dataTable
	var trash_opt = {
				"bProcessing": true,
				"bAutoWidth": false,
				"bDestroy" : true,
				"bSortable": false,
				"iDisplayLength" : parseInt(app_configdefault_per_page),
				"oLanguage":{
								"sSearch": "<span>Search:</span> ",
								"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
								"sLengthMenu": "_MENU_ <span>entries per page</span>"
							},
				"sPaginationType": "full_numbers",
				"sAjaxSource": site_url+"/publisher/messages/fetch_message/trash",
				"fnRowCallback": function( nRow, aData, iDisplayIndex ) {
					if(aData.status==1)
					{
						$(nRow).addClass('unread');
					}
					$(nRow).removeClass('odd');
					$(nRow).removeClass('even');
					return nRow;
				},			
				
			  "aoColumnDefs": [
				{
					"aTargets"	: [0],
					"mData"		:"id",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('checkbox_id'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						var checkbox=	"<input class='checkbox_count' type='checkbox' name='trash_check' id='trash_check' value='"+full.id+"' >";
						return checkbox;
					}
				},
				{
					"aTargets"	: [1],
					"mData"		: "status",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-icon hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return get_status(full);
					}
				},
				{
					"aTargets"	: [2],
					"mData"		: "name",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-fixed-medium'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return full.name;
					}
				},
				{
					"aTargets"	: [3],
					"mData"		: "subject",
					"mRender"	: function (data, type, full)
					{
						return get_subject(full,'trash');
					}
				},
				{
					"aTargets"	: [4],
					"mData"		: "image_name",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-icon hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full)
					{
						return get_file(full);
					}
				},
				{
					"aTargets"	: [5],
					"mData"		:"date",
					"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
                    {
                        $(nTd).addClass('table-date hidden-480'); // center the link                        
                    },
					"mRender"	: function (data, type, full) 
					{						
						return get_date(full);
					}
				}
				
				],
				dom:'Bfrtip',
	   "sDom": 'B<"clear">lfrtip',
				 'columnDefs': [
			         {
			         	
			            'checkboxes': {
			               'selectRow': true
			            }
			         }
					],
					buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'csvHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'excelHtml5',
               exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
                        {
                extend: 'print',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            }
         
        ]
			};

$(document).ready(function() {	
	
	if($(".dataTable").length > 0){
		
		if(read_type!='inbox')
		{
			var inbox	=	jQuery('#inbox.dataTable').dataTable(custom_opt);
			inbox.fnDraw();
		}
		
		if(read_type!='sent')
		{
			var sent	=	jQuery('#sent.dataTable').dataTable(sent_opt);
			sent.fnDraw();
		}
		
		var trash	=	jQuery('#trash.dataTable').dataTable(trash_opt);
		//TRIGGER THE DATATBLE EVENT
		
		trash.fnDraw();
		//TRIGGER THE DATATBLE EVENT

		jQuery('.dataTables_filter input').attr("placeholder", "Search here...");
		/*jQuery(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
			disable_search_threshold: 9999999
		});*/
		
		if(read_type!='inbox')
		{
			$("#inbox #check_all").click(function () {
				$("input", inbox.fnGetNodes()).prop("checked", this.checked);
			});
		}
		
		if(read_type!='sent')
		{
			$("#sent #check_all").click(function () {
				$("input", sent.fnGetNodes()).prop("checked", this.checked);
			});
		}
		
		$("#trash #check_all").click(function () {
			$("input", trash.fnGetNodes()).prop("checked", this.checked);
		});
		
		if(jQuery(this).hasClass("dataTable-fixedcolumn")){
			new FixedColumns( oTable );
		}
		if(jQuery(this).hasClass("dataTable-columnfilter")){
			oTable.columnFilter({
			"sPlaceHolder" : "head:after"
			});
		}
		resize_chosen();
	}	
		
});


$("#inbox #check_all").click(function () {

                var inbox = $('#inbox').dataTable();
                console.log('test');
				$("input", inbox.fnGetNodes()).prop("checked", this.checked);
			});
$("#sent #check_all").click(function () {
	
				var sent = $('#sent').dataTable();
                console.log('test');
				$("input", sent.fnGetNodes()).prop("checked", this.checked);
			});

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function get_status(full)
{
	if(full.status==0)
	{
		var status	="<a class='sel-star active' href='#'><i class='icon-star'></i></a>";
	}
	else
	{
		var status	="<a class='sel-star' href='#'><i class='icon-star'></i></a>";
	}
	
	return status;
}

function get_subject(full,type)
{
	var read_url = site_url+'/publisher/messages/read/'+type; 
	if(type=='inbox')
	{
		var read_btn = '<a class="sublinkcls" href="'+read_url+'/'+full.id+'" >'+full.subject.charAt(0).toUpperCase()+full.subject.substring(1,50)+'</a>';
	}
	else
	{
		var read_btn = '<a class="sublinkcls" href="'+read_url+'/'+full.id+'" >'+full.subject.charAt(0).toUpperCase()+full.subject.substring(1,50)+'</a>';
	}
	
	return read_btn;
}

function get_file(full)
{
	if(full.image_name || full.file_name)
	{
		var file	="<i class='icon-paper-clip'></i>";
	}
	else
	{
		var file	="";
	}
	
	return file;
}

function get_date(full)
{ 
	var currentTime = new Date();
    var month = currentTime.getMonth()+1; 
	var day = currentTime.getDate();
    var year = currentTime.getFullYear();
    var curr_date=year + "-" + month + "-" + day;
    var date=full.msg_date;
	return date;
}
	/*
	var monthNames 	= 	new Array("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
	var msg_date	=	full.date.replace(" ","T");
	var time		=	new Date(msg_date);
	var now 		= 	new Date();
	if(time.getDate()==now.getDate())
	{
		if(time.getHours()>=12)
		{
			if(time.getHours()==12)
			{
				var hour	=	time.getHours();
			}
			else
			{
				var hour	=	time.getHours()-12;
			}
			var date	=	hour+':'+time.getMinutes()+' PM';
		}
		else
		{
			var date	=	time.getHours()+':'+time.getMinutes()+' AM';
		}
	}	
	else
	{
		var date	=	time.getDate()+', '+monthNames[time.getMonth()]+' '+time.getFullYear();
	}
	
	return date;*/


function refresh_msg(type)
{
	custom_opt.dom= 'Bfrtip';
	custom_opt.sdom=  'B<"clear">lfrtip';	
	custom_opt.select=  { 'style':'multi' };
	custom_opt.columnDefs=[
					 {
						'checkboxes': {
						   'selectRow': true
							}
						 }
					  ];
				custom_opt.buttons=[
                {
                extend: 'copyHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'csvHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'excelHtml5',
               exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
                        {
                extend: 'print',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            }
         
        ];


                    sent_opt.dom= 'Bfrtip';
	sent_opt.sdom=  'B<"clear">lfrtip';	
	sent_opt.select=  { 'style':'multi' };
	sent_opt.columnDefs=[
					 {
						'checkboxes': {
						   'selectRow': true
							}
						 }
					  ];
				sent_opt.buttons=[
                {
                extend: 'copyHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'csvHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'excelHtml5',
               exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
                        {
                extend: 'print',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            }
         
        ];

        	trash_opt.dom= 'Bfrtip';
	trash_opt.sdom=  'B<"clear">lfrtip';	
	trash_opt.select=  { 'style':'multi' };
	trash_opt.columnDefs=[
					 {
						'checkboxes': {
						   'selectRow': true
							}
						 }
					  ];
				trash_opt.buttons=[
                {
                extend: 'copyHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'csvHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'excelHtml5',
               exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
                        {
                extend: 'print',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            }
         
        ];


	if(type=='inbox')
	{
		var inbox_count=jQuery.ajax({
			type:'POST',
			url: site_url+'/publisher/messages/fetch_message_count/inbox',
			async: false
		}).success(function(response){}).responseText;
		
		if(inbox_count!=0)
		{
			$('.inbox_count').html('('+inbox_count+')');
		}
		var inbox	=	jQuery('#inbox.dataTable').dataTable(custom_opt);
		
		inbox.fnDraw();
		$("#inbox #check_all").click(function(){
			$('input', inbox.fnGetNodes()).prop('checked',this.checked);
		});
	}
	else if(type=='sent')
	{
		var sent_count=jQuery.ajax({
			type:'POST',
			url: site_url+'/publisher/messages/fetch_message_count/sent',
			async: false
		}).success(function(response){}).responseText;
		
		if(sent_count!=0)
		{
			$('.sent_count').html('('+sent_count+')');
		}
		var sent	=	jQuery('#sent.dataTable').dataTable(sent_opt);
		sent.fnDraw();
		$("#sent #check_all").click(function(){
			$('input', sent.fnGetNodes()).prop('checked',this.checked);
		});
	}
	else if(type=='write')
	{
		if($(".icheck-me").length > 0)
		{
			$(".icheck-me").each(function(){
				var $el = $(this);
				var skin = ($el.attr('data-skin') !== undefined) ? "_"+$el.attr('data-skin') : "",
				color = ($el.attr('data-color') !== undefined) ? "-"+$el.attr('data-color') : "";

				var opt = {
					checkboxClass: 'icheckbox' + skin + color,
					radioClass: 'iradio' + skin + color,
					increaseArea: "10%"
				}

				$el.iCheck(opt);
			});
		}
		
		$("#subject,#msg_content").val('');
		$("#attach_type_image").iCheck('uncheck');
		$("#attach_type_image,#attach_type_file").iCheck('uncheck');
		$("#image_upload,#file_upload").val('');
		jQuery('#image_block').hide();
		jQuery('#file_block').hide();
		
		
	}
	else if(type=='trash')
	{
     	var trash	=	jQuery('#trash.dataTable').dataTable(trash_opt);
		trash.fnDraw();
	}
	
	$('.dataTables_filter input').attr("placeholder", "Search here...");
	if(type=='inbox')
	{
	var t = document.getElementById("inbox_length_select");		
	new AcostUISelect(t);
	}
	else if(type=='sent')
	{
     var t = document.getElementById("sent_length_select");		
	new AcostUISelect(t);
	}
	
	else if(type=='trash')
	{
     var t = document.getElementById("trash_length_select");		
	new AcostUISelect(t);
	}

	if($(this).hasClass("dataTable-fixedcolumn")){
		new FixedColumns( oTable );
	}
	if($(this).hasClass("dataTable-columnfilter")){
		oTable.columnFilter({
			"sPlaceHolder" : "head:after"
		});
	}
	
	resize_chosen();	
}

function delete_msg(type)
{
	if(type=='inbox')
	{
		var id	=	jQuery("#inbox input:checkbox:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	}
	else if(type=='sent')
	{
		var id	=	jQuery("#sent input:checkbox:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	}
	else if(type=='trash')
	{
		var id	=	jQuery("#trash input:checkbox:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	}
	
	if(id!='' && type!='trash')
	{
		$("#del_msg_id").val(id);
		$("#del_type").val(type);
		$('#modal_delete_message').modal('show');	
	}
	else if(type=='trash' && id!='')
	{
		//alert(id);exit;
	   $("#del_msg_trash_id").val(id); 
	   $('#modal_delete_trash_message').modal('show');	
	}
	else 
	{
		if(msg_id && read_type==type)
		{
			$("#del_msg_id").val(msg_id);
			$("#del_type").val(type);
			$("#del_read").val(read_type);
			$('#modal_delete_message').modal('show');	
		}
		else
		{
			$('#modal_no_delete_message').modal('show');
		}
	}
}
