	//When form ready
	jQuery(document).ready(function ()
	{
		var campaign_id = jQuery('#mobile_creative_anchor').attr('data-campaign-id');

		//Store it to a hidden feild
		jQuery('#_int_campaign_id').val(campaign_id);
		if(campaign_id)
		{
			jQuery('#int_campaign_group').hide();
		}
		
		//REINITIATE VALIDATE CLASS FOR MODAL BOX
		if($('.form-validate').length > 0)
		{
			$('.form-validate').each(function(){
			var id = $(this).attr('id');
				$("#"+id).validate({
					errorElement:'span',
					errorClass: 'help-block error',
					errorPlacement:function(error, element){
					element.parents('.controls').append(error);
					},
					highlight: function(label) {
					$(label).closest('.control-group').removeClass('error success').addClass('error');
					},
					success: function(label) {
					label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
					}
				});
			});
		}
		//REINITIATE CHECKBOX CLASS FOR MODAL BOX
		if($(".icheck-me").length > 0)
		{
			$(".icheck-me").each(function(){
				var $el = $(this);
				var skin = ($el.attr('data-skin') !== undefined) ? "_"+$el.attr('data-skin') : "",
				color = ($el.attr('data-color') !== undefined) ? "-"+$el.attr('data-color') : "";

				var opt = {
					checkboxClass: 'icheckbox' + skin + color,
					radioClass: 'iradio' + skin + color,
					increaseArea: "10%"
				}

				$el.iCheck(opt);
			});
		}
		
	});


	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];

	//Define default

	var input = document.getElementById("interstitial_creative"),formdata = false;
	//Bind the event to onchange of the url file
	input.addEventListener("change",handleFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#interstitial_creative_form" );
	
	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFileSelect(evt)
 	{
		var iab_max_width= '320'; 
		var iab_max_height= '480';

		var form = jQuery( "#interstitial_creative_form" );

		var isvalid_creative=true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_interstitial_creative').val()!='')
				{
					var tmp_interstitial_creative_name=jQuery('#tmp_interstitial_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/mobile_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_interstitial_creative_name, api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#interstitial_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				jQuery('#tmp_interstitial_creative').val('');//empty temporary feild value
		
				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();	
					
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						
						img.onload = function() //After programatically loding selcted image get inside the method
						{
					
						//Fetch creative attribute
						var creative_size=file.size;
						var creative_type=file.type;
						var creative_width=parseInt(this.width,10);
						var creative_height=parseInt(this.height,10);

						//VALIDATE THE SELECTED IMAGE
							//IAB type check
							var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
							if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
							{
								var validator = form.validate();
								validator.showErrors({"interstitial_creative": "Creative file format should be jpeg, png, jpg or gif"});
								isvalid_creative=false;
								$('#interstitial_ad.fileupload').removeClass('fileupload-exists');
								$('#interstitial_ad.fileupload').addClass('fileupload-new');
								jQuery('#interstitial_creative').val('');
								jQuery('#tmp_interstitial_creative').val('');
							}
							//IAB size check
							else if (creative_size > iab_max_size )
							{
								var validator = form.validate();
								validator.showErrors({"interstitial_creative": "Creative file size should not exceeds "+iab_size_kb});
								isvalid_creative=false;
								$('#interstitial_ad.fileupload').removeClass('fileupload-exists');
								$('#interstitial_ad.fileupload').addClass('fileupload-new');
								
								jQuery('#interstitial_creative').val('');
								jQuery('#tmp_interstitial_creative').val('');
							}

							//IAB width check
							else if (creative_width != iab_max_width || creative_height != iab_max_height)
							{
								var validator = form.validate();
								validator.showErrors({"interstitial_creative": "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions"});
								isvalid_creative=false;
								$('#interstitial_ad.fileupload').removeClass('fileupload-exists');
								$('#interstitial_ad.fileupload').addClass('fileupload-new');
								
								jQuery('#interstitial_creative').val('');
								jQuery('#tmp_interstitial_creative').val('');
							}

							//IAB height check
							/*if (creative_height != iab_max_height )
							{
								var validator = form.validate();
								validator.showErrors({"interstitial_creative": "creative height is not upto Iab standard."});
								isvalid_creative=false;
								$('#interstitial_ad.fileupload').removeClass('fileupload-exists');
								$('#interstitial_ad.fileupload').addClass('fileupload-new');
								//jQuery('#no_image').attr('src','http://www.placehold.it/200x150/EFEFEF/AAAAAA&text=no+image');
								jQuery('#interstitial_creative').val('');
								jQuery('#tmp_interstitial_creative').val('');
							}*/

							
							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("api_key", api_key);
								formdata.append("creative", file);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								form.validate().element(jQuery('#interstitial_creative'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/mobile_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_interstitial_creative').val(data.response.file_name);
												jQuery('#tmp_interstitial_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_interstitial_creative_url').val(data.response.full_path);
											}
											else
											{
												//window.location.replace(data.redirect);
												var validator = form.validate();
												validator.showErrors(data.msg);
												//jQuery('#tmp_interstitial_creative').val('');
											}
										}
									});
								}
							}
						}
					}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = form.validate();
					$('#interstitial_ad.fileupload').removeClass('fileupload-exists');
					$('#interstitial_ad.fileupload').addClass('fileupload-new');
					jQuery('#interstitial_creative').val('');
					validator.showErrors({"interstitial_creative": "Creative must be an image "});
				}
			}	
		}
	}
	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload()
	{
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#interstitial_creative').val('');
		jQuery('#preview_image').html('');
		//Validate the particular feild
		var form = jQuery( "#interstitial_creative_form" );
		form.validate().element(jQuery('#interstitial_creative'));
		
		if(jQuery('#tmp_interstitial_creative').val() !='')
		{
			var tmp_interstitial_creative_name=jQuery('#tmp_interstitial_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/mobile_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_interstitial_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_interstitial_creative').val('');
	}

	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the mobile interstitial creative form
	 * */
	jQuery(function(){
		var form = jQuery("#interstitial_creative_form");
		var validator = form.validate();
		//jQuery( "#upload_interstial_creative" ).unbind().bind('click',function(evt){
		jQuery(document).on('click','#upload_interstial_creative',function(evt){
			if(form.valid()==true)
			{				
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					async:false,
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							//Prevent multiple requests
							jQuery( "#upload_interstial_creative" ).unbind('click');
				
							if(jQuery('#_int_campaign_id').val() !='')
							{
								refresh_existing_creative(jQuery('#_int_campaign_id').val());
								$('#add_creative_msg').attr("data-notify-message","Creative added sucessfully");
								$('#add_creative_msg').trigger('click');								
							}
							
							//Switch modal box
							$('#modal_mob_interstital_creative_add').one('hidden.bs.modal', function (e) {
								if(jQuery('#_int_campaign_id').val() =='')
								{
									jQuery('#modal_mob_interstitial_creative_success').modal('show');
								}
							}).modal('hide');
							
							validator.resetForm();
							form.get(0).reset();
							//Reset hidden feilds
							jQuery('#tmp_interstitial_creative').val('');
							jQuery('#tmp_interstitial_creative_content_type').val('');
							jQuery('#tmp_interstitial_creative_url').val('');							
						}
						else
						{
							jQuery('.alert-error').show();
							jQuery('#error_msg').html(data.msg);
							validator.showErrors(data.msg);							
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});


	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){
			var form = jQuery("#interstitial_creative_form");
			evt.preventDefault();
			form.validate().element(jQuery('#interstitial_creative'));
			
			jQuery('#interstitial_ad.fileupload').removeClass('fileupload-exists');
			jQuery('#interstitial_ad.fileupload').addClass('fileupload-new');
			jQuery('#interstitial_creative').val('');
			jQuery('#preview_image').html('');
		
			if(jQuery('#tmp_interstitial_creative').val() !='')
			{
				var tmp_interstitial_creative_name=jQuery('#tmp_interstitial_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/mobile_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_interstitial_creative_name, api_key:api_key},
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#interstitial_creative'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_interstitial_creative').val('');
		});
	});

	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			async:false,
			url : site_url+"/buyer/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id},
			
			success : function(data){

				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the base creative when remove button is clicked
	 * */
	
	jQuery(function(){
		jQuery(".remove" ).click(function(evt){
		
			var creative_type	=	jQuery(this).attr('id');
			
			var form = jQuery("#interstitial_creative_form");
			form.validate().element(jQuery('#'+creative_type+'_creative'));
			
			jQuery('#'+creative_type+'_ad.fileupload').removeClass('fileupload-exists').addClass('fileupload-new');
			jQuery('#'+creative_type+'_creative').val('');
			jQuery('#preview_'+creative_type).html('');
			
			if(jQuery('#tmp_'+creative_type+'_creative').val() !='')
			{
				var tmp_base_creative_name=jQuery('#tmp_'+creative_type+'_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_base_creative_name, api_key:api_key},
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#'+creative_type+'_creative'));
					}, 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}	
			jQuery('#tmp_'+creative_type+'_creative').val('');		
		});
	});
