	if($(".select2-me").length > 0){
		$(".select2-me").select2();
	}
	//When form ready
	jQuery(document).ready(function ()
	{
		jQuery('#sl_external_group').hide();
		jQuery('#sl_html_group').hide();
		jQuery('#sl_flash_upload').hide();
		//jQuery("#mobile_creative_anchor").attr('data-campaign-id',data.campaign_id);
		//jQuery("#web_creative_anchor").attr('data-campaign-id',data.campaign_id);
		var campaign_id = jQuery('#web_creative_anchor').attr('data-campaign-id');
		//Store it to a hidden feild
		jQuery('#_wsl_campaign_id').val(campaign_id);
		if(campaign_id)
		{
			jQuery('#wsl_campaign_group').hide();
		}
		
	});
	
	/* name: source_type
	 * @param:null
	 * 
	 * switch between url and text.
	 * */
	
	function sl_source_type()
	{
		if (jQuery('#is_sl_external').is(':checked'))
		{
			jQuery('#sl_url').show();
			jQuery('#sl_html').hide();
			jQuery('#sl_flash').hide();	
			jQuery('#sl_upload_group').hide();
			jQuery('#sl_external_group').show();			
			jQuery('#sl_html_group').hide();
			jQuery('#sl_flash_upload').hide();
		}
		else if (jQuery('#is_sl_html').is(':checked'))
		{
			jQuery('#sl_url').hide();
			jQuery('#sl_html').show();
			jQuery('#sl_flash').hide();
			jQuery('#sl_upload_group').hide();
			jQuery('#sl_external_group').hide();
			jQuery('#sl_flash_upload').hide();			
			jQuery('#sl_html_group').show();
		}
		else if (jQuery('#is_sl_flash').is(':checked'))
		{
			jQuery('#sl_url').hide();
			jQuery('#sl_html').hide();
			jQuery('#sl_flash').show();
			jQuery('#sl_upload_group').hide();
			jQuery('#sl_external_group').hide();			
			jQuery('#sl_html_group').hide();
			jQuery('#sl_flash_upload').show();
		}
		else
		{
			jQuery('#sl_url').show();
			jQuery('#sl_html').show();
			jQuery('#sl_flash').show();
			jQuery('#sl_upload_group').show();
			jQuery('#sl_external_group').hide();			
			jQuery('#sl_html_group').hide();
			jQuery('#sl_flash_upload').hide();
		}
	}
	
	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];
	var iab_flash_file_type=['application/x-shockwave-flash'];

	//Define default

	var input = document.getElementById("slide_creative"),formdata = false;
	var input_flash = document.getElementById("flash_creative"),formdata = false;
	
	//Bind the event to onchange of the url file
	input.addEventListener("change",handleFileSelect , false);
	input_flash.addEventListener("change",handleFlashFileSelect , false);
	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#sliderad_creative_form" );

	
	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFileSelect(evt)
 	{
		var selcted_creative_size=jQuery('#slider_creative_size').val();
		var creative_size_split = selcted_creative_size.split('x');
		var iab_max_width= parseInt(creative_size_split[0], 10); 
		var iab_max_height= parseInt(creative_size_split[1], 10);

		var form = jQuery( "#sliderad_creative_form" );

		var isvalid_creative=true;		//form check list

		
		var i = 0, len = this.files.length, img, reader, file;
		//for ( ; i < len; i++ )
		//{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_slide_creative').val()!='')
				{
					var tmp_web_creative_name=jQuery('#tmp_slide_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_web_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#slide_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				
				jQuery('#tmp_slide_creative').val('');//empty temporary feild value
		
				if ((!!file.type.match(/image.*/)))
				{
					var freader = new FileReader();	
				
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.

						img.onload = function() //After programatically loding selcted image get inside the method
						{
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type=file.type;
							var creative_width=parseInt(this.width,10);
							var creative_height=parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
								//IAB type check
								var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
								if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
								{
									var validator = form.validate();
									validator.showErrors({"slide_creative": "Creative file format should be jpeg, png, jpg or gif"});
									isvalid_creative=false;
									jQuery('#slide_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#slide_creative').val('');
									jQuery('#tmp_slide_creative').val('');
								}
								
								//IAB size check
								if (creative_size > iab_max_size )
								{
									var validator = form.validate();
									validator.showErrors({"slide_creative": "Creative file size should not exceeds "+iab_size_kb});
									isvalid_creative=false;
									jQuery('#slide_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#slide_creative').val('');
									jQuery('#tmp_slide_creative').val('');
								}

								//IAB width check
								else if (creative_width != iab_max_width || creative_height != iab_max_height)
								{
									var validator = form.validate();
									
									validator.showErrors({"slide_creative": "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions"});
									isvalid_creative=false;
									jQuery('#slide_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#slide_creative').val('');
									jQuery('#tmp_slide_creative').val('');
								}

								//IAB height check
								/*if (creative_height != iab_max_height )
								{
									var validator = form.validate();
									validator.showErrors({"web_creative": "creative height is not upto Iab standard."});
									isvalid_creative=false;
									jQuery('#creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#web_creative').val('');
									jQuery('#tmp_web_creative').val('');
								}*/

							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								jQuery( "#sliderad_creative_form" ).validate().element(jQuery('#slide_creative'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_slide_creative').val(data.response.file_name);
												jQuery('#tmp_slide_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_slide_creative_url').val(data.response.full_path);
												jQuery('#tmp_slide_creative_size').val(creative_size/1024);
											}
											else
											{												
												//window.location.replace(data.redirect);
												jQuery('#tmp_slide_creative').val('');
												var validator = jQuery( "#sliderad_creative_form" ).validate();
												validator.showErrors({"slide_creative": data.msg});
											}
										}
									});
								}
							}
						}
						
					}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = jQuery( "#sliderad_creative_form" ).validate();
					jQuery('#slide_creative').val('');
					jQuery('#slide_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"slide_creative": "Creative must be an image "});
				}
			}	
		//}
		
	}
	
	/* name: handleFlashFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFlashFileSelect(evt)
 	{
		var sel_creative_size=jQuery('#slider_creative_size').val();
		var csize_split = sel_creative_size.split('x');
		var iab_max_width= parseInt(csize_split[0], 10); 
		var iab_max_height= parseInt(csize_split[1], 10);

		var form = jQuery( "#sliderad_creative_form" );
		
		var isvalid_creative=true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;

			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_flash_creative').val()!='')
				{
					var tmp_web_creative_name=jQuery('#tmp_flash_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_web_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
						console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#flash_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				
				jQuery('#tmp_flash_creative').val('');//empty temporary feild value
				if ((file.type=='application/x-shockwave-flash'))
				{
					if (window.FileReader)
					{
						reader = new FileReader();
						reader.readAsDataURL(file);
					}
					if (formdata)
					{
						formdata.append("api_key", api_key);
						formdata.append("creative", file);
					}

					//If everything goes right move to a tmp location
					if (isvalid_creative==true)
					{
						//Validate the particular feild
						jQuery( "#sliderad_creative_form" ).validate().element(jQuery('#flash_creative'));
						if (formdata)
						{
							jQuery.ajax({
								//site_url is defined in header.php (advertiser layout) file,
								url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
								type: "POST",
								async:false,
								data: formdata,
								processData: false,
								contentType: false,
								success:function(data, textStatus, jqXHR)
								{
									if(data.response != 'error')
									{
										console.log(data.response);
										jQuery('#tmp_flash_creative').val(data.response.file_name);
										jQuery('#tmp_flash_creative_content_type').val(data.response.image_type);
										jQuery('#tmp_flash_creative_url').val(data.response.full_path);
										jQuery('#tmp_flash_creative_size').val(this.files[0].size/1024);
									}
									else
									{
										//window.location.replace(data.redirect);
										jQuery('#tmp_flash_creative').val('');
										var validator = jQuery( "#sliderad_creative_form" ).validate();
										validator.showErrors({"flash_creative": data.msg});
									}
								}
							});
						}
					}
				}
				else
				{
					var validator = jQuery( "#sliderad_creative_form" ).validate();
					jQuery('#flash_creative').val('');
					jQuery('#flash_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"flash_creative": "Creative must be an swf file"});
				}
			}	
	}

	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload()
	{
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#slide_creative').val('');
		jQuery('#preview_image').html('');
		//Validate the particular feild
		var form = jQuery( "#sliderad_creative_form" );
		form.validate().element(jQuery('#slide_creative'));
		
		if(jQuery('#tmp_slide_creative').val() !='')
		{
			var tmp_web_creative_name=jQuery('#tmp_slide_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_web_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
				console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_slide_creative').val('');
	}

	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){
		var form = jQuery("#sliderad_creative_form");
		var validator = form.validate();
		jQuery( "#sliderad_creative" ).unbind().bind('click',function(evt){

			if(form.valid()==true)
			{
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					url: form.attr("action"),
					async:false,
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							jQuery( "#sliderad_creative" ).unbind('click');
							
							if(jQuery('#_wsl_campaign_id').val() !='')
							{
								refresh_existing_creative(jQuery('#_wsl_campaign_id').val());
								$('#add_creative_msg').attr("data-notify-message","Creative added sucessfully");
								$('#add_creative_msg').trigger('click');
							}

							//Switch modal box
							$('#modal_sliderad_creative_add').one('hidden.bs.modal', function (e) {
								if(jQuery('#_wsl_campaign_id').val() =='')
								{
									jQuery('#modal_sliderad_creative_success').modal('show');
								}
							}).modal('hide');
							
							validator.resetForm();
							form.get(0).reset();
							//Reset hidden feilds
							jQuery('#tmp_slide_creative').val('');
							jQuery('#tmp_slide_creative_content_type').val('');
							jQuery('#tmp_slide_creative_url').val('');
							jQuery('#tmp_slide_creative_size').val('');
							
							jQuery('#tmp_flash_creative').val('');
							
							jQuery('#tmp_flash_creative_content_type').val('');
							jQuery('#tmp_flash_creative_url').val('');					
							jQuery('#tmp_flash_creative_size').val('');
						}
						else
						{
							validator.showErrors(data.msg);
							$(this).modal('hide');
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});


	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){
			var form = jQuery("#sliderad_creative_form");
			evt.preventDefault();
			form.validate().element(jQuery('#slide_creative'));
			
			jQuery('.fileupload').removeClass('fileupload-exists');
			jQuery('.fileupload').addClass('fileupload-new');
			jQuery('#slide_creative').val('');
			jQuery('#preview_image').html('');
		
			if(jQuery('#tmp_slide_creative').val() !='')
			{
				var tmp_web_creative_name=jQuery('#tmp_slide_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_web_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#slide_creative'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_slide_creative').val('');
			
		});
	});	
	
	
	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			async:false,
			url : site_url+"/buyer/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id},
			
			success : function(data){

				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}

